/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.util;

import com.sun.javaws.debug.Debug;
import com.sun.javaws.debug.Globals;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.BitSet;

public class URLUtil {
    static BitSet encodedInPath = new BitSet(256);

    public static void setHostHeader(URLConnection uRLConnection) {
        int n = uRLConnection.getURL().getPort();
        String string = uRLConnection.getURL().getHost();
        if (n != -1 && n != 80) {
            string = string + ":" + String.valueOf(n);
        }
        uRLConnection.setRequestProperty("Host", string);
    }

    public static URL getBase(URL uRL) {
        if (uRL == null) {
            return null;
        }
        String string = uRL.getFile();
        if (string != null) {
            int n = string.lastIndexOf(47);
            if (n != -1) {
                string = string.substring(0, n + 1);
            }
            try {
                return new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string);
            }
            catch (MalformedURLException malformedURLException) {
                Debug.ignoredException(malformedURLException);
            }
        }
        return uRL;
    }

    public static URL asPathURL(URL uRL) {
        if (uRL == null) {
            return null;
        }
        String string = uRL.getFile();
        if (string != null && !string.endsWith("/")) {
            try {
                return new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), uRL.getFile() + "/");
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return uRL;
    }

    public static boolean equals(URL uRL, URL uRL2) {
        if (uRL == null || uRL2 == null) {
            return uRL2 == uRL;
        }
        if ("http".equals(uRL.getProtocol()) && "http".equals(uRL2.getProtocol()) && uRL.getPort() != uRL2.getPort()) {
            uRL = URLUtil.normalizePort(uRL);
            uRL2 = URLUtil.normalizePort(uRL2);
        }
        return uRL.toString().equals(uRL2.toString());
    }

    public static int compareTo(URL uRL, URL uRL2) {
        if ("http".equals(uRL.getProtocol()) && "http".equals(uRL2.getProtocol()) && uRL.getPort() != uRL2.getPort()) {
            uRL = URLUtil.normalizePort(uRL);
            uRL2 = URLUtil.normalizePort(uRL2);
        }
        return uRL.toString().compareTo(uRL2.toString());
    }

    private static URL normalizePort(URL uRL) {
        if (uRL.getPort() != -1) {
            return uRL;
        }
        try {
            return new URL(uRL.getProtocol(), uRL.getHost(), 80, uRL.getFile());
        }
        catch (MalformedURLException malformedURLException) {
            return uRL;
        }
    }

    public static String encodePath(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == File.separatorChar) {
                stringBuffer.append('/');
                continue;
            }
            if (c <= '\u007f') {
                if (encodedInPath.get(c)) {
                    URLUtil.escape(stringBuffer, c);
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            if (c > '\u07ff') {
                URLUtil.escape(stringBuffer, (char)(0xE0 | c >> 12 & 0xF));
                URLUtil.escape(stringBuffer, (char)(0x80 | c >> 6 & 0x3F));
                URLUtil.escape(stringBuffer, (char)(0x80 | c >> 0 & 0x3F));
                continue;
            }
            URLUtil.escape(stringBuffer, (char)(0xC0 | c >> 6 & 0x1F));
            URLUtil.escape(stringBuffer, (char)(0x80 | c >> 0 & 0x3F));
        }
        if (Globals.TraceEncoding && !string.equals(stringBuffer.toString())) {
            Debug.println("     String: " + string);
            Debug.println(" encoded to: " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    private static void escape(StringBuffer stringBuffer, char c) {
        stringBuffer.append('%');
        stringBuffer.append(Character.forDigit(c >> 4 & 0xF, 16));
        stringBuffer.append(Character.forDigit(c & 0xF, 16));
    }

    public static String decodePath(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c != '%') {
                ++n;
            } else {
                try {
                    c = URLUtil.unescape(string, n);
                    n += 3;
                    if ((c & 0x80) != 0) {
                        switch (c >> 4) {
                            case 12: 
                            case 13: {
                                char c2 = URLUtil.unescape(string, n);
                                n += 3;
                                c = (char)((c & 0x1F) << 6 | c2 & 0x3F);
                                break;
                            }
                            case 14: {
                                char c2 = URLUtil.unescape(string, n);
                                char c3 = URLUtil.unescape(string, n += 3);
                                n += 3;
                                c = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
                                break;
                            }
                            default: {
                                Debug.ignoredException(new IllegalArgumentException());
                            }
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    Debug.ignoredException(numberFormatException);
                }
            }
            stringBuffer.append(c);
        }
        if (Globals.TraceEncoding && !string.equals(stringBuffer.toString())) {
            Debug.println("     String: " + string);
            Debug.println(" decoded to: " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    private static char unescape(String string, int n) {
        return (char)Integer.parseInt(string.substring(n + 1, n + 3), 16);
    }

    public static String getEncodedPath(File file) {
        String string = file.getAbsolutePath();
        if (!string.endsWith(File.separator) && file.isDirectory()) {
            string = string + File.separator;
        }
        return URLUtil.encodePath(string);
    }

    public static String getDecodedPath(URL uRL) {
        String string = uRL.getFile();
        string = string.replace('/', File.separatorChar);
        return URLUtil.decodePath(string);
    }

    public static String getPathFromURL(URL uRL) {
        return URLUtil.getDecodedPath(uRL);
    }

    static {
        encodedInPath.set(61);
        encodedInPath.set(59);
        encodedInPath.set(63);
        encodedInPath.set(47);
        encodedInPath.set(35);
        encodedInPath.set(32);
        encodedInPath.set(60);
        encodedInPath.set(62);
        encodedInPath.set(37);
        encodedInPath.set(34);
        encodedInPath.set(123);
        encodedInPath.set(125);
        encodedInPath.set(124);
        encodedInPath.set(92);
        encodedInPath.set(94);
        encodedInPath.set(91);
        encodedInPath.set(93);
        encodedInPath.set(96);
        for (int i = 0; i < 32; ++i) {
            encodedInPath.set(i);
        }
        encodedInPath.set(127);
    }
}

