/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.extract;

import com.ibm.jvm.dump.extract.AbstractLayout;
import com.ibm.jvm.dump.extract.ElfHeader;
import com.ibm.jvm.dump.extract.ElfSegment;
import com.ibm.jvm.dump.extract.ElfType;
import com.ibm.jvm.dump.extract.ExProcess;
import com.ibm.jvm.dump.extract.ExThread;
import com.ibm.jvm.dump.extract.HPIModule;
import com.ibm.jvm.dump.extract.JVMModule;
import com.ibm.jvm.dump.extract.MemoryMap;
import com.ibm.jvm.dump.format.BigEnd;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.format.LittleEnd;
import com.ibm.jvm.dump.format.WordType;
import com.ibm.jvm.dump.sdff.DvFileReader;
import com.ibm.jvm.dump.sdff.SDFFDump;
import com.ibm.jvm.dump.sdff.Segment;
import com.ibm.jvm.dump.sdff.WordLength;
import com.ibm.jvm.dump.sdffArchive.SdffArchiveOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;

public class Elf
implements AbstractLayout {
    ElfHeader header;
    ElfType elfType;
    DvFileReader reader;
    MemoryMap memoryMap = new MemoryMap();
    static final int ARCH_SOLARIS = 2;
    static final int ARCH_IA32 = 3;
    static final int ARCH_IA64 = 50;
    static final int ARCH_PPC32 = 20;
    static final int ARCH_PPC64 = 21;
    static final int ARCH_S390 = 22;

    public Elf(RandomAccessFile randomAccessFile) throws IOException {
        int n;
        WordType wordType;
        WordLength wordLength;
        byte[] byArray = new byte[2];
        randomAccessFile.seek(4L);
        randomAccessFile.read(byArray);
        switch (byArray[0]) {
            case 1: {
                DvUtils.trace("32 bits", 2, false);
                wordLength = new WordLength(32);
                break;
            }
            case 2: {
                DvUtils.trace("64 bits", 2, false);
                wordLength = new WordLength(64);
                break;
            }
            default: {
                throw new IOException("JVMRAS022: Bad word length detected in core file.");
            }
        }
        switch (byArray[1]) {
            case 1: {
                DvUtils.trace("Little end", 2, false);
                wordType = new LittleEnd();
                break;
            }
            case 2: {
                DvUtils.trace("Big end", 2, false);
                wordType = new BigEnd();
                break;
            }
            default: {
                throw new IOException("JVMRAS023: Bad endian type detected in core file.");
            }
        }
        randomAccessFile.seek(17 + byArray[1]);
        byte by = randomAccessFile.readByte();
        switch (by) {
            case 20: 
            case 21: 
            case 50: {
                n = 4;
                break;
            }
            case 22: {
                n = wordLength.size / 2;
                break;
            }
            default: {
                n = 2;
            }
        }
        this.reader = new DvFileReader(randomAccessFile, wordType, wordLength, n);
    }

    public DvFileReader getFileReader(RandomAccessFile randomAccessFile) throws IOException {
        return this.reader;
    }

    public void readHeader() throws IOException {
        DvUtils.trace("Create Elf Header", 2, false);
        this.header = new ElfHeader(this.reader);
    }

    public MemoryMap getMemoryMap() {
        return this.memoryMap;
    }

    private void readSegments() throws IOException {
        DvUtils.trace("readSegments", 2, false);
        int n = 0;
        this.reader.setPos(this.header.programHeaderOffset);
        int n2 = 0;
        while ((long)n2 < this.header.numProgramHeaders) {
            this.reader.setPos(this.header.programHeaderOffset + (long)n2 * this.header.programHeaderEntrySize);
            ElfSegment elfSegment = new ElfSegment(this);
            switch (elfSegment.getType()) {
                case 4: {
                    if (n++ == 0 && this.header.machine == 2L) break;
                    this.readNoteSegment(elfSegment);
                    break;
                }
                case 7: {
                    break;
                }
                case 1: {
                    this.memoryMap.addSegment(this.reader, elfSegment);
                    break;
                }
                default: {
                    DvUtils.trace("Ignoring section type " + elfSegment.getType(), 2, false);
                }
            }
            ++n2;
        }
    }

    private void readNoteSegment(ElfSegment elfSegment) throws IOException {
        long l = elfSegment.offset;
        this.reader.setPos(l);
        DvUtils.trace("Note start:" + Long.toHexString(elfSegment.offset) + " end:" + Long.toHexString(elfSegment.offset + elfSegment.fileSize), 2, false);
        while (l < elfSegment.offset + elfSegment.fileSize) {
            long l2;
            if (this.reader.getPos() != l) {
                System.err.println("JVMRAS014: Expected to be at offset " + Long.toHexString(l) + " after reading Note, but find " + "myself at " + "offset " + Long.toHexString(this.reader.getPos()) + ".  Adjusting offset.");
                this.reader.setPos(l);
            }
            if ((l2 = this.reader.readWord()) > 4L) {
                l2 = 8L;
            }
            long l3 = this.reader.readWord();
            long l4 = this.reader.readWord();
            String string = this.reader.readString((int)l2);
            string = string.trim();
            DvUtils.trace("-------------------------------------", 2, false);
            DvUtils.trace("nameLen = " + l2, 2, false);
            DvUtils.trace("dataSize = " + l3, 2, false);
            DvUtils.trace("type = " + l4, 2, false);
            DvUtils.trace("name = " + string, 2, false);
            DvUtils.trace("Current file offset = " + Long.toHexString(this.reader.getPos() - 16L), 2, false);
            if (!string.startsWith("CORE") && !string.startsWith("LINUX")) {
                DvUtils.trace("Segment named '" + string + "' found", 2, false);
            }
            l = this.reader.getPos() + l3;
            DvUtils.trace("Next file offset = " + Long.toHexString(l), 2, false);
            this.elfType.readNote((int)l4, l);
        }
    }

    private void createThreadIndex() {
        DvUtils.trace("The thread list has " + this.elfType.process.thread.size() + " elements", 2, false);
        this.elfType.process.setMemoryMap(this.memoryMap);
        Iterator iterator = this.elfType.process.thread.iterator();
        while (iterator.hasNext()) {
            ExThread exThread = null;
            try {
                exThread = (ExThread)iterator.next();
                this.elfType.process.addThreadIndex(exThread);
            }
            catch (Exception exception) {
                System.err.println("JVMRAS028: Could not map stack address 0x" + Long.toHexString(exThread.context.getSp()) + " to a data segment.");
            }
        }
    }

    public void readCoreFile() throws IOException {
        this.readHeader();
        this.header.dump();
        this.elfType = ElfType.makeElfType(this);
        this.readSegments();
        this.createThreadIndex();
    }

    /*
     * Unable to fully structure code
     */
    public void getJVMLayout(ExProcess var1_1, MemoryMap var2_2, DvFileReader var3_3) throws IOException {
        DvUtils.trace("JVMLayout", 0, false);
        var4_4 = var2_2.segments.elements();
        var5_5 = new byte[]{82, 65, 83, 0, 0, 0, 0, 0, 0};
        if (var3_3.endType instanceof BigEnd) {
            DvUtils.trace("Look for big-end patterns", 2, false);
            var5_5[8] = 85;
            var5_5[6] = 85;
            var5_5[7] = -86;
            var5_5[5] = -86;
        } else {
            DvUtils.trace("Look for little-end patterns", 2, false);
            var5_5[7] = 85;
            var5_5[5] = 85;
            var5_5[8] = -86;
            var5_5[6] = -86;
        }
        var6_6 = 2;
        block0: while (var4_4.hasMoreElements()) {
            var7_7 = (Segment)var4_4.nextElement();
            DvUtils.trace("Segment type=" + var7_7.moduleType + " length=" + var7_7.moduleSize + " offset=" + Long.toHexString(var7_7.offset), 2, false);
            if (var7_7.moduleType != 2 || var7_7.moduleSize > 0x10000000L) continue;
            DvUtils.trace("Segment type=" + var7_7.moduleType + " length=" + var7_7.moduleSize + " offset=" + Long.toHexString(var7_7.offset), 2, false);
            var8_8 = 2048;
            var9_9 = (int)var7_7.moduleSize;
            var10_10 = new byte[var8_8];
            var11_11 = var7_7.moduleAddress.getAddressAsLong();
            var13_12 = 0;
            var3_3.setPos(var7_7.offset);
            block1: while (var9_9 > 0) {
                var3_3.read(var10_10);
                var9_9 -= var8_8;
                var14_13 = 0;
                ** GOTO lbl64
                {
                    if (++var13_12 == var5_5.length) {
                        var15_14 = var3_3.getPos();
                        DvUtils.trace("Match found", 2, false);
                        var3_3.setPos(var3_3.getPos() - (long)var8_8 + (long)var14_13 - (long)var13_12 - 3L);
                        var17_15 = var3_3.readString(3);
                        var18_16 = var3_3.getPos() + 21L;
                        DvUtils.trace("match:" + var17_15, 2, false);
                        if (var17_15.compareTo("HPI") == 0) {
                            DvUtils.trace("HPI Found", 2, false);
                            var1_1.hpiData = new HPIModule(var7_7, var18_16);
                            --var6_6;
                            var3_3.setPos(var15_14);
                        } else if (var17_15.compareTo("JVM") == 0) {
                            DvUtils.trace("JVM Found", 2, false);
                            var1_1.jvmData = new JVMModule(var7_7, var18_16, var11_11 + (long)var14_13 - (long)var13_12 - 3L);
                            --var6_6;
                            var3_3.setPos(var15_14);
                        }
                        if (var6_6 == 0) break block0;
                        var13_12 = 0;
                    }
                    if (var14_13 == var8_8) {
                        var15_14 = var3_3.getPos() - (long)var8_8 + (long)var14_13;
                        DvUtils.trace("match crosses buffer boundary " + var15_14, 2, false);
                        var11_11 += (long)var8_8;
                        continue block1;
                    }
                    do {
                        if (var10_10[var14_13++] == var5_5[var13_12]) continue block2;
                        if (var13_12 <= 0) continue;
                        var13_12 = 0;
                        if (var14_13 <= 0) continue;
                        --var14_13;
lbl64:
                        // 4 sources

                    } while (var14_13 < var8_8);
                }
                var11_11 += (long)var8_8;
            }
        }
        if (var1_1.hpiData == null) {
            System.err.println("JVMRAS002: Could not find eyecatcher HPIRAS in core file.");
        }
        if (var1_1.jvmData == null) {
            System.err.println("JVMRAS003: Could not find eyecatcher JVMRAS in core file.");
        }
    }

    public SDFFDump getHeader() {
        return this.header;
    }

    public DvFileReader getReader() {
        return this.reader;
    }

    public ExProcess getProcess() {
        return this.elfType.process;
    }

    public void dumpLibs(SdffArchiveOutputStream sdffArchiveOutputStream) throws IOException {
    }
}

