/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.extract;

import com.ibm.jvm.dump.extract.Elf;
import com.ibm.jvm.dump.extract.ElfType;
import com.ibm.jvm.dump.extract.ExProcess;
import com.ibm.jvm.dump.extract.ExThread;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.sdff.DvFileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;

class ElfSolaris
extends ElfType {
    int signal;
    static final int NT_PRSTATUS = 1;
    static final int NT_PRFPREG = 2;
    static final int NT_PRPSINFO = 3;
    static final int NT_PRXREG = 4;
    static final int NT_PLATFORM = 5;
    static final int NT_AUXV = 6;
    static final int NT_GWINDOWS = 7;
    static final int NT_ASRS = 8;
    static final int NT_PSTATUS = 10;
    static final int NT_PSINFO = 13;
    static final int NT_PRCRED = 14;
    static final int NT_UTSNAME = 15;
    static final int NT_LWPSTATUS = 16;
    static final int NT_LWPSINFO = 17;

    ElfSolaris(Elf elf) {
        super(elf);
    }

    void readNote(int n, long l) throws IOException {
        switch (n) {
            case 10: {
                new PStatus(this.process);
                break;
            }
            case 13: {
                this.process = new PsInfo();
                break;
            }
            case 16: {
                LwpStatus lwpStatus = new LwpStatus();
                break;
            }
            case 17: {
                this.reader.setPos(l);
                break;
            }
            case 4: {
                this.reader.setPos(l);
                break;
            }
            case 5: {
                this.reader.setPos(l);
                break;
            }
            case 6: {
                this.reader.setPos(l);
                break;
            }
            default: {
                System.err.println("JVMRAS007: Unexpected note type " + n + " found in " + "core file - ignored.");
                this.reader.setPos(l);
            }
        }
    }

    class LwpStatus
    extends ExThread {
        LwpStatus() throws IOException {
            DvFileReader dvFileReader = ElfSolaris.this.elf.reader;
            long l = dvFileReader.readWord();
            long l2 = dvFileReader.readWord();
            long l3 = dvFileReader.readHalf();
            long l4 = dvFileReader.readHalf();
            long l5 = dvFileReader.readHalf();
            long l6 = dvFileReader.readHalf();
            byte[] byArray = new byte[128];
            dvFileReader.read(byArray);
            byte[] byArray2 = new byte[16];
            dvFileReader.read(byArray2);
            byte[] byArray3 = new byte[16];
            dvFileReader.read(byArray3);
            byte[] byArray4 = new byte[32];
            dvFileReader.read(byArray4);
            byte[] byArray5 = new byte[12];
            dvFileReader.read(byArray5);
            long l7 = dvFileReader.readAddress();
            long l8 = dvFileReader.readHalf();
            long l9 = dvFileReader.readHalf();
            long l10 = dvFileReader.readWord();
            byte[] byArray6 = new byte[32];
            dvFileReader.read(byArray6);
            long l11 = dvFileReader.readWord();
            long l12 = dvFileReader.readWord();
            long l13 = dvFileReader.readLong();
            long l14 = dvFileReader.readLong();
            byte[] byArray7 = new byte[48];
            dvFileReader.read(byArray7);
            long l15 = dvFileReader.readWord();
            long l16 = dvFileReader.readWord();
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            Vector<Long> vector = new Vector<Long>(8);
            Vector<Long> vector2 = new Vector<Long>(8);
            Vector<Long> vector3 = new Vector<Long>(8);
            Vector<Long> vector4 = new Vector<Long>(8);
            Vector<Long> vector5 = new Vector<Long>(32);
            int n = 0;
            while (n < 8) {
                vector.add(new Long(dvFileReader.readWord()));
                ++n;
            }
            int n2 = 0;
            while (n2 < 8) {
                vector2.add(new Long(dvFileReader.readWord()));
                ++n2;
            }
            int n3 = 0;
            while (n3 < 8) {
                vector3.add(new Long(dvFileReader.readWord()));
                ++n3;
            }
            int n4 = 0;
            while (n4 < 8) {
                vector4.add(new Long(dvFileReader.readWord()));
                ++n4;
            }
            long l17 = dvFileReader.readWord();
            long l18 = dvFileReader.readWord();
            long l19 = dvFileReader.readWord();
            long l20 = dvFileReader.readWord();
            long l21 = dvFileReader.readWord();
            long l22 = dvFileReader.readWord();
            int n5 = 0;
            while (n5 < 32) {
                vector5.add(new Long(dvFileReader.readWord()));
                ++n5;
            }
            long l23 = dvFileReader.readWord();
            long l24 = dvFileReader.readWord();
            long l25 = dvFileReader.readByte();
            long l26 = dvFileReader.readByte();
            long l27 = dvFileReader.readByte();
            int n6 = 0;
            while (n6 < 32) {
                dvFileReader.readAddress();
                dvFileReader.readWord();
                ++n6;
            }
            byte[] byArray8 = new byte[5];
            dvFileReader.read(byArray8);
            this.register.setBank("g      ", vector, 4);
            this.register.setBank("o      ", vector2, 4);
            this.register.setBank("l      ", vector3, 4);
            this.register.setBank("i      ", vector4, 4);
            this.register.setBank("fpr    ", vector5, 4);
            hashMap.put("psr     ", new Long(l17));
            hashMap.put("pc      ", new Long(l18));
            hashMap.put("npc     ", new Long(l19));
            hashMap.put("y       ", new Long(l20));
            this.register.setSpecial(hashMap, 4);
            DvUtils.trace("flags = " + Long.toHexString(l), 2, false);
            DvUtils.trace("lwpid = " + Long.toHexString(l2), 2, false);
            DvUtils.trace("why = " + Long.toHexString(l3), 2, false);
            DvUtils.trace("what = " + Long.toHexString(l4), 2, false);
            DvUtils.trace("cursig = " + Long.toHexString(l5), 2, false);
            DvUtils.trace("syscall = " + Long.toHexString(l8), 2, false);
            DvUtils.trace("nsysarg = " + Long.toHexString(l9), 2, false);
            DvUtils.trace("errno = " + Long.toHexString(l10), 2, false);
            DvUtils.trace("rval1 = " + Long.toHexString(l11), 2, false);
            DvUtils.trace("rval2 = " + Long.toHexString(l12), 2, false);
            DvUtils.trace("instr = " + Long.toHexString(l16), 2, false);
            DvUtils.trace("PSR = " + Long.toHexString(l17), 2, false);
            DvUtils.trace("PC = " + Long.toHexString(l18), 2, false);
            DvUtils.trace("nPC = " + Long.toHexString(l19), 2, false);
            DvUtils.trace("Y = " + Long.toHexString(l20), 2, false);
            int n7 = 0;
            while (n7 < 8) {
                DvUtils.trace("G" + n7 + " = " + Long.toHexString((Long)vector.elementAt(n7)), 2, false);
                ++n7;
            }
            int n8 = 0;
            while (n8 < 8) {
                DvUtils.trace("O" + n8 + " = " + Long.toHexString((Long)vector2.elementAt(n8)), 2, false);
                ++n8;
            }
            int n9 = 0;
            while (n9 < 8) {
                DvUtils.trace("L" + n9 + " = " + Long.toHexString((Long)vector3.elementAt(n9)), 2, false);
                ++n9;
            }
            int n10 = 0;
            while (n10 < 8) {
                DvUtils.trace("I" + n10 + " = " + Long.toHexString((Long)vector4.elementAt(n10)), 2, false);
                ++n10;
            }
            int n11 = 0;
            while (n11 < 32) {
                DvUtils.trace("FPR" + n11 + " = " + Long.toHexString((Long)vector5.elementAt(n11)), 2, false);
                ++n11;
            }
            DvUtils.trace("filler2 = " + l23, 2, false);
            DvUtils.trace("fsr = " + Long.toHexString(l24), 2, false);
            DvUtils.trace("qcnt = " + l25, 2, false);
            DvUtils.trace("entrysize = " + l26, 2, false);
            DvUtils.trace("en = " + l27, 2, false);
        }
    }

    class PsInfo
    extends ExProcess {
        PsInfo() throws IOException {
            DvFileReader dvFileReader = ElfSolaris.this.elf.reader;
            DvUtils.trace("Read PsInfo", 1, false);
            long l = dvFileReader.readWord();
            long l2 = dvFileReader.readWord();
            Long l3 = new Long(dvFileReader.readWord());
            long l4 = dvFileReader.readWord();
            long l5 = dvFileReader.readWord();
            long l6 = dvFileReader.readWord();
            long l7 = dvFileReader.readWord();
            long l8 = dvFileReader.readWord();
            long l9 = dvFileReader.readWord();
            long l10 = dvFileReader.readWord();
            long l11 = dvFileReader.readAddress();
            long l12 = dvFileReader.readWord();
            long l13 = dvFileReader.readWord();
            long l14 = dvFileReader.readWord();
            long l15 = dvFileReader.readWord();
            long l16 = dvFileReader.readHalf();
            long l17 = dvFileReader.readHalf();
            long l18 = dvFileReader.readLong();
            long l19 = dvFileReader.readLong();
            long l20 = dvFileReader.readLong();
            String string = dvFileReader.readString(16);
            String string2 = dvFileReader.readString(80);
            long l21 = dvFileReader.readWord();
            long l22 = dvFileReader.readWord();
            long l23 = dvFileReader.readAddress();
            long l24 = dvFileReader.readAddress();
            long l25 = dvFileReader.readByte();
            byte[] byArray = new byte[3];
            dvFileReader.read(byArray);
            byte[] byArray2 = new byte[28];
            dvFileReader.read(byArray2);
            byte[] byArray3 = new byte[104];
            dvFileReader.read(byArray3);
            this.generateExecutable(string, string2);
            DvUtils.trace("flags = " + Long.toHexString(l), 2, false);
            DvUtils.trace("numLwp = " + l2, 2, false);
            DvUtils.trace("pid = " + l3, 2, false);
            DvUtils.trace("ppid = " + l4, 2, false);
            DvUtils.trace("pgid = " + Long.toHexString(l5), 2, false);
            DvUtils.trace("sid = " + Long.toHexString(l6), 2, false);
            DvUtils.trace("uid = " + l7, 2, false);
            DvUtils.trace("euid = " + l8, 2, false);
            DvUtils.trace("gid = " + l9, 2, false);
            DvUtils.trace("egid = " + l10, 2, false);
            DvUtils.trace("processAddress = " + Long.toHexString(l11), 2, false);
            DvUtils.trace("processSize = " + Long.toHexString(l12), 2, false);
            DvUtils.trace("residentSize = " + Long.toHexString(l13), 2, false);
            DvUtils.trace("tty = " + Long.toHexString(l15), 2, false);
            DvUtils.trace("pctcpu = " + l16, 2, false);
            DvUtils.trace("pctmem = " + l17, 2, false);
            DvUtils.trace("command = " + string, 2, false);
            DvUtils.trace("executable = " + ElfSolaris.this.process.executable, 2, false);
            DvUtils.trace("commandLine = " + string2, 2, false);
            DvUtils.trace("waitStatus = " + l21, 2, false);
            DvUtils.trace("argc = " + l22, 2, false);
            DvUtils.trace("argv = " + Long.toHexString(l23), 2, false);
            DvUtils.trace("envp = " + Long.toHexString(l24), 2, false);
            DvUtils.trace("dmodel = " + l25, 2, false);
        }
    }

    class PStatus {
        PStatus(ExProcess exProcess) throws IOException {
            DvUtils.trace("Read PStatus", 1, false);
            DvFileReader dvFileReader = ElfSolaris.this.elf.reader;
            long l = dvFileReader.readWord();
            long l2 = dvFileReader.readWord();
            exProcess.pid = dvFileReader.readWord();
            long l3 = dvFileReader.readWord();
            long l4 = dvFileReader.readWord();
            long l5 = dvFileReader.readWord();
            long l6 = dvFileReader.readWord();
            long l7 = dvFileReader.readWord();
            byte[] byArray = new byte[16];
            dvFileReader.read(byArray);
            long l8 = dvFileReader.readAddress();
            long l9 = dvFileReader.readWord();
            long l10 = dvFileReader.readAddress();
            long l11 = dvFileReader.readWord();
            long l12 = dvFileReader.readWord();
            long l13 = dvFileReader.readWord();
            long l14 = dvFileReader.readWord();
            long l15 = dvFileReader.readWord();
            long l16 = dvFileReader.readWord();
            long l17 = dvFileReader.readWord();
            long l18 = dvFileReader.readWord();
            long l19 = dvFileReader.readWord();
            byte[] byArray2 = new byte[16];
            dvFileReader.read(byArray2);
            byte[] byArray3 = new byte[16];
            dvFileReader.read(byArray3);
            byte[] byArray4 = new byte[64];
            dvFileReader.read(byArray4);
            byte[] byArray5 = new byte[64];
            dvFileReader.read(byArray5);
            long l20 = dvFileReader.readByte();
            byte[] byArray6 = new byte[3];
            dvFileReader.read(byArray6);
            byte[] byArray7 = new byte[76];
            dvFileReader.read(byArray7);
            byte[] byArray8 = new byte[896];
            dvFileReader.read(byArray8);
            DvUtils.trace("flags = " + Long.toHexString(l), 2, false);
            DvUtils.trace("numThreads = " + Long.toHexString(l2), 2, false);
            DvUtils.trace("pid = " + Long.toHexString(exProcess.pid), 2, false);
            DvUtils.trace("ppid = " + Long.toHexString(l3), 2, false);
            DvUtils.trace("pgid = " + Long.toHexString(l4), 2, false);
            DvUtils.trace("sid = " + Long.toHexString(l5), 2, false);
            DvUtils.trace("aslwpid = " + Long.toHexString(l6), 2, false);
            DvUtils.trace("agentid = " + Long.toHexString(l7), 2, false);
            DvUtils.trace("sigpend = " + byArray, 2, false);
            DvUtils.trace("brkbase = " + Long.toHexString(l8), 2, false);
            DvUtils.trace("brksize = " + Long.toHexString(l9), 2, false);
            DvUtils.trace("stkbase = " + Long.toHexString(l10), 2, false);
            DvUtils.trace("stksize = " + Long.toHexString(l11), 2, false);
            DvUtils.trace("cpu = " + Long.toHexString(l12), 2, false);
            DvUtils.trace("cpu_ms = " + Long.toHexString(l13), 2, false);
            DvUtils.trace("sys = " + Long.toHexString(l14), 2, false);
            DvUtils.trace("sys_ms = " + Long.toHexString(l15), 2, false);
            DvUtils.trace("ccpu = " + Long.toHexString(l16), 2, false);
            DvUtils.trace("ccpu_ms = " + Long.toHexString(l17), 2, false);
            DvUtils.trace("csys = " + Long.toHexString(l18), 2, false);
            DvUtils.trace("csys_ms = " + Long.toHexString(l19), 2, false);
            DvUtils.trace("sigtrace = " + byArray2, 2, false);
            DvUtils.trace("sysentry = " + byArray4, 2, false);
            DvUtils.trace("dmodel = " + Long.toHexString(l20), 2, false);
        }
    }
}

