/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.extract;

import com.ibm.jvm.dump.extract.ExRegister;
import com.ibm.jvm.dump.format.DvJavaFrame;
import com.ibm.jvm.dump.format.DvNativeFrame;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.frame.ThreadContext;
import com.ibm.jvm.dump.sdff.SDFFJavaStack;
import com.ibm.jvm.dump.sdff.SDFFNativeStack;
import com.ibm.jvm.dump.sdff.Sdff;
import java.io.IOException;

class ExThread {
    Long pid;
    long tid;
    ThreadContext context = new ThreadContext();
    long execEnv;
    ExRegister register = new ExRegister();
    DvJavaFrame[] javaFrames;
    DvNativeFrame[] nativeFrames;

    ExThread() {
    }

    void attach(long l, long l2, long l3) {
        DvUtils.trace("ExThread pid=" + l + " tid=" + l2, 2, false);
        this.pid = new Long(l);
        this.tid = l2;
        this.execEnv = l3;
    }

    ThreadContext getFrameContext() {
        long l = this.execEnv;
        this.context.setEE(l);
        DvUtils.trace("Using ThreadContext with ee:" + Long.toHexString(this.context.getEE()) + " ip:" + Long.toHexString(this.context.getPc()) + " lr:" + Long.toHexString(this.context.getLr()) + " sp:" + Long.toHexString(this.context.getSp()) + " bp:" + Long.toHexString(this.context.getBp()), 2, false);
        return this.context;
    }

    void printSdff(Sdff sdff) throws IOException {
        DvUtils.trace("Printing Thread", 0, false);
        sdff.align(8);
        long l = sdff.getFilePointer();
        sdff.writeLong(0L);
        sdff.writeBytes("THREAD  ");
        sdff.writeLong(this.tid);
        sdff.writeInt(-1);
        sdff.writeInt(-1);
        sdff.writeLong(this.context.getSp());
        sdff.writeLong(this.context.getPc());
        sdff.writeLong(this.execEnv);
        sdff.writeInt(-1);
        sdff.writeInt(-1);
        SDFFJavaStack sDFFJavaStack = new SDFFJavaStack(this.javaFrames);
        SDFFNativeStack sDFFNativeStack = new SDFFNativeStack(this.nativeFrames);
        sDFFJavaStack.printSdff(sdff);
        sDFFNativeStack.printSdff(sdff);
        this.register.printSdff(sdff);
        int n = 0;
        while (n < 8) {
            sdff.writeBytes("PAD ");
            ++n;
        }
        sdff.writeLong(-1L);
        sdff.printLength(l);
    }
}

