/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.extract;

import com.ibm.jvm.dump.extract.ExProcess;
import com.ibm.jvm.dump.extract.ExThread;
import com.ibm.jvm.dump.extract.Extract;
import com.ibm.jvm.dump.format.DvJavaFrame;
import com.ibm.jvm.dump.format.DvNativeFrame;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.frame.FrameTraverser;
import com.ibm.jvm.dump.frame.JavaFrame;
import com.ibm.jvm.dump.frame.NativeFrame;
import com.ibm.jvm.dump.frame.TargetReader;
import com.ibm.jvm.dump.frame.ThreadContext;
import com.ibm.jvm.dump.sdff.DvFileReader;
import com.ibm.jvm.dump.sdff.Segment;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;

class HPIModule
extends Segment {
    long fileOffset;
    long hpiInfo;
    long threadQueue;
    long threadNum;
    long threadNext;
    long execEnvOffset;
    long pidOffset;
    long tidOffset;
    long spOffset;
    long pfmData;

    HPIModule() {
    }

    HPIModule(Segment segment, long l) {
        super(segment.moduleName, segment.moduleAddress.getAddressAsLong(), segment.moduleSize, segment.moduleType, segment.reader, segment.offset);
        this.fileOffset = l;
    }

    boolean populate() throws IOException {
        DvUtils.trace("populate HPIModule", 0, false);
        ((DvFileReader)this.reader).setPos(this.fileOffset);
        this.threadQueue = ((DvFileReader)this.reader).readAddress();
        this.threadNext = ((DvFileReader)this.reader).readAddress();
        this.execEnvOffset = ((DvFileReader)this.reader).readAddressOffset();
        this.pidOffset = ((DvFileReader)this.reader).readAddressOffset();
        this.tidOffset = ((DvFileReader)this.reader).readAddressOffset();
        this.spOffset = ((DvFileReader)this.reader).readAddressOffset();
        this.pfmData = ((DvFileReader)this.reader).readAddressOffset();
        DvUtils.trace("threadQueue=" + Long.toHexString(this.threadQueue), 2, false);
        DvUtils.trace("threadNext=" + Long.toHexString(this.threadNext), 2, false);
        DvUtils.trace("execEnvOffset=" + Long.toHexString(this.execEnvOffset), 2, false);
        DvUtils.trace("spOffset=" + Long.toHexString(this.spOffset), 2, false);
        DvUtils.trace("tidOffset=" + Long.toHexString(this.tidOffset), 2, false);
        DvUtils.trace("pfmData=" + Long.toHexString(this.pfmData), 2, false);
        return true;
    }

    boolean populateThread(ExProcess exProcess, HashMap hashMap) throws IOException {
        DvUtils.trace("populateThread: process=" + exProcess + " reader=" + this.reader, 0, false);
        ((DvFileReader)this.reader).setAddress(this.threadQueue);
        long l = ((DvFileReader)this.reader).readAddress();
        DvUtils.trace("Thread: " + Long.toHexString(l), 2, false);
        ExReader exReader = new ExReader((DvFileReader)this.reader);
        FrameTraverser frameTraverser = new FrameTraverser(exReader, exProcess.jvmData.jvmRas, null, Extract.getExeName(), null);
        while (l != 0L) {
            long l2 = l + this.execEnvOffset;
            DvUtils.trace("thread=" + l + " execEnvOffset=" + this.execEnvOffset + " execEnv=" + l2, 1, false);
            DvUtils.trace("execEnv : " + Long.toHexString(l2), 2, false);
            ((DvFileReader)this.reader).setAddress(l + this.spOffset);
            long l3 = ((DvFileReader)this.reader).readAddress();
            DvUtils.trace("sp address: " + Long.toHexString(l) + " value = " + Long.toHexString(l3), 2, false);
            DvUtils.trace("Thread: " + Long.toHexString(l), 2, false);
            ((DvFileReader)this.reader).setAddress(l + this.tidOffset);
            long l4 = ((DvFileReader)this.reader).readAddress();
            ExThread exThread = exProcess.getNativeThread(l3);
            if (exThread == null) {
                DvUtils.trace("No native thread found", 2, false);
                exThread = new ExThread();
                exThread.context.setEE(l2);
                exProcess.thread.add(exThread);
            }
            exThread.attach(l3, l4, l2);
            ((DvFileReader)this.reader).setAddress(l + this.threadNext);
            l = ((DvFileReader)this.reader).readAddress();
            DvUtils.trace("Thread: " + Long.toHexString(l), 2, false);
        }
        Enumeration enumeration = exProcess.thread.elements();
        while (enumeration.hasMoreElements()) {
            ExThread exThread = (ExThread)enumeration.nextElement();
            ThreadContext threadContext = exThread.getFrameContext();
            JavaFrame[] javaFrameArray = frameTraverser.getJavaFrames(threadContext);
            if (javaFrameArray != null) {
                exThread.javaFrames = new DvJavaFrame[javaFrameArray.length];
                int n = 0;
                while (n < javaFrameArray.length) {
                    exThread.javaFrames[n] = new DvJavaFrame(javaFrameArray[n]);
                    ++n;
                }
            } else {
                exThread.javaFrames = null;
            }
            NativeFrame[] nativeFrameArray = frameTraverser.getNativeFrames(threadContext);
            if (nativeFrameArray != null) {
                exThread.nativeFrames = new DvNativeFrame[nativeFrameArray.length];
                int n = 0;
                while (n < nativeFrameArray.length) {
                    exThread.nativeFrames[n] = new DvNativeFrame(nativeFrameArray[n]);
                    ++n;
                }
                continue;
            }
            exThread.nativeFrames = null;
        }
        return true;
    }

    class ExReader
    extends TargetReader {
        DvFileReader reader;

        ExReader(DvFileReader dvFileReader) {
            this.reader = dvFileReader;
        }

        public int readBytes(byte[] byArray, long l, int n) {
            try {
                this.reader.setAddress(l);
                if (this.reader.getPos() == 0L) {
                    return 0;
                }
                this.reader.read(byArray, 0, n);
                return n;
            }
            catch (Exception exception) {
                return 0;
            }
        }
    }
}

