/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.format;

import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.frame.NativeFrame;
import java.io.UnsupportedEncodingException;

public class DvNativeFrame {
    long mb;
    long pc;
    long sp;
    int frameType;
    String name;

    public long frameid() {
        return this.sp;
    }

    public DvAddress spAddress() {
        return new DvAddress(this.sp);
    }

    public DvAddress mbAddress() {
        return new DvAddress(this.mb);
    }

    public DvAddress pcAddress() {
        return new DvAddress(this.pc);
    }

    public DvNativeFrame(NativeFrame nativeFrame) {
        this.mb = nativeFrame.getMb();
        this.pc = nativeFrame.getPc();
        this.sp = nativeFrame.getSp();
        this.frameType = nativeFrame.getFrameType();
        this.setName(nativeFrame.getName());
    }

    public DvNativeFrame() {
    }

    public boolean isJit() {
        return this.frameType == 2;
    }

    public boolean isNative() {
        return this.frameType == 3;
    }

    public boolean isMmi() {
        return this.frameType == 0;
    }

    public byte[] getMetadata() {
        return null;
    }

    public void setMb(long l) {
        this.mb = l;
    }

    public void setPc(long l) {
        this.pc = l;
    }

    public void setSp(long l) {
        this.sp = l;
    }

    public void setFrameType(int n) {
        this.frameType = n;
    }

    public void setName(byte[] byArray) {
        String string;
        try {
            string = new String(byArray, "ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            DvUtils.writetoTrace(" DvNativeFrame:toString() - ASCII encoding not found");
            string = new String(byArray);
        }
        this.name = string.trim();
    }

    public long getMb() {
        return this.mb;
    }

    public long getPc() {
        return this.pc;
    }

    public long getSp() {
        return this.sp;
    }

    public String getName() {
        return this.name;
    }

    public int getFrameType() {
        return this.frameType;
    }

    public String toString() {
        return this.name;
    }
}

