/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.format;

import com.ibm.jvm.Trace;
import com.ibm.jvm.dump.format.CType;
import com.ibm.jvm.dump.format.CTypeFile;
import com.ibm.jvm.dump.format.CTypeObject;
import com.ibm.jvm.dump.format.Dumpviewer;
import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressException;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvDump;
import com.ibm.jvm.dump.format.DvMemRanges;
import com.ibm.jvm.dump.format.DvProcess;
import com.ibm.jvm.dump.format.DvThread;
import com.ibm.jvm.dump.format.Dvifm;
import com.ibm.jvm.dump.plugins.CommandPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class DvUtils {
    private static String suffix = null;
    private static DvThread currentThread = null;
    private static DvProcess currentProcess = null;
    private static DvAddressSpace currentAsid = null;
    private static boolean consoleOutput = true;
    private static Properties setValues = null;
    private static Dvifm theIFM;
    private static String traceString;
    private static String traceString1;
    private static String traceString2;
    private static boolean order12;
    private static Properties dvProperties;
    private static JTextArea tc_text;
    public static String byteToHex;
    private static boolean verbose;
    private static boolean force;
    private static boolean bTraceTime;
    public static String byteToAscii;
    public static String byteToEbcdic;
    private static boolean typeFileLoaded;
    private static Vector jvmHints;
    private static DateFormat df;
    private static String[] hintListJvm;
    private static String[] hintListSTGlobal;
    static int traceHandle;
    static final String[] templates;
    static final int ENTRY = 0;
    static final int EXIT = 1;
    static final int EVENT = 2;
    static final int EXCEPTION = 3;
    static final int ERROREXIT = 4;
    private static int inLoadFormatFile;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$ibm$jvm$dump$format$DvConsole;

    public static void initTrace() {
        traceHandle = Trace.registerApplication((String)"DvConsole", (String[])templates);
        DvUtils.writetoTrace(" trace started  ");
    }

    public static void errorMsg(String string, int n) {
        System.err.println("\n***** ERROR **********");
        System.err.println(string);
        System.err.println("***** ERROR **********\n");
    }

    public static void infoMsg(String string) {
        System.out.println("\n***** Information **********");
        System.out.println(string);
        System.out.println("***** Information **********\n");
    }

    public static void setTc_text(JTextArea jTextArea) {
        tc_text = jTextArea;
    }

    public static String getDvProperty(String string) {
        if (!string.equals("EarlyTrace")) {
            DvUtils.writetoTrace("DvUtils:getDvProperty entry (" + string + ")");
        }
        String string2 = null;
        if (dvProperties == null) {
            dvProperties = DvUtils.findPropertiesFile("Dv.properties");
        }
        if (null != dvProperties) {
            string2 = dvProperties.getProperty(string);
        }
        if (!string.equals("EarlyTrace")) {
            DvUtils.writetoTrace("DvUtils:getDvProperty exit (" + string2 + ")");
        }
        return string2;
    }

    public static String getSuppProperty(String string) {
        if (!string.equals("EarlyTrace")) {
            DvUtils.writetoTrace("DvUtils:getSuppProperty entry (" + string + ")");
        }
        String string2 = null;
        if (null != DvConsole.supplementalP) {
            string2 = DvConsole.supplementalP.getProperty(string);
        }
        if (!string.equals("EarlyTrace")) {
            DvUtils.writetoTrace("DvUtils:getSuppProperty exit (" + string2 + ")");
        }
        return string2;
    }

    public static Properties searchClassPathForPropFile(String string) {
        Properties properties = null;
        String string2 = System.getProperty("java.class.path");
        String string3 = System.getProperty("path.separator");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens() && !bl) {
            String string4 = System.getProperty("file.separator");
            String string5 = stringTokenizer.nextToken() + string4 + string;
            try {
                FileInputStream fileInputStream = new FileInputStream(string5);
                properties = new Properties();
                properties.load(fileInputStream);
                bl = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return properties;
    }

    public static Vector findCommandPlugins(boolean bl, Vector vector) {
        DvUtils.writetoTrace("Looking for command plugins");
        Vector vector2 = new Vector();
        String string = DvUtils.getDvProperty("CommandPlugins");
        if (bl) {
            String string2 = DvUtils.getSuppProperty("CommandPlugins");
            string = string + "," + string2;
        }
        if (null == string) {
            DvUtils.errorMsg("No CommandPlugins stanza(s) found ", 0);
            return null;
        }
        vector2 = DvUtils.findCommandClasses(string, vector);
        DvUtils.writetoTrace(" DvUtils:findCommandPlugins - " + vector2.size() + " command plugins found");
        return vector2;
    }

    public static DvDump findDumpPlugin(String string) {
        DvDump dvDump;
        boolean bl = false;
        DvUtils.writetoTrace("Looking for dump plugin that supports " + string);
        String string2 = DvUtils.getDvProperty("DumpPlugins");
        if (null == string2) {
            string2 = "SDFFDump";
        }
        if (null != (dvDump = DvUtils.findDumpClass(string, string2))) {
            bl = true;
        } else {
            DvUtils.writetoTrace("No dump plugin owned up to supporting " + string);
        }
        return dvDump;
    }

    public static void enableConsoleTrace(boolean bl) {
        verbose = bl;
    }

    public static boolean isTraceOn() {
        return verbose;
    }

    public static void setNativeLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            DvUtils.writetoTrace("Error setting native LAF: " + exception);
        }
    }

    public static void setJavaLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            DvUtils.writetoTrace("Error setting Java LAF: " + exception);
        }
    }

    public static void setMotifLookAndFeel() {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
        }
        catch (Exception exception) {
            DvUtils.writetoTrace("Error setting Motif LAF: " + exception);
        }
    }

    public static void setTheIFM(Dvifm dvifm) {
        theIFM = dvifm;
    }

    public static Dvifm getTheIFM() {
        return theIFM;
    }

    public static void writetoTrace(String string) {
        if (DvConsole.runningUnderGUI && DvConsole.bSystemErrTrace) {
            System.err.println(string);
        } else if (!DvConsole.runningUnderGUI && verbose) {
            if (bTraceTime) {
                System.err.println(DvUtils.getTime() + string);
            } else {
                System.err.println(string);
            }
        }
    }

    public static long hexToLong(String string) throws NumberFormatException {
        int n;
        long l = 0L;
        if (string.startsWith("0x")) {
            string = string.substring(2, string.length());
        }
        if ((n = string.length()) <= 16) {
            int n2 = 0;
            while (n2 < n) {
                int n3 = DvUtils.hexValue(string.charAt(n2));
                if (n3 == -1) {
                    throw new NumberFormatException("Bad hex input");
                }
                l = 16L * l + (long)n3;
                ++n2;
            }
        } else {
            throw new NumberFormatException("Too many hex digits");
        }
        return l;
    }

    public static int hexValue(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        return -1;
    }

    public static Vector findCommandClasses(String string, Vector vector) {
        Vector<CommandPlugin> vector2 = new Vector<CommandPlugin>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = stringTokenizer.countTokens();
        int n2 = 0;
        boolean bl = false;
        String string2 = stringTokenizer.nextToken();
        String string3 = "*** Loading plugins ***\n";
        if (DvConsole.runningUnderGUI && !string2.endsWith("Gui")) {
            string2 = string2 + "Gui";
        }
        while (!bl) {
            try {
                string2 = string2.trim();
                DvUtils.writetoTrace(" Trying .." + string2);
                Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(string2);
                CommandPlugin commandPlugin = null;
                try {
                    commandPlugin = (CommandPlugin)clazz.newInstance();
                    vector2.add(commandPlugin);
                    string3 = string3 + "loaded " + string2 + "\n";
                    ++n2;
                }
                catch (InstantiationException instantiationException) {}
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (DvConsole.runningUnderGUI) {
                    --n;
                } else {
                    string3 = string3 + "ERROR: " + string2 + ".class - class not found\n";
                    DvUtils.writetoTrace(" ERROR: " + string2 + ".class - class not found");
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                string3 = string3 + "ERROR: " + string2 + " - IllegalAccessException\n";
                DvUtils.writetoTrace(" ERROR: " + string2 + " - IllegalAccessException");
            }
            catch (ClassCastException classCastException) {
                string3 = string3 + "ERROR: " + string2 + " - is not a CommandPlugin\n";
                DvUtils.writetoTrace(" ERROR: " + string2 + " - is not a CommandPlugin");
            }
            try {
                string2 = stringTokenizer.nextToken();
                if (!DvConsole.runningUnderGUI || string2.endsWith("Gui")) continue;
                string2 = string2 + "Gui";
            }
            catch (NoSuchElementException noSuchElementException) {
                bl = true;
            }
        }
        string3 = n2 == n ? string3 + "\n*** All plugins loaded successfully *** \n" : string3 + "\n*** ERROR: " + (n - n2) + " plugin(s) failed to load *** \n";
        if (null == DvConsole.viewerInit) {
            if (null != vector) {
                vector.add(string3);
            } else {
                System.out.println(string3);
            }
        } else if (null != vector) {
            vector.add(string3);
        } else {
            DvConsole.viewerInit.add(string3);
        }
        return vector2;
    }

    public static DvDump findDumpClass(String string, String string2) {
        DvUtils.writetoTrace("Dumpviewer: findDumpClass entry - " + string + "-" + string2);
        DvDump dvDump = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        int n = stringTokenizer.countTokens();
        boolean bl = false;
        String string3 = stringTokenizer.nextToken();
        int n2 = 0;
        while (!bl) {
            try {
                DvUtils.writetoTrace(" Trying .." + string3);
                Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(string3);
                Method method = clazz.getMethod("isSupportedSource", class$java$lang$String == null ? DvUtils.class$("java.lang.String") : class$java$lang$String);
                Object object = method.invoke(null, string);
                Boolean bl2 = (Boolean)object;
                if (bl2.booleanValue()) {
                    try {
                        dvDump = (DvDump)clazz.newInstance();
                        suffix = DvUtils.getValue("Suffix");
                        if (null == suffix) {
                            suffix = dvDump.getSuffix();
                        }
                        bl = true;
                    }
                    catch (InstantiationException instantiationException) {
                        System.err.println("\nInstantiationException");
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        System.err.println("\nIllegalAccessException");
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                DvUtils.writetoTrace(" ERROR!!! " + string3 + ".class was not found !!!!");
            }
            catch (NoSuchMethodException noSuchMethodException) {
                DvUtils.writetoTrace(" ERROR!!! " + string3 + ".class has no isSupportedSource method !!!!");
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println("\nIllegalAccessException");
            }
            catch (InvocationTargetException invocationTargetException) {
                System.err.println("\nInvocationTargetException");
            }
            try {
                string3 = stringTokenizer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                bl = true;
            }
            ++n2;
        }
        DvUtils.writetoTrace("Dumpviewer: findDumpClass exit - " + (null == dvDump ? "Unrecognized format" : "Recognized format"));
        return dvDump;
    }

    public static void removeSpecFromVector(Vector vector, String string) {
        int n = -1;
        int n2 = 0;
        while (n2 < vector.size() && n == -1) {
            if (vector.get(n2).equals(string)) {
                n = n2;
            }
            ++n2;
        }
        if (-1 != n) {
            vector.remove(n);
        }
    }

    public static void initSetCommand() {
        if (null == setValues) {
            String string;
            Object object;
            Object object2;
            block9: {
                try {
                    object2 = new FileInputStream("DvSetDefaults.properties");
                    object = new Properties();
                    DvUtils.setProperties((Properties)object);
                    ((Properties)object).load((InputStream)object2);
                }
                catch (IOException iOException) {
                    object = System.getProperty("file.separator");
                    string = "com" + (String)object + "ibm" + (String)object + "jvm" + (String)object + "dump" + (String)object + "format" + (String)object + "DvSetDefaults.properties";
                    setValues = DvUtils.searchClassPathForPropFile(string);
                    if (null != setValues) break block9;
                    string = "DvSetDefaults.properties";
                    setValues = DvUtils.searchClassPathForPropFile(string);
                }
            }
            if (null == setValues) {
                object2 = new Properties();
                object = (class$com$ibm$jvm$dump$format$DvConsole == null ? (class$com$ibm$jvm$dump$format$DvConsole = DvUtils.class$("com.ibm.jvm.dump.format.DvConsole")) : class$com$ibm$jvm$dump$format$DvConsole).getClassLoader();
                if (null == object) {
                    object = ClassLoader.getSystemClassLoader();
                }
                try {
                    string = "com/ibm/jvm/dump/format/DvSetDefaults.properties";
                    InputStream inputStream = ((ClassLoader)object).getResourceAsStream(string);
                    if (null != inputStream) {
                        ((Properties)object2).load(inputStream);
                        setValues = object2;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (null == setValues) {
                System.err.println("Unable to find DvSetDefaults");
            }
        }
    }

    public static Enumeration getPropertyNames() {
        return setValues.propertyNames();
    }

    public static void setProperties(Properties properties) {
        setValues = properties;
    }

    public static void setValue(String string, String string2) {
        if (null == string2 || string2.equals("")) {
            setValues.remove(string.toUpperCase());
        } else {
            setValues.setProperty(string.toUpperCase(), string2);
        }
    }

    public static String getValue(String string) {
        return setValues.getProperty(string.toUpperCase());
    }

    public static int getPropertyInt(String string) {
        int n;
        block2: {
            n = -1;
            if (null == setValues) break block2;
            String string2 = setValues.getProperty(string.toUpperCase());
            try {
                n = new Integer(string2);
            }
            catch (Exception exception) {}
        }
        return n;
    }

    public static String getProperty(String string) {
        String string2 = null;
        if (null != setValues) {
            string2 = setValues.getProperty(string);
        }
        return string2;
    }

    public static boolean isConsoleOutput() {
        return consoleOutput;
    }

    public static void setConsoleOutput(boolean bl) {
        consoleOutput = bl;
    }

    protected static final int convertEndian(int n) {
        return n >>> 24 | n << 24 | n << 8 & 0xFF0000 | n >> 8 & 0xFF00;
    }

    public static boolean is64BitSystem(int n) {
        boolean bl = false;
        try {
            if (-1 != DvDump.ARCHITECTURE_DESCRIPTION[n].indexOf("64")) {
                bl = true;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return bl;
    }

    public static boolean isBigEndian(int n) {
        boolean bl = false;
        try {
            if (-1 != DvDump.ARCHITECTURE_DESCRIPTION[n].indexOf("Big")) {
                bl = true;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return bl;
    }

    public static byte[] convertToBigEndian(byte[] byArray) {
        if (byArray.length != 4 && byArray.length != 8) {
            return byArray;
        }
        if (byArray.length == 8) {
            byte[] byArray2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
            byArray2[0] = byArray[7];
            byArray2[1] = byArray[6];
            byArray2[2] = byArray[5];
            byArray2[3] = byArray[4];
            byArray2[4] = byArray[3];
            byArray2[5] = byArray[2];
            byArray2[6] = byArray[1];
            byArray2[7] = byArray[0];
            return byArray2;
        }
        byte[] byArray3 = new byte[]{0, 0, 0, 0};
        byArray3[0] = byArray[3];
        byArray3[1] = byArray[2];
        byArray3[2] = byArray[1];
        byArray3[3] = byArray[0];
        return byArray3;
    }

    public static String bytesToHexString(byte[] byArray) {
        String string = "";
        int n = 0;
        boolean bl = true;
        while (n < byArray.length) {
            int n2 = byArray[n];
            if (n2 < 0) {
                n2 += 256;
            }
            string = string + byteToHex.substring(2 * n2, 2 * n2 + 2);
            ++n;
        }
        return string;
    }

    public static void output(String string) {
        System.out.println(string);
    }

    public static long findNextInFile(RandomAccessFile randomAccessFile, byte[] byArray, long l, long l2, int n) {
        long l3;
        block11: {
            String string = new String(byArray);
            DvUtils.writetoTrace("DvUtil:findNextInFile entry(what=" + string + " sp=x" + Long.toHexString(l) + " ep=x" + Long.toHexString(l2));
            l3 = -1L;
            long l4 = byArray.length;
            long l5 = l;
            byte[] byArray2 = new byte[4096];
            Object var19_10 = null;
            if (0 != n) {
                l5 = l + l % (long)n;
            }
            if (l5 >= l2) break block11;
            try {
                boolean bl = false;
                boolean bl2 = true;
                int n2 = 0;
                while (!bl && l < l2) {
                    if (bl2) {
                        DvUtils.writetoTrace(" Reading from file at offfset x" + Long.toHexString(l5));
                        randomAccessFile.seek(l5);
                        randomAccessFile.read(byArray2);
                        bl2 = false;
                        n2 = 0;
                    }
                    bl = true;
                    int n3 = 0;
                    while (n3 < byArray.length && bl) {
                        if (byArray[n3] != byArray2[n3 + n2]) {
                            bl = false;
                        }
                        ++n3;
                    }
                    if (bl) continue;
                    n2 = 0 != n ? (n2 += n) : ++n2;
                    if ((long)n2 <= 4096L - l4) continue;
                    bl2 = true;
                    if ((l5 = l5 + 4096L - (l4 + l4 % (long)n)) < l2) continue;
                    l = l2;
                }
                if (bl) {
                    l3 = l5 + (long)n2;
                    if (l3 > l2) {
                        l3 = -1L;
                        DvUtils.writetoTrace("Failed to find it...(1)");
                    } else {
                        DvUtils.writetoTrace("Found it at 0x" + Long.toHexString(l3));
                    }
                    break block11;
                }
                DvUtils.writetoTrace("Failed to find it...(2)");
            }
            catch (IOException iOException) {
                DvUtils.writetoTrace("DvUtil:findNextInFile caught IOException");
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                DvUtils.writetoTrace("DvUtil:findNextInFile caught ArrayIndexOutOfBoundsException");
            }
        }
        return l3;
    }

    public static Vector findInMemory(DvDump dvDump, byte[] byArray, DvAddress dvAddress, DvAddress dvAddress2, int n, int n2, boolean bl) {
        long l = 0L;
        Vector<DvAddress> vector = new Vector<DvAddress>();
        DvAddressSpace dvAddressSpace = DvUtils.findAsid(dvDump, DvUtils.getValue("ASID"));
        Object var11_10 = null;
        long l2 = dvAddress.getAddressAsLong();
        long l3 = dvAddress2.getAddressAsLong();
        if (0L != l2 % (long)n) {
            l2 += (long)n - l2 % (long)n;
            try {
                dvAddress.offsetBy((long)n - l2 % (long)n);
            }
            catch (DvAddressException dvAddressException) {
                try {
                    dvAddress.offsetBy(-l2 % (long)n);
                }
                catch (DvAddressException dvAddressException2) {
                    // empty catch block
                }
            }
        }
        if (0L != l3 % (long)n) {
            l3 += (long)n - l3 % (long)n;
            try {
                dvAddress2.offsetBy((long)n - l3 % (long)n);
            }
            catch (DvAddressException dvAddressException) {
                try {
                    dvAddress2.offsetBy(-l3 % (long)n);
                }
                catch (DvAddressException dvAddressException3) {
                    // empty catch block
                }
            }
        }
        if (null != dvDump && 1 == dvAddress.compare(dvAddress2)) {
            DvMemRanges[] dvMemRangesArray = dvAddressSpace.getMemRanges();
            int n3 = 0;
            while (n3 < dvMemRangesArray.length && vector.size() < n2) {
                long l4 = dvMemRangesArray[n3].addressStart().getAddressAsLong();
                long l5 = l4 + dvMemRangesArray[n3].length();
                DvAddress dvAddress3 = dvAddressSpace.createAddress(l5);
                DvAddress dvAddress4 = dvAddressSpace.createAddress(l4);
                if (0L != l4 % (long)n) {
                    try {
                        dvAddress4.offsetBy((long)n - l4 % (long)n);
                    }
                    catch (DvAddressException dvAddressException) {
                        try {
                            dvAddress4.offsetBy(-l4 % (long)n);
                        }
                        catch (DvAddressException dvAddressException4) {
                            // empty catch block
                        }
                    }
                }
                if (0L != l5 % (long)n) {
                    try {
                        dvAddress3.offsetBy((long)n - l5 % (long)n);
                    }
                    catch (DvAddressException dvAddressException) {
                        try {
                            dvAddress3.offsetBy(-l5 % (long)n);
                        }
                        catch (DvAddressException dvAddressException5) {
                            // empty catch block
                        }
                    }
                }
                if (1 != dvAddress2.compare(dvAddress) && -1 != dvAddress.compare(dvAddress3) && -1 != dvAddress4.compare(dvAddress2) && dvMemRangesArray[n3].length() != 0L) {
                    DvAddress dvAddress5 = dvAddressSpace.createAddress(l4);
                    if (1 == dvAddress5.compare(dvAddress)) {
                        dvAddress5 = dvAddressSpace.createAddress(dvAddress.getAddressAsLong());
                    }
                    boolean bl2 = false;
                    while (!bl2) {
                        long l6 = dvAddress5.getAddressAsLong();
                        int n4 = 16000;
                        byte[] byArray2 = null;
                        try {
                            byArray2 = dvAddressSpace.readBytes(dvAddress5, 16384L);
                        }
                        catch (DvAddressException dvAddressException) {
                            byArray2 = new byte[]{};
                        }
                        if (null == byArray2) {
                            System.err.println("Error!!! - Ongoing:" + dvAddress5.getAddressAsLong());
                        }
                        l += (long)byArray2.length;
                        int n5 = byArray2.length;
                        if (16384 == byArray2.length) {
                            try {
                                dvAddress5.offsetBy(16000L);
                                if (1 == dvAddress3.compare(dvAddress5) || 1 == dvAddress2.compare(dvAddress5)) {
                                    bl2 = true;
                                }
                            }
                            catch (DvAddressException dvAddressException) {
                                bl2 = true;
                            }
                        } else {
                            bl2 = true;
                            n4 = n5;
                        }
                        boolean bl3 = false;
                        if (n5 <= 0) continue;
                        int n6 = 0;
                        while (n6 < n4) {
                            bl3 = true;
                            int n7 = 0;
                            while (n7 < byArray.length && bl3 && n7 + n6 < n5) {
                                if (byArray[n7] != byArray2[n7 + n6]) {
                                    bl3 = false;
                                }
                                ++n7;
                            }
                            if (bl3) {
                                DvAddress dvAddress6 = dvAddressSpace.createAddress(l6 + (long)n6);
                                if (-1 != dvAddress6.compare(dvAddress2)) {
                                    vector.add(dvAddressSpace.createAddress(l6 + (long)n6));
                                    if (n2 == vector.size()) {
                                        n6 = n4;
                                        bl2 = true;
                                    }
                                } else {
                                    bl2 = true;
                                }
                            }
                            n6 += n;
                        }
                    }
                }
                ++n3;
            }
        }
        DvUtils.writetoTrace(" .... Number of bytes read = " + l);
        return vector;
    }

    public static DvThread findThread(DvDump dvDump, String string, DvAddressSpace dvAddressSpace, DvProcess dvProcess) {
        DvThread dvThread = currentThread;
        if (null == currentThread || !currentThread.id().equals(string)) {
            dvThread = null;
            DvThread[] dvThreadArray = dvProcess.getThreads();
            if (null != dvThreadArray) {
                boolean bl = false;
                int n = 0;
                while (n < dvThreadArray.length && !bl) {
                    if (dvThreadArray[n].id().equals(string)) {
                        dvThread = dvThreadArray[n];
                        bl = true;
                    }
                    ++n;
                }
            }
        }
        return dvThread;
    }

    public static DvProcess findProc(DvDump dvDump, String string, DvAddressSpace dvAddressSpace) {
        DvProcess dvProcess = currentProcess;
        if (null == currentProcess || !currentProcess.id().equals(string)) {
            dvProcess = null;
            DvProcess[] dvProcessArray = dvAddressSpace.getProcesses();
            if (null != dvProcessArray) {
                boolean bl = false;
                int n = 0;
                while (n < dvProcessArray.length && !bl) {
                    if (dvProcessArray[n].id().equals(string)) {
                        dvProcess = dvProcessArray[n];
                        bl = true;
                    }
                    ++n;
                }
            }
        }
        return dvProcess;
    }

    public static DvAddressSpace findAsid(DvDump dvDump, String string) {
        DvAddressSpace dvAddressSpace = currentAsid;
        if (null == dvAddressSpace || !dvAddressSpace.id().equals(string)) {
            dvAddressSpace = null;
            DvAddressSpace[] dvAddressSpaceArray = dvDump.getAddressSpaces();
            if (null != dvAddressSpaceArray) {
                boolean bl = false;
                int n = 0;
                while (n < dvAddressSpaceArray.length && !bl) {
                    if (dvAddressSpaceArray[n].id().equals(string)) {
                        dvAddressSpace = dvAddressSpaceArray[n];
                        bl = true;
                    }
                    ++n;
                }
            }
        }
        return dvAddressSpace;
    }

    public static File searchForFile(String string) {
        String string2;
        File file = null;
        String string3 = System.getProperty("file.separator");
        file = new File("." + string3 + string);
        if (!(null != file && file.canRead() || null != (file = new File(string2 = "com" + string3 + "ibm" + string3 + "jvm" + string3 + "dump" + string3 + string)) && file.canRead())) {
            String string4 = System.getProperty("java.class.path");
            StringTokenizer stringTokenizer = new StringTokenizer(string4, ";");
            boolean bl = false;
            while (stringTokenizer.hasMoreTokens() && !bl) {
                string2 = stringTokenizer.nextToken() + string3 + string;
                file = new File(string2);
                if (null != file && file.canRead()) {
                    bl = true;
                    continue;
                }
                file = null;
            }
        }
        return file;
    }

    public static boolean checkAddressInDump(DvAddress dvAddress, DvAddressSpace dvAddressSpace) {
        boolean bl = false;
        try {
            dvAddressSpace.readInt(dvAddress);
            bl = true;
        }
        catch (DvAddressException dvAddressException) {
            DvUtils.writetoTrace(" checkAddressInDump:Unable to read integer from 0x" + Long.toHexString(dvAddress.getAddressAsLong()));
        }
        return bl;
    }

    public static Vector splitIntoPieces(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        if (stringTokenizer.countTokens() != 0) {
            while (stringTokenizer.hasMoreTokens()) {
                vector.add(stringTokenizer.nextToken());
            }
        }
        return vector;
    }

    public static boolean isTypeFileLoaded() {
        return typeFileLoaded;
    }

    public static void setTypeFileLoaded(boolean bl) {
        typeFileLoaded = bl;
    }

    public static String remove0x(String string) {
        String string2 = string.trim().toUpperCase();
        if (string2.startsWith("0X")) {
            string2 = string2.substring(2);
        }
        return string2;
    }

    public static String removeAtSign(String string) {
        String string2 = string.trim().toUpperCase();
        if (string2.startsWith("@")) {
            string2 = string2.substring(1);
        }
        return string2;
    }

    public static Object getAPT(DvDump dvDump, String string) {
        String string2 = DvUtils.getValue("ASID");
        String string3 = DvUtils.getValue("THREAD");
        String string4 = DvUtils.getValue("PID");
        DvAddressSpace dvAddressSpace = null;
        DvProcess dvProcess = null;
        DvThread dvThread = null;
        dvAddressSpace = DvUtils.findAsid(dvDump, string2);
        if (null != dvAddressSpace && null != (dvProcess = DvUtils.findProc(dvDump, string4, dvAddressSpace))) {
            dvThread = DvUtils.findThread(dvDump, string3, dvAddressSpace, dvProcess);
        }
        if (string.toUpperCase().equals("A")) {
            return dvAddressSpace;
        }
        if (string.toUpperCase().equals("P")) {
            return dvProcess;
        }
        if (string.toUpperCase().equals("T")) {
            return dvThread;
        }
        return null;
    }

    public static Vector getAllJVMHints(long l) {
        Vector vector = new Vector();
        JVMHints jVMHints = null;
        if (0 != jvmHints.size()) {
            int n = 0;
            while (n < jvmHints.size()) {
                jVMHints = (JVMHints)jvmHints.get(n);
                if (jVMHints.getJvmId() == l) {
                    vector = jVMHints.getAllValues();
                    return vector;
                }
                ++n;
            }
        }
        return vector;
    }

    public static String getJVMHint(DvAddressSpace dvAddressSpace, String string) {
        String string2 = null;
        DvThread dvThread = (DvThread)DvUtils.getAPT(DvConsole.theDump, "T");
        if (null != dvThread) {
            long l = DvUtils.jvmFromThreadId(dvThread.id());
            string2 = DvUtils.getJVMHint(l, string);
        }
        return string2;
    }

    public static String getJVMHint(long l, String string) {
        String string2 = null;
        JVMHints jVMHints = null;
        if (0 != jvmHints.size()) {
            int n = 0;
            while (n < jvmHints.size()) {
                jVMHints = (JVMHints)jvmHints.get(n);
                if (jVMHints.getJvmId() == l) {
                    string2 = jVMHints.getValue(string);
                    return string2;
                }
                ++n;
            }
        }
        return string2;
    }

    public static void setupJVMHints(CTypeObject cTypeObject, long l, DvAddressSpace dvAddressSpace) {
        DvUtils.writetoTrace(" Entry to DvUtils:setupJVMHints");
        if (null == jvmHints) {
            jvmHints = new Vector();
        } else {
            jvmHints.clear();
        }
        JVMHints jVMHints = null;
        if (0 != jvmHints.size()) {
            int n = 0;
            while (n < jvmHints.size()) {
                long l2 = Long.parseLong(dvAddressSpace.id(), 16);
                jVMHints = (JVMHints)jvmHints.get(n);
                if (jVMHints.getJvmId() == l && jVMHints.getAsId() == l2) {
                    jVMHints.setAllValues(cTypeObject, hintListJvm);
                    DvUtils.setupSTGHints(jVMHints);
                    DvUtils.writetoTrace(" Exit from DvUtils:setupJVMHints");
                    return;
                }
                ++n;
            }
        }
        DvUtils.writetoTrace("\tCreating new JVMHints");
        jVMHints = new JVMHints(l, cTypeObject, dvAddressSpace);
        jVMHints.setAllValues(cTypeObject, hintListJvm);
        jvmHints.add(jVMHints);
        DvUtils.setupSTGHints(jVMHints);
        DvUtils.writetoTrace(" Exit from DvUtils:setupJVMHints");
    }

    public static void setupSTGHints(JVMHints jVMHints) {
        DvAddress dvAddress;
        String string = jVMHints.getValue("STGLOBALPTR");
        DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
        if (null != string && null != dvAddressSpace && DvUtils.checkAddressInDump(dvAddress = dvAddressSpace.createAddress(DvUtils.hexToLong(string)), dvAddressSpace)) {
            CTypeObject cTypeObject = DvUtils.formatAddrAsType(dvAddressSpace, dvAddress, "STGlobal");
            jVMHints.setAllValues(cTypeObject, hintListSTGlobal);
        }
    }

    public static CTypeObject formatAddrAsType(DvAddressSpace dvAddressSpace, DvAddress dvAddress, String string) {
        CTypeObject cTypeObject = null;
        CType cType = CType.find(string);
        if (null != cType) {
            cTypeObject = new CTypeObject(string, dvAddress, dvAddressSpace);
        }
        return cTypeObject;
    }

    public static String getCtypeFile(DvDump dvDump, String string) {
        String string2 = null;
        Vector vector = DvUtils.getMultiplePropertyValues("CTypeFile", "Dv.properties");
        if (vector.size() > 0) {
            int n = 0;
            while (n < vector.size()) {
                String string3 = (String)vector.elementAt(n);
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                String string4 = stringTokenizer.nextToken().toUpperCase();
                if (-1 != string.toUpperCase().indexOf(string4)) {
                    string2 = stringTokenizer.nextToken();
                    string2 = string2.trim();
                    n = vector.size();
                }
                ++n;
            }
        }
        return string2;
    }

    public static Vector getMultiplePropertyValues(String string, String string2) {
        Properties properties;
        String string3;
        String string4;
        Vector<String> vector;
        block12: {
            vector = new Vector<String>();
            string4 = null;
            string3 = null;
            properties = null;
            try {
                FileInputStream fileInputStream = new FileInputStream(string2);
                properties = new Properties();
                properties.load(fileInputStream);
            }
            catch (IOException iOException) {
                String string5;
                Object object;
                if (null == properties) {
                    object = (class$com$ibm$jvm$dump$format$DvConsole == null ? (class$com$ibm$jvm$dump$format$DvConsole = DvUtils.class$("com.ibm.jvm.dump.format.DvConsole")) : class$com$ibm$jvm$dump$format$DvConsole).getClassLoader();
                    if (null == object) {
                        object = ClassLoader.getSystemClassLoader();
                    }
                    try {
                        string5 = "com/ibm/jvm/dump/plugins/" + string2;
                        InputStream inputStream = ((ClassLoader)object).getResourceAsStream(string5);
                        if (null != inputStream) {
                            Properties properties2 = new Properties();
                            properties2.load(((ClassLoader)object).getResourceAsStream(string5));
                            properties = properties2;
                        }
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                }
                if (null != properties) break block12;
                object = System.getProperty("file.separator");
                string5 = "com" + (String)object + "ibm" + (String)object + "jvm" + (String)object + "dump" + (String)object + string2;
                properties = DvUtils.searchClassPathForPropFile(string5);
                if (null == properties) {
                    string5 = string2;
                    properties = DvUtils.searchClassPathForPropFile(string5);
                }
                if (null != properties) break block12;
                string5 = "com" + (String)object + "ibm" + (String)object + "jvm" + (String)object + "dump" + (String)object + "plugins" + (String)object + string2;
                properties = DvUtils.searchClassPathForPropFile(string5);
            }
        }
        if (null != properties) {
            Enumeration<?> enumeration = properties.propertyNames();
            int n = 1;
            while (n < 999) {
                string4 = string + n;
                string3 = properties.getProperty(string4);
                if (null != string3) {
                    vector.add(DvUtils.unTab(string3, 4));
                } else {
                    n = 999;
                }
                ++n;
            }
        }
        return vector;
    }

    public static long getFieldAddress(long l, String[] stringArray, DvAddressSpace dvAddressSpace) throws DvAddressException {
        if (stringArray.length == 2) {
            CTypeObject cTypeObject = new CTypeObject(stringArray[0], l, dvAddressSpace);
            CTypeObject cTypeObject2 = cTypeObject.getField(stringArray[1]);
            l = cTypeObject2.getAddr();
            return l;
        }
        throw new DvAddressException("Odd number of arguments in String[]");
    }

    public static boolean filtrate(String string, Vector vector) {
        DvUtils.writetoTrace(" DvUtils.filtrate entry -" + string);
        boolean bl = false;
        String string2 = string.toUpperCase();
        boolean bl2 = false;
        bl = false;
        int n = 0;
        while (n < vector.size() && !bl2) {
            String string3 = (String)vector.get(n);
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            if (string3.equals("*") || string3.equals("**")) {
                bl = true;
            } else if (string3.equals("!")) {
                bl2 = true;
                bl = false;
            } else {
                if (string3.startsWith("!")) {
                    bl3 = true;
                    string3 = string3.substring(1);
                }
                if (string3.startsWith("*")) {
                    bl4 = true;
                    string3 = string3.substring(1);
                }
                if (string3.endsWith("*")) {
                    bl5 = true;
                    string3 = string3.substring(0, string3.length() - 1);
                }
                string3 = string3.toUpperCase();
                if (bl4 && bl5) {
                    if (-1 != string2.indexOf(string3)) {
                        if (bl3) {
                            bl2 = true;
                            bl = false;
                        } else {
                            bl = true;
                        }
                    } else if (bl3) {
                        bl = true;
                    }
                }
                if (bl4 && !bl5) {
                    if (string2.endsWith(string3)) {
                        if (bl3) {
                            bl2 = true;
                            bl = false;
                        } else {
                            bl = true;
                        }
                    } else if (bl3) {
                        bl = true;
                    }
                }
                if (bl5 && !bl4) {
                    if (string2.startsWith(string3)) {
                        if (bl3) {
                            bl2 = true;
                            bl = false;
                        } else {
                            bl = true;
                        }
                    } else if (bl3) {
                        bl = true;
                    }
                }
                if (!bl5 && !bl4) {
                    if (string2.equals(string3)) {
                        if (bl3) {
                            bl2 = true;
                            bl = false;
                        } else {
                            bl = true;
                        }
                    } else if (bl3) {
                        bl = true;
                    }
                }
            }
            ++n;
        }
        DvUtils.writetoTrace("DvUtils,filtrate exit - " + (bl ? "true" : "false"));
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    public static String getStringFromBytes(byte[] var0) {
        var1_1 = 0;
        var2_2 = new StringBuffer();
        if (null != var0) ** GOTO lbl9
        return "   !!! null !!!";
        while (var0[var1_1] != 0 && var0[0] != 0) {
            var2_2.append((char)var0[var1_1]);
            ++var1_1;
lbl9:
            // 2 sources

            if (var1_1 < var0.length) continue;
        }
        return var2_2.toString();
    }

    public static long getPtrFromPtr(DvDump dvDump, DvAddressSpace dvAddressSpace, long l) throws DvAddressException {
        long l2 = true == DvUtils.is64BitSystem(dvDump.getArchitecture()) ? dvAddressSpace.readLong(dvAddressSpace.createAddress(l)) : (long)dvAddressSpace.readInt(dvAddressSpace.createAddress(l)) & 0xFFFFFFFFL;
        return l2;
    }

    public static short bytesToShort(byte[] byArray, int n, int n2) {
        short s = 0;
        s = true == DvUtils.isBigEndian(n2) ? (short)(256 * byArray[n] + byArray[n + 1]) : (short)(256 * byArray[n + 1] + byArray[n]);
        return s;
    }

    public static void trace(String string, int n, boolean bl) {
        if (bl || verbose) {
            DvUtils.writetoTrace("(" + n + ")" + string);
            if (DvConsole.bGuiRequested) {
                Dumpviewer.showMessage("\n*******************\n" + string + "\n*******************\n", false);
            }
        }
        if (!verbose && bl) {
            System.err.println("\n*******************\n" + string + "\n*******************\n");
        }
    }

    public static void setVerbose(boolean bl) {
        verbose = bl;
    }

    public static boolean loadFormatFile(Vector vector) {
        boolean bl;
        block12: {
            bl = false;
            String string = DvUtils.getValue("FORMATFILE");
            ++inLoadFormatFile;
            if (null == string || string.equals("")) {
                if (null != vector) {
                    vector.add(" No FORMATFILE setting.");
                }
                if (null != DvConsole.theDump && 1 == inLoadFormatFile) {
                    vector.add("\nFormatFile usage revoked - redoing sanity check\n");
                    DvConsole.setTheDump(DvConsole.theDump, vector, null);
                }
            } else {
                File file = new File(string);
                if (!file.canRead()) {
                    file = DvUtils.searchForFile(string);
                }
                if (file == null || !file.canRead()) {
                    if (null != vector) {
                        vector.add(" FORMATFILE " + string + " not found.");
                    }
                } else {
                    if (null != vector) {
                        bl = true;
                        vector.add(" FORMATFILE is " + file.getAbsolutePath());
                    }
                    try {
                        FileInputStream fileInputStream = new FileInputStream(file);
                        CTypeFile cTypeFile = new CTypeFile();
                        if (!cTypeFile.processTypes(file.getAbsolutePath())) {
                            System.err.println("\n*****\n It appears that the types file is bad\n   - expect further errors when navigating control blocks\n*****\n");
                        }
                    }
                    catch (IOException iOException) {
                        if (null == vector) break block12;
                        vector.add(" IOError for " + string);
                    }
                }
            }
        }
        --inLoadFormatFile;
        return bl;
    }

    public boolean validateJVM() {
        return true;
    }

    public static String stringFromAddress(long l, DvAddressSpace dvAddressSpace) {
        String string;
        block8: {
            boolean bl = false;
            byte by = 0;
            int n = 0;
            string = "!!!! value could not be established !!!!";
            while (!bl) {
                try {
                    by = dvAddressSpace.readByte(dvAddressSpace.createAddress(l + (long)n));
                    if (0 == by) {
                        bl = true;
                        continue;
                    }
                    ++n;
                }
                catch (DvAddressException dvAddressException) {
                    bl = true;
                }
            }
            if (0 == n) break block8;
            try {
                byte[] byArray = dvAddressSpace.readBytes(dvAddressSpace.createAddress(l), (long)n);
                try {
                    string = new String(byArray, "ASCII");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    string = " !!! caught encoding exception !!!";
                }
            }
            catch (DvAddressException dvAddressException) {
                string = " !!! caught DvAddress exception !!!";
            }
        }
        return string;
    }

    public static String stripToFileName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\\/");
        int n = stringTokenizer.countTokens();
        String string2 = null;
        int n2 = 0;
        while (n2 < n) {
            string2 = stringTokenizer.nextToken();
            ++n2;
        }
        return string2;
    }

    public static final String getTime() {
        Calendar calendar = Calendar.getInstance();
        return df.format(calendar.getTime());
    }

    public static String getThreadName(DvThread dvThread, DvAddressSpace dvAddressSpace) {
        String string = " !!! Not determined !!!";
        string = dvThread.getThreadName(dvAddressSpace);
        return string;
    }

    public static long readPtrAsLong(CTypeObject cTypeObject, DvAddressSpace dvAddressSpace) {
        long l = -1L;
        try {
            DvAddress dvAddress = dvAddressSpace.readPointer(dvAddressSpace.createAddress(cTypeObject.getAddr()));
            l = dvAddress.getAddressAsLong();
        }
        catch (DvAddressException dvAddressException) {
            DvUtils.writetoTrace(" DvAddressException in DvUtils.readPtrAsLong()");
        }
        return l;
    }

    public static String convertResponse(Vector vector, boolean bl) {
        String string = "";
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.get(n);
            if (e instanceof String) {
                string = string + (String)e + "\n";
            } else if (e instanceof Vector) {
                if (0 != ((Vector)e).size()) {
                    int n2 = 0;
                    while (n2 < ((Vector)e).size()) {
                        Object e2 = ((Vector)e).get(n2);
                        if (e2 instanceof Vector) {
                            int n3 = 0;
                            while (n3 < ((Vector)e2).size()) {
                                Object e3 = ((Vector)e2).get(n3);
                                if (e3 instanceof String) {
                                    string = string + (String)e3 + "\n";
                                }
                                ++n3;
                            }
                        } else {
                            string = e2 instanceof String ? string + (String)e2 + "\n" : string + e2.toString();
                        }
                        ++n2;
                    }
                }
            } else {
                string = string + e.toString();
            }
            ++n;
        }
        if (bl) {
            vector.clear();
        }
        return string;
    }

    public static boolean runningSystemIsEBCDIC() {
        boolean bl = false;
        String string = System.getProperty("os.name");
        if (string.equals("z/OS")) {
            bl = true;
        }
        return bl;
    }

    public static String rJustify(String string, int n) {
        return n > string.length() ? "                ".substring(0, n - string.length()) + string : string;
    }

    public static String rJustifyZ(String string, int n) {
        int n2 = n;
        if (0 == n2) {
            n2 = string.length() > 8 ? 16 : 8;
        }
        return n2 > string.length() ? "0000000000000000".substring(0, n2 - string.length()) + string : string;
    }

    public static long jvmFromThreadId(String string) {
        DvProcess dvProcess = (DvProcess)DvUtils.getAPT(DvConsole.theDump, "P");
        DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
        DvThread dvThread = DvUtils.getThread(dvProcess, string);
        return DvUtils.jvmFromExecenv(dvAddressSpace, dvThread.eeAddress());
    }

    public static long jvmFromExecenv(DvAddressSpace dvAddressSpace, DvAddress dvAddress) {
        long l = 0L;
        CTypeObject cTypeObject = DvUtils.formatAddrAsType(dvAddressSpace, dvAddress, "execenv");
        if (null != cTypeObject) {
            CTypeObject cTypeObject2 = cTypeObject.getField("jvmP");
            if (null != cTypeObject2) {
                try {
                    DvAddress dvAddress2 = dvAddressSpace.readPointer(dvAddressSpace.createAddress(cTypeObject2.getAddr()));
                    l = dvAddress2.getAddressAsLong();
                }
                catch (DvAddressException dvAddressException) {
                    DvUtils.trace(" !!!!! Failure to establish jvmP from ExecEnv (1)", 0, true);
                }
            } else {
                DvUtils.trace(" !!!!! Failure to establish jvmP from ExecEnv (2)", 0, true);
            }
        } else {
            DvUtils.trace(" !!!!! Failure to establish jvmP from ExecEnv (3)", 0, true);
        }
        return l;
    }

    public static DvThread getThread(DvProcess dvProcess, String string) {
        DvThread dvThread = null;
        DvThread[] dvThreadArray = dvProcess.getThreads();
        boolean bl = false;
        int n = 0;
        while (n < dvThreadArray.length && !bl) {
            if (dvThreadArray[n].id().toUpperCase().equals(string.toUpperCase())) {
                bl = true;
                dvThread = dvThreadArray[n];
            }
            ++n;
        }
        return dvThread;
    }

    public static boolean sameJvm(DvAddressSpace dvAddressSpace, DvThread dvThread, DvAddressSpace dvAddressSpace2, DvThread dvThread2) {
        boolean bl = false;
        if (dvThread != null && dvThread2 != null && DvUtils.jvmFromExecenv(dvAddressSpace, dvThread.eeAddress()) == DvUtils.jvmFromExecenv(dvAddressSpace2, dvThread2.eeAddress())) {
            bl = true;
        }
        return bl;
    }

    public static boolean threadWithinCurrentJVM(DvThread dvThread) {
        long l;
        boolean bl = false;
        DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
        long l2 = DvUtils.jvmFromExecenv(dvAddressSpace, dvThread.eeAddress());
        String string = DvUtils.getValue("CURRJVM");
        if (null != string && !string.equals("-1") && (l = DvUtils.hexToLong(string)) == l2) {
            bl = true;
        }
        return bl;
    }

    public static boolean safeClear(Object object) {
        boolean bl = false;
        if (null != object) {
            if (object instanceof Vector) {
                ((Vector)object).clear();
                bl = true;
            } else if (object instanceof HashSet) {
                ((HashSet)object).clear();
                bl = true;
            } else if (object instanceof Hashtable) {
                ((Hashtable)object).clear();
                bl = true;
            } else if (object instanceof HashMap) {
                ((HashMap)object).clear();
                bl = true;
            }
        }
        return bl;
    }

    public static String getStringFromAddress(String string, int n) {
        return DvUtils.getStringFromAddress(Long.parseLong(string, 16), n);
    }

    public static String getStringFromAddress(long l, int n) {
        String string = " Not established (0x" + Long.toHexString(l) + ")";
        try {
            DvAddressSpace dvAddressSpace = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
            DvAddress dvAddress = dvAddressSpace.createAddress(l);
            byte[] byArray = dvAddressSpace.readBytes(dvAddress, 256L);
            if (byArray.length > 0) {
                string = DvUtils.getStringFromBytes(byArray);
            }
        }
        catch (Exception exception) {}
        return string;
    }

    public static String unTab(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = 0;
        while (n3 < string.length()) {
            char c = string.charAt(n3);
            if (c == '\n') {
                n2 = 0;
                stringBuffer = stringBuffer.append("\n");
            }
            if (c == '\t') {
                int n4;
                int n5 = n4 = n - n2 % n;
                while (n5 > 0) {
                    stringBuffer = stringBuffer.append(" ");
                    ++n2;
                    --n5;
                }
            } else if (c != '\n') {
                stringBuffer = stringBuffer.append(c);
                ++n2;
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static String getSuffix() {
        return suffix;
    }

    public static Properties findPropertiesFile(String string) {
        Properties properties = null;
        String string2 = System.getProperty("file.separator");
        try {
            FileInputStream fileInputStream = new FileInputStream("." + string2 + string);
            properties = new Properties();
            properties.load(fileInputStream);
            return properties;
        }
        catch (IOException iOException) {
            block8: {
                DvUtils.writetoTrace("   ... permeating through classpath");
                Object object = "com" + string2 + "ibm" + string2 + "jvm" + string2 + "dump" + string2 + "format" + string2 + string;
                properties = DvUtils.searchClassPathForPropFile((String)object);
                if (null == properties) {
                    object = string;
                    properties = DvUtils.searchClassPathForPropFile((String)object);
                }
                if (null != properties) {
                    return properties;
                }
                if (properties != null) break block8;
                DvUtils.writetoTrace("   ... looking in jar file");
                Properties properties2 = new Properties();
                object = (class$com$ibm$jvm$dump$format$DvConsole == null ? (class$com$ibm$jvm$dump$format$DvConsole = DvUtils.class$("com.ibm.jvm.dump.format.DvConsole")) : class$com$ibm$jvm$dump$format$DvConsole).getClassLoader();
                if (null == object) {
                    object = ClassLoader.getSystemClassLoader();
                }
                try {
                    String string3 = "com/ibm/jvm/dump/format/" + string;
                    InputStream inputStream = ((ClassLoader)object).getResourceAsStream(string3);
                    if (null != inputStream) {
                        properties2.load(((ClassLoader)object).getResourceAsStream(string3));
                        properties = properties2;
                        return properties;
                    }
                }
                catch (IOException iOException2) {
                    DvUtils.writetoTrace("   ... unable to find Dv.properties anywhere!");
                }
            }
            return null;
        }
    }

    public static Vector findCommandPlugins() {
        Object object;
        Object object2;
        int n;
        String string = System.getProperty("java.class.path", ".");
        String string2 = "com.ibm.jvm.dump.plugins.CommandPlugin";
        TreeSet<String> treeSet = new TreeSet<String>();
        boolean bl = false;
        boolean bl2 = true;
        while ((n = string.indexOf(File.pathSeparatorChar)) != -1) {
            bl2 = false;
            object2 = string.substring(0, n);
            treeSet.add((String)object2);
            string = string.substring(n + 1);
        }
        if (bl2) {
            treeSet.add(string);
        }
        Vector vector = new Vector();
        object2 = treeSet.iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            Vector vector2 = DvUtils.findPlugins((String)object, string2, true);
            Vector vector3 = new Vector();
            int n2 = 0;
            while (n2 < vector2.size()) {
                boolean bl3 = false;
                String string3 = (String)vector2.get(n2);
                int n3 = 0;
                while (n3 < vector.size()) {
                    if (string3.equals((String)vector.get(n3))) {
                        bl3 = true;
                        System.err.println("\nDuplicate of \"" + string3 + "\" found in " + (String)object + " was ignored");
                        System.err.println("   Class is in more than one part of classPath");
                        bl = true;
                    }
                    ++n3;
                }
                if (!bl3) {
                    vector3.add(vector2.get(n2));
                }
                ++n2;
            }
            vector.addAll(vector3);
        }
        object = new Vector(vector);
        return object;
    }

    public static Vector findPlugins(String string, String string2, boolean bl) {
        Vector<String> vector = new Vector<String>();
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(" Unable to find plugin base class \"" + string2 + "\"");
        }
        if (string.toUpperCase().endsWith(".JAR")) {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(string);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (null != jarFile) {
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    JarEntry jarEntry = enumeration.nextElement();
                    String string3 = jarEntry.getName();
                    if (-1 == string3.toUpperCase().indexOf("PLUGIN") || !string3.endsWith(".class")) continue;
                    string3 = string3.substring(0, string3.length() - ".class".length());
                    String string4 = string3.replace('/', '.');
                    if (!DvUtils.isClassExtender(string4 = string4.replace('\\', '.'), clazz)) continue;
                    vector.add(string4);
                }
            }
        } else {
            File file = new File(string);
            if (file.isDirectory() && file.exists()) {
                if (-1 == string.toUpperCase().indexOf("PLUGIN")) {
                    DvUtils.findPlugins(file, clazz, bl, file.getAbsolutePath(), vector, false);
                } else {
                    DvUtils.findPlugins(file, clazz, bl, file.getAbsolutePath(), vector, true);
                }
            }
        }
        return vector;
    }

    private static void findPlugins(File file, Class clazz, boolean bl, String string, Vector vector, boolean bl2) {
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            Object object;
            if (stringArray[n].endsWith(".class")) {
                object = DvUtils.makeClassName(file, string, stringArray[n]);
                if (DvUtils.isClassExtender((String)object, clazz)) {
                    try {
                        vector.addElement(Class.forName((String)object).getName());
                    }
                    catch (Exception exception) {}
                }
            } else if (-1 == stringArray[n].indexOf(".") && bl && ((File)(object = new File(file, stringArray[n]))).isDirectory()) {
                if (-1 == stringArray[n].toUpperCase().indexOf("PLUGIN")) {
                    DvUtils.findPlugins((File)object, clazz, bl, string, vector, false);
                } else {
                    DvUtils.findPlugins((File)object, clazz, bl, string, vector, true);
                }
            }
            ++n;
        }
    }

    private static String makeClassName(File file, String string, String string2) {
        String string3 = string2.substring(0, string2.length() - ".class".length());
        String string4 = file.getAbsolutePath();
        if (string4.equals(string)) {
            return string3;
        }
        if (!string4.startsWith(string)) {
            return "";
        }
        String string5 = string4.substring(string.length() + 1);
        string5 = string5.replace(File.separatorChar, '.');
        return string5 + "." + string3;
    }

    private static boolean isClassExtender(String string, Class clazz) {
        boolean bl = false;
        Class<?> clazz2 = null;
        try {
            clazz2 = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception exception) {
        }
        catch (Error error) {
            // empty catch block
        }
        try {
            if (clazz.isAssignableFrom(clazz2) && !clazz2.isInterface() && !clazz.getName().equals(clazz2.getName())) {
                bl = true;
            }
        }
        catch (NullPointerException nullPointerException) {}
        return bl;
    }

    public static boolean checkIfPluginLoaded(String string) {
        Vector vector = DvConsole.getCommandPluginVector();
        int n = 0;
        while (n < vector.size()) {
            if (vector.get(n).getClass().getName().equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static long getControlBlockFieldInt(String string, String string2, long l, DvAddressSpace dvAddressSpace) {
        CTypeObject cTypeObject = new CTypeObject(string, dvAddressSpace.createAddress(l), dvAddressSpace);
        CTypeObject cTypeObject2 = cTypeObject.getField(string2);
        long l2 = 0L;
        try {
            l2 = (long)dvAddressSpace.readInt(dvAddressSpace.createAddress(cTypeObject2.getAddr())) & 0xFFFFFFFFL;
        }
        catch (DvAddressException dvAddressException) {
            DvUtils.trace("DvAddressException in DvUtils.getControlBlockFieldInt for address 0x" + Long.toHexString(l) + " controlBlock: " + string + " field: " + string2, 0, true);
        }
        return l2;
    }

    public static long getControlBlockField(String string, String string2, long l, DvAddressSpace dvAddressSpace) {
        DvUtils.writetoTrace("Entry:DvObjectsCommands.getControlBlockField");
        CTypeObject cTypeObject = new CTypeObject(string, dvAddressSpace.createAddress(l), dvAddressSpace);
        CTypeObject cTypeObject2 = null;
        if (null != cTypeObject) {
            cTypeObject2 = cTypeObject.getField(string2);
        }
        DvAddress dvAddress = null;
        long l2 = 0L;
        if (null != cTypeObject2) {
            try {
                dvAddress = dvAddressSpace.readPointer(dvAddressSpace.createAddress(cTypeObject2.getAddr()));
            }
            catch (DvAddressException dvAddressException) {
                DvUtils.trace("DvAddressException in DvUtils.getControlBlockField for address 0x" + Long.toHexString(l) + " controlBlock: " + string + " field: " + string2, 0, true);
            }
        }
        if (null != dvAddress) {
            l2 = dvAddress.getAddressAsLong();
        } else {
            DvUtils.trace("\n!!!!!!!!WARNING!!!!!WARNING!!!!!WARNING!!!!!!!!\n Unable to find field \"" + string2 + "\"\n" + "    expected in  control block \"" + string + "\"\n    lying at address: " + Long.toHexString(l) + "\n This may be due to a partial dump missing some areas of\n" + "   memory or to an expected pointer containing an invalid value\n" + "  This error has also been seen with dumps taken in the middle of\n" + "  a GC cycle" + "\n!!!!!!!!WARNING!!!!!WARNING!!!!!WARNING!!!!!!!!\n", 0, true);
        }
        return l2;
    }

    public static long getControlBlockField(String string, String string2, String string3, long l, DvAddressSpace dvAddressSpace) {
        long l2 = 0L;
        CTypeObject cTypeObject = new CTypeObject(string, dvAddressSpace.createAddress(l), dvAddressSpace);
        CTypeObject cTypeObject2 = cTypeObject.getField(string2);
        CTypeObject cTypeObject3 = cTypeObject2.getField(string3);
        DvAddress dvAddress = null;
        try {
            dvAddress = dvAddressSpace.readPointer(dvAddressSpace.createAddress(cTypeObject3.getAddr()));
        }
        catch (DvAddressException dvAddressException) {
            DvUtils.trace("DvAddressException in DvUtils.getControlBlockField for address 0x" + Long.toHexString(l) + " controlBlock: " + string + " firstField: " + string2 + " secondField: " + string3, 0, true);
        }
        if (null != dvAddress) {
            l2 = dvAddress.getAddressAsLong();
        } else {
            DvUtils.trace("!!! DvUtils:getControlBlockField(): \n  Problem traversing fields \"" + string2 + ":" + string3 + "\" in control block \"" + string + "\"\n at address: " + Long.toHexString(l), 0, true);
        }
        return l2;
    }

    public static Vector findMethodForCurrentSuffix(String string, Class[] classArray) {
        int n = DvConsole.commandPlugins.size();
        int n2 = 0;
        while (n2 < n) {
            try {
                CommandPlugin commandPlugin = (CommandPlugin)DvConsole.commandPlugins.get(n2);
                String[] stringArray = commandPlugin.getSuffixes();
                if (null != stringArray) {
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        if (stringArray[n3].equals(suffix)) {
                            Class<?> clazz = commandPlugin.getClass();
                            Method method = clazz.getMethod(string, classArray);
                            Vector<Object> vector = new Vector<Object>();
                            vector.add(commandPlugin);
                            vector.add(method);
                            return vector;
                        }
                        ++n3;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        return null;
    }

    public static int pointerLength() {
        if (null == DvConsole.theDump) {
            System.out.println("theDump is null!!!!");
        }
        if (DvUtils.is64BitSystem(DvConsole.theDump.getArchitecture())) {
            return 8;
        }
        return 4;
    }

    public static void setForce(boolean bl) {
        force = bl;
    }

    public static boolean isForce() {
        return force;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        order12 = true;
        tc_text = null;
        byteToHex = "000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F202122232425262728292A2B2C2D2E2F303132333435363738393A3B3C3D3E3F404142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F606162636465666768696A6B6C6D6E6F707172737475767778797A7B7C7D7E7F808182838485868788898A8B8C8D8E8F909192939495969798999A9B9C9D9E9FA0A1A2A3A4A5A6A7A8A9AAABACADAEAFB0B1B2B3B4B5B6B7B8B9BABBBCBDBEBFC0C1C2C3C4C5C6C7C8C9CACBCCCDCECFD0D1D2D3D4D5D6D7D8D9DADBDCDDDEDFE0E1E2E3E4E5E6E7E8E9EAEBECEDEEEFF0F1F2F3F4F5F6F7F8F9FAFBFCFDFEFF";
        verbose = false;
        force = false;
        bTraceTime = false;
        byteToAscii = "................................ !\"#$%&'()*+'-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~.................................................................................................................................";
        byteToEbcdic = "..........................................................................\ufffd.<(+|&.........!$*);\ufffd-/.........,%_>?..........:#@'=\".abcdefghi.......jklmnopqr........stuvwxyz...............`.......ABCDEFGHI.......JKLMNOPQR........STUVWXYZ......0123456789......";
        typeFileLoaded = false;
        jvmHints = null;
        df = DateFormat.getTimeInstance();
        hintListJvm = new String[]{"Jvm @ 0x,!,JVM,", "lk :,LockInterface @ 0x,LOCKINTERFACE", "lk :,dataP = 0x,LKGLOBALPTR", "dg :,dataP = 0x,DGGLOBALPTR", "st :,dataP = 0x,STGLOBALPTR", "cl :,class_mirrors = 0x,CLASSMIRRORS", "fullVersion = ,!,FULLVERSION"};
        hintListSTGlobal = new String[]{"allocbits = 0x,!,ALLOCBITS", "MH_heapbase = 0x,!,MH_HEAPBASE", "MH_heaplimit = 0x,!,MH_HEAPLIMIT", "curHeapMin = 0x,!,CURHEAPMIN", "curHeapMax = 0x,!,CURHEAPMAX", "TH_heapbase = 0x,!,TH_HEAPBASE", "TH_heaplimit = 0x,!,TH_HEAPLIMIT", "loadedACSClasses = 0x,!,LOADEDACSCLASSES", "loadedSystemClasses = 0x,!,LOADEDSYSTEMCLASSES", "loadedClasses = 0x,!,LOADEDCLASSES"};
        templates = new String[]{"0 DvConsole: %s", "1 DvConsole: %s", "2 DvConsole: %s", "4 DvConsole: %s", "5 DvConsole: %s"};
        inLoadFormatFile = 0;
    }

    private static class JVMHints {
        protected long jvm_id;
        protected long as_id;
        protected Properties p;

        protected JVMHints(long l, CTypeObject cTypeObject, DvAddressSpace dvAddressSpace) {
            this.jvm_id = l;
            this.as_id = Long.parseLong(dvAddressSpace.id(), 16);
            this.p = new Properties();
        }

        protected long getJvmId() {
            return this.jvm_id;
        }

        protected long getAsId() {
            return this.as_id;
        }

        protected String getValue(String string) {
            return this.p.getProperty(string.toUpperCase());
        }

        protected void setValue(String string, String string2) {
            this.p.setProperty(string.toUpperCase(), string2);
        }

        protected void setAllValues(CTypeObject cTypeObject, String[] stringArray) {
            String string = cTypeObject.toString();
            int n = 0;
            while (n < stringArray.length) {
                int n2;
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[n], ",");
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                if (string3.equals("!")) {
                    string3 = null;
                }
                String string4 = stringTokenizer.nextToken();
                int n3 = 0;
                int n4 = string.indexOf(string2);
                if (-1 != n4) {
                    if (null != string3) {
                        n3 = string.indexOf(string3, n4);
                        n3 += string3.length();
                    } else {
                        n3 = n4 + string2.length();
                    }
                }
                if (-1 != n4 && -1 != n3 && -1 != (n2 = string.indexOf("\n", n3))) {
                    String string5 = string.substring(n3, n2);
                    this.p.setProperty(string4.toUpperCase(), string5.trim());
                }
                ++n;
            }
        }

        protected Vector getAllValues() {
            Vector<String> vector = new Vector<String>();
            String string = null;
            Enumeration<?> enumeration = this.p.propertyNames();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                vector.add(string + " = " + this.getValue(string));
            }
            return vector;
        }
    }
}

