/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.plugins;

import com.ibm.jvm.dump.format.CType;
import com.ibm.jvm.dump.format.CTypeObject;
import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvDump;
import com.ibm.jvm.dump.format.DvThread;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.plugins.CommandPlugin;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;

public class DvBaseFmtCmds
extends CommandPlugin {
    private static String thisName = "com.ibm.jvm.dump.plugins.DvBaseFmtCmds";
    protected static String[] cbNamesArray = null;
    private static DvBaseFmtCmds selfRef;
    protected static String[] commandsSupported;

    public DvBaseFmtCmds() {
        selfRef = this;
    }

    public String pluginName() {
        return "Base format commands (DvBaseFmtCmds)";
    }

    public String[] getSyntax() {
        return commandsSupported;
    }

    public static Object getGenericHelp() {
        Vector vector = DvUtils.getMultiplePropertyValues("GeneralHelp", "DvBaseFmtCmds.properties");
        return vector;
    }

    public void doFormatHelp() {
        Vector vector = DvUtils.getMultiplePropertyValues("FORHelp", "DvBaseFmtCmds.properties");
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    public String help() {
        return null;
    }

    public String help(String string) {
        return null;
    }

    public String[] guiPopupSyntax() {
        return null;
    }

    public void showFormatInfo() {
        Vector<String> vector = new Vector<String>();
        vector.add("  Format information  ==================\n");
        vector.add("The formatting of structures is controlled via either\na mapping of formatable structures within the dump\nitself or by a supplied file whose identity is specified\nusing \"SET FORMATFILE=\" command.");
        vector.add("\n");
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    public void doFormat() {
        Vector<Object> vector = new Vector<Object>();
        DvDump dvDump = DvConsole.theDump;
        if (null != dvDump) {
            vector.add(DvBaseFmtCmds.doFormatEx(this.paramString, dvDump, this.verbModifier));
        } else {
            vector.add(" Unable to comply as no dump accessed yet");
        }
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    public static Vector doFormatEx(String string, DvDump dvDump, String string2) {
        DvUtils.writetoTrace(" Entry to DvBaseFmtCmds:doFormatEx (" + string2 + " " + string + ")");
        Vector<Object> vector = new Vector<Object>();
        if (null == string) {
            vector.add(" paramString is null !!!!");
        } else {
            Vector vector2 = DvUtils.splitIntoPieces(string, " ");
            String string3 = (String)vector2.get(0);
            if (string3.toUpperCase().equals("AS")) {
                if (vector2.size() != 2) {
                    vector.add(" Invalid request");
                } else {
                    long l = 0L;
                    try {
                        String string4 = DvUtils.getValue("ASID");
                        DvAddressSpace dvAddressSpace = DvUtils.findAsid(dvDump, string4);
                        string2 = DvUtils.remove0x(string2);
                        l = DvUtils.hexToLong(string2);
                        String string5 = (String)vector2.get(1);
                        if (null != CType.find(string5)) {
                            if (null != dvAddressSpace) {
                                DvAddress dvAddress = dvAddressSpace.createAddress(l);
                                if (DvUtils.checkAddressInDump(dvAddress, dvAddressSpace)) {
                                    CTypeObject cTypeObject = DvUtils.formatAddrAsType(dvAddressSpace, dvAddress, string5);
                                    if (null != cTypeObject) {
                                        vector.add(cTypeObject);
                                        vector.add("\n " + string + " finished");
                                    } else {
                                        vector.add(" Format failed!!!!");
                                    }
                                } else {
                                    vector.add(" Address " + string2 + " not in dump");
                                }
                            } else {
                                vector.add(" Unable to find address space: " + string4);
                            }
                        } else {
                            vector.add(" Unsupported structure \"" + string5 + "\" (case is relevent).");
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        vector.add(" Invalid hex: " + string2);
                    }
                }
            }
        }
        DvUtils.writetoTrace(" Exit from DvBaseFmtCmds:doFormatEx");
        return vector;
    }

    public void displayHints() {
        Vector<Object> vector = new Vector<Object>();
        DvThread dvThread = (DvThread)DvUtils.getAPT(DvConsole.theDump, "T");
        if (null != dvThread) {
            long l = DvUtils.jvmFromThreadId(dvThread.id());
            vector.add("\n Jvm Hints for jvm 0x" + Long.toHexString(l) + "\n ====================================\n");
            vector.add(DvUtils.getAllJVMHints(l));
        } else {
            vector.add("Unable to establish current thread");
        }
        this.cpr.output(vector);
        this.forcedEnd = true;
    }

    public void reset() {
    }

    public static CTypeObject formatGeneric(DvAddress dvAddress, String string, DvAddressSpace dvAddressSpace) {
        CTypeObject cTypeObject = DvUtils.formatAddrAsType(dvAddressSpace, dvAddress, string);
        return cTypeObject;
    }

    public void formatOffsets() {
        DvUtils.writetoTrace("Entry:DvBaseFmtCmds.formatOffsets()");
        if (null == this.paramString) {
            this.cpr.output("paramString is null");
            this.forcedEnd = true;
            DvUtils.writetoTrace("Exit:1 DvBaseFmtCmds.formatOffsets()");
            return;
        }
        this.formatOffsets(this.paramString);
        this.forcedEnd = true;
        DvUtils.writetoTrace("Exit:2 DvBaseFmtCmds.formatOffsets()");
    }

    private void formatOffsets(String string) {
        DvUtils.writetoTrace("Entry:DvBaseFmtCmds.formatOffsets(" + string + ")");
        if (null == string) {
            this.cpr.output("paramString is null");
            this.forcedEnd = true;
            DvUtils.writetoTrace("Exit:1 DvBaseFmtCmds.formatOffsets(" + string + ")");
            return;
        }
        if (0 == CType.listSize()) {
            this.cpr.output("FAILED to find CType information");
            this.cpr.output("Need either to \"set formatfile=jvmdcf.X\"");
            this.cpr.output("or if embedded core file \"set dump=xxx\"");
            this.forcedEnd = true;
            DvUtils.writetoTrace("Exit:2 DvBaseFmtCmds.formatOffsets(" + string + ")");
            return;
        }
        CType cType = CType.find(string);
        this.cpr.output("");
        try {
            this.cpr.output(cType.getName());
        }
        catch (Exception exception) {
            this.cpr.output("FAILED");
            this.cpr.output("Possible something wrong with the case of \"" + string + "\"");
            this.cpr.output("As this commands is case sensitive with regards to its parameter");
            this.cpr.output("example \"jvm\" needs to be \"Jvm\" ");
            this.cpr.output("");
            this.cpr.output("Use \"dis cb(" + string.toUpperCase() + ")\" to see if any control blocks with this name exist");
            this.cpr.output("The result from this command will also show the correct case");
            this.forcedEnd = true;
            DvUtils.writetoTrace("Exit:3 DvBaseFmtCmds.formatOffsets(" + string + ")");
            return;
        }
        this.cpr.output("----------");
        this.displayCType(this.processCType(cType, "", 0L));
        this.forcedEnd = true;
        DvUtils.writetoTrace("Exit:5 DvBaseFmtCmds.formatOffsets(" + string + ")");
    }

    protected Vector processCType(CType cType, String string, long l) {
        DvUtils.writetoTrace("Entry:DvBaseFmtCmds.processCType(CType,String)");
        Vector<String> vector = new Vector<String>();
        if (string.equals("")) {
            vector.add("Offset");
            vector.add("   Name");
            vector.add("Type");
            vector.add("------");
            vector.add("   ----");
            vector.add("----");
        }
        int n = 0;
        while (n < cType.getNumFields()) {
            CType cType2 = cType.getFieldType(n);
            long l2 = cType.getFieldOffset(n);
            vector.add(string + Long.toHexString(l2) + "(" + Long.toHexString(l + l2) + ")");
            vector.add(string + "   " + cType.getFieldName(n));
            if (null == cType2.getName() || cType2.getName().equalsIgnoreCase("void") || cType2.getName().equalsIgnoreCase("(null)") || cType2.getName().equalsIgnoreCase("__unnamed")) {
                vector.add(string + "....");
            } else {
                vector.add(string + cType2.getName());
            }
            vector.addAll(this.processCType(cType2, string + "  ", l + l2));
            ++n;
        }
        DvUtils.writetoTrace("Exit:1 DvBaseFmtCmds.processCType(CType,String)");
        return vector;
    }

    private void displayCType(Vector vector) {
        DvUtils.writetoTrace("Entry:DvBaseFmtCmds.displayCType(Vector)");
        this.cpr.output(this.getCTypeData(vector));
        this.cpr.output("");
        DvUtils.writetoTrace("Exit:1 DvBaseFmtCmds.displayCType(Vector)");
    }

    protected Vector getCTypeData(Vector vector) {
        String string;
        Vector<String> vector2 = new Vector<String>();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < vector.size()) {
            String string2 = (String)vector.elementAt(n3);
            if (string2.length() > n) {
                n = string2.length();
            }
            if ((string = (String)vector.elementAt(n3 + 1)).length() > n2) {
                n2 = string.length();
            }
            n3 += 3;
        }
        int n4 = 0;
        while (n4 < vector.size()) {
            string = (String)vector.elementAt(n4);
            String string3 = (String)vector.elementAt(n4 + 1);
            String string4 = (String)vector.elementAt(n4 + 2);
            while (string.length() < n) {
                string = string + " ";
            }
            while (string3.length() < n2) {
                string3 = string3 + " ";
            }
            vector2.add(string + string3 + string4);
            n4 += 3;
        }
        return vector2;
    }

    public void formatList() {
        DvUtils.writetoTrace("Entry:DvBaseFmtCmds.formatList()");
        Vector<String> vector = new Vector<String>();
        if (0 == CType.listSize()) {
            this.cpr.output("FAILED to find CType information");
            this.cpr.output("Need either to \"set formatfile=jvmdcf.X\"");
            this.cpr.output("or if embedded core file \"set dump=xxx\"");
            this.forcedEnd = true;
            DvUtils.writetoTrace("Exit:1 DvBaseFmtCmds.formatList()");
            return;
        }
        if (null == this.paramString) {
            vector.add("*");
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(this.paramString, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken().trim();
                vector.add(string);
            }
        }
        if (vector.size() > 0) {
            this.cpr.output("\n");
            if (null == cbNamesArray) {
                selfRef.findControlBlocks();
            }
            int n = 0;
            while (n < cbNamesArray.length) {
                boolean bl = true;
                if (0 != vector.size()) {
                    bl = DvUtils.filtrate(cbNamesArray[n], vector);
                }
                if (bl) {
                    this.cpr.output(cbNamesArray[n]);
                }
                ++n;
            }
        }
        this.forcedEnd = true;
        DvUtils.writetoTrace("Exit:3 DvBaseFmtCmds.formatList()");
    }

    protected void findControlBlocks() {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < CType.listSize()) {
            String string = null;
            try {
                string = CType.find(n).getName();
            }
            catch (Exception exception) {
                string = null;
            }
            if (!(null == string || string.equals("(null)") || string.equals("__unnamed") || string.equals(" ") || string.equals("") || string.equals("void"))) {
                boolean bl = false;
                int n2 = 0;
                while (n2 < vector.size()) {
                    String string2 = (String)vector.get(n2);
                    if (string2.equals(string)) {
                        bl = true;
                    }
                    ++n2;
                }
                if (!bl) {
                    vector.add(string);
                }
            }
            ++n;
        }
        int n3 = vector.size();
        cbNamesArray = new String[n3];
        int n4 = 0;
        while (n4 < n3) {
            String string;
            DvBaseFmtCmds.cbNamesArray[n4] = string = (String)vector.get(n4);
            ++n4;
        }
        Arrays.sort(cbNamesArray);
    }

    static {
        commandsSupported = new String[]{"FORMAT,FOR, , ,showFormatInfo,Y,N", "FORMAT,FOR,*,*,doFormat,Y,N", "FORM,FO, , ,showFormatInfo,Y,N", "FORM,FO,*,*,doFormat,Y,N", "DISPLAY,DIS,hints,hints,displayHints,Y,N", "DISP,D,hints,hints,displayHints,Y,N", "DISPLAY,DIS,controlblock,cb,formatList,Y,N", "DISP,D,controlblock,cb,formatList,Y,N", "DISPLAY,DIS,controlblockoffsets,cbo,formatOffsets,Y,N", "DISP,D,controlblockoffsets,cbo,formatOffsets,Y,N", "FORMAT,FOR,?,?,doFormatHelp,N,N", "FORM,FO,?,?,doFormatHelp,N,N", "HELP,H,FORMAT,FOR,doFormatHelp,N,N", "HELP,H,FORM,FO,doFormatHelp,N,N", "HELP,?,FORMAT,FOR,doFormatHelp,N,N", "HELP,?,FORM,FO,doFormatHelp,N,N"};
    }
}

