/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.plugins;

import com.ibm.jvm.dump.format.CTypeObject;
import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressException;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.format.TraceFormatterListener;
import com.ibm.jvm.dump.plugins.CommandPlugin;
import com.ibm.jvm.format.TraceFormat;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class DvTraceFmtPlugin
extends CommandPlugin {
    private boolean printLines = true;
    private static String thisName = "com.ibm.jvm.dump.plugins.DvTraceFmtPlugin";
    protected static Vector output = new Vector();
    protected static boolean verbose = false;
    private static Vector summaryData = null;
    protected static DvAddressSpace as = null;
    protected static String snapTraceFileName = null;
    protected static String snapTraceInfoFileName = null;
    protected static String snapTraceOutputFileName = null;
    private static int traceOutStart = 1;
    private static int traceOutPage = 25;
    public static int waitFlag = 0;
    public static String savedFileName = null;
    protected static Hashtable traceRecords = null;
    private static String[] commandsSupported = new String[]{"TRACE,T,EXTRACT,E,CMD_TraceExtract", "TRACE,T,FORMAT,F,CMD_TraceFormat", "TRACE,T,DISPLAY,D,CMD_TraceDisplay", "TRACE,T,SUMMARY,S,CMD_TraceSummary", "TRACE,T,THREADS,T,CMD_TraceThreads", "TRACE,T,VERBOSE,V,CMD_TraceCMD", "TRACE,T,SYMBOLIC,SYM,CMD_TraceCMD", "TRACE,T,INDENT,I,CMD_TraceCMD", "TRACE,T,ENTRIES,ENT,CMD_TraceEntries", "TRACE,T,OUTFILENAME,O,CMD_TraceOutfilename", "TRACE,T,DATADIR,DATADIR,CMD_TraceDataDir", "TRACE,T,SET,SET,CMD_TraceSet", "TRACE,T,HELP,?,CMD_TraceHelp", "HELP,?,TRACE,T,CMD_TraceHelp"};
    public static DvTraceFmtPlugin selfRef;

    public DvTraceFmtPlugin() {
        selfRef = this;
    }

    public void CMD_TraceHelp() {
        this.printBanner(true, "", false);
        output.add("HELP FOR USING TRACE\n====================\n");
        output.add("These are the currently supported commands:\n");
        output.add("TRACE FORMAT              - formats the extracted trace file.");
        output.add("TRACE EXTRACT             - writes in-memory trace buffers to an \"extracted\n                            trace file\".");
        output.add("TRACE SUMMARY             - display the summary information for an extracted\n                            trace file.\n");
        output.add("TRACE DISPLAY             - display the current page of the trace output file.");
        output.add("TRACE DISPLAY ALL         - display entire trace file (warning - long!)");
        output.add("TRACE DISPLAY +           - display the next page of the trace output file.");
        output.add("TRACE DISPLAY -           - display the previous page of the trace output file.");
        output.add("TRACE DISPLAY PAGE=nn     - set the length of the page for trace display.\n");
        output.add("TRACE THREADS             - list all the threads in the dump.");
        output.add("TRACE THREADS 0xnn[,0xnn] - format infomation only for these threads.\n");
        output.add("TRACE SET                 - display all env vars affecting trace formatting.");
        output.add("TRACE SET option=value    - set one of these env vars.");
        output.add("TRACE OUTFILENAME <file>  - write the formatted trace to the selected file.");
        output.add("TRACE INDENT true|false   - sets indent mode on or off for formatting.");
        output.add("TRACE ENTRIES id[,id...]  - format infomation only for these components.");
        output.add("TRACE SYMBOLIC true|false - sets symbolic option on or off for formatting.\n                            (symbolic trace point names in trace output.)");
        output.add("TRACE DATADIR <directory> - Set TraceFormat.dat directory (ibm.dg.trc.format)");
        output.add("TRACE VERBOSE true|false  - sets verbose mode on or off (contents of buffers\n                            are displayed as they are formatted etc.)\n");
        DvTraceFmtPlugin.outputAndFlush("TRACE HELP                - this information.");
        this.printBanner(true, "End of Trace Help", true);
        this.forcedEnd = true;
    }

    public void CMD_TraceDisplay() {
        Object var1_1 = null;
        if (this.noDumpAccessed()) {
            this.forcedEnd = true;
            return;
        }
        if (snapTraceOutputFileName == null) {
            this.printBanner(true, "", true);
            DvTraceFmtPlugin.outputAndFlush("Unable to comply - trace must first be formatted.");
            this.printBanner(true, "finished Trace Display", true);
            this.forcedEnd = true;
            return;
        }
        if (this.paramString == null) {
            this.displayFile(snapTraceOutputFileName, traceOutStart, traceOutStart + traceOutPage - 1);
        } else if (this.paramString.length() > 5 && this.paramString.toUpperCase().substring(0, 5).equals("PAGE=")) {
            String string = new String(this.paramString.substring(5));
            Integer n = new Integer(string);
            if (n >= 5 && n <= 10001) {
                DvTraceFmtPlugin.outputAndFlush("\nPage size set to " + n);
                traceOutPage = n;
            } else {
                DvTraceFmtPlugin.outputAndFlush("\nERROR: Page size must be between 5 and 10000.");
            }
        } else if (this.paramString.toUpperCase().equals("ALL")) {
            DvTraceFmtPlugin.outputAndFlush("");
            this.displayFile(snapTraceOutputFileName, 1, 1000000);
        } else if (this.paramString.substring(0, 1).equals("+")) {
            DvTraceFmtPlugin.outputAndFlush("");
            if (!this.displayFile(snapTraceOutputFileName, traceOutStart += traceOutPage, traceOutStart + traceOutPage - 1) && (traceOutStart -= traceOutPage) < 1) {
                traceOutStart = 1;
            }
        } else if (this.paramString.substring(0, 1).equals("-")) {
            if ((traceOutStart -= traceOutPage) < 1) {
                traceOutStart = 1;
            }
            DvTraceFmtPlugin.outputAndFlush("");
            this.displayFile(snapTraceOutputFileName, traceOutStart, traceOutStart + traceOutPage - 1);
        } else {
            this.printBanner(true, "", true);
            DvTraceFmtPlugin.outputAndFlush("Usage Error:\n   TRACE DISPLAY [ + | - | ALL ]");
            this.printBanner(true, "", true);
        }
        this.forcedEnd = true;
    }

    public void CMD_TraceCMD() {
        this.printBanner(true, "", false);
        DvTraceFmtPlugin.outputAndFlush("Query/Set Formatted Trace Options\n=================================\n");
        this.verbModifier = this.verbModifier.toUpperCase();
        if (this.verbModifier.equals("SYMBOLIC") || this.verbModifier.equals("VERBOSE") || this.verbModifier.equals("INDENT")) {
            this.doTraceCMD("TRACE_" + this.verbModifier.toUpperCase());
        } else {
            DvTraceFmtPlugin.outputAndFlush("Usage error:\n   unrecognised TRACE option: " + this.verbModifier);
        }
        this.printBanner(true, "", true);
        this.forcedEnd = true;
    }

    private void doTraceCMD(String string) {
        block7: {
            if (this.paramString == null) {
                String string2 = null;
                string2 = this.getEnvVar(string);
                if (string2.toUpperCase().equals("NULL")) {
                    string2 = "false";
                }
                DvTraceFmtPlugin.outputAndFlush(string + " = " + string2);
            } else {
                try {
                    if (this.paramString.toUpperCase().equals("TRUE")) {
                        DvUtils.setValue(string, "true");
                        DvTraceFmtPlugin.outputAndFlush(string + " = true");
                        if (!string.toUpperCase().equals("VERBOSE")) break block7;
                        verbose = true;
                        break block7;
                    }
                    if (this.paramString.toUpperCase().equals("FALSE")) {
                        DvUtils.setValue(string, "false");
                        DvTraceFmtPlugin.outputAndFlush(string + " = false");
                        if (!string.toUpperCase().equals("VERBOSE")) break block7;
                        verbose = false;
                        break block7;
                    }
                    DvTraceFmtPlugin.outputAndFlush("Usage Error:\n   TRACE " + string.substring(6, string.length()) + " true|false");
                }
                catch (Exception exception) {
                    DvTraceFmtPlugin.outputAndFlush("ERROR: Exception setting TRACE_" + string + " (" + exception.getMessage() + ")");
                }
            }
        }
    }

    public void CMD_TraceSet() {
        String string;
        Object object;
        this.printBanner(true, "", false);
        output.add("OPTIONS FOR TRACE FORMATTER\n===========================\n");
        if (this.paramString != null) {
            object = new StringTokenizer(this.paramString, "=");
            while (((StringTokenizer)object).hasMoreTokens()) {
                string = null;
                String string2 = null;
                if (((StringTokenizer)object).hasMoreTokens()) {
                    string = ((StringTokenizer)object).nextToken().toUpperCase();
                }
                if (((StringTokenizer)object).hasMoreTokens()) {
                    string2 = ((StringTokenizer)object).nextToken();
                }
                if (string == null || string2 == null) {
                    DvTraceFmtPlugin.outputAndFlush("Usage Error:\n   TRACE SET [<option>=<value>]");
                    continue;
                }
                if (string.equals("VERBOSE") || string.equals("SYMBOLIC") || string.equals("INDENT") || string.equals("ENTRIES") || string.equals("OUTFILENAME") || string.equals("THREADS") || string.equals("DATADIR")) {
                    boolean bl = this.printLines;
                    this.printLines = false;
                    this.verb = "TRACE";
                    this.verbModifier = string;
                    this.paramString = string2;
                    if (string.equals("VERBOSE")) {
                        this.CMD_TraceCMD();
                    }
                    if (string.equals("INDENT")) {
                        this.CMD_TraceCMD();
                    }
                    if (string.equals("SYMBOLIC")) {
                        this.CMD_TraceCMD();
                    }
                    if (string.equals("THREADS")) {
                        this.CMD_TraceThreads();
                    }
                    if (string.equals("ENTRIES")) {
                        this.CMD_TraceEntries();
                    }
                    if (string.equals("OUTFILENAME")) {
                        this.CMD_TraceOutfilename();
                    }
                    if (string.equals("DATADIR")) {
                        this.CMD_TraceDataDir();
                    }
                    this.printLines = bl;
                    continue;
                }
                DvTraceFmtPlugin.outputAndFlush("Usage Error:\n   TRACE SET [<OUTFILENAME|THREADS|SYMBOLIC|INDENT|ENTRIES|VERBOSE|<DATADIR>>=<value>]");
            }
        }
        DvTraceFmtPlugin.outputAndFlush("\nTRACE_INFILENAME  = \"extracted.trc\" (hardcoded)");
        object = this.getEnvVar("TRACE_OUTFILENAME");
        if (((String)object).toUpperCase().equals("NULL")) {
            object = "<not set - will default to \"extracted.trc.fmt\">";
        }
        DvTraceFmtPlugin.outputAndFlush("TRACE_OUTFILENAME = " + (String)object);
        object = this.getEnvVar("TRACE_THREADS");
        if (((String)object).toUpperCase().equals("NULL")) {
            object = "<not set - will default to ALL>";
        }
        DvTraceFmtPlugin.outputAndFlush("TRACE_THREADS     = " + (String)object);
        object = this.getEnvVar("TRACE_SYMBOLIC");
        if (((String)object).toUpperCase().equals("NULL")) {
            object = "<not set - will default to false>";
        }
        DvTraceFmtPlugin.outputAndFlush("TRACE_SYMBOLIC    = " + (String)object);
        object = this.getEnvVar("TRACE_INDENT");
        if (((String)object).toUpperCase().equals("NULL")) {
            object = "<not set - will default to false>";
        }
        DvTraceFmtPlugin.outputAndFlush("TRACE_INDENT      = " + (String)object);
        object = this.getEnvVar("TRACE_ENTRIES");
        if (((String)object).toUpperCase().equals("NULL")) {
            object = "<not set - will default to ALL>";
        }
        DvTraceFmtPlugin.outputAndFlush("TRACE_ENTRIES     = " + (String)object);
        object = this.getEnvVar("TRACE_VERBOSE");
        if (((String)object).toUpperCase().equals("NULL")) {
            object = "<not set - will default to false>";
        }
        DvTraceFmtPlugin.outputAndFlush("TRACE_VERBOSE     = " + (String)object);
        object = this.getEnvVar("TRACE_DATADIR");
        if (((String)object).toUpperCase().equals("NULL")) {
            string = System.getProperty("java.home");
            string = string.concat(File.separator).concat("lib");
            object = System.getProperty("ibm.dg.trc.format", string);
            object = "<not set - will default to:\n                    " + (String)object + ">";
        }
        DvTraceFmtPlugin.outputAndFlush("TRACE_DATADIR     = " + (String)object);
        this.printBanner(true, "", true);
        this.forcedEnd = true;
    }

    public void CMD_TraceOutfilename() {
        this.printBanner(true, "", false);
        DvTraceFmtPlugin.outputAndFlush("Query/Set Formatted Trace File Name\n===================================\n");
        if (this.paramString == null) {
            String string = null;
            try {
                string = DvUtils.getValue("TRACE_OUTFILENAME");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string == null) {
                string = "extracted.trc.fmt";
            }
            DvTraceFmtPlugin.outputAndFlush("trace out file name = \"" + string + "\"");
        } else {
            try {
                DvUtils.setValue("TRACE_OUTFILENAME", this.paramString);
                DvTraceFmtPlugin.outputAndFlush("TRACE_OUTFILENAME = " + this.paramString);
            }
            catch (Exception exception) {
                DvTraceFmtPlugin.outputAndFlush("ERROR: Exception setting TRACE_OUTFILENAME (" + exception.getMessage() + ")");
            }
        }
        DvTraceFmtPlugin.outputAndFlush("\nNOTE - Embedding %T in an outfilename, e.g.: \"TRACE OUTFILENAME thread.%T.fmt\"\n       will cause the threadid to be inserted at that point when tracing a\n       single thread.");
        this.printBanner(true, "", true);
        this.forcedEnd = true;
    }

    public void CMD_TraceEntries() {
        this.printBanner(true, "", false);
        DvTraceFmtPlugin.outputAndFlush("Query/Set Entries Option\n========================\n");
        if (this.paramString == null) {
            String string = null;
            try {
                string = this.getEnvVar("TRACE_ENTRIES");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string.toUpperCase().equals("NULL")) {
                string = "ALL";
            }
            DvTraceFmtPlugin.outputAndFlush("TRACE_ENTRIES = " + string);
        } else {
            String string;
            StringTokenizer stringTokenizer;
            boolean bl = true;
            if (!this.paramString.toUpperCase().equals("ALL")) {
                stringTokenizer = new StringTokenizer(this.paramString, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken().toLowerCase();
                    StringTokenizer stringTokenizer2 = DvTraceFmtPlugin.getValidTraceEntries();
                    boolean bl2 = false;
                    while (stringTokenizer2.hasMoreTokens() && !bl2) {
                        String string2 = stringTokenizer2.nextToken().toLowerCase();
                        if (!string.equals(string2)) continue;
                        bl2 = true;
                    }
                    if (bl2) continue;
                    DvTraceFmtPlugin.outputAndFlush("ERROR: invalid token - " + string + "\n");
                    bl = false;
                }
            }
            if (bl) {
                DvUtils.setValue("TRACE_ENTRIES", this.paramString.toUpperCase());
                DvTraceFmtPlugin.outputAndFlush("TRACE_ENTRIES = " + this.getEnvVar("TRACE_ENTRIES"));
            } else {
                stringTokenizer = DvTraceFmtPlugin.getValidTraceEntries();
                string = "Allowed options are:";
                while (stringTokenizer.hasMoreTokens()) {
                    string = string + "\n\t" + stringTokenizer.nextToken();
                }
                DvTraceFmtPlugin.outputAndFlush(string);
                DvTraceFmtPlugin.outputAndFlush("\nTRACE_ENTRIES = " + this.getEnvVar("TRACE_ENTRIES") + " (unchanged)");
            }
        }
        this.printBanner(true, "", true);
        this.forcedEnd = true;
    }

    public void CMD_TraceDataDir() {
        String string;
        Object object;
        this.printBanner(true, "", false);
        DvTraceFmtPlugin.outputAndFlush("Query/Set Data directory\n========================\n");
        if (this.paramString != null) {
            if (this.paramString.equals("NULL")) {
                DvUtils.setValue("TRACE_DATADIR", "NULL");
                DvTraceFmtPlugin.outputAndFlush("TRACE_DATADIR property cleared.\n");
            } else {
                if (this.paramString != null && this.paramString.indexOf(" ") != -1) {
                    this.paramString = this.paramString.substring(0, this.paramString.indexOf(" "));
                }
                DvTraceFmtPlugin.outputAndFlush("attempting to set TRACE_DATADIR to:\n   " + this.paramString);
                object = new File(this.paramString);
                string = new String(object + System.getProperty("file.separator") + "TraceFormat.dat");
                if (((File)object).exists() && ((File)object).isDirectory() && new File(string).exists()) {
                    DvUtils.setValue("TRACE_DATADIR", this.paramString);
                    DvTraceFmtPlugin.outputAndFlush("TRACE_DATADIR set to:\n   " + this.paramString + "\n");
                } else {
                    DvTraceFmtPlugin.outputAndFlush("ERROR: TraceFormat.dat cannot be found in the specified directory.\n");
                }
            }
        }
        object = null;
        if (this.getEnvVar("TRACE_DATADIR").toUpperCase().equals("NULL")) {
            string = System.getProperty("java.home");
            string = string.concat(File.separator).concat("lib");
            object = System.getProperty("ibm.dg.trc.format", string);
        } else {
            object = this.getEnvVar("TRACE_DATADIR");
        }
        DvTraceFmtPlugin.outputAndFlush("Trace formatter will use TraceFormat.dat from:\n   " + (String)object);
        this.printBanner(true, "", true);
        this.forcedEnd = true;
    }

    public void CMD_TraceExtract() {
        DvUtils.writetoTrace("DvTraceFmtPlugin:CMD_TraceExtract(Vector) entry");
        if (this.noDumpAccessed()) {
            this.forcedEnd = true;
            return;
        }
        this.printBanner(true, "", false);
        if (this.isTraceEnabled()) {
            DvTraceFmtPlugin.outputAndFlush("Running Dump Extractor\n======================");
            if (snapTraceFileName == null) {
                this.doCreateTraceFile();
            } else {
                DvTraceFmtPlugin.outputAndFlush("\nThe file already exists and will be used.\nThe trace filename is: \"" + snapTraceFileName + "\"");
            }
        } else {
            DvTraceFmtPlugin.outputAndFlush("\nCannot Extract - There are no trace buffers in this dump.");
        }
        this.printBanner(true, "finsihed Dump Extractor", false);
        this.forcedEnd = true;
        DvUtils.writetoTrace("DvTraceFmtPlugin:CMD_TraceExtract(Vector) exit");
    }

    private void doCreateTraceFile() {
        Method method = null;
        Vector vector = new Vector();
        Vector vector2 = DvUtils.findMethodForCurrentSuffix("doCreateTraceFile", new Class[0]);
        if (null != vector2 && vector2.size() == 2) {
            CommandPlugin commandPlugin = (CommandPlugin)vector2.get(0);
            method = (Method)vector2.get(1);
            try {
                method.invoke((Object)commandPlugin, new Object[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                DvUtils.trace("*** Exception trying to utilise \" doCreateTraceFile \" supporting " + DvUtils.getSuffix(), 0, true);
                String string = exception.toString();
                DvUtils.trace(string, 0, true);
            }
        } else {
            DvUtils.trace("*** Error trying to find \" +doCreateTraceFile \" supporting " + DvUtils.getSuffix(), 0, true);
        }
    }

    public void CMD_TraceFormat() {
        if (this.noDumpAccessed()) {
            this.forcedEnd = true;
            return;
        }
        if (!this.isTraceEnabled()) {
            this.printBanner(true, "", false);
            DvTraceFmtPlugin.outputAndFlush("\nCannot format trace - There are no trace buffers in this dump.");
            this.printBanner(true, "", false);
            this.forcedEnd = true;
            return;
        }
        if (snapTraceFileName == null) {
            this.CMD_TraceExtract();
            DvTraceFmtPlugin.outputAndFlush(" ");
        }
        this.printBanner(true, "", false);
        DvTraceFmtPlugin.outputAndFlush("Running Trace Formatter\n=======================");
        if (snapTraceFileName != null) {
            String[] stringArray = this.buildFormatArgs();
            DvTraceFmtPlugin.outputAndFlush("input file:   \"" + stringArray[0] + "\"");
            DvTraceFmtPlugin.outputAndFlush("output file:  \"" + stringArray[1] + "\"");
            int n = 2;
            while (n < stringArray.length) {
                DvTraceFmtPlugin.outputAndFlush("option:       " + stringArray[n]);
                ++n;
            }
            DvTraceFmtPlugin.outputAndFlush(" ");
            this.doTraceFormat(stringArray);
        } else {
            DvTraceFmtPlugin.outputAndFlush("\nERROR: Problem reading extracted trace file.\n");
        }
        this.printBanner(true, "finished Trace Formatter", false);
        this.forcedEnd = true;
    }

    private String[] buildFormatArgs() {
        String[] stringArray;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = null;
        string = snapTraceFileName;
        hashtable.put("infilename", string);
        string = this.getEnvVar("TRACE_OUTFILENAME");
        if (string.toUpperCase().equals("NULL")) {
            string = snapTraceFileName.concat(".fmt");
        } else if (string.indexOf("%T") != -1) {
            stringArray = null;
            String string2 = null;
            String string3 = null;
            String string4 = this.getEnvVar("TRACE_THREADS");
            int n = string.indexOf("%T");
            stringArray = new String("");
            if (n > 0) {
                stringArray = string.substring(0, n);
            }
            if (string4.toUpperCase().equals("NULL") || string4.toUpperCase().equals("ALL")) {
                string2 = "ALL";
            } else {
                string2 = string4;
                if (string2.indexOf(",") != -1) {
                    string2 = "MULTI";
                }
            }
            string3 = new String("");
            if (n < string.length()) {
                string3 = string.substring(n + 2, string.length());
            }
            string = stringArray.concat(string2).concat(string3);
        }
        hashtable.put("outfilename", string);
        savedFileName = string;
        string = this.getEnvVar("TRACE_THREADS");
        if (!string.equals("ALL") && !string.equals("NULL")) {
            hashtable.put("thread", "-thread:" + string);
        }
        if ((string = this.getEnvVar("TRACE_INDENT")).toUpperCase().equals("TRUE")) {
            hashtable.put("indent", "-indent");
        }
        if ((string = this.getEnvVar("TRACE_SYMBOLIC")).toUpperCase().equals("TRUE")) {
            hashtable.put("symbolic", "-symbolic");
        }
        if (!(string = this.getEnvVar("TRACE_ENTRIES")).equals("ALL") && !string.equals("NULL")) {
            hashtable.put("entries", "-entries:" + string);
        }
        stringArray = new String[hashtable.size()];
        int n = 0;
        if (hashtable.get("infilename") != null) {
            stringArray[n++] = (String)hashtable.get("infilename");
        }
        if (hashtable.get("outfilename") != null) {
            stringArray[n++] = (String)hashtable.get("outfilename");
        }
        if (hashtable.get("thread") != null) {
            stringArray[n++] = (String)hashtable.get("thread");
        }
        if (hashtable.get("indent") != null) {
            stringArray[n++] = (String)hashtable.get("indent");
        }
        if (hashtable.get("symbolic") != null) {
            stringArray[n++] = (String)hashtable.get("symbolic");
        }
        if (hashtable.get("entries") != null) {
            stringArray[n++] = (String)hashtable.get("entries");
        }
        return stringArray;
    }

    private void doTraceFormat(String[] stringArray) {
        PipedInputStream pipedInputStream = null;
        PrintStream printStream = null;
        try {
            pipedInputStream = new PipedInputStream();
            printStream = new PrintStream(new PipedOutputStream(pipedInputStream));
        }
        catch (IOException iOException) {
            DvTraceFmtPlugin.outputAndFlush("ERROR: Unexpected exception creating output pipe.");
        }
        waitFlag = 0;
        TraceFormatterListener traceFormatterListener = new TraceFormatterListener(pipedInputStream, output, this.cpr);
        traceFormatterListener.start();
        while (waitFlag < 1) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                DvTraceFmtPlugin.outputAndFlush("ERROR: Unexpected exception during sleep.");
            }
        }
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)System.getProperties());
        if (!this.getEnvVar("TRACE_DATADIR").equals("NULL")) {
            System.setProperty("ibm.dg.trc.format", this.getEnvVar("TRACE_DATADIR"));
        }
        String string = null;
        String string2 = System.getProperty("java.home");
        string2 = string2.concat(File.separator).concat("lib");
        string = System.getProperty("ibm.dg.trc.format", string2);
        string = string.concat(System.getProperty("file.separator")).concat("TraceFormat.dat");
        DvTraceFmtPlugin.outputAndFlush("Looking for Trace Format data in file: \n   " + string + "\n");
        if (new File(string).exists()) {
            TraceFormat traceFormat = new TraceFormat(printStream, stringArray);
        } else {
            DvTraceFmtPlugin.outputAndFlush("ERROR: Unable to format Trace file - TraceFormat.dat does not exist.");
        }
        waitFlag = 2;
        while (waitFlag < 3) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                DvTraceFmtPlugin.outputAndFlush("ERROR: Unexpected exception during sleep.");
            }
        }
        try {
            printStream.close();
            pipedInputStream.close();
        }
        catch (IOException iOException) {
            DvTraceFmtPlugin.outputAndFlush("ERROR: unexpected exception closing print stream.");
        }
        System.setProperties(properties);
        if (snapTraceOutputFileName == null) {
            snapTraceOutputFileName = !this.getEnvVar("TRACE_OUTFILENAME").toUpperCase().equals("NULL") ? this.getEnvVar("TRACE_OUTFILENAME") : new String(snapTraceFileName + ".fmt");
        }
    }

    public void CMD_TraceSummary() {
        if (this.noDumpAccessed()) {
            this.forcedEnd = true;
            return;
        }
        this.printBanner(true, "", false);
        DvTraceFmtPlugin.outputAndFlush("Display Trace Summary\n=====================\n");
        if (snapTraceFileName != null) {
            String[] stringArray = new String[]{snapTraceFileName, snapTraceFileName + ".tmp", "-summary"};
            this.doTraceFormat(stringArray);
        } else {
            DvTraceFmtPlugin.outputAndFlush("\nThe trace file must already exist before the TRACE SUMMARY command is run.\n(Use TRACE EXTRACT or TRACE FORMAT before running TRACE SUMMARY).");
        }
        this.printBanner(true, "finished displaying trace summary", true);
        this.forcedEnd = true;
    }

    private void cacheSummaryInfo() {
        PrintStream printStream = null;
        if (this.noDumpAccessed()) {
            this.forcedEnd = true;
            return;
        }
        if (snapTraceFileName != null) {
            if (snapTraceInfoFileName == null) {
                String[] stringArray = new String[]{snapTraceFileName, snapTraceFileName + ".tmp", "-summary"};
                try {
                    printStream = new PrintStream(new FileOutputStream(snapTraceFileName + ".info"));
                }
                catch (IOException iOException) {
                    DvTraceFmtPlugin.outputAndFlush("ERROR: Unexpected exception creating printStream.");
                }
                TraceFormat traceFormat = new TraceFormat(printStream, stringArray);
                printStream.close();
                snapTraceInfoFileName = new String(snapTraceFileName + ".info");
            }
        } else {
            DvTraceFmtPlugin.outputAndFlush("\nThe trace file must already exist before the TRACE CACHE command is run.\n(Use TRACE EXTRACT before running TRACE CACHE).");
        }
        this.forcedEnd = true;
    }

    public void CMD_TraceThreads() {
        Object var1_1 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = true;
        if (this.noDumpAccessed()) {
            this.forcedEnd = true;
            return;
        }
        this.printBanner(true, "", false);
        DvTraceFmtPlugin.outputAndFlush("Display Threads\n===============\n");
        if (snapTraceFileName == null) {
            DvTraceFmtPlugin.outputAndFlush("The trace file does not exist so threads cannot be displayed.\n(Use TRACE FORMAT or EXTRACT before running TRACE THREADS).");
            bl = false;
        }
        if (bl && snapTraceInfoFileName == null) {
            this.cacheSummaryInfo();
        }
        boolean bl2 = false;
        String string = null;
        BufferedReader bufferedReader = null;
        if (bl) {
            try {
                bufferedReader = new BufferedReader(new FileReader(snapTraceFileName + ".info"));
                while (bufferedReader.ready()) {
                    string = bufferedReader.readLine();
                    if (bl2) {
                        if (string.trim().toUpperCase().equals("")) {
                            bl2 = false;
                        } else {
                            String string2 = string.trim();
                            DvTraceFmtPlugin.outputAndFlush("THREAD: 0x" + string2);
                            String string3 = new String("0x" + string2.substring(0, string2.indexOf(" "))).toUpperCase();
                            arrayList.add(string3);
                        }
                    }
                    if (!string.trim().toUpperCase().equals("ACTIVE THREADS :")) continue;
                    bl2 = true;
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                DvTraceFmtPlugin.outputAndFlush("ERROR: Unexpected exception reading " + snapTraceFileName + ".info " + "(" + exception + ", " + exception.getMessage() + ")");
                exception.printStackTrace();
            }
        }
        DvTraceFmtPlugin.outputAndFlush(" ");
        if (this.paramString == null) {
            this.checkThreadArgs("NONE", arrayList, bl);
        } else {
            this.checkThreadArgs(this.paramString, arrayList, bl);
        }
        this.printBanner(true, "finished filling summary cache", true);
        this.forcedEnd = true;
    }

    private void checkThreadArgs(String string, ArrayList arrayList, boolean bl) {
        String string2;
        boolean bl2 = false;
        if (string != null) {
            bl2 = true;
        }
        if (string.equals("NONE")) {
            try {
                string = DvUtils.getValue("TRACE_THREADS");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string == null) {
            string = "ALL";
        }
        if ((string = string.toLowerCase()).toUpperCase().equals("ALL")) {
            DvUtils.setValue("TRACE_THREADS", "ALL");
            DvTraceFmtPlugin.outputAndFlush("\nThe trace formatter will be run without the -thread option");
            return;
        }
        if (string == null) {
            DvTraceFmtPlugin.outputAndFlush("No optional parameters supplied.");
            return;
        }
        boolean bl3 = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (!string2.substring(0, 2).equals("0x")) {
                DvTraceFmtPlugin.outputAndFlush("ERROR: " + string2 + " does not must begin \"0x\" (hex)");
                bl3 = true;
            }
            if (!bl3 && string2.length() == 2) {
                DvTraceFmtPlugin.outputAndFlush("ERROR: 0x on it's own is not a valid hex number!!");
                bl3 = true;
            }
            if (!bl3) {
                String string3 = string2.substring(2, string2.length());
                try {
                    Long.parseLong(string3, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    DvTraceFmtPlugin.outputAndFlush("ERROR: " + string2 + " is not a proper hex number.");
                    bl3 = true;
                }
            }
            if (!bl) continue;
            if (arrayList.contains(string2.toUpperCase())) {
                DvTraceFmtPlugin.outputAndFlush(string2 + " is a valid thread.");
                continue;
            }
            DvTraceFmtPlugin.outputAndFlush("ERROR: " + string2 + " is not in list of active threads.");
            bl3 = true;
        }
        try {
            if (bl3) {
                if (!bl2) {
                    DvUtils.setValue("TRACE_THREADS", "ALL");
                }
            } else {
                DvUtils.setValue("TRACE_THREADS", string);
            }
        }
        catch (Exception exception) {
            DvTraceFmtPlugin.outputAndFlush("ERROR: Unexpected Exception received setting TRACE_THREADS");
            DvTraceFmtPlugin.outputAndFlush("expception text:" + exception.getMessage());
        }
        string2 = null;
        string2 = DvUtils.getValue("TRACE_THREADS");
        if (string2 != null) {
            DvTraceFmtPlugin.outputAndFlush("\nThe trace formatter will be run with the following option:");
            DvTraceFmtPlugin.outputAndFlush("\"-thread:" + string2.toLowerCase() + "\"");
        }
    }

    private boolean noDumpAccessed() {
        if (DvConsole.theDump == null) {
            this.printBanner(true, "", true);
            DvTraceFmtPlugin.outputAndFlush("Unable to comply as no dump accessed yet.");
            this.printBanner(true, "", true);
            return true;
        }
        return false;
    }

    private void printBanner(boolean bl, String string, boolean bl2) {
        if (this.printLines) {
            DvTraceFmtPlugin.outputAndFlush("------------------------------------------------------------------------------");
        }
    }

    private String getEnvVar(String string) {
        String string2 = "NULL";
        try {
            string2 = DvUtils.getValue(string);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (string2 == null) {
            string2 = "NULL";
        }
        return string2;
    }

    private boolean displayFile(String string, int n, int n2) {
        DvTraceFmtPlugin.outputAndFlush("display file \"" + string + "\", from line " + n + " to line " + n2);
        BufferedReader bufferedReader = null;
        File file = new File(string);
        FileReader fileReader = null;
        boolean bl = false;
        if (!file.exists()) {
            DvTraceFmtPlugin.outputAndFlush("ERROR: the file " + file.getName() + " doesn't exist");
            return false;
        }
        if (!file.canRead()) {
            DvTraceFmtPlugin.outputAndFlush("ERROR: Unable to read the file " + file.getName());
            return false;
        }
        int n3 = 1;
        String string2 = null;
        boolean bl2 = false;
        try {
            fileReader = new FileReader(file);
            bufferedReader = new BufferedReader(fileReader);
            while (bufferedReader.ready() && !bl2) {
                string2 = bufferedReader.readLine();
                if (n3 >= n) {
                    if (n3 <= n2) {
                        DvTraceFmtPlugin.outputAndFlush("[" + n3 + "] " + string2);
                        bl = true;
                    } else {
                        bl2 = true;
                    }
                }
                ++n3;
            }
            fileReader.close();
            bufferedReader.close();
        }
        catch (Exception exception) {
            DvTraceFmtPlugin.outputAndFlush("ERROR: Unexpected exception reading \"" + snapTraceOutputFileName + "\" (" + exception + ", " + exception.getMessage() + ")");
            exception.printStackTrace();
        }
        return bl;
    }

    protected static long readPtrAsLong(CTypeObject cTypeObject) {
        long l = 0L;
        try {
            DvAddress dvAddress = as.readPointer(as.createAddress(cTypeObject.getAddr()));
            l = dvAddress.getAddressAsLong();
        }
        catch (DvAddressException dvAddressException) {
            DvTraceFmtPlugin.outputAndFlush("DvAddressException while trying to read pointer from address 0x" + Long.toHexString(cTypeObject.getAddr()));
            DvTraceFmtPlugin.outputAndFlush(dvAddressException.toString());
        }
        catch (Exception exception) {
            DvTraceFmtPlugin.outputAndFlush("Other exception received reading pointer from address 0x" + Long.toHexString(cTypeObject.getAddr()));
            exception.printStackTrace();
        }
        return l;
    }

    protected static long readLongAsLong(CTypeObject cTypeObject) {
        long l = 0L;
        try {
            l = as.readLong(as.createAddress(cTypeObject.getAddr()));
        }
        catch (DvAddressException dvAddressException) {
            DvTraceFmtPlugin.outputAndFlush("DvAddressException while trying to read long from address 0x" + Long.toHexString(cTypeObject.getAddr()));
            DvTraceFmtPlugin.outputAndFlush(dvAddressException.toString());
        }
        catch (Exception exception) {
            DvTraceFmtPlugin.outputAndFlush("Other exception received reading long from address 0x" + Long.toHexString(cTypeObject.getAddr()));
            exception.printStackTrace();
        }
        return l;
    }

    protected static int readAnInt(CTypeObject cTypeObject) {
        int n = -1;
        try {
            n = as.readInt(as.createAddress(cTypeObject.getAddr()));
        }
        catch (DvAddressException dvAddressException) {
            DvTraceFmtPlugin.outputAndFlush("Exception while truing to read field from address 0x" + Long.toHexString(cTypeObject.getAddr()));
            DvTraceFmtPlugin.outputAndFlush(dvAddressException.toString());
        }
        return n;
    }

    protected static void writeDataToFile(long l, int n, String string) {
        FileOutputStream fileOutputStream;
        boolean bl = true;
        byte[] byArray = null;
        boolean bl2 = true;
        if (string.toUpperCase().trim().equals("NEW")) {
            bl2 = false;
        }
        output.add("writing 0x" + Long.toHexString(n) + " bytes from address 0x" + Long.toHexString(l) + " to file \"" + snapTraceFileName + "\"");
        try {
            fileOutputStream = new FileOutputStream(snapTraceFileName, bl2);
        }
        catch (IOException iOException) {
            output.add("Exception opening FileOutputStream for " + snapTraceFileName);
            return;
        }
        try {
            byArray = as.readBytes(l, (long)n);
            if (byArray.length < n) {
                output.add("Warning: Trace Buffer incomplete in dump, assuming zeroes for remainder.");
                byte[] byArray2 = new byte[n];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                byArray = byArray2;
            }
        }
        catch (Exception exception) {
            output.add("Exception trying to put bytes into array");
            bl = false;
        }
        if (bl) {
            try {
                fileOutputStream.write(byArray);
            }
            catch (IOException iOException) {
                output.add("Exception writing bytes to " + snapTraceFileName);
            }
        }
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            output.add("Exception closing FileOutputStream");
        }
    }

    protected static void outputAndFlush(String string) {
        output.add(string);
        DvTraceFmtPlugin.selfRef.cpr.output(output);
        output.clear();
    }

    public static Object getGenericHelp() {
        Vector vector = DvUtils.getMultiplePropertyValues("GeneralHelp", "DvTraceFmtPlugin.properties");
        return vector;
    }

    public String pluginName() {
        return "Trace format commands (DvTraceFmtPlugin)";
    }

    public String[] getSyntax() {
        return commandsSupported;
    }

    public String help() {
        return null;
    }

    public String help(String string) {
        return null;
    }

    public String[] guiMenuSyntax() {
        return null;
    }

    public String[] guiPopupSyntax() {
        return null;
    }

    public static StringTokenizer getValidTraceEntries() {
        Method method = null;
        Vector vector = new Vector();
        StringTokenizer stringTokenizer = null;
        Vector vector2 = DvUtils.findMethodForCurrentSuffix("getValidTraceEntries", new Class[0]);
        if (null != vector2 && vector2.size() == 2) {
            CommandPlugin commandPlugin = (CommandPlugin)vector2.get(0);
            method = (Method)vector2.get(1);
            try {
                stringTokenizer = (StringTokenizer)method.invoke((Object)commandPlugin, new Object[0]);
            }
            catch (Exception exception) {
                DvUtils.trace("*** Exception trying to utilise \" getValidTraceEntries \" supporting " + DvUtils.getSuffix(), 0, true);
                String string = exception.toString();
                DvUtils.trace(string, 0, true);
            }
        } else {
            DvUtils.trace("*** Error trying to find \" +getValidTraceEntries \" supporting " + DvUtils.getSuffix(), 0, true);
        }
        return stringTokenizer;
    }

    private boolean isTraceEnabled() {
        Method method = null;
        Vector vector = new Vector();
        Object var3_3 = null;
        boolean bl = false;
        Vector vector2 = DvUtils.findMethodForCurrentSuffix("isTraceEnabled", new Class[0]);
        if (null != vector2 && vector2.size() == 2) {
            CommandPlugin commandPlugin = (CommandPlugin)vector2.get(0);
            method = (Method)vector2.get(1);
            try {
                Boolean bl2 = (Boolean)method.invoke((Object)commandPlugin, new Object[0]);
                bl = bl2;
            }
            catch (Exception exception) {
                DvUtils.trace("*** Exception trying to utilise \" isTraceEnabled \" supporting " + DvUtils.getSuffix(), 0, true);
                String string = exception.toString();
                DvUtils.trace(string, 0, true);
            }
        } else {
            DvUtils.trace("*** Error trying to find \" +isTraceEnabled \" supporting " + DvUtils.getSuffix(), 0, true);
        }
        return bl;
    }
}

