/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.plugins;

import com.ibm.jvm.dump.format.DvThread;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.plugins.OutputStrategy;
import com.ibm.jvm.dump.plugins.STGlobalData;

class GcHelperDetails {
    private final STGlobalData sTGlobalData;
    private int gcHelpers;
    private int gcHelpersTarget;
    private int gcHelpersCeiling;
    private int gcThreadCount;
    private String[] gcThreadName;
    private DvThread[] gcThread;

    GcHelperDetails(STGlobalData sTGlobalData) {
        this.sTGlobalData = sTGlobalData;
        this.gcHelpers = this.sTGlobalData.getIntItem("gcHelpers");
        this.gcHelpersTarget = this.sTGlobalData.getIntItem("gcHelpersTarget");
        this.gcHelpersCeiling = this.sTGlobalData.getIntItem("gcHelpersCeiling");
        if (this.gcHelpersCeiling == 0) {
            this.gcHelpersCeiling = this.gcHelpers;
        }
        this.gcThreadCount = this.gcHelpersCeiling;
        if (this.sTGlobalData.isGcThreadsChangeable()) {
            ++this.gcThreadCount;
        }
        this.gcThreadName = new String[this.gcThreadCount];
        this.gcThread = new DvThread[this.gcThreadCount];
        int n = 0;
        while (n < this.gcHelpersCeiling) {
            this.gcThreadName[n] = "GC Helper " + (n + 1);
            ++n;
        }
        if (this.sTGlobalData.isGcThreadsChangeable()) {
            this.gcThreadName[this.gcHelpersCeiling] = "GC Helper Reconfiguration Thread";
        }
        DvThread[] dvThreadArray = this.sTGlobalData.getCurrentProcess().getThreads();
        int n2 = 0;
        while (n2 < dvThreadArray.length) {
            int n3 = 0;
            while (n3 < this.gcThreadCount) {
                if (DvUtils.getThreadName(dvThreadArray[n2], this.sTGlobalData.getCurrentAddressSpace()).equals(this.gcThreadName[n3])) {
                    this.gcThread[n3] = dvThreadArray[n2];
                }
                ++n3;
            }
            ++n2;
        }
    }

    void report(OutputStrategy outputStrategy) {
        outputStrategy.output("gcHelpers         :\n    Active        :  " + this.gcHelpers + "\n    Target        :  " + this.gcHelpersTarget);
        if (this.sTGlobalData.isGcThreadsChangeable()) {
            outputStrategy.output("\n    Ceiling       : " + this.gcHelpersCeiling);
        }
        outputStrategy.output("");
        outputStrategy.output("gc Helper Threads :");
        int n = 0;
        while (n < this.gcHelpersCeiling) {
            outputStrategy.output("    Name          : " + this.gcThreadName[n]);
            if (this.gcThread[n] != null) {
                outputStrategy.output("        Id        : 0x" + this.gcThread[n].id() + "\n        ExecEnv   : 0x" + this.gcThread[n].eeAddress().convertToHex() + "\n        MarkStack : 0x" + DvUtils.rJustifyZ(Long.toHexString(this.sTGlobalData.getMarkStackDetails().markStackForHelper(n).getAddressAsLong()), 0));
            } else {
                outputStrategy.output("!!Can't be found");
            }
            ++n;
        }
        if (this.gcThreadCount != this.gcHelpersCeiling) {
            outputStrategy.output("    Name          : " + this.gcThreadName[this.gcHelpersCeiling]);
            if (this.gcThread[this.gcHelpersCeiling] != null) {
                outputStrategy.output("\n        Id        : 0x" + this.gcThread[this.gcHelpersCeiling].id() + "\n        ExecEnv   : 0x" + this.gcThread[this.gcHelpersCeiling].eeAddress().convertToHex());
            } else {
                outputStrategy.output("!!Can't be found");
            }
        }
    }

    int getGcHelpersCeiling() {
        return this.gcHelpersCeiling;
    }
}

