/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.sdff;

import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.format.WordType;
import com.ibm.jvm.dump.sdff.DvReader;
import com.ibm.jvm.dump.sdff.Mapper;
import com.ibm.jvm.dump.sdff.WordLength;
import java.io.IOException;
import java.io.RandomAccessFile;

public class DvFileReader
extends DvReader {
    RandomAccessFile core;
    Mapper mapper;
    Uid uid;

    public DvFileReader(RandomAccessFile randomAccessFile, WordType wordType, WordLength wordLength, int n) {
        this.core = randomAccessFile;
        this.endType = wordType;
        this.wordLength = wordLength;
        this.uid = n == 2 ? new UidHalf() : new UidWord();
    }

    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    public void read(byte[] byArray) throws IOException {
        this.core.readFully(byArray);
    }

    public void read(byte[] byArray, int n, int n2) throws IOException {
        this.core.read(byArray, n, n2);
    }

    public long readBytes(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.core.read(byArray);
        return this.endType.toLong(byArray);
    }

    public String readStringPtr() throws IOException {
        long l = this.readAddress();
        long l2 = this.core.getFilePointer();
        DvUtils.trace("Ptr = " + Long.toHexString(l) + " filepos = " + Long.toHexString(l2), 2, false);
        this.setAddress(l);
        int n = 0;
        int n2 = 512;
        byte[] byArray = new byte[n2];
        while (n < n2) {
            byArray[n] = this.core.readByte();
            if (byArray[n] == 0) break;
            ++n;
        }
        DvUtils.trace("String = " + new String(byArray, 0, n), 2, false);
        this.setPos(l2);
        return new String(byArray, 0, n);
    }

    public String readString() throws IOException {
        int n = 0;
        int n2 = 512;
        byte[] byArray = new byte[n2];
        while (n < n2) {
            byArray[n] = this.core.readByte();
            if (byArray[n] == 0) break;
            ++n;
        }
        return new String(byArray, 0, n);
    }

    public String readString(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.core.read(byArray);
        return new String(byArray);
    }

    public int readBuffer(byte[] byArray) throws IOException {
        long l = this.core.read(byArray);
        return (int)l;
    }

    public long readByte() throws IOException {
        return this.readBytes(1);
    }

    public long readHalf() throws IOException {
        return this.readBytes(2);
    }

    public long readWord() throws IOException {
        return this.readBytes(4);
    }

    public long readLong() throws IOException {
        return this.readBytes(8);
    }

    public long getPos() throws IOException {
        return this.core.getFilePointer();
    }

    public void setPos(long l) throws IOException {
        this.core.seek(l);
    }

    public void setAddress(long l) throws IOException {
        long l2 = this.mapper.getOffset(l);
        this.setPos(l2);
    }

    public long readAddressOffset() throws IOException {
        long l = this.readBytes(this.wordLength.size);
        if (this.wordLength.size == 4) {
            int n = (int)l;
            DvUtils.trace("Offset is l:" + l + " i:" + n, 2, false);
            l = n;
            DvUtils.trace("Offset is l:" + l, 2, false);
        }
        return l;
    }

    public long readAddress() throws IOException {
        return this.readBytes(this.wordLength.size);
    }

    public long getAddr(byte[] byArray, int n) {
        byte[] byArray2 = new byte[this.wordLength.size];
        int n2 = 0;
        while (n2 < this.wordLength.size) {
            byArray2[n2] = byArray[n + n2];
            ++n2;
        }
        return this.endType.toLong(byArray2);
    }

    public long readUid() throws IOException {
        return this.uid.readUid();
    }

    class UidHalf
    extends Uid {
        UidHalf() {
        }

        public long readUid() throws IOException {
            return DvFileReader.this.readHalf();
        }
    }

    class UidWord
    extends Uid {
        UidWord() {
        }

        public long readUid() throws IOException {
            return DvFileReader.this.readWord();
        }
    }

    abstract class Uid {
        Uid() {
        }

        public abstract long readUid() throws IOException;
    }
}

