/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.findroots;

import com.ibm.jvm.findroots.Base;
import com.ibm.jvm.findroots.PrintBase;
import com.ibm.jvm.findroots.ReachabilityGraph;
import com.ibm.jvm.util.SvcdumpProperties;

public class PrintDomTree
extends PrintBase {
    int rootId;
    boolean test;

    public static void main(String[] stringArray) {
        PrintDomTree printDomTree = new PrintDomTree();
        printDomTree.start(stringArray, "PrintDomTree");
    }

    String[] options() {
        return new String[]{"-root <id>"};
    }

    String[] optionDescriptions() {
        return new String[]{"\tSpecify the id to use as the root"};
    }

    public boolean parseOption(String string, String string2) {
        if ("-root".equals(string)) {
            try {
                this.rootId = SvcdumpProperties.parseInt(string2, 16);
            }
            catch (Exception exception) {
                System.err.println(string2 + " is not a valid number");
                this.usage();
            }
            return true;
        }
        if ("-test".equals(string)) {
            this.test = true;
            return true;
        }
        return super.parseOption(string, string2);
    }

    protected void parseStart() {
        this.graph.idToIndex(0);
    }

    void clear() {
        this.dump = null;
        this.strings = null;
        this.printGraph = null;
        this.ids = null;
        this.indexes = null;
        this.types = null;
        this.sizes = null;
        this.excludeObjects = null;
        this.excludeClasses = null;
        this.classTable = null;
        this.classes = null;
        this.btypes = null;
    }

    protected void parseEnd() {
        super.parseEnd();
        if (this.test) {
            this.clear();
        }
        if (this.rootId == 0) {
            this.log("go find the biggest root");
            this.rootId = this.graph.getBiggestRoot();
            this.log("biggest root = " + Base.hex(this.rootId));
        }
        if (ReachabilityGraph.nosubgraph) {
            this.graph.findDominatorEdges(this.rootId);
            this.graph.printTree(this, this.rootId);
        } else {
            ReachabilityGraph reachabilityGraph = (ReachabilityGraph)this.graph.getSubgraph(this.rootId);
            ReachabilityGraph reachabilityGraph2 = reachabilityGraph.findDominators(this.rootId);
            reachabilityGraph = null;
            reachabilityGraph2.print(this);
        }
    }
}

