/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.svcdump;

import com.ibm.jvm.dump.format.CType;
import com.ibm.jvm.svcdump.AddressSpace;
import com.ibm.jvm.svcdump.Base;
import com.ibm.jvm.svcdump.Heap;
import com.ibm.jvm.svcdump.HeapField;
import com.ibm.jvm.svcdump.HeapMethod;
import com.ibm.jvm.svcdump.Jvm;
import com.ibm.jvm.util.IntegerArray;

public class HeapClass
extends Base {
    Jvm jvm;
    int address;
    String type;
    String name;
    int[] staticReferences;
    AddressSpace space;
    static HeapClass javaLangClass;
    static HeapClass javaLangString;
    boolean doneReferenceCheck;
    boolean isInstanceOfReference;
    boolean doneSuperClassCheck;
    HeapClass superClass;
    Heap heap;
    HeapClass arrayClass;
    boolean isArray;
    int objectOffsets = -1;
    static HeapClass[] primitiveArrayClasses;
    static final int CCMS_IsInitialized = 4;
    static String[] arrayName;

    HeapClass(Jvm jvm, int n, String string) {
        this.jvm = jvm;
        this.address = n;
        this.name = string.intern();
        this.space = jvm.space;
        this.heap = jvm.getHeap();
    }

    HeapClass(Jvm jvm, HeapClass heapClass) {
        this.isArray = true;
        this.name = "array of " + heapClass.getName();
        this.name = this.name.intern();
        this.jvm = jvm;
        this.space = jvm.space;
        this.heap = jvm.getHeap();
    }

    HeapClass(String string) {
        this.name = string.intern();
    }

    public boolean isArray() {
        return this.isArray;
    }

    static HeapClass getPrimitiveArrayClass(int n) {
        if (primitiveArrayClasses[n] == null) {
            HeapClass.primitiveArrayClasses[n] = new HeapClass(arrayName[n]);
        }
        return primitiveArrayClasses[n];
    }

    public boolean isPrimitive() {
        return this.jvm == null;
    }

    public HeapField getField(String string) {
        try {
            return new HeapField(this, this.getFieldPointer(string));
        }
        catch (Exception exception) {
            try {
                if (this.cbSuperclass() != null) {
                    return this.cbSuperclass().getField(string);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new Error("field " + string + " not found in class " + this.name);
        }
    }

    void check() throws Exception {
        if (this.jvm == null || this.isArray) {
            return;
        }
        if (!this.jvm.isLiveChunk(this.address - 4)) {
            // empty if block
        }
        int n = this.space.readInt(this.cbMainSpace() - 8);
        int n2 = this.space.readInt(this.cbMainSpace() - 4);
        if (n > 0 && n2 != n) {
            this.jvm.expect(n, "HANC", false);
        }
    }

    HeapClass getArrayClass() {
        if (this.arrayClass == null) {
            this.arrayClass = new HeapClass(this.jvm, this);
        }
        return this.arrayClass;
    }

    public int getAddress() {
        if (this.jvm == null) {
            return 0;
        }
        Base.Assert(this.address != 0);
        return this.address;
    }

    boolean isJavaLangClass() {
        if (javaLangClass != null) {
            return this == javaLangClass;
        }
        if (this.name.equals("java/lang/Class")) {
            javaLangClass = this;
            return true;
        }
        return false;
    }

    boolean isJavaLangString() {
        if (javaLangString != null) {
            return this == javaLangString;
        }
        if (this.name.equals("java/lang/String")) {
            javaLangString = this;
            return true;
        }
        return false;
    }

    public int mirrored_state() throws Exception {
        return this.space.readInt(this.address + 8 + CType.offsetof("MirroredClassData", "mirrored_state", -1));
    }

    public int initial_static_variable_values() throws Exception {
        return this.space.readInt(this.address + 8 + CType.offsetof("Classjava_lang_Class", "initial_static_variable_values", 208));
    }

    public int shared_class_id() throws Exception {
        return this.space.readInt(this.address + 8 + CType.offsetof("Classjava_lang_Class", "shared_class_id", 48));
    }

    public int attribute_flags() throws Exception {
        return this.space.readInt(this.address + 8 + CType.offsetof("Classjava_lang_Class", "attribute_flags", 156));
    }

    public boolean cbIsInitialized() {
        try {
            return this.cbMirroredStateIs(4);
        }
        catch (Exception exception) {
            throw new Error("unexpected exception: " + exception);
        }
    }

    public boolean cbMirroredStateIs(int n) throws Exception {
        if (this.cbIsShared()) {
            throw new Error("to be completed");
        }
        return (this.mirrored_state() & n) != 0;
    }

    public boolean cbIsShared() throws Exception {
        return this.shared_class_id() != 0;
    }

    int[] staticReferences() throws Exception {
        if (this.staticReferences != null) {
            return this.staticReferences;
        }
        int n = this.cbDeclaredFields();
        int n2 = this.cbFieldsCount();
        IntegerArray integerArray = null;
        if (n != 0 && n2 > 0) {
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n + n3 * 24;
                if (this.fbIsStatic(n4) && this.fbIsReference(n4)) {
                    int n5 = this.fbStaticValueAddress(n4);
                    try {
                        int n6 = this.space.readInt(n5);
                        if (n6 != 0) {
                            if (this.jvm.stIsValidHandle(n6)) {
                                if (integerArray == null) {
                                    integerArray = new IntegerArray();
                                }
                                integerArray.add(n6);
                            } else if (this.jvm.handler != null) {
                                this.jvm.handler.error("found bad reference " + Base.hex(n6) + " in class " + Base.hex(this.address));
                            }
                        }
                    }
                    catch (Exception exception) {
                        this.jvm.handler.error("found bad static reference pointer " + Base.hex(n5) + " in class " + Base.hex(this.address));
                    }
                }
                ++n3;
            }
        }
        this.staticReferences = integerArray == null ? new int[]{} : integerArray.toArray();
        return this.staticReferences;
    }

    public int getStaticField(String string) throws Exception {
        int n = this.cbDeclaredFields();
        int n2 = this.cbFieldsCount();
        if (n != 0 && n2 > 0) {
            int n3 = 0;
            while (n3 < n2) {
                int n4;
                int n5;
                int n6 = n + n3 * 24;
                if (this.fbIsStatic(n6) && this.fbIsReference(n6) && this.fbName(n6).equals(string) && (n5 = this.space.readInt(n4 = this.fbStaticValueAddress(n6))) != 0 && this.jvm.stIsValidHandle(n5)) {
                    return n5;
                }
                ++n3;
            }
        }
        return -1;
    }

    int getFieldOffset(String string) throws Exception {
        int n = this.cbDeclaredFields();
        int n2 = this.cbFieldsCount();
        if (n != 0 && n2 > 0) {
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n + n3 * 24;
                if (!this.fbIsStatic(n4) && this.fbName(n4).equals(string)) {
                    return this.fbStaticValueAddress(n4);
                }
                ++n3;
            }
        }
        throw new Exception("Field not found: " + string);
    }

    char getFieldType(String string) throws Exception {
        int n = this.cbDeclaredFields();
        int n2 = this.cbFieldsCount();
        if (n != 0 && n2 > 0) {
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n + n3 * 24;
                if (!this.fbIsStatic(n4) && this.fbName(n4).equals(string)) {
                    return this.fbFieldType(n4);
                }
                ++n3;
            }
        }
        throw new Exception("Field not found: " + string);
    }

    int getFieldPointer(String string) throws Exception {
        int n = this.cbDeclaredFields();
        int n2 = this.cbFieldsCount();
        if (n != 0 && n2 > 0) {
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n + n3 * 24;
                if (!this.fbIsStatic(n4) && this.fbName(n4).equals(string)) {
                    return n4;
                }
                ++n3;
            }
        }
        throw new Exception("Field not found: " + string);
    }

    int cbObjectOffsets() throws Exception {
        if (this.objectOffsets == -1) {
            this.objectOffsets = this.space.readInt(this.address + 8 + CType.offsetof("Classjava_lang_Class", "object_offsets", 176));
        }
        return this.objectOffsets;
    }

    int cbMainSpace() throws Exception {
        return this.space.readInt(this.address + 8 + CType.offsetof("Classjava_lang_Class", "main", 180));
    }

    int cbDeclaredMethods() throws Exception {
        return this.space.readInt(this.address + 8 + CType.offsetof("Classjava_lang_Class", "methods", 92));
    }

    int cbDeclaredFields() throws Exception {
        return this.space.readInt(this.address + 8 + CType.offsetof("Classjava_lang_Class", "fields", 96));
    }

    int cbMethodsCount() throws Exception {
        return this.space.readUnsignedShort(this.address + 8 + CType.offsetof("Classjava_lang_Class", "methods_count", 138));
    }

    int cbFieldsCount() throws Exception {
        return this.space.readUnsignedShort(this.address + 8 + CType.offsetof("Classjava_lang_Class", "fields_count", 140));
    }

    public HeapClass cbSuperclass() throws Exception {
        if (this.doneSuperClassCheck) {
            return this.superClass;
        }
        this.doneSuperClassCheck = true;
        int n = this.space.readInt(this.address + 8 + CType.offsetof("Classjava_lang_Class", "superclass", 68));
        if (n != 0) {
            this.superClass = this.jvm.getClass(n);
        }
        return this.superClass;
    }

    boolean isInstanceOfReference() throws Exception {
        if (this.doneReferenceCheck) {
            return this.isInstanceOfReference;
        }
        this.doneReferenceCheck = true;
        if (this.name.equals("java/lang/ref/Reference")) {
            if (this.verbose()) {
                System.out.println("found reference subclass: " + this.name);
            }
            this.isInstanceOfReference = true;
        } else if (this.cbSuperclass() != null && this.cbSuperclass().isInstanceOfReference()) {
            if (this.verbose()) {
                System.out.println("found reference subclass: " + this.name);
            }
            this.isInstanceOfReference = true;
        }
        return this.isInstanceOfReference;
    }

    boolean isInstanceOfString() throws Exception {
        return this.name.equals("java/lang/String");
    }

    boolean fbIsStatic(int n) throws Exception {
        return (this.space.readUnsignedShort(n + 12) & 8) != 0;
    }

    boolean fbIsReference(int n) throws Exception {
        return (this.space.readUnsignedShort(n + 14) & 2) != 0;
    }

    int fbStaticValueAddress(int n) throws Exception {
        return this.space.readInt(n + 20);
    }

    String cbSourceName() throws Exception {
        int n = CType.offsetof("Classjava_lang_Class", "source_name", -1);
        int n2 = this.space.readInt(this.address + 8 + n);
        try {
            return this.space.readString(n2);
        }
        catch (Exception exception) {
            return "";
        }
    }

    String fbSignature(int n) throws Exception {
        int n2 = this.space.readInt(n + 4);
        return this.space.readString(n2);
    }

    char fbFieldType(int n) throws Exception {
        return this.fbSignature(n).charAt(0);
    }

    String mbName(int n) throws Exception {
        int n2 = this.space.readInt(n + 8);
        return this.space.readString(n2);
    }

    String fbName(int n) throws Exception {
        return this.mbName(n);
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public HeapMethod[] getMethods() throws Exception {
        int n = this.cbMethodsCount();
        HeapMethod[] heapMethodArray = new HeapMethod[n];
        int n2 = this.cbDeclaredMethods();
        int n3 = 100;
        CType cType = CType.find("methodblock");
        if (cType != null) {
            n3 = cType.getSize();
        }
        int n4 = 0;
        while (n4 < n) {
            int n5 = n2 + n4 * n3;
            heapMethodArray[n4] = new HeapMethod(this, n5);
            ++n4;
        }
        return heapMethodArray;
    }

    public HeapField[] getFields() throws Exception {
        int n = this.cbFieldsCount();
        HeapField[] heapFieldArray = new HeapField[n];
        int n2 = this.cbDeclaredFields();
        int n3 = 0;
        while (n3 < n) {
            int n4 = n2 + n3 * 24;
            heapFieldArray[n3] = new HeapField(this, n4);
            ++n3;
        }
        return heapFieldArray;
    }

    public boolean equals(Object object) {
        if (!(object instanceof HeapClass)) {
            return false;
        }
        HeapClass heapClass = (HeapClass)object;
        return heapClass.name == this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    static {
        primitiveArrayClasses = new HeapClass[16];
        arrayName = new String[]{"unknown array type", "unknown array type", "array of references", "unknown array type", "array of boolean", "array of char", "array of float", "array of double", "array of byte", "array of short", "array of int", "array of long", "array of unsigned byte", "array of unsigned char", "array of unsigned int", "array of unsigned long"};
    }
}

