/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.svcdump.examples;

import com.ibm.jvm.svcdump.AddressSpace;
import com.ibm.jvm.svcdump.Dsa;
import com.ibm.jvm.svcdump.Dump;
import com.ibm.jvm.svcdump.Page;
import com.ibm.jvm.svcdump.StackSegment;
import com.ibm.jvm.svcdump.Tcb;
import com.ibm.jvm.util.IntHashtable;
import com.ibm.jvm.util.SvcdumpProperties;
import java.util.Vector;

public class FindStackRoots {
    public static void main(String[] stringArray) {
        IntHashtable intHashtable = new IntHashtable();
        Vector<DsaNode> vector = new Vector<DsaNode>();
        if (stringArray.length != 2) {
            System.out.println("Usage: java com.ibm.jvm.svcdump.examples.FindStackRoots <dumpname> <tcb id>");
            return;
        }
        try {
            Object object;
            int n;
            int n2;
            Object object2;
            Object object3;
            int n3 = SvcdumpProperties.parseInt(stringArray[1], 16);
            Dump dump = new Dump(stringArray[0]);
            AddressSpace addressSpace = dump.getDefaultAddressSpace();
            Tcb tcb = addressSpace.getTcb(n3);
            Tcb[] tcbArray = addressSpace.tcbs();
            int n4 = 0;
            while (n4 < tcbArray.length) {
                if (tcbArray[n4].isJava() && addressSpace.readInt(tcbArray[n4].tid()) == tcb.tid()) {
                    System.out.println("tid is present as someones forward pointer");
                }
                ++n4;
            }
            StackSegment[] stackSegmentArray = tcb.stackSegments();
            System.out.println("ok so far, found " + stackSegmentArray.length);
            int n5 = 0;
            while (n5 < stackSegmentArray.length) {
                object3 = stackSegmentArray[n5];
                System.out.println("hunt for dsa from " + FindStackRoots.hex(((StackSegment)object3).lower) + " to " + FindStackRoots.hex(((StackSegment)object3).lower));
                int n6 = ((StackSegment)object3).lower;
                while (n6 < ((StackSegment)object3).upper) {
                    try {
                        object2 = new Dsa(tcb, n6, ((StackSegment)object3).isDownStack);
                        n2 = ((Dsa)object2).prevCount();
                        if (n2 > 3 && n2 < 190) {
                            n = 0;
                            object = object2;
                            while (object != null) {
                                if (!((Dsa)object).function().startsWith("(unknown")) {
                                    n = 1;
                                    break;
                                }
                                object = ((Dsa)object).previous();
                            }
                            if (n != 0) {
                                DsaNode dsaNode = null;
                                Object object4 = object2;
                                while (object4 != null) {
                                    if (FindStackRoots.outsideStack(stackSegmentArray, ((Dsa)object4).address)) break;
                                    DsaNode dsaNode2 = (DsaNode)intHashtable.get(((Dsa)object4).address);
                                    if (dsaNode2 == null) {
                                        dsaNode2 = new DsaNode((Dsa)object4);
                                        intHashtable.put(((Dsa)object4).address, (Object)dsaNode2);
                                    }
                                    if (dsaNode != null) {
                                        DsaNode.link(dsaNode, dsaNode2);
                                    }
                                    dsaNode = dsaNode2;
                                    object4 = ((Dsa)object4).previous();
                                }
                                if (!vector.contains(dsaNode)) {
                                    vector.add(dsaNode);
                                }
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    n6 += 4;
                }
                ++n5;
            }
            object3 = addressSpace.getPages();
            while (object3.hasMoreElements()) {
                Page page = (Page)object3.nextElement();
                object2 = page.getIntArray();
                n2 = 0;
                n = 0;
                while (n < ((Object)object2).length) {
                    int n7;
                    object = (DsaNode)intHashtable.get((int)object2[n]);
                    if (object != null && FindStackRoots.outsideStack(stackSegmentArray, n7 = page.getAddress() + n * 4)) {
                        ((DsaNode)object).addPointer(n7);
                        ++n2;
                    }
                    ++n;
                }
            }
            int n8 = 0;
            while (n8 < vector.size()) {
                object2 = (DsaNode)vector.elementAt(n8);
                ((DsaNode)object2).print(0);
                ++n8;
            }
        }
        catch (Exception exception) {
            System.out.println("Oops: " + exception);
        }
    }

    static boolean outsideStack(StackSegment[] stackSegmentArray, int n) {
        int n2 = 0;
        while (n2 < stackSegmentArray.length) {
            if (stackSegmentArray[n2].contains(n)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    static String hex(int n) {
        return Integer.toHexString(n);
    }

    static class DsaNode {
        Dsa dsa;
        DsaNode parent;
        Vector children = new Vector();
        int[] pointers;

        DsaNode(Dsa dsa) {
            this.dsa = dsa;
        }

        static void link(DsaNode dsaNode, DsaNode dsaNode2) {
            dsaNode.parent = dsaNode2;
            if (!dsaNode2.children.contains(dsaNode)) {
                dsaNode2.children.add(dsaNode);
            }
        }

        void addPointer(int n) {
            if (this.pointers == null) {
                this.pointers = new int[1];
                this.pointers[0] = n;
            } else {
                int[] nArray = new int[this.pointers.length + 1];
                System.arraycopy(this.pointers, 0, nArray, 0, this.pointers.length);
                nArray[this.pointers.length] = n;
                this.pointers = nArray;
            }
        }

        void print(String string, int n) {
            int n2 = 0;
            while (n2 < n) {
                System.out.print("    ");
                ++n2;
            }
            System.out.println(string);
        }

        void print(int n) {
            int n2;
            String string = FindStackRoots.hex(this.dsa.address) + " " + this.dsa.function();
            if (this.pointers != null) {
                string = string + " (pointed to by ";
                n2 = 0;
                while (n2 < this.pointers.length) {
                    if (n2 != 0) {
                        string = string + ", ";
                    }
                    string = string + FindStackRoots.hex(this.pointers[n2]);
                    ++n2;
                }
                string = string + ")";
            }
            this.print(string, n);
            n2 = 0;
            while (n2 < this.children.size()) {
                DsaNode dsaNode = (DsaNode)this.children.elementAt(n2);
                dsaNode.print(n + 1);
                ++n2;
            }
        }
    }
}

