/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.zseries;

import com.ibm.jvm.io.RandomAccessStream;
import com.ibm.jvm.util.html.Document;
import com.ibm.jvm.zseries.Add;
import com.ibm.jvm.zseries.AddHalfword;
import com.ibm.jvm.zseries.AddHalfwordImmediate;
import com.ibm.jvm.zseries.AddLogical;
import com.ibm.jvm.zseries.AddLogicalR;
import com.ibm.jvm.zseries.AddR;
import com.ibm.jvm.zseries.And;
import com.ibm.jvm.zseries.AndImmediate;
import com.ibm.jvm.zseries.BranchAndLink;
import com.ibm.jvm.zseries.BranchAndLinkR;
import com.ibm.jvm.zseries.BranchAndSave;
import com.ibm.jvm.zseries.BranchAndSaveR;
import com.ibm.jvm.zseries.BranchOnCondition;
import com.ibm.jvm.zseries.BranchOnConditionR;
import com.ibm.jvm.zseries.BranchOnCount;
import com.ibm.jvm.zseries.BranchOnCountR;
import com.ibm.jvm.zseries.BranchRelativeOnCondition;
import com.ibm.jvm.zseries.BranchRelativeOnCount;
import com.ibm.jvm.zseries.Compare;
import com.ibm.jvm.zseries.CompareAndSwap;
import com.ibm.jvm.zseries.CompareCharactersUnderMask;
import com.ibm.jvm.zseries.CompareHalfword;
import com.ibm.jvm.zseries.CompareHalfwordImmediate;
import com.ibm.jvm.zseries.CompareLogical;
import com.ibm.jvm.zseries.CompareLogicalCharacter;
import com.ibm.jvm.zseries.CompareLogicalImmediate;
import com.ibm.jvm.zseries.CompareLogicalR;
import com.ibm.jvm.zseries.CompareR;
import com.ibm.jvm.zseries.ConvertToBinary;
import com.ibm.jvm.zseries.Divide;
import com.ibm.jvm.zseries.Execute;
import com.ibm.jvm.zseries.InsertCharacter;
import com.ibm.jvm.zseries.InsertCharactersUnderMask;
import com.ibm.jvm.zseries.Instruction;
import com.ibm.jvm.zseries.Load;
import com.ibm.jvm.zseries.LoadAddress;
import com.ibm.jvm.zseries.LoadAddressRelativeLong;
import com.ibm.jvm.zseries.LoadAndTest;
import com.ibm.jvm.zseries.LoadComplement;
import com.ibm.jvm.zseries.LoadHalfword;
import com.ibm.jvm.zseries.LoadHalfwordImmediate;
import com.ibm.jvm.zseries.LoadLong;
import com.ibm.jvm.zseries.LoadMultiple;
import com.ibm.jvm.zseries.LoadNegative;
import com.ibm.jvm.zseries.LoadPositive;
import com.ibm.jvm.zseries.LoadRegister;
import com.ibm.jvm.zseries.LoadShort;
import com.ibm.jvm.zseries.Move;
import com.ibm.jvm.zseries.MoveC;
import com.ibm.jvm.zseries.MoveString;
import com.ibm.jvm.zseries.MultiplyHalfword;
import com.ibm.jvm.zseries.Or;
import com.ibm.jvm.zseries.OrCharacter;
import com.ibm.jvm.zseries.OrImmediate;
import com.ibm.jvm.zseries.Pack;
import com.ibm.jvm.zseries.SearchString;
import com.ibm.jvm.zseries.SetFPC;
import com.ibm.jvm.zseries.ShiftLeftSingle;
import com.ibm.jvm.zseries.ShiftLeftSingleLogical;
import com.ibm.jvm.zseries.ShiftRightDouble;
import com.ibm.jvm.zseries.ShiftRightSingle;
import com.ibm.jvm.zseries.ShiftRightSingleLogical;
import com.ibm.jvm.zseries.Store;
import com.ibm.jvm.zseries.StoreAccessMultiple;
import com.ibm.jvm.zseries.StoreCharacter;
import com.ibm.jvm.zseries.StoreHalfword;
import com.ibm.jvm.zseries.StoreLong;
import com.ibm.jvm.zseries.StoreMultiple;
import com.ibm.jvm.zseries.StoreShort;
import com.ibm.jvm.zseries.Subtract;
import com.ibm.jvm.zseries.SubtractLogical;
import com.ibm.jvm.zseries.SubtractLogicalR;
import com.ibm.jvm.zseries.SubtractR;
import com.ibm.jvm.zseries.SupervisorCall;
import com.ibm.jvm.zseries.TestUnderMask;
import com.ibm.jvm.zseries.TestUnderMaskHigh;
import com.ibm.jvm.zseries.TestUnderMaskLow;
import com.ibm.jvm.zseries.TranslateAndTest;
import com.ibm.jvm.zseries.Unknown;
import com.ibm.jvm.zseries.Xor;
import com.ibm.jvm.zseries.XorC;
import com.ibm.jvm.zseries.XorR;
import java.util.Vector;

public class Engine {
    RandomAccessStream ras;
    boolean r15PointsToEntry = true;
    int[] reg = new int[16];
    boolean[] regValid = new boolean[16];
    boolean foundStart = false;

    public Engine(RandomAccessStream randomAccessStream) {
        this.ras = randomAccessStream;
    }

    int getRegister(int n) {
        return this.reg[n];
    }

    public void putRegister(int n, int n2) {
        this.reg[n] = n2;
        this.regValid[n] = true;
    }

    public boolean validRegister(int n) {
        return this.regValid[n];
    }

    public void killRegister(int n) {
        this.regValid[n] = false;
    }

    public Instruction[] disassemble(Document document, int n, int n2, int n3) throws Exception {
        this.putRegister(12, n3);
        return this.disassemble(document, n, n2);
    }

    public Instruction[] disassemble(Document document, int n, int n2) throws Exception {
        int n3 = n;
        this.putRegister(15, n);
        Vector vector = new Vector();
        Instruction instruction = null;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = this.ras.readInt(n);
            int n6 = n5 >>> 24;
            boolean bl = true;
            switch (n6) {
                case 5: {
                    instruction = new BranchAndLinkR(this, n5);
                    break;
                }
                case 6: {
                    instruction = new BranchOnCountR(this, n5);
                    break;
                }
                case 7: {
                    instruction = new BranchOnConditionR(this, n5);
                    break;
                }
                case 10: {
                    instruction = new SupervisorCall(this, n5);
                    break;
                }
                case 13: {
                    instruction = new BranchAndSaveR(this, n5);
                    break;
                }
                case 16: {
                    instruction = new LoadPositive(this, n5);
                    break;
                }
                case 17: {
                    instruction = new LoadNegative(this, n5);
                    break;
                }
                case 18: {
                    instruction = new LoadAndTest(this, n5);
                    break;
                }
                case 19: {
                    instruction = new LoadComplement(this, n5);
                    break;
                }
                case 21: {
                    instruction = new CompareLogicalR(this, n5);
                    break;
                }
                case 23: {
                    instruction = new XorR(this, n5);
                    break;
                }
                case 24: {
                    instruction = new LoadRegister(this, n5);
                    break;
                }
                case 25: {
                    instruction = new CompareR(this, n5);
                    break;
                }
                case 26: {
                    instruction = new AddR(this, n5);
                    break;
                }
                case 27: {
                    instruction = new SubtractR(this, n5);
                    break;
                }
                case 30: {
                    instruction = new AddLogicalR(this, n5);
                    break;
                }
                case 31: {
                    instruction = new SubtractLogicalR(this, n5);
                    break;
                }
                case 64: {
                    instruction = new StoreHalfword(this, n5);
                    break;
                }
                case 65: {
                    instruction = new LoadAddress(this, n5);
                    break;
                }
                case 66: {
                    instruction = new StoreCharacter(this, n5);
                    break;
                }
                case 67: {
                    instruction = new InsertCharacter(this, n5);
                    break;
                }
                case 68: {
                    instruction = new Execute(this, n5);
                    break;
                }
                case 69: {
                    instruction = new BranchAndLink(this, n5);
                    break;
                }
                case 70: {
                    instruction = new BranchOnCount(this, n5);
                    break;
                }
                case 71: {
                    instruction = new BranchOnCondition(this, n5);
                    break;
                }
                case 72: {
                    instruction = new LoadHalfword(this, n5);
                    break;
                }
                case 73: {
                    instruction = new CompareHalfword(this, n5);
                    break;
                }
                case 74: {
                    instruction = new AddHalfword(this, n5);
                    break;
                }
                case 76: {
                    instruction = new MultiplyHalfword(this, n5);
                    break;
                }
                case 77: {
                    instruction = new BranchAndSave(this, n5);
                    break;
                }
                case 79: {
                    instruction = new ConvertToBinary(this, n5);
                    break;
                }
                case 80: {
                    instruction = new Store(this, n5);
                    break;
                }
                case 84: {
                    instruction = new And(this, n5);
                    break;
                }
                case 85: {
                    instruction = new CompareLogical(this, n5);
                    break;
                }
                case 86: {
                    instruction = new Or(this, n5);
                    break;
                }
                case 87: {
                    instruction = new Xor(this, n5);
                    break;
                }
                case 88: {
                    instruction = new Load(this, n5);
                    break;
                }
                case 89: {
                    instruction = new Compare(this, n5);
                    break;
                }
                case 90: {
                    instruction = new Add(this, n5);
                    break;
                }
                case 91: {
                    instruction = new Subtract(this, n5);
                    break;
                }
                case 93: {
                    instruction = new Divide(this, n5);
                    break;
                }
                case 94: {
                    instruction = new AddLogical(this, n5);
                    break;
                }
                case 95: {
                    instruction = new SubtractLogical(this, n5);
                    break;
                }
                case 96: {
                    instruction = new StoreLong(this, n5);
                    break;
                }
                case 104: {
                    instruction = new LoadLong(this, n5);
                    break;
                }
                case 112: {
                    instruction = new StoreShort(this, n5);
                    break;
                }
                case 120: {
                    instruction = new LoadShort(this, n5);
                    break;
                }
                case 136: {
                    instruction = new ShiftRightSingleLogical(this, n5);
                    break;
                }
                case 137: {
                    instruction = new ShiftLeftSingleLogical(this, n5);
                    break;
                }
                case 138: {
                    instruction = new ShiftRightSingle(this, n5);
                    break;
                }
                case 139: {
                    instruction = new ShiftLeftSingle(this, n5);
                    break;
                }
                case 142: {
                    instruction = new ShiftRightDouble(this, n5);
                    break;
                }
                case 144: {
                    instruction = new StoreMultiple(this, n5);
                    break;
                }
                case 145: {
                    instruction = new TestUnderMask(this, n5);
                    break;
                }
                case 146: {
                    instruction = new Move(this, n5);
                    break;
                }
                case 148: {
                    instruction = new AndImmediate(this, n5);
                    break;
                }
                case 149: {
                    instruction = new CompareLogicalImmediate(this, n5);
                    break;
                }
                case 150: {
                    instruction = new OrImmediate(this, n5);
                    break;
                }
                case 152: {
                    instruction = new LoadMultiple(this, n5);
                    break;
                }
                case 155: {
                    instruction = new StoreAccessMultiple(this, n5);
                    break;
                }
                case 167: {
                    int n7 = n5 >> 16 & 0xF;
                    if (n7 == 0) {
                        instruction = new TestUnderMaskHigh(this, n5);
                        break;
                    }
                    if (n7 == 1) {
                        instruction = new TestUnderMaskLow(this, n5);
                        break;
                    }
                    if (n7 == 4) {
                        instruction = new BranchRelativeOnCondition(this, n, n5);
                        break;
                    }
                    if (n7 == 6) {
                        instruction = new BranchRelativeOnCount(this, n, n5);
                        break;
                    }
                    if (n7 == 8) {
                        instruction = new LoadHalfwordImmediate(this, n5);
                        break;
                    }
                    if (n7 == 14) {
                        instruction = new CompareHalfwordImmediate(this, n5);
                        break;
                    }
                    if (n7 == 10) {
                        instruction = new AddHalfwordImmediate(this, n5);
                        break;
                    }
                    throw new Exception("Unknown instruction 0x" + Engine.hex(n5) + " at 0x" + Engine.hex(n));
                }
                case 178: {
                    if ((n5 & 0xFFFF0000) == -1303052288) {
                        instruction = new MoveString(this, n5);
                        break;
                    }
                    if ((n5 & 0xFFFF0000) == -1302462464) {
                        instruction = new SearchString(this, n5);
                        break;
                    }
                    throw new Exception("Unknown instruction 0x" + Engine.hex(n5) + " at 0x" + Engine.hex(n));
                }
                case 179: {
                    if ((n5 & 0xFFFF0000) == -1283194880) {
                        instruction = new SetFPC(this, n5);
                        break;
                    }
                    throw new Exception("Unknown instruction 0x" + Engine.hex(n5) + " at 0x" + Engine.hex(n));
                }
                case 186: {
                    instruction = new CompareAndSwap(this, n5);
                    break;
                }
                case 189: {
                    instruction = new CompareCharactersUnderMask(this, n5);
                    break;
                }
                case 191: {
                    instruction = new InsertCharactersUnderMask(this, n5);
                    break;
                }
                case 192: {
                    n6 = n5 >> 16 & 0xF;
                    if (n6 == 0) {
                        int n8 = n5 >> 20 & 0xF;
                        int n9 = this.ras.readInt(n + 2);
                        instruction = new LoadAddressRelativeLong(this, n, n8, n9);
                        break;
                    }
                    throw new Exception("Unknown instruction 0x" + Engine.hex(n5) + " at 0x" + Engine.hex(n));
                }
                case 210: {
                    instruction = new MoveC(this, n5, this.ras.readInt(n + 4));
                    break;
                }
                case 213: {
                    instruction = new CompareLogicalCharacter(this, n5, this.ras.readInt(n + 4));
                    break;
                }
                case 214: {
                    instruction = new OrCharacter(this, n5, this.ras.readInt(n + 4));
                    break;
                }
                case 215: {
                    instruction = new XorC(this, n5, this.ras.readInt(n + 4));
                    break;
                }
                case 221: {
                    instruction = new TranslateAndTest(this, n5, this.ras.readInt(n + 4));
                    break;
                }
                case 242: {
                    instruction = new Pack(this, n5, this.ras.readInt(n + 4));
                    break;
                }
                default: {
                    if (!(this.foundStart || n6 != 0 && n6 != 1)) {
                        instruction = new Unknown(this, n5);
                        bl = false;
                        break;
                    }
                    if (n6 == 0 && instruction instanceof BranchAndLink) {
                        instruction = new Unknown(this, n5);
                        break;
                    }
                    if (n6 == 0) {
                        instruction = new Unknown(this, n5);
                        break;
                    }
                    throw new Exception("Unknown instruction 0x" + Engine.hex(n5) + " at 0x" + Engine.hex(n));
                }
            }
            System.out.println("0x" + Engine.hex(n) + ": " + "(0x" + Engine.hex(n - n3) + "): " + instruction);
            n = instruction.nextAddress(n);
            if (bl) {
                this.foundStart = true;
            }
            ++n4;
        }
        return vector.toArray(new Instruction[0]);
    }

    static String hex(int n) {
        String string = Integer.toHexString(n);
        int n2 = string.length();
        while (n2 < 8) {
            string = "0" + string;
            ++n2;
        }
        return string;
    }

    static String hx(int n) {
        return Integer.toHexString(n);
    }
}

