/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio.cs;

import com.ibm.nio.cs.IBMCharsetEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;
import sun.nio.cs.Surrogate;

class DBA_Encoder
extends IBMCharsetEncoder {
    private final int convertType;
    private final boolean maplow;
    private final Surrogate.Parser sgp = new Surrogate.Parser();
    private boolean islegal = true;
    private final char[] cm;

    DBA_Encoder(Charset charset, byte by, byte by2, byte[] byArray, char[] cArray) {
        super(charset, 1.5f, 2.0f);
        this.convertType = by;
        boolean bl = this.maplow = by2 == 1;
        if (byArray != null) {
            this.replaceWith(byArray);
        }
        this.islegal = false;
        this.cm = cArray;
    }

    public boolean isLegalReplacement(byte[] byArray) {
        if (this.islegal) {
            return true;
        }
        if (byArray.length == 1 && byArray[0] >= 0) {
            return true;
        }
        return super.isLegalReplacement(byArray);
    }

    public boolean canEncode(char c) {
        if (this.maplow && c <= '\u007f') {
            return true;
        }
        char c2 = this.cm[c];
        return c2 != '\u0000' || c == '\u0000';
    }

    private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        char[] cArray = charBuffer.array();
        int n = charBuffer.arrayOffset() + charBuffer.position();
        int n2 = charBuffer.arrayOffset() + charBuffer.limit();
        byte[] byArray = byteBuffer.array();
        int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
        int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
        CoderResult coderResult = CoderResult.UNDERFLOW;
        while (n < n2) {
            char c = cArray[n];
            if (Surrogate.is(c)) {
                if (this.sgp.parse(c, cArray, n, n2) < 0) {
                    coderResult = this.sgp.error();
                    break;
                }
                coderResult = this.sgp.unmappableResult();
                break;
            }
            if (this.maplow && c <= '\u007f') {
                byArray[n3++] = (byte)c;
            } else {
                char c2 = this.cm[c];
                if (c2 < '\u0100') {
                    if (c2 == '\u0000' && c != '\u0000') {
                        coderResult = CoderResult.unmappableForLength(1);
                        break;
                    }
                    if (n4 - n3 < 1) {
                        coderResult = CoderResult.OVERFLOW;
                        break;
                    }
                    byArray[n3++] = (byte)c2;
                } else {
                    if (n4 - n3 < 2) {
                        coderResult = CoderResult.OVERFLOW;
                        break;
                    }
                    byArray[n3++] = (byte)(c2 >> 8);
                    byArray[n3++] = (byte)c2;
                }
            }
            ++n;
        }
        charBuffer.position(n - charBuffer.arrayOffset());
        byteBuffer.position(n3 - byteBuffer.arrayOffset());
        return coderResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        CoderResult coderResult;
        int n;
        block14: {
            CoderResult coderResult2;
            block19: {
                CoderResult coderResult3;
                block18: {
                    CoderResult coderResult4;
                    block17: {
                        CoderResult coderResult5;
                        block16: {
                            CoderResult coderResult6;
                            n = charBuffer.position();
                            try {
                                while (true) {
                                    if (!charBuffer.hasRemaining()) {
                                        coderResult = CoderResult.UNDERFLOW;
                                        break block14;
                                    }
                                    char c = charBuffer.get();
                                    if (Surrogate.is(c)) {
                                        if (this.sgp.parse(c, charBuffer) < 0) {
                                            CoderResult coderResult7 = this.sgp.error();
                                            Object var9_10 = null;
                                            charBuffer.position(n);
                                            return coderResult7;
                                        }
                                        coderResult6 = this.sgp.unmappableResult();
                                        break;
                                    }
                                    if (this.maplow && c <= '\u007f') {
                                        byteBuffer.put((byte)c);
                                    } else {
                                        char c2 = this.cm[c];
                                        if (c2 < '\u0100') {
                                            if (c2 == '\u0000' && c != '\u0000' || this.convertType == 2) {
                                                coderResult5 = CoderResult.unmappableForLength(1);
                                                break block16;
                                            }
                                            if (byteBuffer.remaining() < 1) {
                                                coderResult4 = CoderResult.OVERFLOW;
                                                break block17;
                                            }
                                            byteBuffer.put((byte)c2);
                                        } else {
                                            if (this.convertType == 1) {
                                                coderResult3 = CoderResult.unmappableForLength(1);
                                                break block18;
                                            }
                                            if (byteBuffer.remaining() < 2) {
                                                coderResult2 = CoderResult.OVERFLOW;
                                                break block19;
                                            }
                                            byteBuffer.put((byte)(c2 >> 8));
                                            byteBuffer.put((byte)c2);
                                        }
                                    }
                                    ++n;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var9_17 = null;
                                charBuffer.position(n);
                                throw throwable;
                            }
                            Object var9_11 = null;
                            charBuffer.position(n);
                            return coderResult6;
                        }
                        Object var9_12 = null;
                        charBuffer.position(n);
                        return coderResult5;
                    }
                    Object var9_13 = null;
                    charBuffer.position(n);
                    return coderResult4;
                }
                Object var9_14 = null;
                charBuffer.position(n);
                return coderResult3;
            }
            Object var9_15 = null;
            charBuffer.position(n);
            return coderResult2;
        }
        Object var9_16 = null;
        charBuffer.position(n);
        return coderResult;
    }

    protected final CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        if (this.convertType == 0 && charBuffer.hasArray() && byteBuffer.hasArray() && !IBMCharsetEncoder.UseBuffer) {
            return this.encodeArrayLoop(charBuffer, byteBuffer);
        }
        return this.encodeBufferLoop(charBuffer, byteBuffer);
    }
}

