/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio.cs;

import com.ibm.nio.cs.IBMCharsetDecoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;

class DBCS_Decoder
extends IBMCharsetDecoder {
    private final short[] index;
    private final byte[] leadByte;
    private final String[] data;
    private final int start;
    private final int end;
    private final int convertType;
    private final char[] singleMap;

    DBCS_Decoder(Charset charset, short[] sArray, String[] stringArray, byte[] byArray, char[] cArray, byte by, byte by2, byte by3) {
        super(charset, 1.0f, 1.0f);
        this.index = sArray;
        this.data = stringArray;
        this.leadByte = byArray;
        this.singleMap = by == 2 ? new char[0] : (char[])(cArray != null && cArray.length % 3 == 0 ? cArray : null);
        this.convertType = by;
        this.start = by2 & 0xFF;
        this.end = by3 & 0xFF;
    }

    private char convSingle(int n) {
        if (this.singleMap == null) {
            return n < 128 ? (char)n : (char)'\u0000';
        }
        int n2 = this.singleMap.length;
        int n3 = 0;
        while (n3 < n2) {
            if (n <= this.singleMap[n3 + 1] && n >= this.singleMap[n3]) {
                return (char)(this.singleMap[n3 + 2] + n - this.singleMap[n3]);
            }
            n3 += 3;
        }
        return '\u0000';
    }

    private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        byte[] byArray = byteBuffer.array();
        int n = byteBuffer.arrayOffset() + byteBuffer.position();
        int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
        char[] cArray = charBuffer.array();
        int n3 = charBuffer.arrayOffset() + charBuffer.position();
        int n4 = charBuffer.arrayOffset() + charBuffer.limit();
        int n5 = 1;
        CoderResult coderResult = CoderResult.UNDERFLOW;
        while (n < n2) {
            char c;
            int n6 = byArray[n] & 0xFF;
            if (this.leadByte[n6] == 0) {
                c = this.convSingle(n6);
                n5 = 1;
            } else {
                if (n + 1 >= n2) break;
                c = this.getUnicode(n6, byArray[n + 1] & 0xFF);
                n5 = 2;
            }
            if (c == '\u0000' && n6 != 0) {
                coderResult = CoderResult.unmappableForLength(1);
                break;
            }
            if (n4 - n3 < 1) {
                coderResult = CoderResult.OVERFLOW;
                break;
            }
            cArray[n3++] = c;
            n += n5;
        }
        byteBuffer.position(n - byteBuffer.arrayOffset());
        charBuffer.position(n3 - charBuffer.arrayOffset());
        return coderResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        CoderResult coderResult;
        int n;
        block8: {
            CoderResult coderResult2;
            block7: {
                n = byteBuffer.position();
                int n2 = 1;
                try {
                    while (byteBuffer.hasRemaining()) {
                        char c;
                        int n3 = byteBuffer.get() & 0xFF;
                        if (this.leadByte[n3] == 0) {
                            c = this.convSingle(n3);
                            n2 = 1;
                        } else {
                            if (!byteBuffer.hasRemaining()) break;
                            c = this.getUnicode(n3, byteBuffer.get() & 0xFF);
                            n2 = 2;
                        }
                        if (c == '\u0000' && n3 != 0) {
                            CoderResult coderResult3 = CoderResult.unmappableForLength(1);
                            Object var10_9 = null;
                            byteBuffer.position(n);
                            return coderResult3;
                        }
                        if (!charBuffer.hasRemaining()) {
                            coderResult2 = CoderResult.OVERFLOW;
                            break block7;
                        }
                        n += n2;
                        charBuffer.put(c);
                    }
                    coderResult = CoderResult.UNDERFLOW;
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    byteBuffer.position(n);
                    throw throwable;
                }
            }
            Object var10_10 = null;
            byteBuffer.position(n);
            return coderResult2;
        }
        Object var10_11 = null;
        byteBuffer.position(n);
        return coderResult;
    }

    protected char getUnicode(int n, int n2) {
        if (n2 < this.start || n2 > this.end) {
            return '\ufffd';
        }
        int n3 = (this.index[n] & 0xF) * (this.end - this.start + 1) + (n2 - this.start);
        return this.data[this.index[n] >> 4].charAt(n3);
    }

    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        if (byteBuffer.hasArray() && charBuffer.hasArray() && !IBMCharsetDecoder.UseBuffer) {
            return this.decodeArrayLoop(byteBuffer, charBuffer);
        }
        return this.decodeBufferLoop(byteBuffer, charBuffer);
    }
}

