/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio.cs;

import com.ibm.nio.cs.Converter;
import com.ibm.nio.cs.IBMCharsetDecoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;

class DBE_Decoder
extends IBMCharsetDecoder {
    private final short[] index;
    private final int shift;
    private final int mask1;
    private final int mask2;
    private final int convertType;
    private int state;
    private final String indexSurrogate;
    private final String indexSurrogate2;
    private final int bytePairLead;
    private final int[] pairsArray;
    private final String bytePairs;
    private final char[] charMap;
    private static final int SBCS = 0;
    private static final int DBCS = 1;
    private static final byte SO = 14;
    private static final byte SI = 15;

    DBE_Decoder(Charset charset, short[] sArray, int n, byte by, String string, String string2, int[] nArray, String string3, int n2, char[] cArray) {
        super(charset, 1.0f, 1.0f);
        this.index = sArray;
        this.shift = n;
        this.mask1 = Converter.mask1[n];
        this.mask2 = Converter.mask2[n];
        this.convertType = by;
        this.state = by == 2 ? 1 : 0;
        this.indexSurrogate = string;
        this.indexSurrogate2 = string2;
        this.pairsArray = nArray;
        this.bytePairs = string3;
        this.bytePairLead = n2;
        this.charMap = cArray;
    }

    protected void implReset() {
        if (this.convertType == 0) {
            this.state = 0;
        }
    }

    private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        byte[] byArray = byteBuffer.array();
        int n = byteBuffer.arrayOffset() + byteBuffer.position();
        int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
        char[] cArray = charBuffer.array();
        int n3 = charBuffer.arrayOffset() + charBuffer.position();
        int n4 = charBuffer.arrayOffset() + charBuffer.limit();
        int n5 = 1;
        int n6 = 65533;
        int n7 = 65533;
        boolean bl = false;
        boolean bl2 = false;
        CoderResult coderResult = CoderResult.UNDERFLOW;
        while (n < n2) {
            n5 = 1;
            int n8 = byArray[n] & 0xFF;
            if (n8 == 14 && this.convertType == 0) {
                if (this.state != 0) {
                    coderResult = CoderResult.malformedForLength(1);
                    break;
                }
                this.state = 1;
            } else if (n8 == 15 && this.convertType == 0) {
                if (this.state != 1) {
                    coderResult = CoderResult.malformedForLength(1);
                    break;
                }
                this.state = 0;
            } else {
                int n9;
                char c;
                if (this.state == 0) {
                    c = this.charMap[n8];
                } else {
                    if (n8 < 64 || n8 > 254) {
                        coderResult = CoderResult.malformedForLength(1);
                        break;
                    }
                    if (n + 1 >= n2) break;
                    int n10 = byArray[n + 1] & 0xFF;
                    if (!(n8 == 64 && n10 == 64 || n10 >= 65 && n10 <= 254)) {
                        coderResult = CoderResult.malformedForLength(2);
                        break;
                    }
                    c = this.charMap[n8 * 256 + n10];
                    n5 = 2;
                    if (c >= '\ud800' && c <= '\udbff') {
                        n6 = this.getSurrogatePair(n8 * 256 + n10);
                        if (n6 == 65533) {
                            coderResult = CoderResult.unmappableForLength(n5);
                            break;
                        }
                        bl = true;
                    }
                    if (c == '\ufffd' && n8 == this.bytePairLead && null != this.bytePairs) {
                        n9 = 0;
                        while (n9 < this.bytePairs.length()) {
                            if (this.bytePairs.charAt(n9) == n8 * 256 + n10) {
                                int n11 = this.pairsArray[n9];
                                c = (char)(n11 >> 16 & 0xFFFF);
                                n7 = (char)(n11 & 0xFFFF);
                                bl2 = true;
                                break;
                            }
                            ++n9;
                        }
                    }
                }
                if (c == '\ufffd') {
                    coderResult = CoderResult.unmappableForLength(n5);
                    break;
                }
                if (n4 - n3 < 1) {
                    coderResult = CoderResult.OVERFLOW;
                    break;
                }
                if ((bl || bl2) && n4 - ((n9 = n3) + 1) < 1) {
                    coderResult = CoderResult.OVERFLOW;
                    break;
                }
                cArray[n3++] = c;
                if (bl) {
                    if (n4 - n3 < 1) {
                        coderResult = CoderResult.OVERFLOW;
                        break;
                    }
                    cArray[n3++] = n6;
                    bl = false;
                } else if (bl2) {
                    if (n4 - n3 < 1) {
                        coderResult = CoderResult.OVERFLOW;
                        break;
                    }
                    cArray[n3++] = n7;
                    bl2 = false;
                }
            }
            n += n5;
        }
        byteBuffer.position(n - byteBuffer.arrayOffset());
        charBuffer.position(n3 - charBuffer.arrayOffset());
        return coderResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        CoderResult coderResult;
        int n;
        block27: {
            CoderResult coderResult2;
            block36: {
                CoderResult coderResult3;
                block35: {
                    CoderResult coderResult4;
                    block34: {
                        CoderResult coderResult5;
                        block33: {
                            CoderResult coderResult6;
                            block32: {
                                CoderResult coderResult7;
                                block31: {
                                    CoderResult coderResult8;
                                    block30: {
                                        CoderResult coderResult9;
                                        block29: {
                                            CoderResult coderResult10;
                                            n = byteBuffer.position();
                                            int n2 = 1;
                                            char c = '\ufffd';
                                            char c2 = '\ufffd';
                                            boolean bl = false;
                                            boolean bl2 = false;
                                            try {
                                                while (true) {
                                                    if (!byteBuffer.hasRemaining()) {
                                                        coderResult = CoderResult.UNDERFLOW;
                                                        break block27;
                                                    }
                                                    int n3 = byteBuffer.get() & 0xFF;
                                                    if (n3 == 14 && this.convertType == 0) {
                                                        if (this.state != 0) {
                                                            CoderResult coderResult11 = CoderResult.malformedForLength(1);
                                                            Object var16_25 = null;
                                                            byteBuffer.position(n);
                                                            return coderResult11;
                                                        }
                                                        this.state = 1;
                                                    } else if (n3 == 15 && this.convertType == 0) {
                                                        if (this.state != 1) {
                                                            coderResult10 = CoderResult.malformedForLength(1);
                                                            break;
                                                        }
                                                        this.state = 0;
                                                    } else {
                                                        char c3;
                                                        if (this.state == 0) {
                                                            c3 = this.charMap[n3];
                                                            n2 = 1;
                                                        } else {
                                                            if (n3 < 64 || n3 > 254) {
                                                                coderResult9 = CoderResult.malformedForLength(1);
                                                                break block29;
                                                            }
                                                            if (!byteBuffer.hasRemaining()) {
                                                                coderResult8 = CoderResult.UNDERFLOW;
                                                                break block30;
                                                            }
                                                            int n4 = byteBuffer.get() & 0xFF;
                                                            if (!(n3 == 64 && n4 == 64 || n4 >= 65 && n4 <= 254)) {
                                                                coderResult7 = CoderResult.malformedForLength(2);
                                                                break block31;
                                                            }
                                                            c3 = this.charMap[n3 * 256 + n4];
                                                            n2 = 2;
                                                            if (c3 >= '\ud800' && c3 <= '\udbff') {
                                                                c = this.getSurrogatePair(n3 * 256 + n4);
                                                                if (c == '\ufffd') {
                                                                    coderResult6 = CoderResult.unmappableForLength(2);
                                                                    break block32;
                                                                }
                                                                bl = true;
                                                            }
                                                            if (c3 == '\ufffd' && n3 == this.bytePairLead && null != this.bytePairs) {
                                                                int n5 = 0;
                                                                while (n5 < this.bytePairs.length()) {
                                                                    if (this.bytePairs.charAt(n5) == n3 * 256 + n4) {
                                                                        int n6 = this.pairsArray[n5];
                                                                        c3 = (char)(n6 >> 16 & 0xFFFF);
                                                                        c2 = (char)(n6 & 0xFFFF);
                                                                        bl2 = true;
                                                                        break;
                                                                    }
                                                                    ++n5;
                                                                }
                                                            }
                                                        }
                                                        if (c3 == '\ufffd') {
                                                            coderResult5 = CoderResult.unmappableForLength(n2);
                                                            break block33;
                                                        }
                                                        if (!charBuffer.hasRemaining()) {
                                                            coderResult4 = CoderResult.OVERFLOW;
                                                            break block34;
                                                        }
                                                        charBuffer.put(c3);
                                                        if (bl) {
                                                            if (!charBuffer.hasRemaining()) {
                                                                coderResult3 = CoderResult.OVERFLOW;
                                                                break block35;
                                                            }
                                                            charBuffer.put(c);
                                                            bl = false;
                                                        } else if (bl2) {
                                                            if (!charBuffer.hasRemaining()) {
                                                                coderResult2 = CoderResult.OVERFLOW;
                                                                break block36;
                                                            }
                                                            charBuffer.put(c2);
                                                            bl2 = false;
                                                        }
                                                    }
                                                    n += n2;
                                                    n2 = 1;
                                                }
                                            }
                                            catch (Throwable throwable) {
                                                Object var16_36 = null;
                                                byteBuffer.position(n);
                                                throw throwable;
                                            }
                                            Object var16_26 = null;
                                            byteBuffer.position(n);
                                            return coderResult10;
                                        }
                                        Object var16_27 = null;
                                        byteBuffer.position(n);
                                        return coderResult9;
                                    }
                                    Object var16_28 = null;
                                    byteBuffer.position(n);
                                    return coderResult8;
                                }
                                Object var16_29 = null;
                                byteBuffer.position(n);
                                return coderResult7;
                            }
                            Object var16_30 = null;
                            byteBuffer.position(n);
                            return coderResult6;
                        }
                        Object var16_31 = null;
                        byteBuffer.position(n);
                        return coderResult5;
                    }
                    Object var16_32 = null;
                    byteBuffer.position(n);
                    return coderResult4;
                }
                Object var16_33 = null;
                byteBuffer.position(n);
                return coderResult3;
            }
            Object var16_34 = null;
            byteBuffer.position(n);
            return coderResult2;
        }
        Object var16_35 = null;
        byteBuffer.position(n);
        return coderResult;
    }

    protected char getSurrogatePair(int n) {
        int n2 = this.index[n >> this.shift] + (n & this.mask2);
        char c = this.indexSurrogate2 == null || n2 < 15000 ? this.indexSurrogate.charAt(n2) : this.indexSurrogate2.charAt(n2 - 15000);
        if (c == '\u0000' && n != 0) {
            return '\ufffd';
        }
        return c;
    }

    protected final CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        if (byteBuffer.hasArray() && charBuffer.hasArray() && !IBMCharsetDecoder.UseBuffer) {
            return this.decodeArrayLoop(byteBuffer, charBuffer);
        }
        return this.decodeBufferLoop(byteBuffer, charBuffer);
    }
}

