/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio.cs;

import com.ibm.nio.cs.Converter;
import com.ibm.nio.cs.IBMCharsetEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;
import sun.nio.cs.Surrogate;

class EUCJP_Encoder
extends IBMCharsetEncoder {
    private final short[] index;
    private final String data;
    private final int shift;
    private final int mask1;
    private final int mask2;
    private final boolean maplow;
    private final Surrogate.Parser sgp = new Surrogate.Parser();

    EUCJP_Encoder(Charset charset, short[] sArray, int n, String string, byte[] byArray, byte[] byArray2) {
        super(charset, 1.5f, 3.0f);
        this.index = sArray;
        this.data = string;
        this.shift = n;
        this.mask1 = Converter.mask1[n];
        this.mask2 = Converter.mask2[n];
        this.maplow = byArray != null && byArray.length > 1 ? byArray[1] == 1 : false;
        if (byArray2 != null) {
            this.replaceWith(byArray2);
        }
    }

    public boolean isLegalReplacement(byte[] byArray) {
        if (byArray.length == 1 && byArray[0] >= 0) {
            return true;
        }
        return super.isLegalReplacement(byArray);
    }

    public boolean canEncode(char c) {
        if (c < '\u007f') {
            return true;
        }
        return this.data.charAt(this.index[c >> this.shift] + (c & this.mask2)) > '\u0001';
    }

    private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        char[] cArray = charBuffer.array();
        int n = charBuffer.arrayOffset() + charBuffer.position();
        int n2 = charBuffer.arrayOffset() + charBuffer.limit();
        byte[] byArray = byteBuffer.array();
        int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
        int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
        CoderResult coderResult = CoderResult.UNDERFLOW;
        while (n < n2) {
            char c = cArray[n];
            if (Surrogate.is(c)) {
                if (this.sgp.parse(c, cArray, n, n2) < 0) {
                    coderResult = this.sgp.error();
                    break;
                }
                coderResult = this.sgp.unmappableResult();
                break;
            }
            if (this.maplow && c < '\u007f') {
                if (n4 - n3 < 1) {
                    coderResult = CoderResult.OVERFLOW;
                    break;
                }
                byArray[n3++] = (byte)c;
            } else {
                char c2 = this.data.charAt(this.index[c >> this.shift] + (c & this.mask2));
                if (c2 < '\u0100') {
                    if (c2 < '\u0002' && c2 != c) {
                        coderResult = CoderResult.unmappableForLength(1);
                        break;
                    }
                    if (n4 - n3 < 1) {
                        coderResult = CoderResult.OVERFLOW;
                        break;
                    }
                    byArray[n3++] = (byte)c2;
                } else {
                    int n5 = c2 & 0x8080;
                    if (n5 == 32896) {
                        if (n4 - n3 < 2) {
                            coderResult = CoderResult.OVERFLOW;
                            break;
                        }
                        byArray[n3++] = (byte)(c2 >> 8);
                        byArray[n3++] = (byte)c2;
                    } else if (n5 == 32768) {
                        if (n4 - n3 < 3) {
                            coderResult = CoderResult.OVERFLOW;
                            break;
                        }
                        byArray[n3++] = -113;
                        byArray[n3++] = (byte)(c2 >> 8);
                        byArray[n3++] = (byte)(c2 | 0x80);
                    } else {
                        if (n4 - n3 < 2) {
                            coderResult = CoderResult.OVERFLOW;
                            break;
                        }
                        byArray[n3++] = -114;
                        byArray[n3++] = (byte)(c2 | 0x80);
                    }
                }
            }
            ++n;
        }
        charBuffer.position(n - charBuffer.arrayOffset());
        byteBuffer.position(n3 - byteBuffer.arrayOffset());
        return coderResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        CoderResult coderResult;
        int n;
        block26: {
            CoderResult coderResult2;
            block25: {
                CoderResult coderResult3;
                block24: {
                    CoderResult coderResult4;
                    block23: {
                        CoderResult coderResult5;
                        block22: {
                            CoderResult coderResult6;
                            block21: {
                                CoderResult coderResult7;
                                block20: {
                                    n = charBuffer.position();
                                    try {
                                        while (charBuffer.hasRemaining()) {
                                            char c = charBuffer.get();
                                            if (Surrogate.is(c)) {
                                                if (this.sgp.parse(c, charBuffer) < 0) {
                                                    CoderResult coderResult8 = this.sgp.error();
                                                    Object var11_11 = null;
                                                    charBuffer.position(n);
                                                    return coderResult8;
                                                }
                                                coderResult7 = this.sgp.unmappableResult();
                                                break block20;
                                            }
                                            if (this.maplow && c < '\u007f') {
                                                if (!byteBuffer.hasRemaining()) break;
                                                byteBuffer.put((byte)c);
                                            } else {
                                                char c2 = this.data.charAt(this.index[c >> this.shift] + (c & this.mask2));
                                                if (c2 < '\u0100') {
                                                    if (c2 < '\u0002' && c2 != c) {
                                                        coderResult6 = CoderResult.unmappableForLength(1);
                                                        break block21;
                                                    }
                                                    if (byteBuffer.remaining() < 1) {
                                                        coderResult5 = CoderResult.OVERFLOW;
                                                        break block22;
                                                    } else {
                                                        byteBuffer.put((byte)c2);
                                                        continue;
                                                    }
                                                }
                                                int n2 = c2 & 0x8080;
                                                switch (n2) {
                                                    case 32896: {
                                                        if (byteBuffer.remaining() < 2) {
                                                            coderResult4 = CoderResult.OVERFLOW;
                                                            break block23;
                                                        } else {
                                                            byteBuffer.put((byte)(c2 >> 8));
                                                            byteBuffer.put((byte)c2);
                                                            break;
                                                        }
                                                    }
                                                    case 32768: {
                                                        if (byteBuffer.remaining() < 3) {
                                                            coderResult3 = CoderResult.OVERFLOW;
                                                            break block24;
                                                        } else {
                                                            byteBuffer.put((byte)-113);
                                                            byteBuffer.put((byte)(c2 >> 8));
                                                            byteBuffer.put((byte)(c2 | 0x80));
                                                            break;
                                                        }
                                                    }
                                                    default: {
                                                        if (byteBuffer.remaining() < 2) {
                                                            coderResult2 = CoderResult.OVERFLOW;
                                                            break block25;
                                                        }
                                                        byteBuffer.put((byte)-114);
                                                        byteBuffer.put((byte)(c2 | 0x80));
                                                    }
                                                }
                                            }
                                            ++n;
                                        }
                                        coderResult = CoderResult.UNDERFLOW;
                                        break block26;
                                    }
                                    catch (Throwable throwable) {
                                        Object var11_19 = null;
                                        charBuffer.position(n);
                                        throw throwable;
                                    }
                                }
                                Object var11_12 = null;
                                charBuffer.position(n);
                                return coderResult7;
                            }
                            Object var11_13 = null;
                            charBuffer.position(n);
                            return coderResult6;
                        }
                        Object var11_14 = null;
                        charBuffer.position(n);
                        return coderResult5;
                    }
                    Object var11_15 = null;
                    charBuffer.position(n);
                    return coderResult4;
                }
                Object var11_16 = null;
                charBuffer.position(n);
                return coderResult3;
            }
            Object var11_17 = null;
            charBuffer.position(n);
            return coderResult2;
        }
        Object var11_18 = null;
        charBuffer.position(n);
        return coderResult;
    }

    protected final CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        if (charBuffer.hasArray() && byteBuffer.hasArray() && !IBMCharsetEncoder.UseBuffer) {
            return this.encodeArrayLoop(charBuffer, byteBuffer);
        }
        return this.encodeBufferLoop(charBuffer, byteBuffer);
    }
}

