/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio.cs;

import com.ibm.nio.cs.IBMCharsetEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;
import java.security.AccessController;
import sun.nio.cs.Surrogate;
import sun.security.action.GetPropertyAction;

class UTF16Encoder
extends IBMCharsetEncoder {
    protected static final char BYTE_ORDER_MARK = '\ufeff';
    protected static final char REVERSED_MARK = '\ufffe';
    protected static final int BIG = 2;
    protected static final int LITTLE = 1;
    private int byteOrder;
    private boolean usesMark;
    private boolean needsMark;
    private final Surrogate.Parser sgp;

    protected UTF16Encoder(Charset charset, int n, boolean bl) {
        byte[] byArray;
        float f = bl ? 4.0f : 2.0f;
        if (n == 2) {
            byte[] byArray2 = new byte[2];
            byArray2[0] = -1;
            byArray = byArray2;
            byArray2[1] = -3;
        } else {
            byte[] byArray3 = new byte[2];
            byArray3[0] = -3;
            byArray = byArray3;
            byArray3[1] = -1;
        }
        super(charset, 2.0f, f, byArray);
        this.sgp = new Surrogate.Parser();
        this.usesMark = this.needsMark = bl;
        this.byteOrder = n;
        if (n == 0) {
            String string = AccessController.doPrivileged(new GetPropertyAction("sun.io.unicode.encoding", "UnicodeBig"));
            this.byteOrder = string.equals("UnicodeLittle") ? 1 : 2;
        }
    }

    private void put(char c, ByteBuffer byteBuffer) {
        if (this.byteOrder == 2) {
            byteBuffer.put((byte)(c >> 8));
            byteBuffer.put((byte)(c & 0xFF));
        } else {
            byteBuffer.put((byte)(c & 0xFF));
            byteBuffer.put((byte)(c >> 8));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        CoderResult coderResult;
        int n;
        block11: {
            CoderResult coderResult2;
            block13: {
                CoderResult coderResult3;
                n = charBuffer.position();
                if (this.needsMark) {
                    if (byteBuffer.remaining() < 2) {
                        return CoderResult.OVERFLOW;
                    }
                    this.put('\ufeff', byteBuffer);
                    this.needsMark = false;
                }
                try {
                    while (true) {
                        if (!charBuffer.hasRemaining()) {
                            coderResult = CoderResult.UNDERFLOW;
                            break block11;
                        }
                        char c = charBuffer.get();
                        if (!Surrogate.is(c)) {
                            if (byteBuffer.remaining() < 2) {
                                CoderResult coderResult4 = CoderResult.OVERFLOW;
                                Object var9_8 = null;
                                charBuffer.position(n);
                                return coderResult4;
                            } else {
                                ++n;
                                this.put(c, byteBuffer);
                                continue;
                            }
                        }
                        int n2 = this.sgp.parse(c, charBuffer);
                        if (n2 < 0) {
                            coderResult3 = this.sgp.error();
                            break;
                        }
                        if (byteBuffer.remaining() < 4) {
                            coderResult2 = CoderResult.OVERFLOW;
                            break block13;
                        }
                        n += 2;
                        this.put(Surrogate.high(n2), byteBuffer);
                        this.put(Surrogate.low(n2), byteBuffer);
                    }
                }
                catch (Throwable throwable) {
                    Object var9_12 = null;
                    charBuffer.position(n);
                    throw throwable;
                }
                Object var9_9 = null;
                charBuffer.position(n);
                return coderResult3;
            }
            Object var9_10 = null;
            charBuffer.position(n);
            return coderResult2;
        }
        Object var9_11 = null;
        charBuffer.position(n);
        return coderResult;
    }

    protected void implReset() {
        this.needsMark = this.usesMark;
    }
}

