/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import com.ibm.bidiTools.bdlayout.BidiConvert;
import java.security.AccessController;
import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;
import sun.misc.VM;
import sun.security.action.GetPropertyAction;

public abstract class CharToByteArabic
extends CharToByteConverter {
    protected short[] index1;
    protected char[] index2;
    protected int mask1;
    protected int mask2;
    protected int shift;
    protected byte[] ArabicDeshape = null;
    private byte[] saveArabicDeshape;
    private char highHalfZoneCode;
    private byte[] tmpArray = new byte[2];
    private String bidiParms = bidiInit;
    private boolean bidiEnabled = false;
    private static String bidiInit;

    public String getType() {
        return "arabic";
    }

    public short[] getIndex() {
        return this.index1;
    }

    public char[] getCharData() {
        return this.index2;
    }

    public int getShift() {
        return this.shift;
    }

    public byte[] getByteData() {
        return this.ArabicDeshape;
    }

    public CharToByteArabic() {
        if (null == this.bidiParms) {
            if (VM.isBooted()) {
                this.bidiParms = System.getSecurityManager() == null ? (String)new GetPropertyAction("JAVABIDI").run() : AccessController.doPrivileged(new GetPropertyAction("JAVABIDI"));
                if (null == this.bidiParms) {
                    this.bidiParms = "NO";
                }
                bidiInit = this.bidiParms;
            } else {
                this.bidiParms = "NO";
            }
        }
        this.bidiEnabled = !"NO".equals(this.bidiParms);
    }

    public int flush(byte[] byArray, int n, int n2) throws MalformedInputException {
        if (this.highHalfZoneCode != '\u0000') {
            this.highHalfZoneCode = '\u0000';
            this.badInputLength = 0;
            throw new MalformedInputException();
        }
        this.charOff = 0;
        this.byteOff = 0;
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int convert(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) throws MalformedInputException, UnknownCharacterException, ConversionBufferFullException {
        this.charOff = n;
        this.byteOff = n3;
        if (this.highHalfZoneCode != '\u0000') {
            char c = this.highHalfZoneCode;
            this.highHalfZoneCode = '\u0000';
            if (cArray[n] >= '\udc00' && cArray[n] <= '\udfff') {
                this.badInputLength = 1;
                throw new UnknownCharacterException();
            }
            this.badInputLength = 0;
            throw new MalformedInputException();
        }
        if (this.bidiEnabled) {
            BidiConvert bidiConvert = new BidiConvert();
            this.saveArabicDeshape = this.ArabicDeshape;
            int n5 = n2 - n;
            if (n5 > n4 - n3) {
                n5 = n4 - n3;
            }
            if (bidiConvert.isBidiData(cArray, n, n + n5, this.bidiParms, this.getCharacterEncoding())) {
                char[] cArray2 = new char[n5];
                cArray2 = bidiConvert.toSbcs(cArray, n, n + n5, this.bidiParms, this.getCharacterEncoding());
                System.arraycopy(cArray2, 0, cArray, n, n5);
                this.ArabicDeshape = null;
            }
        }
        while (this.charOff < n2) {
            int n6;
            int n7;
            byte[] byArray2;
            block21: {
                byArray2 = this.tmpArray;
                char c = cArray[this.charOff];
                n7 = 1;
                n6 = 1;
                if ((c & 0xF800) == 55296) {
                    if (c <= '\udbff') {
                        if (this.charOff + 1 >= n2) {
                            this.highHalfZoneCode = c;
                            break;
                        }
                        c = cArray[this.charOff + 1];
                        if (c >= '\udc00' && c <= '\udfff') {
                            if (!this.subMode) {
                                this.badInputLength = 2;
                                throw new UnknownCharacterException();
                            }
                            byArray2 = this.subBytes;
                            n7 = this.subBytes.length;
                            n6 = 2;
                            break block21;
                        } else {
                            this.badInputLength = 1;
                            throw new MalformedInputException();
                        }
                    }
                    if (c <= '\udfff') {
                        this.badInputLength = 1;
                        throw new MalformedInputException();
                    }
                } else {
                    byArray2[0] = (byte)this.index2[this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2)];
                    if (byArray2[0] == 0) {
                        if (this.ArabicDeshape != null && c > '\ufef4' && c <= '\ufefc') {
                            byArray2[0] = this.ArabicDeshape[0];
                            byArray2[1] = this.ArabicDeshape[c - 65268];
                            n7 = 2;
                        } else if (cArray[this.charOff] != '\u0000') {
                            if (!this.subMode) {
                                this.badInputLength = 1;
                                throw new UnknownCharacterException();
                            }
                            byArray2 = this.subBytes;
                            n7 = this.subBytes.length;
                        }
                    }
                }
            }
            if (this.byteOff + n7 > n4) {
                throw new ConversionBufferFullException();
            }
            int n8 = 0;
            while (n8 < n7) {
                byArray[this.byteOff++] = byArray2[n8];
                ++n8;
            }
            this.charOff += n6;
        }
        this.ArabicDeshape = this.saveArabicDeshape;
        return this.byteOff - n3;
    }

    public int getMaxBytesPerChar() {
        return this.ArabicDeshape == null ? 1 : 2;
    }

    public void reset() {
        this.charOff = 0;
        this.byteOff = 0;
        this.highHalfZoneCode = '\u0000';
    }
}

