/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.accessibility.util;

import com.sun.java.accessibility.util.EventQueueMonitor;
import com.sun.java.accessibility.util.TopLevelWindowListener;
import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AWTEventMonitor {
    private static boolean runningOnJDK1_4 = false;
    protected static Component componentWithFocus = null;
    protected static ComponentListener componentListener = null;
    protected static ContainerListener containerListener = null;
    protected static FocusListener focusListener = null;
    protected static KeyListener keyListener = null;
    protected static MouseListener mouseListener = null;
    protected static MouseMotionListener mouseMotionListener = null;
    protected static WindowListener windowListener = null;
    protected static ActionListener actionListener = null;
    protected static AdjustmentListener adjustmentListener = null;
    protected static ItemListener itemListener = null;
    protected static TextListener textListener = null;
    protected static AWTEventsListener awtListener = new AWTEventsListener();

    public static Component getComponentWithFocus() {
        return componentWithFocus;
    }

    public static void addComponentListener(ComponentListener l) {
        if (componentListener == null) {
            awtListener.installListeners(2);
        }
        componentListener = AWTEventMulticaster.add(componentListener, l);
    }

    public static void removeComponentListener(ComponentListener l) {
        if ((componentListener = AWTEventMulticaster.remove(componentListener, l)) == null) {
            awtListener.removeListeners(2);
        }
    }

    public static void addContainerListener(ContainerListener l) {
        containerListener = AWTEventMulticaster.add(containerListener, l);
    }

    public static void removeContainerListener(ContainerListener l) {
        containerListener = AWTEventMulticaster.remove(containerListener, l);
    }

    public static void addFocusListener(FocusListener l) {
        focusListener = AWTEventMulticaster.add(focusListener, l);
    }

    public static void removeFocusListener(FocusListener l) {
        focusListener = AWTEventMulticaster.remove(focusListener, l);
    }

    public static void addKeyListener(KeyListener l) {
        if (keyListener == null) {
            awtListener.installListeners(6);
        }
        keyListener = AWTEventMulticaster.add(keyListener, l);
    }

    public static void removeKeyListener(KeyListener l) {
        if ((keyListener = AWTEventMulticaster.remove(keyListener, l)) == null) {
            awtListener.removeListeners(6);
        }
    }

    public static void addMouseListener(MouseListener l) {
        if (mouseListener == null) {
            awtListener.installListeners(7);
        }
        mouseListener = AWTEventMulticaster.add(mouseListener, l);
    }

    public static void removeMouseListener(MouseListener l) {
        if ((mouseListener = AWTEventMulticaster.remove(mouseListener, l)) == null) {
            awtListener.removeListeners(7);
        }
    }

    public static void addMouseMotionListener(MouseMotionListener l) {
        if (mouseMotionListener == null) {
            awtListener.installListeners(8);
        }
        mouseMotionListener = AWTEventMulticaster.add(mouseMotionListener, l);
    }

    public static void removeMouseMotionListener(MouseMotionListener l) {
        if ((mouseMotionListener = AWTEventMulticaster.remove(mouseMotionListener, l)) == null) {
            awtListener.removeListeners(8);
        }
    }

    public static void addWindowListener(WindowListener l) {
        if (windowListener == null) {
            awtListener.installListeners(11);
        }
        windowListener = AWTEventMulticaster.add(windowListener, l);
    }

    public static void removeWindowListener(WindowListener l) {
        if ((windowListener = AWTEventMulticaster.remove(windowListener, l)) == null) {
            awtListener.removeListeners(11);
        }
    }

    public static void addActionListener(ActionListener l) {
        if (actionListener == null) {
            awtListener.installListeners(0);
        }
        actionListener = AWTEventMulticaster.add(actionListener, l);
    }

    public static void removeActionListener(ActionListener l) {
        if ((actionListener = AWTEventMulticaster.remove(actionListener, l)) == null) {
            awtListener.removeListeners(0);
        }
    }

    public static void addAdjustmentListener(AdjustmentListener l) {
        if (adjustmentListener == null) {
            awtListener.installListeners(1);
        }
        adjustmentListener = AWTEventMulticaster.add(adjustmentListener, l);
    }

    public static void removeAdjustmentListener(AdjustmentListener l) {
        if ((adjustmentListener = AWTEventMulticaster.remove(adjustmentListener, l)) == null) {
            awtListener.removeListeners(1);
        }
    }

    public static void addItemListener(ItemListener l) {
        if (itemListener == null) {
            awtListener.installListeners(5);
        }
        itemListener = AWTEventMulticaster.add(itemListener, l);
    }

    public static void removeItemListener(ItemListener l) {
        if ((itemListener = AWTEventMulticaster.remove(itemListener, l)) == null) {
            awtListener.removeListeners(5);
        }
    }

    public static void addTextListener(TextListener l) {
        if (textListener == null) {
            awtListener.installListeners(10);
        }
        textListener = AWTEventMulticaster.add(textListener, l);
    }

    public static void removeTextListener(TextListener l) {
        if ((textListener = AWTEventMulticaster.remove(textListener, l)) == null) {
            awtListener.removeListeners(10);
        }
    }

    static class AWTEventsListener
    implements TopLevelWindowListener,
    ActionListener,
    AdjustmentListener,
    ComponentListener,
    ContainerListener,
    FocusListener,
    ItemListener,
    KeyListener,
    MouseListener,
    MouseMotionListener,
    TextListener,
    WindowListener,
    ChangeListener {
        private Class[] actionListeners;
        private Method removeActionMethod;
        private Method addActionMethod;
        private Object[] actionArgs;
        private Class[] itemListeners;
        private Method removeItemMethod;
        private Method addItemMethod;
        private Object[] itemArgs;
        private Class[] textListeners;
        private Method removeTextMethod;
        private Method addTextMethod;
        private Object[] textArgs;
        private Class[] windowListeners;
        private Method removeWindowMethod;
        private Method addWindowMethod;
        private Object[] windowArgs;

        public AWTEventsListener() {
            String version = System.getProperty("java.version");
            if (version != null) {
                runningOnJDK1_4 = version.compareTo("1.4") >= 0;
            }
            this.initializeIntrospection();
            this.installListeners();
            if (runningOnJDK1_4) {
                MenuSelectionManager.defaultManager().addChangeListener(this);
            }
            EventQueueMonitor.addTopLevelWindowListener(this);
        }

        private boolean initializeIntrospection() {
            try {
                this.actionListeners = new Class[1];
                this.actionArgs = new Object[1];
                this.actionListeners[0] = Class.forName("java.awt.event.ActionListener");
                this.actionArgs[0] = this;
                this.itemListeners = new Class[1];
                this.itemArgs = new Object[1];
                this.itemListeners[0] = Class.forName("java.awt.event.ItemListener");
                this.itemArgs[0] = this;
                this.textListeners = new Class[1];
                this.textArgs = new Object[1];
                this.textListeners[0] = Class.forName("java.awt.event.TextListener");
                this.textArgs[0] = this;
                this.windowListeners = new Class[1];
                this.windowArgs = new Object[1];
                this.windowListeners[0] = Class.forName("java.awt.event.WindowListener");
                this.windowArgs[0] = this;
                return true;
            }
            catch (ClassNotFoundException e) {
                System.out.println("EXCEPTION - Class 'java.awt.event.*' not in CLASSPATH");
                return false;
            }
        }

        protected void installListeners() {
            Window[] topLevelWindows = EventQueueMonitor.getTopLevelWindows();
            if (topLevelWindows != null) {
                int i = 0;
                while (i < topLevelWindows.length) {
                    this.installListeners(topLevelWindows[i]);
                    ++i;
                }
            }
        }

        protected void installListeners(int eventID) {
            Window[] topLevelWindows = EventQueueMonitor.getTopLevelWindows();
            if (topLevelWindows != null) {
                int i = 0;
                while (i < topLevelWindows.length) {
                    this.installListeners(topLevelWindows[i], eventID);
                    ++i;
                }
            }
        }

        protected void installListeners(Component c) {
            this.installListeners(c, 3);
            this.installListeners(c, 4);
            if (componentListener != null) {
                this.installListeners(c, 2);
            }
            if (keyListener != null) {
                this.installListeners(c, 6);
            }
            if (mouseListener != null) {
                this.installListeners(c, 7);
            }
            if (mouseMotionListener != null) {
                this.installListeners(c, 8);
            }
            if (windowListener != null) {
                this.installListeners(c, 11);
            }
            if (actionListener != null) {
                this.installListeners(c, 0);
            }
            if (adjustmentListener != null) {
                this.installListeners(c, 1);
            }
            if (itemListener != null) {
                this.installListeners(c, 5);
            }
            if (textListener != null) {
                this.installListeners(c, 10);
            }
        }

        public void stateChanged(ChangeEvent e) {
            this.processFocusGained();
        }

        private void processFocusGained() {
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (focusOwner == null) {
                return;
            }
            MenuSelectionManager.defaultManager().removeChangeListener(this);
            MenuSelectionManager.defaultManager().addChangeListener(this);
            if (focusOwner instanceof JRootPane) {
                MenuElement[] path = MenuSelectionManager.defaultManager().getSelectedPath();
                if (path.length > 1) {
                    Component penult = path[path.length - 2].getComponent();
                    Component last = path[path.length - 1].getComponent();
                    if (last instanceof JPopupMenu || last instanceof JMenu) {
                        componentWithFocus = last;
                    } else if (penult instanceof JPopupMenu) {
                        componentWithFocus = penult;
                    }
                }
            } else {
                componentWithFocus = focusOwner;
            }
        }

        protected void installListeners(Component c, int eventID) {
            switch (eventID) {
                case 0: {
                    try {
                        this.removeActionMethod = c.getClass().getMethod("removeActionListener", this.actionListeners);
                        this.addActionMethod = c.getClass().getMethod("addActionListener", this.actionListeners);
                        try {
                            this.removeActionMethod.invoke((Object)c, this.actionArgs);
                            this.addActionMethod.invoke((Object)c, this.actionArgs);
                        }
                        catch (InvocationTargetException e) {
                            System.out.println("Exception: " + e.toString());
                        }
                        catch (IllegalAccessException e) {
                            System.out.println("Exception: " + e.toString());
                        }
                    }
                    catch (NoSuchMethodException e) {
                    }
                    catch (SecurityException e) {
                        System.out.println("Exception: " + e.toString());
                    }
                    break;
                }
                case 1: {
                    if (!(c instanceof Adjustable)) break;
                    ((Adjustable)((Object)c)).removeAdjustmentListener(this);
                    ((Adjustable)((Object)c)).addAdjustmentListener(this);
                    break;
                }
                case 2: {
                    c.removeComponentListener(this);
                    c.addComponentListener(this);
                    break;
                }
                case 3: {
                    if (!(c instanceof Container)) break;
                    ((Container)c).removeContainerListener(this);
                    ((Container)c).addContainerListener(this);
                    break;
                }
                case 4: {
                    c.removeFocusListener(this);
                    c.addFocusListener(this);
                    if (runningOnJDK1_4) {
                        this.processFocusGained();
                        break;
                    }
                    if (c == componentWithFocus || !c.hasFocus()) break;
                    componentWithFocus = c;
                    break;
                }
                case 5: {
                    try {
                        this.removeItemMethod = c.getClass().getMethod("removeItemListener", this.itemListeners);
                        this.addItemMethod = c.getClass().getMethod("addItemListener", this.itemListeners);
                        try {
                            this.removeItemMethod.invoke((Object)c, this.itemArgs);
                            this.addItemMethod.invoke((Object)c, this.itemArgs);
                        }
                        catch (InvocationTargetException e) {
                            System.out.println("Exception: " + e.toString());
                        }
                        catch (IllegalAccessException e) {
                            System.out.println("Exception: " + e.toString());
                        }
                    }
                    catch (NoSuchMethodException e) {
                    }
                    catch (SecurityException e) {
                        System.out.println("Exception: " + e.toString());
                    }
                    break;
                }
                case 6: {
                    c.removeKeyListener(this);
                    c.addKeyListener(this);
                    break;
                }
                case 7: {
                    c.removeMouseListener(this);
                    c.addMouseListener(this);
                    break;
                }
                case 8: {
                    c.removeMouseMotionListener(this);
                    c.addMouseMotionListener(this);
                    break;
                }
                case 10: {
                    try {
                        this.removeTextMethod = c.getClass().getMethod("removeTextListener", this.textListeners);
                        this.addTextMethod = c.getClass().getMethod("addTextListener", this.textListeners);
                        try {
                            this.removeTextMethod.invoke((Object)c, this.textArgs);
                            this.addTextMethod.invoke((Object)c, this.textArgs);
                        }
                        catch (InvocationTargetException e) {
                            System.out.println("Exception: " + e.toString());
                        }
                        catch (IllegalAccessException e) {
                            System.out.println("Exception: " + e.toString());
                        }
                    }
                    catch (NoSuchMethodException e) {
                    }
                    catch (SecurityException e) {
                        System.out.println("Exception: " + e.toString());
                    }
                    break;
                }
                case 11: {
                    try {
                        this.removeWindowMethod = c.getClass().getMethod("removeWindowListener", this.windowListeners);
                        this.addWindowMethod = c.getClass().getMethod("addWindowListener", this.windowListeners);
                        try {
                            this.removeWindowMethod.invoke((Object)c, this.windowArgs);
                            this.addWindowMethod.invoke((Object)c, this.windowArgs);
                        }
                        catch (InvocationTargetException e) {
                            System.out.println("Exception: " + e.toString());
                        }
                        catch (IllegalAccessException e) {
                            System.out.println("Exception: " + e.toString());
                        }
                    }
                    catch (NoSuchMethodException e) {
                    }
                    catch (SecurityException e) {
                        System.out.println("Exception: " + e.toString());
                    }
                    break;
                }
                default: {
                    return;
                }
            }
            if (c instanceof Container) {
                int count = ((Container)c).getComponentCount();
                int i = 0;
                while (i < count) {
                    this.installListeners(((Container)c).getComponent(i), eventID);
                    ++i;
                }
            }
        }

        protected void removeListeners(int eventID) {
            Window[] topLevelWindows = EventQueueMonitor.getTopLevelWindows();
            if (topLevelWindows != null) {
                int i = 0;
                while (i < topLevelWindows.length) {
                    this.removeListeners(topLevelWindows[i], eventID);
                    ++i;
                }
            }
        }

        protected void removeListeners(Component c) {
            if (componentListener != null) {
                this.removeListeners(c, 2);
            }
            if (keyListener != null) {
                this.removeListeners(c, 6);
            }
            if (mouseListener != null) {
                this.removeListeners(c, 7);
            }
            if (mouseMotionListener != null) {
                this.removeListeners(c, 8);
            }
            if (windowListener != null) {
                this.removeListeners(c, 11);
            }
            if (actionListener != null) {
                this.removeListeners(c, 0);
            }
            if (adjustmentListener != null) {
                this.removeListeners(c, 1);
            }
            if (itemListener != null) {
                this.removeListeners(c, 5);
            }
            if (textListener != null) {
                this.removeListeners(c, 10);
            }
        }

        protected void removeListeners(Component c, int eventID) {
            switch (eventID) {
                case 0: {
                    try {
                        this.removeActionMethod = c.getClass().getMethod("removeActionListener", this.actionListeners);
                        try {
                            this.removeActionMethod.invoke((Object)c, this.actionArgs);
                        }
                        catch (InvocationTargetException e) {
                            System.out.println("Exception: " + e.toString());
                        }
                        catch (IllegalAccessException e) {
                            System.out.println("Exception: " + e.toString());
                        }
                    }
                    catch (NoSuchMethodException e) {
                    }
                    catch (SecurityException e) {
                        System.out.println("Exception: " + e.toString());
                    }
                    break;
                }
                case 1: {
                    if (!(c instanceof Adjustable)) break;
                    ((Adjustable)((Object)c)).removeAdjustmentListener(this);
                    break;
                }
                case 2: {
                    c.removeComponentListener(this);
                    break;
                }
                case 5: {
                    try {
                        this.removeItemMethod = c.getClass().getMethod("removeItemListener", this.itemListeners);
                        try {
                            this.removeItemMethod.invoke((Object)c, this.itemArgs);
                        }
                        catch (InvocationTargetException e) {
                            System.out.println("Exception: " + e.toString());
                        }
                        catch (IllegalAccessException e) {
                            System.out.println("Exception: " + e.toString());
                        }
                    }
                    catch (NoSuchMethodException e) {
                    }
                    catch (SecurityException e) {
                        System.out.println("Exception: " + e.toString());
                    }
                    break;
                }
                case 6: {
                    c.removeKeyListener(this);
                    break;
                }
                case 7: {
                    c.removeMouseListener(this);
                    break;
                }
                case 8: {
                    c.removeMouseMotionListener(this);
                    break;
                }
                case 10: {
                    try {
                        this.removeTextMethod = c.getClass().getMethod("removeTextListener", this.textListeners);
                        try {
                            this.removeTextMethod.invoke((Object)c, this.textArgs);
                        }
                        catch (InvocationTargetException e) {
                            System.out.println("Exception: " + e.toString());
                        }
                        catch (IllegalAccessException e) {
                            System.out.println("Exception: " + e.toString());
                        }
                    }
                    catch (NoSuchMethodException e) {
                    }
                    catch (SecurityException e) {
                        System.out.println("Exception: " + e.toString());
                    }
                    break;
                }
                case 11: {
                    try {
                        this.removeWindowMethod = c.getClass().getMethod("removeWindowListener", this.windowListeners);
                        try {
                            this.removeWindowMethod.invoke((Object)c, this.windowArgs);
                        }
                        catch (InvocationTargetException e) {
                            System.out.println("Exception: " + e.toString());
                        }
                        catch (IllegalAccessException e) {
                            System.out.println("Exception: " + e.toString());
                        }
                    }
                    catch (NoSuchMethodException e) {
                    }
                    catch (SecurityException e) {
                        System.out.println("Exception: " + e.toString());
                    }
                    break;
                }
                default: {
                    return;
                }
            }
            if (c instanceof Container) {
                int count = ((Container)c).getComponentCount();
                int i = 0;
                while (i < count) {
                    this.removeListeners(((Container)c).getComponent(i), eventID);
                    ++i;
                }
            }
        }

        public void topLevelWindowCreated(Window w) {
            this.installListeners(w);
        }

        public void topLevelWindowDestroyed(Window w) {
        }

        public void actionPerformed(ActionEvent e) {
            if (actionListener != null) {
                actionListener.actionPerformed(e);
            }
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            if (adjustmentListener != null) {
                adjustmentListener.adjustmentValueChanged(e);
            }
        }

        public void componentHidden(ComponentEvent e) {
            if (componentListener != null) {
                componentListener.componentHidden(e);
            }
        }

        public void componentMoved(ComponentEvent e) {
            if (componentListener != null) {
                componentListener.componentMoved(e);
            }
        }

        public void componentResized(ComponentEvent e) {
            if (componentListener != null) {
                componentListener.componentResized(e);
            }
        }

        public void componentShown(ComponentEvent e) {
            if (componentListener != null) {
                componentListener.componentShown(e);
            }
        }

        public void componentAdded(ContainerEvent e) {
            this.installListeners(e.getChild());
            if (containerListener != null) {
                containerListener.componentAdded(e);
            }
        }

        public void componentRemoved(ContainerEvent e) {
            this.removeListeners(e.getChild());
            if (containerListener != null) {
                containerListener.componentRemoved(e);
            }
        }

        public void focusGained(FocusEvent e) {
            componentWithFocus = (Component)e.getSource();
            if (focusListener != null) {
                focusListener.focusGained(e);
            }
        }

        public void focusLost(FocusEvent e) {
            componentWithFocus = null;
            if (focusListener != null) {
                focusListener.focusLost(e);
            }
        }

        public void itemStateChanged(ItemEvent e) {
            if (itemListener != null) {
                itemListener.itemStateChanged(e);
            }
        }

        public void keyPressed(KeyEvent e) {
            if (keyListener != null) {
                keyListener.keyPressed(e);
            }
        }

        public void keyReleased(KeyEvent e) {
            if (keyListener != null) {
                keyListener.keyReleased(e);
            }
        }

        public void keyTyped(KeyEvent e) {
            if (keyListener != null) {
                keyListener.keyTyped(e);
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (mouseListener != null) {
                mouseListener.mouseClicked(e);
            }
        }

        public void mouseEntered(MouseEvent e) {
            if (mouseListener != null) {
                mouseListener.mouseEntered(e);
            }
        }

        public void mouseExited(MouseEvent e) {
            if (mouseListener != null) {
                mouseListener.mouseExited(e);
            }
        }

        public void mousePressed(MouseEvent e) {
            if (mouseListener != null) {
                mouseListener.mousePressed(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (mouseListener != null) {
                mouseListener.mouseReleased(e);
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (mouseMotionListener != null) {
                mouseMotionListener.mouseDragged(e);
            }
        }

        public void mouseMoved(MouseEvent e) {
            if (mouseMotionListener != null) {
                mouseMotionListener.mouseMoved(e);
            }
        }

        public void textValueChanged(TextEvent e) {
            if (textListener != null) {
                textListener.textValueChanged(e);
            }
        }

        public void windowOpened(WindowEvent e) {
            if (windowListener != null) {
                windowListener.windowOpened(e);
            }
        }

        public void windowClosing(WindowEvent e) {
            if (windowListener != null) {
                windowListener.windowClosing(e);
            }
        }

        public void windowClosed(WindowEvent e) {
            if (windowListener != null) {
                windowListener.windowClosed(e);
            }
        }

        public void windowIconified(WindowEvent e) {
            if (windowListener != null) {
                windowListener.windowIconified(e);
            }
        }

        public void windowDeiconified(WindowEvent e) {
            if (windowListener != null) {
                windowListener.windowDeiconified(e);
            }
        }

        public void windowActivated(WindowEvent e) {
            if (windowListener != null) {
                windowListener.windowActivated(e);
            }
        }

        public void windowDeactivated(WindowEvent e) {
            if (windowListener != null) {
                windowListener.windowDeactivated(e);
            }
        }
    }
}

