/*
 * Decompiled with CFR 0.152.
 */
package javax.security.cert;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.AuthorityKeyIdentifierExtension;
import com.ibm.security.x509.CertificatePoliciesExtension;
import com.ibm.security.x509.DNSName;
import com.ibm.security.x509.EDIPartyName;
import com.ibm.security.x509.ExtKeyUsageExtension;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.GeneralSubtree;
import com.ibm.security.x509.GeneralSubtrees;
import com.ibm.security.x509.IPAddressName;
import com.ibm.security.x509.KeyIdentifier;
import com.ibm.security.x509.NameConstraintsExtension;
import com.ibm.security.x509.OIDMap;
import com.ibm.security.x509.OIDName;
import com.ibm.security.x509.OtherName;
import com.ibm.security.x509.PolicyInformation;
import com.ibm.security.x509.PrivateKeyUsageExtension;
import com.ibm.security.x509.RFC822Name;
import com.ibm.security.x509.SubjectAlternativeNameExtension;
import com.ibm.security.x509.SubjectKeyIdentifierExtension;
import com.ibm.security.x509.URIName;
import com.ibm.security.x509.X400Address;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import com.ibm.security.x509.X509Key;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.security.cert.CertPathValidatorException;
import javax.security.cert.CertSelector;

public class X509CertSelector
implements CertSelector {
    private BigInteger serialNumber;
    private X500Name issuer;
    private boolean issuerAsString;
    private X500Name subject;
    private boolean subjectAsString;
    private byte[] subjectKeyIdentifier;
    private byte[] authorityKeyIdentifier;
    private Date certificateValid;
    private Date privateKeyValid;
    private AlgorithmId subjectPublicKeyAlgID;
    private PublicKey subjectPublicKey;
    private boolean[] keyUsage;
    private ArrayList subjectAlternativeNames;
    private ArrayList subjectAlternativeNamesFromApp;
    private GeneralSubtrees[] nameConstraints;
    private byte[] baNameConstraints = null;
    private int basicConstraints;
    private Set policy;
    private Set keyPurposeSet;
    private X509Certificate certificate;
    private boolean matchAllNames;
    private ArrayList pathToNames;
    private ArrayList pathToNamesFromApp;

    public X509CertSelector() {
        try {
            this.setCertificate(null);
            this.setExtendedKeyUsage(null);
            this.setSerialNumber(null);
            this.setIssuer((byte[])null);
            this.setSubject((byte[])null);
            this.setSubjectKeyIdentifier(null);
            this.setAuthorityKeyIdentifier(null);
            this.setCertificateValid(null);
            this.setPrivateKeyValid(null);
            this.setSubjectPublicKeyAlgID(null);
            this.setSubjectPublicKey((PublicKey)null);
            this.setKeyUsage(null);
            this.setSubjectAlternativeNames(null);
            this.setNameConstraints(null);
            this.setBasicConstraints(-1);
            this.setPolicy(null);
            this.setPathToNames(null);
            this.setMatchAllSubjectAltNames(true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setSerialNumber(BigInteger bigInteger) {
        this.serialNumber = bigInteger != null ? new BigInteger(bigInteger.toByteArray()) : null;
    }

    public void setIssuer(String string) throws IOException {
        this.issuer = string != null ? new X500Name(string) : null;
        this.issuerAsString = true;
    }

    public void setIssuer(byte[] byArray) throws IOException {
        this.issuer = byArray != null ? new X500Name(byArray) : null;
        this.issuerAsString = false;
    }

    public void setSubject(String string) throws IOException {
        this.subject = string != null ? new X500Name(string) : null;
        this.subjectAsString = true;
    }

    public void setSubject(byte[] byArray) throws IOException {
        this.subject = byArray != null ? new X500Name(byArray) : null;
        this.subjectAsString = false;
    }

    public void setSubjectKeyIdentifier(byte[] byArray) {
        this.subjectKeyIdentifier = byArray != null ? (byte[])byArray.clone() : null;
    }

    public void setAuthorityKeyIdentifier(byte[] byArray) {
        this.authorityKeyIdentifier = byArray != null ? (byte[])byArray.clone() : null;
    }

    public void setCertificate(X509Certificate x509Certificate) {
        this.certificate = x509Certificate;
    }

    public void setCertificateValid(Date date) {
        this.certificateValid = date != null ? new Date(date.getTime()) : null;
    }

    public void setExtendedKeyUsage(Set set) throws IOException {
        if (set != null) {
            HashSet<ObjectIdentifier> hashSet = new HashSet<ObjectIdentifier>();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                ObjectIdentifier objectIdentifier;
                Object e = iterator.next();
                if (!(e instanceof String)) {
                    throw new IOException("All elements in the Set must be String");
                }
                try {
                    objectIdentifier = new ObjectIdentifier((String)e);
                }
                catch (Exception exception) {
                    throw new IOException("Invalid OID " + e.toString());
                }
                hashSet.add(objectIdentifier);
            }
            this.keyPurposeSet = hashSet;
        } else {
            this.keyPurposeSet = null;
        }
    }

    public void setPrivateKeyValid(Date date) {
        this.privateKeyValid = date != null ? new Date(date.getTime()) : null;
    }

    public void setSubjectPublicKeyAlgID(String string) throws IOException {
        if (string != null) {
            try {
                this.subjectPublicKeyAlgID = new AlgorithmId(new ObjectIdentifier(string));
            }
            catch (Exception exception) {
                throw new IOException("Invalid OID: " + string);
            }
        } else {
            this.subjectPublicKeyAlgID = null;
        }
    }

    public void setSubjectPublicKey(PublicKey publicKey) {
        this.subjectPublicKey = publicKey;
    }

    public void setSubjectPublicKey(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.subjectPublicKey = null;
        } else {
            X509Key x509Key = new X509Key();
            try {
                x509Key.decode((InputStream)new ByteArrayInputStream((byte[])byArray.clone()));
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new IOException(invalidKeyException.getMessage());
            }
            this.subjectPublicKey = x509Key;
        }
    }

    public void setKeyUsage(boolean[] blArray) {
        this.keyUsage = (boolean[])(blArray == null ? null : (boolean[])blArray.clone());
    }

    public void setMatchAllSubjectAltNames(boolean bl) {
        this.matchAllNames = bl;
    }

    public void setSubjectAlternativeNames(Collection collection) throws IOException {
        if (collection != null && collection.size() > 0) {
            this.subjectAlternativeNames = new ArrayList();
            this.subjectAlternativeNamesFromApp = new ArrayList();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof List)) {
                    throw new IOException("Each entry of names should be a List");
                }
                List list = (List)e;
                if (list.size() < 2) {
                    throw new IOException("Each entry of names should contain two elements");
                }
                Object e2 = list.get(0);
                if (!(e2 instanceof Integer)) {
                    throw new IOException("First element in each entry of names should be an Integer");
                }
                int n = (Integer)e2;
                if (n < 0 || n > 8) {
                    throw new IOException("Name type not 0-8");
                }
                Object e3 = list.get(1);
                if (e3 instanceof byte[]) {
                    this.addSubjectAlternativeName(n, (byte[])e3);
                    continue;
                }
                if (e3 instanceof String) {
                    this.addSubjectAlternativeName(n, (String)e3);
                    continue;
                }
                throw new IOException("Second element in each entry of names should be a byte array or a String");
            }
        } else {
            this.subjectAlternativeNamesFromApp = null;
            this.subjectAlternativeNames = null;
        }
    }

    public void addSubjectAlternativeName(int n, String string) throws IOException {
        if (string == null) {
            throw new IOException("Name is null");
        }
        if (this.subjectAlternativeNames == null) {
            this.subjectAlternativeNamesFromApp = new ArrayList();
            this.subjectAlternativeNames = new ArrayList();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new Integer(n));
        arrayList.add(string);
        this.subjectAlternativeNamesFromApp.add(arrayList);
        this.subjectAlternativeNames.add(this.processGeneralName(n, string));
    }

    public void addSubjectAlternativeName(int n, byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IOException("Name is null");
        }
        if (this.subjectAlternativeNames == null) {
            this.subjectAlternativeNames = new ArrayList();
            this.subjectAlternativeNamesFromApp = new ArrayList();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new Integer(n));
        arrayList.add(byArray.clone());
        this.subjectAlternativeNamesFromApp.add(arrayList);
        this.subjectAlternativeNames.add(this.processGeneralName(n, (byte[])byArray.clone()));
    }

    public void setNameConstraints(byte[] byArray) throws IOException {
        if (byArray != null) {
            this.baNameConstraints = (byte[])byArray.clone();
            if (this.nameConstraints == null) {
                this.nameConstraints = new GeneralSubtrees[2];
            }
            NameConstraintsExtension nameConstraintsExtension = new NameConstraintsExtension(Boolean.TRUE, (Object)byArray);
            GeneralSubtrees generalSubtrees = (GeneralSubtrees)nameConstraintsExtension.get("permitted_subtrees");
            GeneralSubtrees generalSubtrees2 = (GeneralSubtrees)nameConstraintsExtension.get("excluded_subtrees");
            this.nameConstraints[0] = generalSubtrees;
            this.nameConstraints[1] = generalSubtrees2;
        } else {
            this.baNameConstraints = null;
            this.nameConstraints = null;
        }
    }

    public void setBasicConstraints(int n) {
        if (n < -2) {
            throw new IllegalArgumentException("Max path length < -2");
        }
        this.basicConstraints = n;
    }

    public void setPolicy(Set set) throws IOException {
        if (set != null) {
            HashSet<ObjectIdentifier> hashSet = new HashSet<ObjectIdentifier>();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                ObjectIdentifier objectIdentifier;
                Object e = iterator.next();
                if (!(e instanceof String)) {
                    throw new IOException("All elements in the Set must be String");
                }
                try {
                    objectIdentifier = new ObjectIdentifier((String)e);
                }
                catch (Exception exception) {
                    throw new IOException("Invalid OID: " + e.toString());
                }
                hashSet.add(objectIdentifier);
            }
            this.policy = hashSet;
        } else {
            this.policy = null;
        }
    }

    public void setPathToNames(Collection collection) throws IOException {
        if (collection != null && collection.size() > 0) {
            this.pathToNames = new ArrayList();
            this.pathToNamesFromApp = new ArrayList();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof List)) {
                    throw new IOException("Each entry of names should be a List");
                }
                List list = (List)e;
                if (list.size() < 2) {
                    throw new IOException("Each entry of names should contain two elements");
                }
                Object e2 = list.get(0);
                if (!(e2 instanceof Integer)) {
                    throw new IOException("First element in each entry of names should be an Integer");
                }
                int n = (Integer)e2;
                if (n < 0 || n > 8) {
                    throw new IOException("Name type not 0-8");
                }
                Object e3 = list.get(1);
                if (e3 instanceof byte[]) {
                    this.addPathToName(n, (byte[])e3);
                    continue;
                }
                if (e3 instanceof String) {
                    this.addPathToName(n, (String)e3);
                    continue;
                }
                throw new IOException("Second element in each entry of names should be a byte array or a String");
            }
        } else {
            this.pathToNames = null;
            this.pathToNamesFromApp = null;
        }
    }

    public void addPathToName(int n, String string) throws IOException {
        if (string == null) {
            throw new IOException("Name is null");
        }
        if (this.pathToNames == null) {
            this.pathToNames = new ArrayList();
            this.pathToNamesFromApp = new ArrayList();
        }
        this.pathToNames.add(this.processGeneralName(n, string));
        ArrayList<Object> arrayList = new ArrayList<Object>(2);
        arrayList.add(new Integer(n));
        arrayList.add(string);
        this.pathToNamesFromApp.add(arrayList);
    }

    public void addPathToName(int n, byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IOException("Name is null");
        }
        if (this.pathToNames == null) {
            this.pathToNames = new ArrayList();
            this.pathToNamesFromApp = new ArrayList();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new Integer(n));
        arrayList.add(byArray.clone());
        this.pathToNames.add(this.processGeneralName(n, (byte[])byArray.clone()));
        this.pathToNamesFromApp.add(arrayList);
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber != null ? new BigInteger(this.serialNumber.toByteArray()) : null;
    }

    public String getIssuerAsString() {
        return this.issuer != null ? this.issuer.toString() : null;
    }

    public byte[] getIssuerAsBytes() throws IOException {
        return this.issuer != null ? (byte[])this.issuer.getEncoded().clone() : null;
    }

    public String getSubjectAsString() {
        return this.subject != null ? this.subject.toString() : null;
    }

    public byte[] getSubjectAsBytes() throws IOException {
        return this.subject != null ? (byte[])this.subject.getEncoded().clone() : null;
    }

    public byte[] getSubjectKeyIdentifier() {
        return this.subjectKeyIdentifier != null ? (byte[])this.subjectKeyIdentifier.clone() : null;
    }

    public byte[] getAuthorityKeyIdentifier() {
        return this.authorityKeyIdentifier != null ? (byte[])this.authorityKeyIdentifier.clone() : null;
    }

    public Date getCertificateValid() {
        return this.certificateValid != null ? new Date(this.certificateValid.getTime()) : null;
    }

    public Set getExtendedKeyUsage() {
        if (this.keyPurposeSet != null) {
            HashSet<String> hashSet = new HashSet<String>();
            Iterator iterator = this.keyPurposeSet.iterator();
            while (iterator.hasNext()) {
                String string = ((ObjectIdentifier)iterator.next()).toString();
                hashSet.add(string);
            }
            return Collections.unmodifiableSet(hashSet);
        }
        return null;
    }

    public Date getPrivateKeyValid() {
        return this.privateKeyValid != null ? new Date(this.privateKeyValid.getTime()) : null;
    }

    public String getSubjectPublicKeyAlgID() {
        return this.subjectPublicKeyAlgID != null ? this.subjectPublicKeyAlgID.getOID().toString() : null;
    }

    public PublicKey getSubjectPublicKey() {
        return this.subjectPublicKey;
    }

    public boolean[] getKeyUsage() {
        if (this.keyUsage != null) {
            return (boolean[])this.keyUsage.clone();
        }
        return null;
    }

    public boolean getMatchAllSubjectAltNames() {
        return this.matchAllNames;
    }

    public Collection getSubjectAlternativeNames() {
        if (this.subjectAlternativeNamesFromApp != null) {
            ArrayList arrayList = new ArrayList();
            Iterator iterator = this.subjectAlternativeNamesFromApp.iterator();
            while (iterator.hasNext()) {
                ArrayList arrayList2 = (ArrayList)iterator.next();
                ArrayList<Object> arrayList3 = new ArrayList<Object>(2);
                arrayList3.add(arrayList2.get(0));
                if (arrayList2.get(1) instanceof byte[]) {
                    arrayList3.add(((byte[])arrayList2.get(1)).clone());
                } else {
                    arrayList3.add(arrayList2.get(1));
                }
                arrayList.add(arrayList3);
            }
            return arrayList;
        }
        return null;
    }

    public byte[] getNameConstraints() {
        return this.baNameConstraints != null ? (byte[])this.baNameConstraints.clone() : null;
    }

    public int getBasicConstraints() {
        return this.basicConstraints;
    }

    public Set getPolicy() {
        if (this.policy != null) {
            HashSet<String> hashSet = new HashSet<String>();
            Iterator iterator = this.policy.iterator();
            while (iterator.hasNext()) {
                String string = ((ObjectIdentifier)iterator.next()).toString();
                hashSet.add(string);
            }
            return Collections.unmodifiableSet(hashSet);
        }
        return null;
    }

    public Collection getPathToNames() {
        if (this.pathToNamesFromApp != null) {
            ArrayList arrayList = new ArrayList();
            Iterator iterator = this.pathToNamesFromApp.iterator();
            while (iterator.hasNext()) {
                ArrayList arrayList2 = (ArrayList)iterator.next();
                ArrayList<Object> arrayList3 = new ArrayList<Object>(2);
                arrayList3.add(arrayList2.get(0));
                if (arrayList2.get(1) instanceof byte[]) {
                    arrayList3.add(((byte[])arrayList2.get(1)).clone());
                } else {
                    arrayList3.add(arrayList2.get(1));
                }
                arrayList.add(arrayList3);
            }
            return arrayList;
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("X509CertSelector:");
        stringBuffer.append("\n    AuthorityKeyIdentifier:");
        this.dumpBA(this.getAuthorityKeyIdentifier(), stringBuffer);
        stringBuffer.append("\n    BasicConstraints:");
        stringBuffer.append(this.getBasicConstraints());
        stringBuffer.append("\n    CertificateEquals:");
        stringBuffer.append(this.getCertificate());
        stringBuffer.append("\n    CertificateValid:");
        stringBuffer.append(this.getCertificateValid());
        stringBuffer.append("\n    ExtendedKeyUsage:");
        stringBuffer.append(this.getExtendedKeyUsage());
        stringBuffer.append("\n    IssuerAsString:");
        stringBuffer.append(this.getIssuerAsString());
        stringBuffer.append("\n    KeyUsage:");
        boolean[] blArray = this.getKeyUsage();
        if (blArray == null || blArray.length == 0) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(blArray[0]);
            for (int i = 1; i < blArray.length; ++i) {
                stringBuffer.append(", ");
                stringBuffer.append(blArray[i]);
            }
        }
        stringBuffer.append("\n    MatchAllSubjectAltNames:");
        stringBuffer.append(this.getMatchAllSubjectAltNames());
        stringBuffer.append("\n    NameConstraints:");
        this.dumpBA(this.getNameConstraints(), stringBuffer);
        stringBuffer.append("\n    PathToNames:");
        stringBuffer.append(this.getPathToNames());
        stringBuffer.append("\n    Policy:");
        stringBuffer.append(this.getPolicy());
        stringBuffer.append("\n    PrivateKeyValid:");
        stringBuffer.append(this.getPrivateKeyValid());
        stringBuffer.append("\n    SerialNumber:");
        stringBuffer.append(this.getSerialNumber());
        stringBuffer.append("\n    SubjectAlternativeNames:");
        stringBuffer.append(this.getSubjectAlternativeNames());
        stringBuffer.append("\n    SubjectAsString:");
        stringBuffer.append(this.getSubjectAsString());
        stringBuffer.append("\n    SubjectKeyIdentifier:");
        this.dumpBA(this.getSubjectKeyIdentifier(), stringBuffer);
        stringBuffer.append("\n    SubjectPublicKey:");
        stringBuffer.append(this.getSubjectPublicKey());
        stringBuffer.append("\n    SubjectPublicKeyAlgID:");
        stringBuffer.append(this.getSubjectPublicKeyAlgID());
        return stringBuffer.toString();
    }

    private void dumpBA(byte[] byArray, StringBuffer stringBuffer) {
        if (byArray == null) {
            stringBuffer.append("null");
        } else {
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            stringBuffer.append("\n");
            stringBuffer.append(hexDumpEncoder.encodeBuffer(byArray));
        }
    }

    public boolean match(Certificate certificate) {
        ObjectIdentifier objectIdentifier;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object[] objectArray;
        X509CertImpl x509CertImpl;
        if (certificate == null) {
            return false;
        }
        if (!(certificate instanceof X509Certificate)) {
            return false;
        }
        if (certificate instanceof X509CertImpl) {
            x509CertImpl = (X509CertImpl)certificate;
        } else {
            try {
                x509CertImpl = new X509CertImpl(((X509Certificate)certificate).getEncoded());
            }
            catch (CertificateException certificateException) {
                return false;
            }
        }
        if (this.certificate != null && !this.certificate.equals(certificate)) {
            return false;
        }
        if (this.serialNumber != null && this.serialNumber.compareTo(x509CertImpl.getSerialNumber()) != 0) {
            return false;
        }
        if (this.issuer != null && !this.issuer.equals((Object)x509CertImpl.getIssuerDN())) {
            if (this.issuerAsString) {
                if (!this.issuer.getRFC2253Name().equalsIgnoreCase(((X500Name)x509CertImpl.getIssuerDN()).getRFC2253Name())) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (this.subject != null && !this.subject.equals((Object)x509CertImpl.getSubjectDN())) {
            if (this.subjectAsString) {
                if (!this.subject.getRFC2253Name().equalsIgnoreCase(((X500Name)x509CertImpl.getSubjectDN()).getRFC2253Name())) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (this.subjectKeyIdentifier != null) {
            try {
                objectArray = this.getExtension("x509.info.extensions.SubjectKeyIdentifier", (X509Certificate)x509CertImpl);
                object4 = new SubjectKeyIdentifierExtension((Boolean)objectArray[0], objectArray[1]);
                object3 = (KeyIdentifier)object4.get("key_id");
                object2 = new DerOutputStream();
                object3.encode(object2);
                object = object2.toByteArray();
                if (!Arrays.equals(this.subjectKeyIdentifier, (byte[])object)) {
                    return false;
                }
            }
            catch (CertPathValidatorException certPathValidatorException) {
                return false;
            }
            catch (IOException iOException) {
                return false;
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
        }
        if (this.authorityKeyIdentifier != null) {
            try {
                objectArray = this.getExtension("x509.info.extensions.AuthorityKeyIdentifier", (X509Certificate)x509CertImpl);
                object4 = new AuthorityKeyIdentifierExtension((Boolean)objectArray[0], objectArray[1]);
                object3 = (KeyIdentifier)object4.get("key_id");
                object2 = object3.getIdentifier();
                if (!Arrays.equals(this.authorityKeyIdentifier, (byte[])object2)) {
                    return false;
                }
            }
            catch (CertPathValidatorException certPathValidatorException) {
                return false;
            }
            catch (IOException iOException) {
                return false;
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
        }
        if (this.certificateValid != null && (this.certificateValid.before(x509CertImpl.getNotBefore()) || this.certificateValid.after(x509CertImpl.getNotAfter()))) {
            return false;
        }
        if (this.privateKeyValid != null) {
            try {
                objectArray = this.getExtension("x509.info.extensions.PrivateKeyUsage", (X509Certificate)x509CertImpl);
                object2 = new PrivateKeyUsageExtension((Boolean)objectArray[0], objectArray[1]);
                try {
                    object4 = (Date)object2.get("not_before");
                }
                catch (CertificateException certificateException) {
                    object4 = null;
                }
                catch (NullPointerException nullPointerException) {
                    object4 = null;
                }
                try {
                    object3 = (Date)object2.get("not_after");
                }
                catch (CertificateException certificateException) {
                    object3 = null;
                }
                catch (NullPointerException nullPointerException) {
                    object3 = null;
                }
                if (object4 == null && object3 == null || object4 == null && this.privateKeyValid.before((Date)object4) || object3 == null && this.privateKeyValid.after((Date)object3)) {
                    return false;
                }
            }
            catch (CertPathValidatorException certPathValidatorException) {
                return false;
            }
            catch (CertificateException certificateException) {
                return false;
            }
            catch (IOException iOException) {
                return false;
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
        }
        if (this.subjectPublicKeyAlgID != null && !this.subjectPublicKeyAlgID.equals(((X509Key)x509CertImpl.getPublicKey()).getAlgorithmId())) {
            return false;
        }
        if (this.subjectPublicKey != null && !Arrays.equals(this.subjectPublicKey.getEncoded(), x509CertImpl.getPublicKey().getEncoded())) {
            return false;
        }
        if (this.keyUsage != null && (object4 = (Object)x509CertImpl.getKeyUsage()) != null) {
            for (int i = 0; i < this.keyUsage.length; ++i) {
                if (!this.keyUsage[i] || i < ((SubjectKeyIdentifierExtension)object4).length && object4[i] != false) continue;
                return false;
            }
        }
        if (this.keyPurposeSet != null && !this.keyPurposeSet.isEmpty()) {
            try {
                objectArray = this.getExtension("x509.info.extensions.ExtKeyUsage", (X509Certificate)x509CertImpl);
                object4 = new ExtKeyUsageExtension((Boolean)objectArray[0], objectArray[1]);
                Vector vector = (Vector)object4.get("extkeyusage");
                boolean bl = true;
                object = this.keyPurposeSet.iterator();
                while (object.hasNext()) {
                    objectIdentifier = new ObjectIdentifier((String)object.next());
                    if (vector.contains(objectIdentifier)) continue;
                    bl = false;
                    return bl;
                }
            }
            catch (CertPathValidatorException certPathValidatorException) {
                return false;
            }
            catch (IOException iOException) {
                return false;
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
        }
        if (this.subjectAlternativeNames != null || this.nameConstraints != null) {
            List list;
            Object object5;
            Object object6;
            object4 = null;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            try {
                object6 = null;
                objectArray = this.getExtension("x509.info.extensions.SubjectAlternativeName", (X509Certificate)x509CertImpl);
                object6 = new SubjectAlternativeNameExtension((Boolean)objectArray[0], objectArray[1]);
                object4 = (GeneralNames)object6.get("subject_name");
            }
            catch (CertPathValidatorException certPathValidatorException) {
                object4 = null;
            }
            catch (IOException iOException) {
                object4 = null;
            }
            catch (NullPointerException nullPointerException) {
                object4 = null;
            }
            if (this.subjectAlternativeNames != null) {
                if (object4 == null) {
                    return false;
                }
                try {
                    Object e;
                    Object e2;
                    objectIdentifier = object4.iterator();
                    while (objectIdentifier.hasNext()) {
                        object = (GeneralName)objectIdentifier.next();
                        try {
                            object6 = this.processGeneralName((GeneralName)object);
                            arrayList.add(object6);
                        }
                        catch (IOException iOException) {}
                    }
                    boolean bl = false;
                    if (this.getMatchAllSubjectAltNames()) {
                        object5 = this.subjectAlternativeNames.iterator();
                        while (object5.hasNext()) {
                            list = (List)object5.next();
                            objectIdentifier = arrayList.iterator();
                            bl = false;
                            while (objectIdentifier.hasNext()) {
                                object6 = (List)objectIdentifier.next();
                                if (!object6.get(0).equals(list.get(0))) continue;
                                e2 = object6.get(1);
                                e = list.get(1);
                                if (e2 instanceof byte[] && e instanceof byte[]) {
                                    if (!Arrays.equals((byte[])e2, (byte[])e)) continue;
                                    bl = true;
                                    break;
                                }
                                if (!e2.equals(e)) continue;
                                bl = true;
                                break;
                            }
                            if (bl) continue;
                            return false;
                        }
                    } else {
                        object5 = this.subjectAlternativeNames.iterator();
                        while (object5.hasNext()) {
                            list = (List)object5.next();
                            objectIdentifier = arrayList.iterator();
                            bl = false;
                            while (objectIdentifier.hasNext()) {
                                object6 = (List)objectIdentifier.next();
                                if (!object6.get(0).equals(list.get(0))) continue;
                                e2 = object6.get(1);
                                e = list.get(1);
                                if (e2 instanceof byte[] && e instanceof byte[]) {
                                    if (!Arrays.equals((byte[])e2, (byte[])e)) continue;
                                    bl = true;
                                    break;
                                }
                                if (!e2.equals(e)) continue;
                                bl = true;
                                break;
                            }
                            if (!bl) continue;
                        }
                        if (!bl) {
                            return false;
                        }
                    }
                }
                catch (NullPointerException nullPointerException) {
                    return false;
                }
            }
            if (this.nameConstraints != null && !((Object)x509CertImpl.getIssuerDN()).equals(x509CertImpl.getSubjectDN())) {
                objectIdentifier = (X500Name)x509CertImpl.getSubjectDN();
                object6 = new ArrayList();
                object = new ArrayList();
                object.add(new Integer(4));
                object.add(objectIdentifier);
                object6.add(object);
                if (!this.namesMatchConstraints((Collection)object6, this.nameConstraints[0], this.nameConstraints[1])) {
                    return false;
                }
                try {
                    object5 = objectIdentifier.getEmail();
                    if (object5 != null) {
                        list = new DerValue((String)object5);
                        list.resetTag((byte)22);
                        String string = list.getIA5String().toLowerCase();
                        object = this.processGeneralName(1, string);
                        object6.clear();
                        object6.add(object);
                        if (!this.namesMatchConstraints((Collection)object6, this.nameConstraints[0], this.nameConstraints[1])) {
                            return false;
                        }
                    }
                }
                catch (IOException iOException) {
                    return false;
                }
                if (arrayList != null && !this.namesMatchConstraints(arrayList, this.nameConstraints[0], this.nameConstraints[1])) {
                    return false;
                }
            }
        }
        if (this.basicConstraints >= 0 && this.basicConstraints > x509CertImpl.getBasicConstraints()) {
            return false;
        }
        if (this.basicConstraints == -2 && ((Object)x509CertImpl.getIssuerDN()).equals(x509CertImpl.getSubjectDN())) {
            return false;
        }
        if (this.policy != null) {
            try {
                objectArray = this.getExtension("x509.info.extensions.CertificatePolicies", (X509Certificate)x509CertImpl);
                object4 = new CertificatePoliciesExtension((Boolean)objectArray[0], objectArray[1]);
                Vector vector = (Vector)object4.get("cert_policies");
                if (!this.policy.isEmpty() || vector.isEmpty()) {
                    boolean bl = false;
                    for (int i = 0; i < vector.size(); ++i) {
                        ObjectIdentifier objectIdentifier2 = ((PolicyInformation)vector.get(i)).getPolicyIdentifier();
                        if (!this.policy.contains(objectIdentifier2)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        return false;
                    }
                }
            }
            catch (CertPathValidatorException certPathValidatorException) {
                return false;
            }
            catch (IOException iOException) {
                return false;
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
        }
        if (this.pathToNames != null) {
            object4 = null;
            try {
                object4 = (NameConstraintsExtension)x509CertImpl.get("x509.info.extensions.NameConstraints");
            }
            catch (CertificateParsingException certificateParsingException) {
                object4 = null;
            }
            if (object4 != null) {
                try {
                    GeneralSubtrees generalSubtrees = (GeneralSubtrees)object4.get("permitted_subtrees");
                    GeneralSubtrees generalSubtrees2 = (GeneralSubtrees)object4.get("excluded_subtrees");
                    if (!this.namesMatchConstraints(this.pathToNames, generalSubtrees, generalSubtrees2)) {
                        return false;
                    }
                }
                catch (IOException iOException) {
                    return false;
                }
                catch (NullPointerException nullPointerException) {
                    return false;
                }
            }
        }
        return true;
    }

    private Object[] getExtension(String string, X509Certificate x509Certificate) throws CertPathValidatorException {
        boolean bl = false;
        String string2 = OIDMap.getOID((String)string).toString();
        byte[] byArray = x509Certificate.getExtensionValue(string2);
        if (byArray != null) {
            bl = x509Certificate.getCriticalExtensionOIDs().contains(string2);
            try {
                byArray = new DerValue(byArray).getOctetString();
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("An internal error has occurred.", iOException);
            }
        }
        Object[] objectArray = new Object[]{new Boolean(bl), byArray};
        return objectArray;
    }

    private boolean namesMatchConstraints(Collection collection, GeneralSubtrees generalSubtrees, GeneralSubtrees generalSubtrees2) {
        if (generalSubtrees == null && generalSubtrees2 == null) {
            return false;
        }
        Vector vector = generalSubtrees != null ? generalSubtrees.getSubtrees() : null;
        Vector vector2 = generalSubtrees2 != null ? generalSubtrees2.getSubtrees() : null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            GeneralName generalName;
            int n;
            List list;
            Object e = iterator.next();
            if (e instanceof GeneralName) {
                try {
                    list = this.processGeneralName((GeneralName)e);
                }
                catch (IOException iOException) {
                    return false;
                }
            } else {
                list = (List)e;
            }
            if (vector2 != null) {
                for (n = 0; n < vector2.size(); ++n) {
                    generalName = ((GeneralSubtree)vector2.get(n)).getBase();
                    if (((Integer)list.get(0)).intValue() != generalName.getType() || !list.get(1).toString().equals(generalName.toString())) continue;
                    return false;
                }
            }
            if (vector == null) continue;
            boolean bl = false;
            for (n = 0; n < vector.size(); ++n) {
                generalName = ((GeneralSubtree)vector.get(n)).getBase();
                if (((Integer)list.get(0)).intValue() != generalName.getType() || !list.get(1).toString().equals(generalName.toString())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private boolean nameMatchesConstraint(List list, List list2) {
        int n;
        int n2 = (Integer)list.get(0);
        if (n2 != (n = ((Integer)list2.get(0)).intValue())) {
            return false;
        }
        switch (n2) {
            case 0: 
            case 3: 
            case 5: 
            case 8: {
                String string = (String)list.get(1);
                String string2 = (String)list2.get(1);
                return string.equals(string2);
            }
            case 1: {
                String string = (String)list.get(1);
                String string3 = (String)list2.get(1);
                return string.equals(string3) || string.endsWith("@" + string3) || string3.startsWith(".") && string.endsWith(string3);
            }
            case 2: {
                String string = (String)list.get(1);
                String string4 = (String)list2.get(1);
                return string.equals(string4) || string.endsWith(string4);
            }
            case 4: {
                X500Name x500Name = (X500Name)list.get(1);
                X500Name x500Name2 = (X500Name)list2.get(1);
                if (x500Name2.size() > x500Name.size()) {
                    return false;
                }
                boolean bl = true;
                for (int i = 0; i < x500Name2.size(); ++i) {
                    if (x500Name2.getRDN(i).equals((Object)x500Name.getRDN(i))) continue;
                    bl = false;
                    break;
                }
                return bl;
            }
            case 6: {
                String string = (String)list.get(1);
                String string5 = (String)list2.get(1);
                try {
                    string = new URL(string).getHost().toLowerCase();
                    string5 = new URL(string5).getHost().toLowerCase();
                }
                catch (MalformedURLException malformedURLException) {
                    return false;
                }
                return string.equals(string5) || string.endsWith("." + string5);
            }
            case 7: {
                String string = (String)list.get(1);
                String string6 = (String)list2.get(1);
                return string.equals(string6);
            }
        }
        return false;
    }

    private List processGeneralName(GeneralName generalName) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        generalName.encode(derOutputStream);
        byte[] byArray = derOutputStream.toByteArray();
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue derValue = derInputStream.getDerValue();
        byte[] byArray2 = derValue.getData().toByteArray();
        return this.processGeneralName(generalName.getType(), byArray2);
    }

    private List processGeneralName(int n, String string) throws IOException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(2);
        arrayList.add(0, new Integer(n));
        switch (n) {
            case 8: {
                arrayList.add(1, (Integer)new OIDName(new ObjectIdentifier(string)));
                break;
            }
            case 1: {
                arrayList.add(1, (Integer)new RFC822Name(string));
                break;
            }
            case 2: {
                arrayList.add(1, (Integer)new DNSName(string));
                break;
            }
            case 6: {
                arrayList.add(1, (Integer)new URIName(string));
                break;
            }
            case 4: {
                arrayList.add(1, (Integer)new X500Name(string));
                break;
            }
            case 7: {
                arrayList.add(1, (Integer)new IPAddressName(string));
                break;
            }
            default: {
                throw new IOException("Unable to parse String of name type " + n);
            }
        }
        return arrayList;
    }

    private List processGeneralName(int n, byte[] byArray) throws IOException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(2);
        arrayList.add(0, new Integer(n));
        switch (n) {
            case 0: {
                arrayList.add(1, (Integer)new OtherName(new DerValue(byArray)));
                break;
            }
            case 5: {
                arrayList.add(1, (Integer)new EDIPartyName(new DerValue(byArray)));
                break;
            }
            case 8: {
                arrayList.add(1, (Integer)new OIDName(new DerValue(byArray)));
                break;
            }
            case 1: {
                arrayList.add(1, (Integer)new RFC822Name(new DerValue(byArray)));
                break;
            }
            case 2: {
                arrayList.add(1, (Integer)new DNSName(new DerValue(byArray)));
                break;
            }
            case 6: {
                arrayList.add(1, (Integer)new URIName(new DerValue(byArray)));
                break;
            }
            case 4: {
                arrayList.add(1, (Integer)new X500Name(new DerValue(byArray)));
                break;
            }
            case 7: {
                arrayList.add(1, (Integer)new IPAddressName(new DerValue(byArray)));
                break;
            }
            case 3: {
                arrayList.add(1, (Integer)new X400Address(new DerValue(byArray)));
                break;
            }
            default: {
                throw new IOException("Unable to parse byte array of name type " + n);
            }
        }
        return arrayList;
    }

    public Object clone() {
        try {
            Object object = super.clone();
            if (this.subjectAlternativeNames != null) {
                this.subjectAlternativeNames = new ArrayList(this.subjectAlternativeNames);
                this.subjectAlternativeNamesFromApp = new ArrayList(this.subjectAlternativeNamesFromApp);
            }
            if (this.pathToNames != null) {
                this.pathToNames = new ArrayList(this.pathToNames);
                this.pathToNamesFromApp = new ArrayList(this.pathToNamesFromApp);
            }
            return object;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }
}

