/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.cosnaming;

import com.sun.jndi.cosnaming.CNCtx;
import com.sun.jndi.toolkit.url.UrlUtil;
import java.net.MalformedURLException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.Name;
import javax.naming.NamingException;

public final class IiopUrl {
    private static final int DEFAULT_IIOPNAME_PORT = 9999;
    private static final int DEFAULT_IIOP_PORT = 2809;
    private static final String DEFAULT_HOST = "localhost";
    private Vector addresses;
    private String stringName;

    public Vector getAddresses() {
        return this.addresses;
    }

    public String getStringName() {
        return this.stringName;
    }

    public Name getCosName() throws NamingException {
        return CNCtx.parser.parse(this.stringName);
    }

    public IiopUrl(String string) throws MalformedURLException {
        int n;
        boolean bl;
        if (string.startsWith("iiopname://")) {
            bl = false;
            n = 11;
        } else if (string.startsWith("iiop://")) {
            bl = true;
            n = 7;
        } else {
            throw new MalformedURLException("Invalid iiop/iiopname URL: " + string);
        }
        int n2 = string.indexOf(47, n);
        if (n2 < 0) {
            n2 = string.length();
            this.stringName = "";
        } else {
            this.stringName = UrlUtil.decode(string.substring(n2 + 1));
        }
        this.addresses = new Vector(3);
        if (bl) {
            this.addresses.addElement(new Address(string.substring(n, n2), bl));
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n, n2), ",");
            while (stringTokenizer.hasMoreTokens()) {
                this.addresses.addElement(new Address(stringTokenizer.nextToken(), bl));
            }
            if (this.addresses.size() == 0) {
                this.addresses.addElement(new Address("", bl));
            }
        }
    }

    public static class Address {
        public int port;
        public int major;
        public int minor;
        public String host;

        public Address(String string, boolean bl) throws MalformedURLException {
            int n;
            int n2;
            int n3;
            if (bl || (n3 = string.indexOf(64)) < 0) {
                this.major = 1;
                this.minor = 0;
                n2 = 0;
            } else {
                n = string.indexOf(46);
                if (n < 0) {
                    throw new MalformedURLException("invalid version: " + string);
                }
                try {
                    this.major = Integer.parseInt(string.substring(0, n));
                    this.minor = Integer.parseInt(string.substring(n + 1, n3));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MalformedURLException("Nonnumeric version: " + string);
                }
                n2 = n3 + 1;
            }
            n = string.indexOf(58, n2);
            if (n < 0) {
                this.port = bl ? 2809 : 9999;
                this.host = string.substring(n2);
            } else {
                try {
                    this.port = Integer.parseInt(string.substring(n + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MalformedURLException("Nonnumeric port number: " + string);
                }
                this.host = string.substring(n2, n);
            }
            if (this.host.equals("")) {
                this.host = IiopUrl.DEFAULT_HOST;
            }
        }
    }
}

