/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.Name;

public final class DnsName
implements Name,
Comparable {
    private String domain = "";
    private ArrayList labels = new ArrayList();
    private short octets = 1;
    private static final long serialVersionUID = 7040187611324710271L;

    public DnsName() {
    }

    public DnsName(String string) throws InvalidNameException {
        this.parse(string);
    }

    private DnsName(DnsName dnsName, int n, int n2) {
        int n3 = dnsName.size() - n2;
        int n4 = dnsName.size() - n;
        this.labels.addAll(dnsName.labels.subList(n3, n4));
        if (this.size() == dnsName.size()) {
            this.domain = dnsName.domain;
            this.octets = dnsName.octets;
        } else {
            Iterator iterator = this.labels.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (string.length() <= 0) continue;
                this.octets = (short)(this.octets + (short)(string.length() + 1));
            }
        }
    }

    public String toString() {
        if (this.domain == null) {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.labels.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (stringBuffer.length() > 0 || string.length() == 0) {
                    stringBuffer.append('.');
                }
                DnsName.escape(stringBuffer, string);
            }
            this.domain = stringBuffer.toString();
        }
        return this.domain;
    }

    public boolean isHostName() {
        Iterator iterator = this.labels.iterator();
        while (iterator.hasNext()) {
            if (DnsName.isHostNameLabel((String)iterator.next())) continue;
            return false;
        }
        return true;
    }

    public short getOctets() {
        return this.octets;
    }

    public int size() {
        return this.labels.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.size()) {
            n = 31 * n + this.getKey(n2).hashCode();
            ++n2;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Name) || object instanceof CompositeName) {
            return false;
        }
        Name name = (Name)object;
        return this.size() == name.size() && this.compareTo(object) == 0;
    }

    public int compareTo(Object object) {
        Name name = (Name)object;
        return this.compareRange(0, this.size(), name);
    }

    public boolean startsWith(Name name) {
        return this.size() >= name.size() && this.compareRange(0, name.size(), name) == 0;
    }

    public boolean endsWith(Name name) {
        return this.size() >= name.size() && this.compareRange(this.size() - name.size(), this.size(), name) == 0;
    }

    public String get(int n) {
        if (n < 0 || n >= this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n2 = this.size() - n - 1;
        return (String)this.labels.get(n2);
    }

    public Enumeration getAll() {
        return new Enumeration(){
            int pos = 0;

            public boolean hasMoreElements() {
                return this.pos < DnsName.this.size();
            }

            public Object nextElement() {
                if (this.pos < DnsName.this.size()) {
                    return DnsName.this.get(this.pos++);
                }
                throw new NoSuchElementException();
            }
        };
    }

    public Name getPrefix(int n) {
        return new DnsName(this, 0, n);
    }

    public Name getSuffix(int n) {
        return new DnsName(this, n, this.size());
    }

    public Object clone() {
        return new DnsName(this, 0, this.size());
    }

    public Object remove(int n) {
        if (n < 0 || n >= this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n2 = this.size() - n - 1;
        String string = (String)this.labels.remove(n2);
        int n3 = string.length();
        if (n3 > 0) {
            this.octets = (short)(this.octets - (short)(n3 + 1));
        }
        this.domain = null;
        return string;
    }

    public Name add(String string) throws InvalidNameException {
        return this.add(this.size(), string);
    }

    public Name add(int n, String string) throws InvalidNameException {
        if (n < 0 || n > this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n2 = string.length();
        if (n > 0 && n2 == 0 || n == 0 && this.hasRootLabel()) {
            throw new InvalidNameException("Empty label must be the last label in a domain name");
        }
        if (n2 > 0) {
            if (this.octets + n2 + 1 >= 256) {
                throw new InvalidNameException("Name too long");
            }
            this.octets = (short)(this.octets + (short)(n2 + 1));
        }
        int n3 = this.size() - n;
        DnsName.verifyLabel(string);
        this.labels.add(n3, string);
        this.domain = null;
        return this;
    }

    public Name addAll(Name name) throws InvalidNameException {
        return this.addAll(this.size(), name);
    }

    public Name addAll(int n, Name name) throws InvalidNameException {
        if (name instanceof DnsName) {
            DnsName dnsName = (DnsName)name;
            if (dnsName.isEmpty()) {
                return this;
            }
            if (n > 0 && dnsName.hasRootLabel() || n == 0 && this.hasRootLabel()) {
                throw new InvalidNameException("Empty label must be the last label in a domain name");
            }
            short s = (short)(this.octets + dnsName.octets - 1);
            if (s > 255) {
                throw new InvalidNameException("Name too long");
            }
            this.octets = s;
            int n2 = this.size() - n;
            this.labels.addAll(n2, dnsName.labels);
            this.domain = this.isEmpty() ? dnsName.domain : (this.domain == null || dnsName.domain == null ? null : (n == 0 ? this.domain + (dnsName.domain.equals(".") ? "" : ".") + dnsName.domain : (n == this.size() ? dnsName.domain + (this.domain.equals(".") ? "" : ".") + this.domain : null)));
        } else if (name instanceof CompositeName) {
            name = (DnsName)name;
        } else {
            int n3 = name.size() - 1;
            while (n3 >= 0) {
                this.add(n, name.get(n3));
                --n3;
            }
        }
        return this;
    }

    boolean hasRootLabel() {
        return !this.isEmpty() && this.get(0).equals("");
    }

    private int compareRange(int n, int n2, Name name) {
        if (name instanceof CompositeName) {
            name = (DnsName)name;
        }
        int n3 = Math.min(n2 - n, name.size());
        int n4 = 0;
        while (n4 < n3) {
            String string = this.get(n4 + n);
            String string2 = name.get(n4);
            int n5 = this.size() - (n4 + n) - 1;
            int n6 = DnsName.compareLabels(string, string2);
            if (n6 != 0) {
                return n6;
            }
            ++n4;
        }
        return n2 - n - name.size();
    }

    String getKey(int n) {
        return DnsName.keyForLabel(this.get(n));
    }

    private void parse(String string) throws InvalidNameException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\\') {
                c = DnsName.getEscapedOctet(string, n++);
                if (DnsName.isDigit(string.charAt(n))) {
                    n += 2;
                }
                stringBuffer.append(c);
            } else if (c != '.') {
                stringBuffer.append(c);
            } else {
                this.add(0, stringBuffer.toString());
                stringBuffer.delete(0, n);
            }
            ++n;
        }
        if (!string.equals("") && !string.equals(".")) {
            this.add(0, stringBuffer.toString());
        }
        this.domain = string;
    }

    private static char getEscapedOctet(String string, int n) throws InvalidNameException {
        try {
            char c = string.charAt(++n);
            if (DnsName.isDigit(c)) {
                char c2 = string.charAt(++n);
                char c3 = string.charAt(++n);
                if (DnsName.isDigit(c2) && DnsName.isDigit(c3)) {
                    return (char)((c - 48) * 100 + (c2 - 48) * 10 + (c3 - 48));
                }
                throw new InvalidNameException("Invalid escape sequence in " + string);
            }
            return c;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new InvalidNameException("Invalid escape sequence in " + string);
        }
    }

    private static void verifyLabel(String string) throws InvalidNameException {
        if (string.length() > 63) {
            throw new InvalidNameException("Label exceeds 63 octets: " + string);
        }
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if ((c & 0xFF00) != 0) {
                throw new InvalidNameException("Label has two-byte char: " + string);
            }
            ++n;
        }
    }

    private static boolean isHostNameLabel(String string) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!DnsName.isHostNameChar(c)) {
                return false;
            }
            ++n;
        }
        return !string.startsWith("-") && !string.endsWith("-");
    }

    private static boolean isHostNameChar(char c) {
        return c == '-' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9';
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static void escape(StringBuffer stringBuffer, String string) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '.' || c == '\\') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
            ++n;
        }
    }

    private static int compareLabels(String string, String string2) {
        int n = Math.min(string.length(), string2.length());
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            char c2 = string2.charAt(n2);
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            if (c2 >= 'A' && c2 <= 'Z') {
                c2 = (char)(c2 + 32);
            }
            if (c != c2) {
                return c - c2;
            }
            ++n2;
        }
        return string.length() - string2.length();
    }

    private static String keyForLabel(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            stringBuffer.append(c);
            ++n;
        }
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.toString());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            this.parse((String)objectInputStream.readObject());
        }
        catch (InvalidNameException invalidNameException) {
            throw new StreamCorruptedException("Invalid name: " + this.domain);
        }
    }
}

