/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import com.sun.jndi.dns.DnsName;
import java.io.UnsupportedEncodingException;
import javax.naming.InvalidNameException;

public class ResourceRecord {
    static final int TYPE_A = 1;
    static final int TYPE_NS = 2;
    static final int TYPE_CNAME = 5;
    static final int TYPE_SOA = 6;
    static final int TYPE_PTR = 12;
    static final int TYPE_HINFO = 13;
    static final int TYPE_MX = 15;
    static final int TYPE_TXT = 16;
    static final int TYPE_AAAA = 28;
    static final int TYPE_SRV = 33;
    static final int TYPE_NAPTR = 35;
    static final int QTYPE_AXFR = 252;
    static final int QTYPE_STAR = 255;
    static final String[] rrTypeNames = new String[]{null, "A", "NS", null, null, "CNAME", "SOA", null, null, null, null, null, "PTR", "HINFO", null, "MX", "TXT", null, null, null, null, null, null, null, null, null, null, null, "AAAA", null, null, null, null, "SRV", null, "NAPTR"};
    static final int CLASS_INTERNET = 1;
    static final int CLASS_HESIOD = 2;
    static final int QCLASS_STAR = 255;
    static final String[] rrClassNames = new String[]{null, "IN", null, null, "HS"};
    byte[] msg;
    int msgLen;
    boolean qSection;
    int offset;
    int rrlen;
    DnsName name;
    int rrtype;
    String rrtypeName;
    int rrclass;
    String rrclassName;
    int ttl = 0;
    int rdlen = 0;
    Object rdata = null;

    ResourceRecord(byte[] byArray, int n, int n2, boolean bl, boolean bl2) throws InvalidNameException {
        this.msg = byArray;
        this.msgLen = n;
        this.offset = n2;
        this.qSection = bl;
        this.decode(bl2);
    }

    public String toString() {
        String string = this.name + " " + this.rrclassName + " " + this.rrtypeName;
        if (!this.qSection) {
            string = string + " " + this.ttl + " " + (this.rdata != null ? this.rdata : "[n/a]");
        }
        return string;
    }

    public DnsName getName() {
        return this.name;
    }

    public int size() {
        return this.rrlen;
    }

    public int getType() {
        return this.rrtype;
    }

    public int getRrclass() {
        return this.rrclass;
    }

    public Object getRdata() {
        return this.rdata;
    }

    public static String getTypeName(int n) {
        return ResourceRecord.valueToName(n, rrTypeNames);
    }

    public static int getType(String string) {
        return ResourceRecord.nameToValue(string, rrTypeNames);
    }

    public static String getRrclassName(int n) {
        return ResourceRecord.valueToName(n, rrClassNames);
    }

    public static int getRrclass(String string) {
        return ResourceRecord.nameToValue(string, rrClassNames);
    }

    private static String valueToName(int n, String[] stringArray) {
        String string = null;
        if (n > 0 && n < stringArray.length) {
            string = stringArray[n];
        } else if (n == 255) {
            string = "*";
        }
        if (string == null) {
            string = Integer.toString(n);
        }
        return string;
    }

    private static int nameToValue(String string, String[] stringArray) {
        if (string.equals("")) {
            return -1;
        }
        if (string.equals("*")) {
            return 255;
        }
        if (Character.isDigit(string.charAt(0))) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int n = 1;
        while (n < stringArray.length) {
            if (stringArray[n] != null && string.equalsIgnoreCase(stringArray[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static int compareSerialNumbers(long l, long l2) {
        long l3 = l2 - l;
        if (l3 == 0L) {
            return 0;
        }
        if (l3 > 0L && l3 <= Integer.MAX_VALUE || l3 < 0L && -l3 > Integer.MAX_VALUE) {
            return -1;
        }
        return 1;
    }

    private void decode(boolean bl) throws InvalidNameException {
        int n = this.offset;
        this.name = new DnsName();
        n = this.decodeName(n, this.name);
        this.rrtype = this.getUShort(n);
        String string = this.rrtypeName = this.rrtype < rrTypeNames.length ? rrTypeNames[this.rrtype] : null;
        if (this.rrtypeName == null) {
            this.rrtypeName = Integer.toString(this.rrtype);
        }
        this.rrclass = this.getUShort(n += 2);
        String string2 = this.rrclassName = this.rrclass < rrClassNames.length ? rrClassNames[this.rrclass] : null;
        if (this.rrclassName == null) {
            this.rrclassName = Integer.toString(this.rrclass);
        }
        n += 2;
        if (!this.qSection) {
            this.ttl = this.getInt(n);
            this.rdlen = this.getUShort(n += 4);
            Object object = this.rdata = bl || this.rrtype == 6 ? this.decodeRdata(n += 2) : null;
            if (this.rdata instanceof DnsName) {
                this.rdata = this.rdata.toString();
            }
            n += this.rdlen;
        }
        this.rrlen = n - this.offset;
        this.msg = null;
    }

    private int getUByte(int n) {
        return this.msg[n] & 0xFF;
    }

    private int getUShort(int n) {
        return (this.msg[n] & 0xFF) << 8 | this.msg[n + 1] & 0xFF;
    }

    private int getInt(int n) {
        return this.getUShort(n) << 16 | this.getUShort(n + 2);
    }

    private long getUInt(int n) {
        return (long)this.getInt(n) & 0xFFFFFFFFL;
    }

    private DnsName decodeName(int n) throws InvalidNameException {
        DnsName dnsName = new DnsName();
        this.decodeName(n, dnsName);
        return dnsName;
    }

    private int decodeName(int n, DnsName dnsName) throws InvalidNameException {
        if (this.msg[n] == 0) {
            dnsName.add(0, "");
            return n + 1;
        }
        if ((this.msg[n] & 0xC0) != 0) {
            this.decodeName(this.getUShort(n) & 0x3FFF, dnsName);
            return n + 2;
        }
        byte by = this.msg[n++];
        try {
            dnsName.add(0, new String(this.msg, n, (int)by, "ISO-8859-1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return this.decodeName(n + by, dnsName);
    }

    private Object decodeRdata(int n) throws InvalidNameException {
        if (this.rrclass == 1) {
            switch (this.rrtype) {
                case 1: {
                    return this.decodeA(n);
                }
                case 28: {
                    return this.decodeAAAA(n);
                }
                case 2: 
                case 5: 
                case 12: {
                    return this.decodeName(n);
                }
                case 15: {
                    return this.decodeMx(n);
                }
                case 6: {
                    return this.decodeSoa(n);
                }
                case 33: {
                    return this.decodeSrv(n);
                }
                case 35: {
                    return this.decodeNaptr(n);
                }
                case 16: {
                    return this.decodeTxt(n);
                }
                case 13: {
                    return this.decodeHinfo(n);
                }
            }
        }
        byte[] byArray = new byte[this.rdlen];
        System.arraycopy(this.msg, n, byArray, 0, this.rdlen);
        return byArray;
    }

    private String decodeMx(int n) throws InvalidNameException {
        int n2 = this.getUShort(n);
        DnsName dnsName = this.decodeName(n += 2);
        return n2 + " " + dnsName;
    }

    private String decodeSoa(int n) throws InvalidNameException {
        DnsName dnsName = new DnsName();
        n = this.decodeName(n, dnsName);
        DnsName dnsName2 = new DnsName();
        n = this.decodeName(n, dnsName2);
        long l = this.getUInt(n);
        long l2 = this.getUInt(n += 4);
        long l3 = this.getUInt(n += 4);
        long l4 = this.getUInt(n += 4);
        long l5 = this.getUInt(n += 4);
        n += 4;
        return dnsName + " " + dnsName2 + " " + l + " " + l2 + " " + l3 + " " + l4 + " " + l5;
    }

    private String decodeSrv(int n) throws InvalidNameException {
        int n2 = this.getUShort(n);
        int n3 = this.getUShort(n += 2);
        int n4 = this.getUShort(n += 2);
        DnsName dnsName = this.decodeName(n += 2);
        return n2 + " " + n3 + " " + n4 + " " + dnsName;
    }

    private String decodeNaptr(int n) throws InvalidNameException {
        int n2 = this.getUShort(n);
        int n3 = this.getUShort(n += 2);
        n += 2;
        StringBuffer stringBuffer = new StringBuffer();
        n += this.decodeCharString(n, stringBuffer);
        StringBuffer stringBuffer2 = new StringBuffer();
        n += this.decodeCharString(n, stringBuffer2);
        StringBuffer stringBuffer3 = new StringBuffer(this.rdlen);
        n += this.decodeCharString(n, stringBuffer3);
        DnsName dnsName = this.decodeName(n);
        return n2 + " " + n3 + " " + stringBuffer + " " + stringBuffer2 + " " + stringBuffer3 + " " + dnsName;
    }

    private String decodeTxt(int n) {
        StringBuffer stringBuffer = new StringBuffer(this.rdlen);
        int n2 = n + this.rdlen;
        while (n < n2) {
            if ((n += this.decodeCharString(n, stringBuffer)) >= n2) continue;
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    private String decodeHinfo(int n) {
        StringBuffer stringBuffer = new StringBuffer(this.rdlen);
        n += this.decodeCharString(n, stringBuffer);
        stringBuffer.append(' ');
        n += this.decodeCharString(n, stringBuffer);
        return stringBuffer.toString();
    }

    private int decodeCharString(int n, StringBuffer stringBuffer) {
        int n2;
        int n3 = stringBuffer.length();
        boolean bl = (n2 = this.getUByte(n++)) == 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5;
            bl |= (n5 = this.getUByte(n++)) == 32;
            if (n5 == 92 || n5 == 34) {
                bl = true;
                stringBuffer.append('\\');
            }
            stringBuffer.append((char)n5);
            ++n4;
        }
        if (bl) {
            stringBuffer.insert(n3, '\"');
            stringBuffer.append('\"');
        }
        return n2 + 1;
    }

    private String decodeA(int n) {
        return (this.msg[n] & 0xFF) + "." + (this.msg[n + 1] & 0xFF) + "." + (this.msg[n + 2] & 0xFF) + "." + (this.msg[n + 3] & 0xFF);
    }

    private String decodeAAAA(int n) {
        int[] nArray = new int[8];
        int n2 = 0;
        while (n2 < 8) {
            nArray[n2] = this.getUShort(n);
            n += 2;
            ++n2;
        }
        int n3 = -1;
        int n4 = 0;
        int n5 = -1;
        int n6 = 0;
        int n7 = 0;
        while (n7 < 8) {
            if (nArray[n7] == 0) {
                if (n3 == -1) {
                    n3 = n7;
                    n4 = 1;
                } else if (++n4 >= 2 && n4 > n6) {
                    n5 = n3;
                    n6 = n4;
                }
            } else {
                n3 = -1;
            }
            ++n7;
        }
        if (n5 == 0) {
            if (n6 == 6 || n6 == 7 && nArray[7] > 1) {
                return "::" + this.decodeA(n - 4);
            }
            if (n6 == 5 && nArray[5] == 65535) {
                return "::ffff:" + this.decodeA(n - 4);
            }
        }
        boolean bl = n5 != -1;
        StringBuffer stringBuffer = new StringBuffer(40);
        if (n5 == 0) {
            stringBuffer.append(':');
        }
        int n8 = 0;
        while (n8 < 8) {
            if (!bl || n8 < n5 || n8 >= n5 + n6) {
                stringBuffer.append(Integer.toHexString(nArray[n8]));
                if (n8 < 7) {
                    stringBuffer.append(':');
                }
            } else if (bl && n8 == n5) {
                stringBuffer.append(':');
            }
            ++n8;
        }
        return stringBuffer.toString();
    }
}

