/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.ibm.jvm.ExtendedSystem;
import com.sun.jndi.ldap.Ber;
import java.io.UnsupportedEncodingException;

public final class BerEncoder
extends Ber {
    private int curSeqIndex;
    private int[] seqOffset;
    private static final int INITIAL_SEQUENCES = 16;
    private static final int DEFAULT_BUFSIZE = 1024;
    private static final int BUF_GROWTH_FACTOR = 8;

    public BerEncoder() {
        this(1024);
    }

    public BerEncoder(int n) {
        this.buf = new byte[n];
        this.bufsize = n;
        this.offset = 0;
        this.seqOffset = new int[16];
        this.curSeqIndex = 0;
    }

    public void reset() {
        while (this.offset > 0) {
            this.buf[--this.offset] = 0;
        }
        while (this.curSeqIndex > 0) {
            this.seqOffset[--this.curSeqIndex] = 0;
        }
    }

    public int getDataLen() {
        return this.offset;
    }

    public byte[] getBuf() {
        if (this.curSeqIndex != 0) {
            throw new IllegalStateException("BER encode error: Unbalanced SEQUENCEs.");
        }
        return this.buf;
    }

    public byte[] getTrimmedBuf() {
        int n = this.getDataLen();
        byte[] byArray = new byte[n];
        System.arraycopy(this.getBuf(), 0, byArray, 0, n);
        return byArray;
    }

    public void beginSeq(int n) {
        if (this.curSeqIndex >= this.seqOffset.length) {
            int[] nArray = (int[])ExtendedSystem.newArray(Integer.TYPE, (int)(this.seqOffset.length * 2), (Object)this);
            int n2 = 0;
            while (n2 < this.seqOffset.length) {
                nArray[n2] = this.seqOffset[n2];
                ++n2;
            }
            this.seqOffset = nArray;
        }
        this.encodeByte(n);
        this.seqOffset[this.curSeqIndex] = this.offset;
        this.ensureFreeBytes(3);
        this.offset += 3;
        ++this.curSeqIndex;
    }

    public void endSeq() throws Ber.EncodeException {
        --this.curSeqIndex;
        if (this.curSeqIndex < 0) {
            throw new IllegalStateException("BER encode error: Unbalanced SEQUENCEs.");
        }
        int n = this.seqOffset[this.curSeqIndex] + 3;
        int n2 = this.offset - n;
        if (n2 <= 127) {
            this.shiftSeqData(n, n2, -2);
            this.buf[this.seqOffset[this.curSeqIndex]] = (byte)n2;
        } else if (n2 <= 255) {
            this.shiftSeqData(n, n2, -1);
            this.buf[this.seqOffset[this.curSeqIndex]] = -127;
            this.buf[this.seqOffset[this.curSeqIndex] + 1] = (byte)n2;
        } else if (n2 <= 65535) {
            this.buf[this.seqOffset[this.curSeqIndex]] = -126;
            this.buf[this.seqOffset[this.curSeqIndex] + 1] = (byte)(n2 >> 8);
            this.buf[this.seqOffset[this.curSeqIndex] + 2] = (byte)n2;
        } else if (n2 <= 0xFFFFFF) {
            this.shiftSeqData(n, n2, 1);
            this.buf[this.seqOffset[this.curSeqIndex]] = -125;
            this.buf[this.seqOffset[this.curSeqIndex] + 1] = (byte)(n2 >> 16);
            this.buf[this.seqOffset[this.curSeqIndex] + 2] = (byte)(n2 >> 8);
            this.buf[this.seqOffset[this.curSeqIndex] + 3] = (byte)n2;
        } else {
            throw new Ber.EncodeException("SEQUENCE too long");
        }
    }

    private void shiftSeqData(int n, int n2, int n3) {
        if (n3 > 0) {
            this.ensureFreeBytes(n3);
        }
        System.arraycopy(this.buf, n, this.buf, n + n3, n2);
        this.offset += n3;
    }

    public void encodeByte(int n) {
        this.ensureFreeBytes(1);
        this.buf[this.offset++] = (byte)n;
    }

    public void encodeInt(int n) {
        this.encodeInt(n, 2);
    }

    public void encodeInt(int n, int n2) {
        int n3 = -8388608;
        int n4 = 4;
        while (((n & n3) == 0 || (n & n3) == n3) && n4 > 1) {
            --n4;
            n <<= 8;
        }
        this.encodeInt(n, n2, n4);
    }

    private void encodeInt(int n, int n2, int n3) {
        if (n3 > 4) {
            throw new IllegalArgumentException("BER encode error: INTEGER too long.");
        }
        this.ensureFreeBytes(2 + n3);
        this.buf[this.offset++] = (byte)n2;
        this.buf[this.offset++] = (byte)n3;
        int n4 = -16777216;
        while (n3-- > 0) {
            this.buf[this.offset++] = (byte)((n & n4) >> 24);
            n <<= 8;
        }
    }

    public void encodeBoolean(boolean bl) {
        this.encodeBoolean(bl, 1);
    }

    public void encodeBoolean(boolean bl, int n) {
        this.ensureFreeBytes(3);
        this.buf[this.offset++] = (byte)n;
        this.buf[this.offset++] = 1;
        this.buf[this.offset++] = bl ? -1 : 0;
    }

    public void encodeString(String string, boolean bl) throws Ber.EncodeException {
        this.encodeString(string, 4, bl);
    }

    public void encodeString(String string, int n, boolean bl) throws Ber.EncodeException {
        int n2;
        this.encodeByte(n);
        int n3 = 0;
        byte[] byArray = null;
        if (string == null) {
            n2 = 0;
        } else {
            if (bl) {
                try {
                    byArray = string.getBytes("UTF8");
                    n2 = byArray.length;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new Ber.EncodeException("UTF8 not available on platform");
                }
            }
            try {
                byArray = string.getBytes("8859_1");
                n2 = byArray.length;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new Ber.EncodeException("8859_1 not available on platform");
            }
        }
        this.encodeLength(n2);
        this.ensureFreeBytes(n2);
        while (n3 < n2) {
            this.buf[this.offset++] = byArray[n3++];
        }
    }

    public void encodeOctetString(byte[] byArray, int n, int n2, int n3) throws Ber.EncodeException {
        this.encodeByte(n);
        this.encodeLength(n3);
        if (n3 > 0) {
            this.ensureFreeBytes(n3);
            System.arraycopy(byArray, n2, this.buf, this.offset, n3);
            this.offset += n3;
        }
    }

    public void encodeOctetString(byte[] byArray, int n) throws Ber.EncodeException {
        this.encodeOctetString(byArray, n, 0, byArray.length);
    }

    private void encodeLength(int n) throws Ber.EncodeException {
        this.ensureFreeBytes(4);
        if (n < 128) {
            this.buf[this.offset++] = (byte)n;
        } else if (n <= 255) {
            this.buf[this.offset++] = -127;
            this.buf[this.offset++] = (byte)n;
        } else if (n <= 65535) {
            this.buf[this.offset++] = -126;
            this.buf[this.offset++] = (byte)(n >> 8);
            this.buf[this.offset++] = (byte)(n & 0xFF);
        } else if (n <= 0xFFFFFF) {
            this.buf[this.offset++] = -125;
            this.buf[this.offset++] = (byte)(n >> 16);
            this.buf[this.offset++] = (byte)(n >> 8);
            this.buf[this.offset++] = (byte)(n & 0xFF);
        } else {
            throw new Ber.EncodeException("string too long");
        }
    }

    public void encodeStringArray(String[] stringArray, boolean bl) throws Ber.EncodeException {
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            this.encodeString(stringArray[n], bl);
            ++n;
        }
    }

    private void ensureFreeBytes(int n) {
        if (this.bufsize - this.offset < n) {
            int n2 = this.bufsize * 8;
            if (n2 - this.offset < n) {
                n2 += n;
            }
            this.buf = (byte[])ExtendedSystem.resizeArray((int)n2, (Object)this.buf, (int)0, (int)this.offset);
            this.bufsize = n2;
        }
    }
}

