/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.fips.provider;

import com.ibm.crypto.fips.provider.AlgorithmStatus;
import com.ibm.crypto.fips.provider.FIPSRuntimeException;
import com.ibm.crypto.fips.provider.SelfTest;
import com.ibm.crypto.fips.provider.j;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.security.AccessController;
import java.security.Identity;
import java.security.IdentityScope;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signer;
import java.util.Enumeration;
import java.util.Hashtable;

public class IdentityDatabase
extends IdentityScope
implements Serializable,
AlgorithmStatus {
    private static final long serialVersionUID = 4923799573357658384L;
    private static final boolean debug = false;
    private static final boolean error = true;
    File sourceFile;
    Hashtable identities = new Hashtable();

    IdentityDatabase() throws InvalidParameterException {
        this(IdentityDatabase.d("\u000e\u0011=\u0006J\u000e\u001d \u0015\u000bRZ"));
    }

    public boolean isFipsApproved() {
        return true;
    }

    public IdentityDatabase(File file) throws InvalidParameterException {
        this(file.getName());
        this.sourceFile = file;
    }

    public IdentityDatabase(String string) throws InvalidParameterException {
        super(string);
    }

    public static IdentityDatabase fromStream(InputStream inputStream) throws IOException {
        if (!SelfTest.isFipsRunnable()) {
            throw new FIPSRuntimeException();
        }
        IdentityDatabase identityDatabase = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            Object object = objectInputStream.readObject();
            if (object instanceof IdentityDatabase) {
                identityDatabase = (IdentityDatabase)object;
            } else {
                Enumeration enumeration = ((sun.security.provider.IdentityDatabase)object).identities();
                identityDatabase = new IdentityDatabase();
                while (enumeration.hasMoreElements()) {
                    try {
                        identityDatabase.addIdentity((Identity)enumeration.nextElement());
                    }
                    catch (KeyManagementException keyManagementException) {
                        throw new IOException(keyManagementException.getMessage());
                    }
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            IdentityDatabase.a(IdentityDatabase.d("(\u001c'\u0001\u0005\u000f\u001c!\u0007I\u0018T \u001dQ\\\u0016+RM\u001d\u0004>\u0017K\u0015\u001a)\\"), classNotFoundException);
            IdentityDatabase.b(IdentityDatabase.d("(\u001c+RS\u0019\u0006=\u001bJ\u0012T!\u0014\u0005\b\u001c+RA\u001d\u0000/\u0010D\u000f\u0011n\u001bV\\\u001b,\u0001J\u0010\u0011:\u0017\u000b\\7/\u001cK\u0013\u0000n\u001bK\u0015\u0000'\u0013I\u0015\u000e+\\"));
        }
        catch (InvalidClassException invalidClassException) {
            IdentityDatabase.a(IdentityDatabase.d("(\u001c'\u0001\u0005\u000f\u001c!\u0007I\u0018T \u001dQ\\\u0016+RM\u001d\u0004>\u0017K\u0015\u001a)\\"), invalidClassException);
            IdentityDatabase.b(IdentityDatabase.d(")\u001a/\u0010I\u0019T:\u001d\u0005\u0015\u001a'\u0006L\u001d\u0018'\b@\\\u00077\u0001Q\u0019\u0019n\u001bA\u0019\u001a:\u001bQ\u0005T=\u0011J\f\u0011tR\u00055\u001a8\u0013I\u0015\u0010\r\u001eD\u000f\u0007\u000b\nF\u0019\u0004:\u001bJ\u0012Znxq\u0014\u001d=RL\u000fT#\u001dV\bT\"\u001bN\u0019\u00187RA\t\u0011n\u0006J\\\u0015n\u0001@\u000e\u001d/\u001eL\u0006\u0015:\u001bJ\u0012T8\u0017W\u000f\u001d!\u001cL\u0012\u0013n\u0002W\u0013\u0016\"\u0017HFT/RF\u0010\u0015=\u0001\u0005\t\u0007+\u0016\u0005\u0015\u001an\u0019@\u0005T#\u0013K\u001d\u0013+\u001f@\u0012\u0000n\u0005D\u000fT!\u0010V\u0013\u0018+\u0006@\u0018"));
        }
        catch (StreamCorruptedException streamCorruptedException) {
            IdentityDatabase.a(IdentityDatabase.d("(\u001c+RV\u0019\u0006'\u0013I\u0015\u000e/\u0006L\u0013\u001an\u0001Q\u000e\u0011/\u001f\u0005\u0015\u0007n\u0011J\u000e\u0006;\u0002Q\u0019\u0010`Rp\u0012\u0015,\u001e@\\\u0000!RI\u0013\u0015*\\"), streamCorruptedException);
            IdentityDatabase.b(IdentityDatabase.d(")\u001a/\u0010I\u0019T:\u001d\u0005\u0015\u001a'\u0006L\u001d\u0018'\b@\\\u00077\u0001Q\u0019\u0019n\u001bA\u0019\u001a:\u001bQ\u0005T=\u0011J\f\u0011`Rv\b\u0006+\u0013H?\u001b<\u0000U\t\u0000+\u0016`\u0004\u0017+\u0002Q\u0015\u001b \\"));
        }
        if (identityDatabase == null) {
            identityDatabase = new IdentityDatabase(IdentityDatabase.d("\t\u001a'\u001cL\b\u001d/\u001eL\u0006\u0011*"));
        }
        return identityDatabase;
    }

    public static IdentityDatabase fromFile(File file) throws IOException {
        if (!SelfTest.isFipsRunnable()) {
            throw new FIPSRuntimeException();
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        IdentityDatabase identityDatabase = IdentityDatabase.fromStream(fileInputStream);
        identityDatabase.sourceFile = file;
        return identityDatabase;
    }

    public int size() {
        if (!SelfTest.isFipsRunnable()) {
            throw new FIPSRuntimeException();
        }
        return this.identities.size();
    }

    public Identity getIdentity(String string) {
        if (!SelfTest.isFipsRunnable()) {
            throw new FIPSRuntimeException();
        }
        Identity identity = (Identity)this.identities.get(string);
        if (identity instanceof Signer) {
            this.c(IdentityDatabase.d("\u001b\u0011:\\V\u0015\u0013 \u0017W"));
        }
        return identity;
    }

    public Identity getIdentity(PublicKey publicKey) {
        if (!SelfTest.isFipsRunnable()) {
            throw new FIPSRuntimeException();
        }
        if (publicKey == null) {
            return null;
        }
        Enumeration enumeration = this.identities();
        while (enumeration.hasMoreElements()) {
            Identity identity = (Identity)enumeration.nextElement();
            PublicKey publicKey2 = identity.getPublicKey();
            if (publicKey2 == null || !this.a(publicKey2, publicKey)) continue;
            if (identity instanceof Signer) {
                this.c(IdentityDatabase.d("\u001b\u0011:\\V\u0015\u0013 \u0017W"));
            }
            return identity;
        }
        return null;
    }

    private boolean a(Key key, Key key2) {
        if (key == key2) {
            return true;
        }
        return MessageDigest.isEqual(key.getEncoded(), key2.getEncoded());
    }

    public void addIdentity(Identity identity) throws KeyManagementException {
        if (!SelfTest.isFipsRunnable()) {
            throw new FIPSRuntimeException();
        }
        this.c(IdentityDatabase.d("\u001d\u0010*\\L\u0018\u0011 \u0006L\b\r"));
        Identity identity2 = this.getIdentity(identity.getName());
        Identity identity3 = this.getIdentity(identity.getPublicKey());
        String string = null;
        if (identity2 != null) {
            string = IdentityDatabase.d("\u0012\u0015#\u0017\u0005\u001f\u001b \u0014I\u0015\u0017:");
        }
        if (identity3 != null) {
            string = IdentityDatabase.d("\u0017\u00117RF\u0013\u001a(\u001eL\u001f\u0000");
        }
        if (string != null) {
            throw new KeyManagementException(string);
        }
        this.identities.put(identity.getName(), identity);
    }

    public void removeIdentity(Identity identity) throws KeyManagementException {
        if (!SelfTest.isFipsRunnable()) {
            throw new FIPSRuntimeException();
        }
        this.c(IdentityDatabase.d("\u000e\u0011#\u001dS\u0019Z'\u0016@\u0012\u0000'\u0006\\"));
        String string = identity.getName();
        if (this.identities.get(string) == null) {
            throw new KeyManagementException(IdentityDatabase.d("\b\u001c+\u0000@\\\u001d=RK\u0013T'\u0016@\u0012\u0000'\u0006\\\\\u001a/\u001f@\u0018T") + string + IdentityDatabase.d("\\\u001d R") + this);
        }
        this.identities.remove(string);
    }

    public Enumeration identities() {
        if (!SelfTest.isFipsRunnable()) {
            throw new FIPSRuntimeException();
        }
        return this.identities.elements();
    }

    void a(File file) {
        this.sourceFile = file;
    }

    File a() {
        return this.sourceFile;
    }

    public void save(OutputStream outputStream) throws IOException {
        if (!SelfTest.isFipsRunnable()) {
            throw new FIPSRuntimeException();
        }
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.flush();
        }
        catch (InvalidClassException invalidClassException) {
            IdentityDatabase.a(IdentityDatabase.d("(\u001c'\u0001\u0005\u000f\u001c!\u0007I\u0018T \u001dQ\\\u0016+RM\u001d\u0004>\u0017K\u0015\u001a)\\"), invalidClassException);
            return;
        }
    }

    void b(File file) throws IOException {
        this.a(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.save(fileOutputStream);
    }

    public void save() throws IOException {
        if (!SelfTest.isFipsRunnable()) {
            throw new FIPSRuntimeException();
        }
        if (this.sourceFile == null) {
            throw new IOException(IdentityDatabase.d("\b\u001c'\u0001\u0005\u0018\u0015:\u0013G\u001d\u0007+RM\u001d\u0007n\u001cJ\\\u0007!\u0007W\u001f\u0011n\u0014L\u0010\u0011"));
        }
        this.b(this.sourceFile);
    }

    private static File b() {
        String string = Security.getProperty(IdentityDatabase.d("\u0015\u0010+\u001cQ\u0015\u00007\\A\u001d\u0000/\u0010D\u000f\u0011"));
        if (string == null) {
            string = System.getProperty(IdentityDatabase.d("\t\u0007+\u0000\u000b\u0014\u001b#\u0017")) + File.separatorChar + IdentityDatabase.d("\u0015\u0010+\u001cQ\u0015\u00007\u0016GR\u001b,\u0018");
        }
        return new File(string);
    }

    private static void c() {
        File file = IdentityDatabase.b();
        try {
            IdentityDatabase identityDatabase;
            if (file.exists()) {
                IdentityDatabase.a(IdentityDatabase.d("\u0010\u001b/\u0016L\u0012\u0013n\u0001\\\u000f\u0000+\u001f\u0005\u0018\u0015:\u0013G\u001d\u0007+RC\u000e\u001b#RC\u0015\u0018+H\u0005") + file);
                identityDatabase = IdentityDatabase.fromFile(file);
            } else {
                identityDatabase = new IdentityDatabase(file);
            }
            IdentityScope.setSystemScope(identityDatabase);
            IdentityDatabase.a(IdentityDatabase.d("/\r=\u0006@\u0011T*\u0013Q\u001d\u0016/\u0001@\\\u001d \u001bQ\u0015\u0015\"\u001b_\u0019\u0010tR") + identityDatabase);
        }
        catch (IOException iOException) {
            IdentityDatabase.a(IdentityDatabase.d("9\u0006<\u001dW\\\u001d \u001bQ\u0015\u0015\"\u001b_\u0015\u001a)RL\u0018\u0011 \u0006L\b\rn\u0016D\b\u0015,\u0013V\u0019Nn") + file, iOException);
            return;
        }
        catch (InvalidParameterException invalidParameterException) {
            IdentityDatabase.a(IdentityDatabase.d("9\u0006<\u001dW\\\u0000<\u000bL\u0012\u0013n\u0006J\\\u001d \u0001Q\u001d\u001a:\u001bD\b\u0011n\u0013\u0005\u000f\r=\u0006@\u0011T'\u0016@\u0012\u0000'\u0006L\u0019\u0007n\u0016G\\\u001d R") + file, invalidParameterException);
            return;
        }
    }

    public String toString() {
        if (!SelfTest.isFipsRunnable()) {
            throw new FIPSRuntimeException();
        }
        return IdentityDatabase.d("\u001f\u001b#\\L\u001e\u0019`\u0011W\u0005\u0004:\u001d\u000b\u001a\u001d>\u0001\u000b\f\u0006!\u0004L\u0018\u0011<\\l\u0018\u0011 \u0006L\b\r\n\u0013Q\u001d\u0016/\u0001@PT=\u001dP\u000e\u0017+RC\u0015\u0018+H\u0005") + this.sourceFile;
    }

    private static void a(String string) {
    }

    private static void a(String string, Throwable throwable) {
    }

    private static void b(String string) {
        System.err.println(string);
    }

    void c(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            string = this.getClass().getName() + "." + string + "." + this.d();
            securityManager.checkSecurityAccess(string);
        }
    }

    String d() {
        String string = this.getName();
        if (this.getScope() != null) {
            string = string + "." + this.getScope().getName();
        }
        return string;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.c(IdentityDatabase.d("\u000f\u0011<\u001bD\u0010\u001d4\u0017\u000b\u0015\u0010+\u001cQ\u0015\u00007\\A\u001d\u0000/\u0010D\u000f\u0011"));
        objectOutputStream.writeObject(this.identities);
        objectOutputStream.writeObject(this.sourceFile);
    }

    static void e() {
        IdentityDatabase.c();
    }

    static {
        AccessController.doPrivileged(new j());
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String d(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl = true;
        block6: do {
            if (bl && !(bl = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 124;
                        break;
                    }
                    case 1: {
                        n5 = 116;
                        break;
                    }
                    case 2: {
                        n5 = 78;
                        break;
                    }
                    case 3: {
                        n5 = 114;
                        break;
                    }
                    default: {
                        n5 = 37;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

