/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm;

import java.io.File;
import java.io.PrintStream;
import java.net.URL;
import java.util.Vector;

public final class ClassLoaderDiagnosticsHelper {
    private static final PrintStream stream = System.out;

    private static String getLoaderName(ClassLoader classLoader) {
        String string = classLoader.toString();
        String string2 = null;
        try {
            string2 = string.substring(string.indexOf(36) + 1, string.indexOf(64));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return string;
        }
        return string2;
    }

    private static String normalize(String string) {
        boolean bl = false;
        if (string.startsWith("jar:")) {
            string = string.substring(4);
        }
        if (string.startsWith("file:")) {
            string = string.substring(5);
            bl = true;
        }
        if (string.endsWith("/") && string.length() > 1) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.endsWith("!")) {
            string = string.substring(0, string.length() - 1);
        }
        if (File.separatorChar == '\\') {
            if (bl && string.startsWith("/")) {
                string = string.substring(1);
            }
            string = string.replace('/', '\\');
        }
        return string;
    }

    public static void attemptingToLoadClass(ClassLoader classLoader, String string) {
        stream.println(ClassLoaderDiagnosticsHelper.getLoaderName(classLoader) + " attempting to find " + string);
    }

    public static void failedToLoadClass(ClassLoader classLoader, String string) {
        stream.println(ClassLoaderDiagnosticsHelper.getLoaderName(classLoader) + " could not find " + string + "\n");
    }

    public static void loadedClass(ClassLoader classLoader, String string) {
        stream.println(ClassLoaderDiagnosticsHelper.getLoaderName(classLoader) + " found " + string + "\n\n");
    }

    public static void showURLClassPath(ClassLoader classLoader, URL[] uRLArray) {
        Object object;
        Object object2;
        Vector vector = new Vector();
        String string = ClassLoaderDiagnosticsHelper.getLoaderName(classLoader);
        stream.print(string + " using classpath ");
        int n = 0;
        while (n < uRLArray.length) {
            object2 = ClassLoaderDiagnosticsHelper.normalize(uRLArray[n].toString());
            object = new File((String)object2);
            stream.print((String)object2);
            if (!((File)object).exists() || !((File)object).canRead()) {
                vector.addElement(object2);
            }
            if (n + 1 < uRLArray.length) {
                stream.print(File.pathSeparator);
            } else {
                stream.println("");
            }
            ++n;
        }
        object2 = vector.elements();
        while (object2.hasMoreElements()) {
            object = ClassLoaderDiagnosticsHelper.normalize(object2.nextElement().toString());
            File file = new File((String)object);
            if (!file.exists()) {
                stream.println(string + " path element " + file + " does not exist");
                continue;
            }
            if (file.canRead()) continue;
            stream.println(string + " path element " + file + " is not readable");
        }
    }

    public static void failedToLoadFrom(ClassLoader classLoader, String string, String string2) {
        stream.println(ClassLoaderDiagnosticsHelper.getLoaderName(classLoader) + " could not find " + string + " in " + ClassLoaderDiagnosticsHelper.normalize(string2));
    }

    public static void succeededLoadingFrom(ClassLoader classLoader, String string, String string2) {
        stream.println(ClassLoaderDiagnosticsHelper.getLoaderName(classLoader) + " found " + string + " in " + ClassLoaderDiagnosticsHelper.normalize(string2));
    }
}

