/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.InvalidSpannedRecordException;
import com.ibm.jvm.format.Merge;
import com.ibm.jvm.format.MessageFile;
import com.ibm.jvm.format.TraceArgs;
import com.ibm.jvm.format.TraceFile;
import com.ibm.jvm.format.TraceRecord;
import com.ibm.jvm.format.TraceThread;
import com.ibm.jvm.format.Util;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;

public final class TraceFormat {
    private TraceArgs traceArgs = null;
    private Vector traceFiles = new Vector();
    private TraceFile traceFile = null;
    private BufferedWriter out;
    private static int generations;
    protected static MessageFile messageFile;
    protected static Vector threads;
    protected static int invalidBuffers;
    protected static float verMod;
    protected static BigInteger overallStartSystem;
    protected static BigInteger overallStartPlatform;
    protected static BigInteger first;
    protected static BigInteger last;
    protected static BigInteger lastWritePlatform;
    protected static BigInteger lastWriteSystem;
    protected static BigInteger timeConversion;
    protected static String headings;
    protected static PrintStream outStream;
    protected static int expectedRecords;
    protected static final String usageMessage = "Usage: java format.TraceFormat input_filespec [output_filespec] \n\t[-summary] [ -entries:comp[(class,...),...]] [-thread:threadid,...] \n\t[-indent] [-symbolic]";
    protected static final String header = "                Trace Formatted Data ";
    private static final int FAIL = -1;
    private static final int OK = 0;

    public static void main(String[] stringArray) {
        TraceFormat traceFormat = new TraceFormat();
        traceFormat.readAndFormat(stringArray);
    }

    public TraceFormat() {
        this.initStatics();
        outStream = System.out;
    }

    public TraceFormat(String[] stringArray) {
        new TraceFormat(System.out, stringArray);
    }

    public TraceFormat(PrintStream printStream, String[] stringArray) {
        this.initStatics();
        outStream = printStream;
        this.readAndFormat(stringArray);
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            outStream.println("Error closing formatted trace file.");
        }
        catch (NullPointerException nullPointerException) {}
    }

    private void initStatics() {
        threads = new Vector();
        invalidBuffers = 0;
        overallStartSystem = BigInteger.ZERO;
        overallStartPlatform = BigInteger.ZERO;
        first = new BigInteger("FFFFFFFFFFFFFFFF", 16);
        last = BigInteger.ZERO;
        lastWritePlatform = BigInteger.ZERO;
        lastWriteSystem = BigInteger.ZERO;
        timeConversion = BigInteger.ZERO;
        headings = new String("ThreadID         TP id  Type         TraceEntry ");
        expectedRecords = 0;
        Util.initStatics();
        TraceArgs.initStatics();
        TraceRecord.initStatics();
        MessageFile.initStatics();
    }

    private void readAndFormat(String[] stringArray) {
        try {
            this.traceArgs = new TraceArgs(stringArray);
        }
        catch (TraceArgs.UsageException usageException) {
            outStream.println("TraceFormat Usage: java format.TraceFormat input_filespec [output_filespec] \n\t[-summary] [ -entries:comp[(class,...),...]] [-thread:threadid,...] \n\t[-indent] [-symbolic]");
            return;
        }
        try {
            if (this.getTraceFiles() != 0) {
                return;
            }
            String string = System.getProperty("java.home");
            string = string.concat(File.separator).concat("lib");
            String string2 = System.getProperty("ibm.dg.trc.format", string);
            outStream.println("Looking for TraceFormat.dat in " + string2);
            this.out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(TraceArgs.outputFile)));
            messageFile = new MessageFile(string2 + File.separator + "TraceFormat.dat");
            Iterator iterator = this.traceFiles.iterator();
            while (iterator.hasNext()) {
                this.traceFile = (TraceFile)iterator.next();
                this.traceFile.traceFileHeader.processTraceBufferHeaders();
            }
            Iterator iterator2 = threads.iterator();
            while (iterator2.hasNext()) {
                TraceThread traceThread = (TraceThread)iterator2.next();
                Collections.sort(traceThread);
            }
            if (TraceArgs.summary) {
                this.doSummary(new BufferedWriter(new OutputStreamWriter(outStream)));
                return;
            }
            if (this.doSummary(this.out) != 0) {
                return;
            }
            outStream.println("*** starting formatting of entries");
            this.out.write(header, 0, header.length());
            this.out.newLine();
            this.out.newLine();
            if (Integer.valueOf(Util.getProperty("POINTER_SIZE")) == 4) {
                headings = "ThreadID TP id  Type         TraceEntry ";
            }
            this.out.write(Util.getTimerDescription() + headings, 0, headings.length() + Util.getTimerDescription().length());
            this.out.newLine();
            try {
                String string3;
                Merge merge = new Merge(threads);
                String string4 = System.getProperty("line.separator");
                while ((string3 = merge.getNextEntry()) != null) {
                    this.out.write(string3 + string4);
                }
            }
            catch (InvalidSpannedRecordException invalidSpannedRecordException) {
                outStream.println("\n" + invalidSpannedRecordException.getMessage());
                return;
            }
            this.out.flush();
            outStream.println("*** formatted ");
        }
        catch (Exception exception) {
            exception.printStackTrace(outStream);
        }
    }

    protected int doSummary(BufferedWriter bufferedWriter) throws IOException {
        Object object;
        Object object2;
        bufferedWriter.write("                Trace Summary");
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        TraceFile traceFile = (TraceFile)this.traceFiles.firstElement();
        traceFile.traceFileHeader.summarize(bufferedWriter);
        bufferedWriter.write("Active Threads :");
        bufferedWriter.newLine();
        Iterator iterator = threads.iterator();
        while (iterator.hasNext()) {
            TraceThread traceThread = (TraceThread)iterator.next();
            bufferedWriter.write("        " + Long.toHexString(traceThread.threadID));
            bufferedWriter.write("  ");
            bufferedWriter.write(traceThread.threadName);
            bufferedWriter.newLine();
        }
        bufferedWriter.newLine();
        if (threads.size() == 0) {
            bufferedWriter.write("Trace file contains no trace data");
            outStream.println("Trace file contains no trace data");
            bufferedWriter.close();
            return -1;
        }
        if ((double)verMod >= 1.1) {
            object2 = lastWritePlatform.subtract(overallStartPlatform);
            object = lastWriteSystem.subtract(overallStartSystem);
            Util.Debug.println("lastWritePlatform:  " + lastWritePlatform);
            Util.Debug.println("overallStartSystem: " + overallStartSystem);
            Util.Debug.println("spanPlatform:       " + object2);
            Util.Debug.println("spanSystem:         " + object);
            timeConversion = ((BigInteger)object2).divide((BigInteger)object);
            Util.Debug.println("timeConversion:         " + timeConversion);
            bufferedWriter.write("JVM started      : " + Util.getFormattedTime(overallStartPlatform));
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            bufferedWriter.write("Last buffer write: " + Util.getFormattedTime(lastWritePlatform));
            bufferedWriter.newLine();
            bufferedWriter.newLine();
        }
        object2 = "First tracepoint:  " + Util.getFormattedTime(first);
        object = "Last tracepoint :  " + Util.getFormattedTime(last);
        bufferedWriter.write((String)object2, 0, ((String)object2).length());
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write((String)object, 0, ((String)object).length());
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.flush();
        return 0;
    }

    static final void setStartSystem(BigInteger bigInteger) {
        if (overallStartSystem.equals(BigInteger.ZERO)) {
            overallStartSystem = bigInteger;
        }
        if (overallStartSystem.compareTo(bigInteger) == -1) {
            overallStartSystem = bigInteger;
        }
    }

    static final void setStartPlatform(BigInteger bigInteger) {
        if (overallStartPlatform.equals(BigInteger.ZERO)) {
            overallStartPlatform = bigInteger;
        }
        if (overallStartPlatform.compareTo(bigInteger) == -1) {
            overallStartPlatform = bigInteger;
        }
    }

    final int getTraceFiles() {
        int n = 36;
        int n2 = TraceArgs.traceFile.indexOf("#");
        if (n2 == -1) {
            try {
                this.traceFiles.addElement(new TraceFile(TraceArgs.traceFile, "r"));
            }
            catch (FileNotFoundException fileNotFoundException) {
                outStream.println("Trace file is missing");
                return -1;
            }
            catch (Exception exception) {
                exception.printStackTrace(outStream);
                return -1;
            }
        }
        int n3 = 0;
        char c = '\u0000';
        n3 = 0;
        while (n3 < n) {
            c = Integer.toString(n3, n).toUpperCase().charAt(0);
            try {
                this.traceFiles.addElement(new TraceFile(TraceArgs.traceFile.replace('#', c), "r"));
            }
            catch (Exception exception) {
                Util.Debug.println("TraceFormat: generations found " + n3);
                break;
            }
            ++n3;
        }
        if (n3 == 0) {
            outStream.println("Trace file is missing");
            return -1;
        }
        if (n3 != generations) {
            Util.Debug.println("TraceFormat: generations = " + generations);
            outStream.println("Trace file " + TraceArgs.traceFile.replace('#', c) + " is missing");
        }
        outStream.println("Processing " + (n3 != generations ? Integer.toString(n3) : "all") + " of the " + generations + " generations specified at runtime");
        return 0;
    }

    static final void setGenerations(int n) {
        generations = n;
    }
}

