/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio.cs;

import com.ibm.nio.cs.IBMCharsetEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import sun.nio.cs.Surrogate;

class DBE_Encoder
extends IBMCharsetEncoder {
    private static final int SBCS = 1;
    private static final int DBCS = 2;
    private static final byte SO = 14;
    private static final byte SI = 15;
    private final int convertType;
    private int replaceLen;
    private int state;
    private final String ByteArray;
    private final String leftPair;
    private final String rightPair;
    private final String bytePair;
    private final int[] SurrogateArray;
    private final int numberOfSurrogates;
    private final Surrogate.Parser sgp = new Surrogate.Parser();
    private static char[] map;

    DBE_Encoder(Charset charset, byte by, byte[] byArray, String string, String string2, String string3, String string4, int[] nArray, int n, char[] cArray) {
        super(charset, 2.0f, 4.0f);
        this.ByteArray = string;
        this.leftPair = string2;
        this.rightPair = string3;
        this.bytePair = string4;
        this.SurrogateArray = nArray;
        this.numberOfSurrogates = n;
        this.convertType = by;
        int n2 = this.state = by == 2 ? 2 : 1;
        if (byArray != null) {
            this.replaceWith(byArray);
        }
        map = cArray;
    }

    public boolean isLegalReplacement(byte[] byArray) {
        if (byArray.length == 1) {
            return true;
        }
        int n = byArray[0] & 0xFF;
        int n2 = byArray[1] & 0xFF;
        if (n < 64 || n == 255) {
            return false;
        }
        if (n2 == 64 && n != 64) {
            return false;
        }
        return n2 >= 64 && n2 != 255;
    }

    public boolean canEncode(char c) {
        int n = 0xFFFF & map[c];
        if (n >= 65534) {
            return false;
        }
        switch (this.convertType) {
            default: {
                return true;
            }
            case 1: {
                return n < 256;
            }
            case 2: 
        }
        return n >= 256;
    }

    protected void implReset() {
        if (this.convertType == 0) {
            this.state = 1;
        }
    }

    protected CoderResult implFlush(ByteBuffer byteBuffer) {
        if (this.state == 2 && this.convertType == 0) {
            if (!byteBuffer.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            byteBuffer.put((byte)15);
            if (this.convertType == 0) {
                this.state = 1;
            }
        }
        return CoderResult.UNDERFLOW;
    }

    protected void implReplaceWith(byte[] byArray) {
        this.replaceLen = byArray.length;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CoderResult setForReplacement(CoderResult coderResult, ByteBuffer byteBuffer) {
        CodingErrorAction codingErrorAction = coderResult.isMalformed() ? this.malformedInputAction() : this.unmappableCharacterAction();
        if (codingErrorAction != CodingErrorAction.REPLACE) return coderResult;
        if (this.replaceLen == 1 && this.state != 1) {
            if (!byteBuffer.hasRemaining()) return CoderResult.OVERFLOW;
            byteBuffer.put((byte)15);
            return coderResult;
        } else {
            if (this.replaceLen != 2 || this.state == 2) return coderResult;
            if (!byteBuffer.hasRemaining()) return CoderResult.OVERFLOW;
            byteBuffer.put((byte)14);
            this.state = 2;
        }
        return coderResult;
    }

    /*
     * Unable to fully structure code
     */
    private CoderResult encodeArrayLoop(CharBuffer var1_1, ByteBuffer var2_2) {
        var3_3 = var1_1.array();
        var4_4 = var1_1.arrayOffset() + var1_1.position();
        var5_5 = var1_1.arrayOffset() + var1_1.limit();
        var6_6 = var2_2.array();
        var7_7 = var2_2.arrayOffset() + var2_2.position();
        var8_8 = var2_2.arrayOffset() + var2_2.limit();
        var10_9 = 0;
        var11_10 = CoderResult.UNDERFLOW;
        while (var4_4 < var5_5) {
            block23: {
                var9_11 = var3_3[var4_4];
                var12_12 = this.leftPair.indexOf(var9_11);
                var13_13 = false;
                var14_14 = false;
                if (var4_4 + 1 < var5_5 && var12_12 > -1) {
                    while (var12_12 > -1) {
                        if (this.rightPair.charAt(var12_12) == var3_3[var4_4 + 1]) {
                            var10_9 = this.bytePair.charAt(var12_12);
                            ++var4_4;
                            var13_13 = true;
                            var12_12 = -1;
                            continue;
                        }
                        var12_12 = this.leftPair.indexOf(var9_11, var12_12 + 1);
                    }
                }
                if (var13_13) break block23;
                if (!Surrogate.is(var9_11)) ** GOTO lbl63
                if (this.sgp.parse(var9_11, var3_3, var4_4, var5_5) < 0) {
                    this.sgp.error();
                    break;
                }
                var15_15 = this.numberOfSurrogates;
                var16_16 = -1;
                var17_17 = false;
                var18_18 = var15_15 / 2;
                if (this.SurrogateArray[0] == this.sgp.character()) {
                    var16_16 = 0;
                    var18_18 = 0;
                } else if (this.SurrogateArray[var15_15 - 1] == this.sgp.character()) {
                    var16_16 = var15_15 - 1;
                    var18_18 = 0;
                }
                while (var18_18 >= 1) {
                    if (this.SurrogateArray[var18_18] == this.sgp.character()) {
                        var16_16 = var18_18;
                        break;
                    }
                    if (this.SurrogateArray[var18_18] < this.sgp.character()) {
                        if ((var15_15 + var18_18) / 2 == var18_18) {
                            var18_18 = 0;
                            continue;
                        }
                        var18_18 = (var15_15 + var18_18) / 2;
                        continue;
                    }
                    if (this.SurrogateArray[var18_18] <= this.sgp.character()) continue;
                    var15_15 = var18_18;
                    var18_18 = var15_15 / 2;
                }
                if (var16_16 >= 0) {
                    var10_9 = this.ByteArray.charAt(var16_16);
                    ++var4_4;
                    var14_14 = true;
                } else {
                    this.sgp.unmappableResult();
                    break;
lbl63:
                    // 1 sources

                    var10_9 = 65535 & DBE_Encoder.map[var9_11];
                    if (var10_9 >= 65534) {
                        var11_10 = CoderResult.unmappableForLength(1);
                        break;
                    }
                }
            }
            if (this.state == 2 && var10_9 < 256) {
                if (var8_8 - var7_7 < 1) {
                    var11_10 = CoderResult.OVERFLOW;
                    break;
                }
                this.state = 1;
                var6_6[var7_7++] = 15;
            } else if (this.state == 1 && var10_9 >= 256) {
                if (var8_8 - var7_7 < 1) {
                    var11_10 = CoderResult.OVERFLOW;
                    break;
                }
                var6_6[var7_7++] = 14;
                this.state = 2;
            }
            if (var8_8 - var7_7 < this.state) {
                var11_10 = CoderResult.OVERFLOW;
                break;
            }
            if (this.state == 2 || var13_13 || var14_14) {
                var6_6[var7_7++] = (byte)(var10_9 >> 8);
            }
            var6_6[var7_7++] = (byte)var10_9;
            ++var4_4;
        }
        var1_1.position(var4_4 - var1_1.arrayOffset());
        var2_2.position(var7_7 - var2_2.arrayOffset());
        if (var11_10.isError() && this.convertType == 0) {
            var11_10 = this.setForReplacement(var11_10, var2_2);
        }
        return var11_10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        CoderResult coderResult;
        int n;
        block29: {
            CoderResult coderResult2;
            block37: {
                CoderResult coderResult3;
                block36: {
                    CoderResult coderResult4;
                    block35: {
                        CoderResult coderResult5;
                        block34: {
                            CoderResult coderResult6;
                            block33: {
                                CoderResult coderResult7;
                                block32: {
                                    CoderResult coderResult8;
                                    n = charBuffer.position();
                                    int n2 = 0;
                                    boolean bl = false;
                                    try {
                                        while (true) {
                                            boolean bl2;
                                            block40: {
                                                block38: {
                                                    block39: {
                                                        block31: {
                                                            int n3;
                                                            int n4;
                                                            if (!charBuffer.hasRemaining()) {
                                                                coderResult = CoderResult.UNDERFLOW;
                                                                break block29;
                                                            }
                                                            char c = charBuffer.get();
                                                            int n5 = this.leftPair.indexOf(c);
                                                            bl2 = false;
                                                            boolean bl3 = false;
                                                            if (charBuffer.hasRemaining() && n5 > -1) {
                                                                n4 = charBuffer.position();
                                                                n3 = charBuffer.get();
                                                                while (true) {
                                                                    if (n5 <= -1) {
                                                                        if (bl2) break;
                                                                        charBuffer.position(n4);
                                                                        break;
                                                                    }
                                                                    if (this.rightPair.charAt(n5) == n3) {
                                                                        n2 = this.bytePair.charAt(n5);
                                                                        bl2 = true;
                                                                        ++n;
                                                                        n5 = -1;
                                                                        continue;
                                                                    }
                                                                    n5 = this.leftPair.indexOf(c, n5 + 1);
                                                                }
                                                            }
                                                            if (!bl2) {
                                                                if (Surrogate.is(c)) {
                                                                    if (this.sgp.parse(c, charBuffer) < 0) {
                                                                        coderResult8 = this.setForReplacement(this.sgp.error(), byteBuffer);
                                                                        Object var17_22 = null;
                                                                        break;
                                                                    }
                                                                    n4 = this.numberOfSurrogates;
                                                                    n3 = -1;
                                                                    boolean bl4 = false;
                                                                    int n6 = n4 / 2;
                                                                    if (this.SurrogateArray[0] == this.sgp.character()) {
                                                                        n3 = 0;
                                                                        n6 = 0;
                                                                    } else if (this.SurrogateArray[n4 - 1] == this.sgp.character()) {
                                                                        n3 = n4 - 1;
                                                                        n6 = 0;
                                                                    }
                                                                    while (n6 >= 1) {
                                                                        if (this.SurrogateArray[n6] == this.sgp.character()) {
                                                                            n3 = n6;
                                                                            break;
                                                                        }
                                                                        if (this.SurrogateArray[n6] < this.sgp.character()) {
                                                                            if ((n4 + n6) / 2 == n6) {
                                                                                n6 = 0;
                                                                                continue;
                                                                            }
                                                                            n6 = (n4 + n6) / 2;
                                                                            continue;
                                                                        }
                                                                        if (this.SurrogateArray[n6] <= this.sgp.character()) continue;
                                                                        n4 = n6;
                                                                        n6 = n4 / 2;
                                                                    }
                                                                    if (n3 >= 0) {
                                                                        n2 = this.ByteArray.charAt(n3);
                                                                        ++n;
                                                                        bl3 = true;
                                                                        break block31;
                                                                    } else {
                                                                        CoderResult coderResult9 = this.setForReplacement(this.sgp.unmappableResult(), byteBuffer);
                                                                        Object var17_23 = null;
                                                                        charBuffer.position(n);
                                                                        return coderResult9;
                                                                    }
                                                                }
                                                                n2 = 0xFFFF & map[c];
                                                                if (n2 >= 65534) {
                                                                    coderResult7 = this.setForReplacement(CoderResult.unmappableForLength(1), byteBuffer);
                                                                    break block32;
                                                                }
                                                            }
                                                        }
                                                        if (this.convertType != 0) break block38;
                                                        if (this.state != 2 || n2 >= 256) break block39;
                                                        if (!byteBuffer.hasRemaining()) {
                                                            coderResult6 = CoderResult.OVERFLOW;
                                                            break block33;
                                                        }
                                                        this.state = 1;
                                                        byteBuffer.put((byte)15);
                                                        break block40;
                                                    }
                                                    if (this.state != 1 || n2 < 256) break block40;
                                                    if (!byteBuffer.hasRemaining()) {
                                                        coderResult5 = CoderResult.OVERFLOW;
                                                        break block34;
                                                    }
                                                    this.state = 2;
                                                    byteBuffer.put((byte)14);
                                                    break block40;
                                                }
                                                if (this.convertType == 1) {
                                                    if (n2 >= 256) {
                                                        coderResult4 = CoderResult.unmappableForLength(1);
                                                        break block35;
                                                    }
                                                } else if (n2 < 256) {
                                                    coderResult3 = this.setForReplacement(CoderResult.unmappableForLength(1), byteBuffer);
                                                    break block36;
                                                }
                                            }
                                            if (byteBuffer.remaining() < this.state) {
                                                coderResult2 = CoderResult.OVERFLOW;
                                                break block37;
                                            }
                                            if (this.state == 2 || bl2) {
                                                byteBuffer.put((byte)(n2 >> 8));
                                            }
                                            byteBuffer.put((byte)n2);
                                            ++n;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        Object var17_31 = null;
                                        charBuffer.position(n);
                                        throw throwable;
                                    }
                                    charBuffer.position(n);
                                    return coderResult8;
                                }
                                Object var17_24 = null;
                                charBuffer.position(n);
                                return coderResult7;
                            }
                            Object var17_25 = null;
                            charBuffer.position(n);
                            return coderResult6;
                        }
                        Object var17_26 = null;
                        charBuffer.position(n);
                        return coderResult5;
                    }
                    Object var17_27 = null;
                    charBuffer.position(n);
                    return coderResult4;
                }
                Object var17_28 = null;
                charBuffer.position(n);
                return coderResult3;
            }
            Object var17_29 = null;
            charBuffer.position(n);
            return coderResult2;
        }
        Object var17_30 = null;
        charBuffer.position(n);
        return coderResult;
    }

    protected final CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        if (this.convertType == 0 && charBuffer.hasArray() && byteBuffer.hasArray() && !IBMCharsetEncoder.UseBuffer) {
            return this.encodeArrayLoop(charBuffer, byteBuffer);
        }
        return this.encodeBufferLoop(charBuffer, byteBuffer);
    }
}

