/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio.cs;

import com.ibm.nio.cs.IBMCharsetDecoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;
import java.security.AccessController;
import sun.nio.cs.Surrogate;
import sun.security.action.GetPropertyAction;

class UTF16Decoder
extends IBMCharsetDecoder {
    protected static final char BYTE_ORDER_MARK = '\ufeff';
    protected static final char REVERSED_MARK = '\ufffe';
    protected static final int NONE = 0;
    protected static final int BIG = 2;
    protected static final int LITTLE = 1;
    private final int expectedByteOrder;
    private int currentByteOrder;
    private final Surrogate.Generator sgg = new Surrogate.Generator();

    public UTF16Decoder(Charset charset, int n) {
        super(charset, 1.0f, 1.0f);
        this.expectedByteOrder = this.currentByteOrder = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        CoderResult coderResult;
        int n;
        block9: {
            Object object;
            block11: {
                n = byteBuffer.position();
                try {
                    while (true) {
                        char c;
                        if (byteBuffer.remaining() <= 1) {
                            coderResult = CoderResult.UNDERFLOW;
                            break block9;
                        }
                        int n2 = byteBuffer.get() & 0xFF;
                        int n3 = byteBuffer.get() & 0xFF;
                        if (this.currentByteOrder == 0) {
                            c = (char)(n2 << 8 | n3);
                            if (c == '\ufeff') {
                                this.currentByteOrder = 2;
                                n += 2;
                                continue;
                            }
                            if (c == '\ufffe') {
                                this.currentByteOrder = 1;
                                n += 2;
                                continue;
                            }
                            object = (String)AccessController.doPrivileged(new GetPropertyAction("sun.io.unicode.encoding", "UnicodeBig"));
                            this.currentByteOrder = ((String)object).equals("UnicodeLittle") ? 1 : 2;
                        }
                        if ((c = this.currentByteOrder == 2 ? (char)(n2 << 8 | n3) : (char)(n3 << 8 | n2)) == '\ufffe') {
                            object = CoderResult.malformedForLength(2);
                            Object var9_9 = null;
                            break;
                        }
                        if (!charBuffer.hasRemaining()) {
                            object = CoderResult.OVERFLOW;
                            break block11;
                        }
                        charBuffer.put(c);
                        n += 2;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_12 = null;
                    byteBuffer.position(n);
                    throw throwable;
                }
                byteBuffer.position(n);
                return object;
            }
            Object var9_10 = null;
            byteBuffer.position(n);
            return object;
        }
        Object var9_11 = null;
        byteBuffer.position(n);
        return coderResult;
    }

    protected void implReset() {
        this.currentByteOrder = this.expectedByteOrder;
    }
}

