/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.jvm.ExtendedSystem;

class FloatingDecimal {
    boolean isExceptional;
    boolean isNegative;
    int decExponent;
    char[] digits;
    int nDigits;
    int bigIntExp;
    int bigIntNBits;
    boolean mustSetRoundDir;
    int roundDir;
    static final long signMask = Long.MIN_VALUE;
    static final long expMask = 0x7FF0000000000000L;
    static final long fractMask = 0xFFFFFFFFFFFFFL;
    static final int expShift = 52;
    static final int expBias = 1023;
    static final long fractHOB = 0x10000000000000L;
    static final long expOne = 0x3FF0000000000000L;
    static final int maxSmallBinExp = 62;
    static final int minSmallBinExp = -21;
    static final int maxDecimalDigits = 15;
    static final int maxDecimalExponent = 308;
    static final int minDecimalExponent = -324;
    static final int bigDecimalExponent = 324;
    static final long highbyte = -72057594037927936L;
    static final long highbit = Long.MIN_VALUE;
    static final long lowbytes = 0xFFFFFFFFFFFFFFL;
    static final int singleSignMask = Integer.MIN_VALUE;
    static final int singleExpMask = 2139095040;
    static final int singleFractMask = 0x7FFFFF;
    static final int singleExpShift = 23;
    static final int singleFractHOB = 0x800000;
    static final int singleExpBias = 127;
    static final int singleMaxDecimalDigits = 7;
    static final int singleMaxDecimalExponent = 38;
    static final int singleMinDecimalExponent = -45;
    static final int intDecimalDigits = 9;
    private static FDBigInt[] b5p;
    private static ThreadLocal perThreadBuffer;
    private static final double[] small10pow;
    private static final float[] singleSmall10pow;
    private static final double[] big10pow;
    private static final double[] tiny10pow;
    private static final int maxSmallTen;
    private static final int singleMaxSmallTen;
    private static final int[] small5pow;
    private static final long[] long5pow;
    private static final int[] n5bits;
    private static final char[] infinity;
    private static final char[] notANumber;
    private static final char[] zero;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$lang$FloatingDecimal;

    private FloatingDecimal(boolean bl, int n, char[] cArray, int n2, boolean bl2) {
        this.mustSetRoundDir = false;
        this.isNegative = bl;
        this.isExceptional = bl2;
        this.decExponent = n;
        this.digits = cArray;
        this.nDigits = n2;
    }

    /*
     * Unable to fully structure code
     */
    private static int countBits(long var0) {
        if (var0 != 0L) ** GOTO lbl4
        return 0;
lbl-1000:
        // 1 sources

        {
            var0 <<= 8;
lbl4:
            // 2 sources

            ** while ((var0 & -72057594037927936L) == 0L)
        }
lbl5:
        // 2 sources

        while (var0 > 0L) {
            var0 <<= 1;
        }
        var2_1 = 0;
        while ((var0 & 0xFFFFFFFFFFFFFFL) != 0L) {
            var0 <<= 8;
            var2_1 += 8;
        }
        while (var0 != 0L) {
            var0 <<= 1;
            ++var2_1;
        }
        return var2_1;
    }

    private static synchronized FDBigInt big5pow(int n) {
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError(n);
        }
        if (b5p == null) {
            b5p = new FDBigInt[n + 1];
        } else if (b5p.length <= n) {
            FDBigInt[] fDBigIntArray = new FDBigInt[n + 1];
            System.arraycopy(b5p, 0, fDBigIntArray, 0, b5p.length);
            b5p = fDBigIntArray;
        }
        if (b5p[n] != null) {
            return b5p[n];
        }
        if (n < small5pow.length) {
            FloatingDecimal.b5p[n] = new FDBigInt(small5pow[n]);
            return FloatingDecimal.b5p[n];
        }
        if (n < long5pow.length) {
            FloatingDecimal.b5p[n] = new FDBigInt(long5pow[n]);
            return FloatingDecimal.b5p[n];
        }
        int n2 = n >> 1;
        int n3 = n - n2;
        FDBigInt fDBigInt = b5p[n2];
        if (fDBigInt == null) {
            fDBigInt = FloatingDecimal.big5pow(n2);
        }
        if (n3 < small5pow.length) {
            FloatingDecimal.b5p[n] = fDBigInt.mult(small5pow[n3]);
            return FloatingDecimal.b5p[n];
        }
        FDBigInt fDBigInt2 = b5p[n3];
        if (fDBigInt2 == null) {
            fDBigInt2 = FloatingDecimal.big5pow(n3);
        }
        FloatingDecimal.b5p[n] = fDBigInt.mult(fDBigInt2);
        return FloatingDecimal.b5p[n];
    }

    private static FDBigInt multPow52(FDBigInt fDBigInt, int n, int n2) {
        if (n != 0) {
            fDBigInt = n < small5pow.length ? fDBigInt.mult(small5pow[n]) : fDBigInt.mult(FloatingDecimal.big5pow(n));
        }
        if (n2 != 0) {
            fDBigInt.lshiftMe(n2);
        }
        return fDBigInt;
    }

    private static FDBigInt constructPow52(int n, int n2) {
        FDBigInt fDBigInt = new FDBigInt(FloatingDecimal.big5pow(n));
        if (n2 != 0) {
            fDBigInt.lshiftMe(n2);
        }
        return fDBigInt;
    }

    private FDBigInt doubleToBigInt(double d) {
        long l = Double.doubleToLongBits(d) & Long.MAX_VALUE;
        int n = (int)(l >>> 52);
        l &= 0xFFFFFFFFFFFFFL;
        if (n > 0) {
            l |= 0x10000000000000L;
        } else {
            if (!$assertionsDisabled && l == 0L) {
                throw new AssertionError(l);
            }
            ++n;
            while ((l & 0x10000000000000L) == 0L) {
                l <<= 1;
                --n;
            }
        }
        int n2 = FloatingDecimal.countBits(l);
        int n3 = 53 - n2;
        this.bigIntExp = (n -= 1023) + 1 - n2;
        this.bigIntNBits = n2;
        return new FDBigInt(l >>>= n3);
    }

    private static double ulp(double d, boolean bl) {
        long l = Double.doubleToLongBits(d) & Long.MAX_VALUE;
        int n = (int)(l >>> 52);
        if (bl && n >= 52 && (l & 0xFFFFFFFFFFFFFL) == 0L) {
            --n;
        }
        double d2 = n > 52 ? Double.longBitsToDouble((long)(n - 52) << 52) : (n == 0 ? Double.MIN_VALUE : Double.longBitsToDouble(1L << n - 1));
        if (bl) {
            d2 = -d2;
        }
        return d2;
    }

    float stickyRound(double d) {
        long l = Double.doubleToLongBits(d);
        long l2 = l & 0x7FF0000000000000L;
        if (l2 == 0L || l2 == 0x7FF0000000000000L) {
            return (float)d;
        }
        return (float)Double.longBitsToDouble(l += (long)this.roundDir);
    }

    private void developLongDigits(int n, long l, long l2) {
        int n2;
        char[] cArray;
        int n3;
        int n4 = 0;
        while (l2 >= 10L) {
            l2 /= 10L;
            ++n4;
        }
        if (n4 != 0) {
            long l3 = long5pow[n4] << n4;
            long l4 = l % l3;
            l /= l3;
            n += n4;
            if (l4 >= l3 >> 1) {
                ++l;
            }
        }
        if (l <= Integer.MAX_VALUE) {
            if (!$assertionsDisabled && l <= 0L) {
                throw new AssertionError(l);
            }
            int n5 = (int)l;
            n3 = 10;
            cArray = (char[])perThreadBuffer.get();
            n2 = n3 - 1;
            int n6 = n5 % 10;
            n5 /= 10;
            while (n6 == 0) {
                ++n;
                n6 = n5 % 10;
                n5 /= 10;
            }
            while (n5 != 0) {
                cArray[n2--] = (char)(n6 + 48);
                ++n;
                n6 = n5 % 10;
                n5 /= 10;
            }
            cArray[n2] = (char)(n6 + 48);
        } else {
            n3 = 20;
            cArray = (char[])perThreadBuffer.get();
            n2 = n3 - 1;
            int n7 = (int)(l % 10L);
            l /= 10L;
            while (n7 == 0) {
                ++n;
                n7 = (int)(l % 10L);
                l /= 10L;
            }
            while (l != 0L) {
                cArray[n2--] = (char)(n7 + 48);
                ++n;
                n7 = (int)(l % 10L);
                l /= 10L;
            }
            cArray[n2] = (char)(n7 + 48);
        }
        char[] cArray2 = (char[])ExtendedSystem.newArray(Character.TYPE, n3 -= n2, this);
        System.arraycopy(cArray, n2, cArray2, 0, n3);
        this.digits = cArray2;
        this.decExponent = n + 1;
        this.nDigits = n3;
    }

    private void roundup() {
        int n = this.nDigits - 1;
        char c = this.digits[n];
        if (c == '9') {
            while (c == '9' && n > 0) {
                this.digits[n] = 48;
                c = this.digits[--n];
            }
            if (c == '9') {
                ++this.decExponent;
                this.digits[0] = 49;
                return;
            }
        }
        this.digits[n] = (char)(c + '\u0001');
    }

    /*
     * Unable to fully structure code
     */
    public FloatingDecimal(double var1_1) {
        block7: {
            block6: {
                super();
                this.mustSetRoundDir = false;
                var3_2 = Double.doubleToLongBits(var1_1);
                if ((var3_2 & -9223372036854775808L) != 0L) {
                    this.isNegative = true;
                    var3_2 ^= -9223372036854775808L;
                } else {
                    this.isNegative = false;
                }
                var7_3 = (int)((var3_2 & 0x7FF0000000000000L) >> 52);
                var5_4 = var3_2 & 0xFFFFFFFFFFFFFL;
                if (var7_3 == 2047) {
                    this.isExceptional = true;
                    if (var5_4 == 0L) {
                        this.digits = FloatingDecimal.infinity;
                    } else {
                        this.digits = FloatingDecimal.notANumber;
                        this.isNegative = false;
                    }
                    this.nDigits = this.digits.length;
                    return;
                }
                this.isExceptional = false;
                if (var7_3 != 0) break block6;
                if (var5_4 != 0L) ** GOTO lbl29
                this.decExponent = 0;
                this.digits = FloatingDecimal.zero;
                this.nDigits = 1;
                return;
lbl-1000:
                // 1 sources

                {
                    var5_4 <<= 1;
                    --var7_3;
lbl29:
                    // 2 sources

                    ** while ((var5_4 & 0x10000000000000L) == 0L)
                }
lbl30:
                // 1 sources

                var8_5 = 52 + var7_3 + 1;
                ++var7_3;
                break block7;
            }
            var5_4 |= 0x10000000000000L;
            var8_5 = 53;
        }
        this.dtoa(var7_3 -= 1023, var5_4, var8_5);
    }

    /*
     * Unable to fully structure code
     */
    public FloatingDecimal(float var1_1) {
        block7: {
            block6: {
                super();
                this.mustSetRoundDir = false;
                var2_2 = Float.floatToIntBits(var1_1);
                if ((var2_2 & -2147483648) != 0) {
                    this.isNegative = true;
                    var2_2 ^= -2147483648;
                } else {
                    this.isNegative = false;
                }
                var4_3 = (var2_2 & 2139095040) >> 23;
                var3_4 = var2_2 & 0x7FFFFF;
                if (var4_3 == 255) {
                    this.isExceptional = true;
                    if ((long)var3_4 == 0L) {
                        this.digits = FloatingDecimal.infinity;
                    } else {
                        this.digits = FloatingDecimal.notANumber;
                        this.isNegative = false;
                    }
                    this.nDigits = this.digits.length;
                    return;
                }
                this.isExceptional = false;
                if (var4_3 != 0) break block6;
                if (var3_4 != 0) ** GOTO lbl29
                this.decExponent = 0;
                this.digits = FloatingDecimal.zero;
                this.nDigits = 1;
                return;
lbl-1000:
                // 1 sources

                {
                    var3_4 <<= 1;
                    --var4_3;
lbl29:
                    // 2 sources

                    ** while ((var3_4 & 0x800000) == 0)
                }
lbl30:
                // 1 sources

                var5_5 = 23 + var4_3 + 1;
                ++var4_3;
                break block7;
            }
            var3_4 |= 0x800000;
            var5_5 = 24;
        }
        this.dtoa(var4_3 -= 127, (long)var3_4 << 29, var5_5);
    }

    private void dtoa(int n, long l, int n2) {
        long l2;
        boolean bl;
        boolean bl2;
        int n3 = FloatingDecimal.countBits(l);
        int n4 = Math.max(0, n3 - n - 1);
        if (n <= 62 && n >= -21 && n4 < long5pow.length && n3 + n5bits[n4] < 64 && n4 == 0) {
            long l3 = n > n2 ? 1L << n - n2 - 1 : 0L;
            l = n >= 52 ? (l <<= n - 52) : (l >>>= 52 - n);
            this.developLongDigits(0, l, l3);
            return;
        }
        double d = Double.longBitsToDouble(0x3FF0000000000000L | l & 0xFFEFFFFFFFFFFFFFL);
        int n5 = (int)Math.floor((d - 1.5) * 0.289529654 + 0.176091259 + (double)n * 0.301029995663981);
        int n6 = Math.max(0, -n5);
        int n7 = n6 + n4 + n;
        int n8 = Math.max(0, n5);
        int n9 = n8 + n4;
        int n10 = n6;
        int n11 = n7 - n2;
        l >>>= 53 - n3;
        int n12 = Math.min(n7 -= n3 - 1, n9);
        n7 -= n12;
        n9 -= n12;
        n11 -= n12;
        if (n3 == 1) {
            --n11;
        }
        if (n11 < 0) {
            n7 -= n11;
            n9 -= n11;
            n11 = 0;
        }
        this.digits = new char[18];
        char[] cArray = this.digits;
        int n13 = 0;
        int n14 = n3 + n7 + (n6 < n5bits.length ? n5bits[n6] : n6 * 3);
        int n15 = n9 + 1 + (n8 + 1 < n5bits.length ? n5bits[n8 + 1] : (n8 + 1) * 3);
        if (n14 < 64 && n15 < 64) {
            if (n14 < 32 && n15 < 32) {
                int n16 = (int)l * small5pow[n6] << n7;
                int n17 = small5pow[n8] << n9;
                int n18 = small5pow[n10] << n11;
                int n19 = n17 * 10;
                n13 = 0;
                int n20 = n16 / n17;
                bl2 = (n16 = 10 * (n16 % n17)) < (n18 *= 10);
                boolean bl3 = bl = n16 + n18 > n19;
                if (!$assertionsDisabled && n20 >= 10) {
                    throw new AssertionError(n20);
                }
                if (n20 == 0 && !bl) {
                    --n5;
                } else {
                    cArray[n13++] = (char)(48 + n20);
                }
                if (n5 <= -3 || n5 >= 8) {
                    bl2 = false;
                    bl = false;
                }
                while (!bl2 && !bl) {
                    n20 = n16 / n17;
                    n16 = 10 * (n16 % n17);
                    n18 *= 10;
                    if (!$assertionsDisabled && n20 >= 10) {
                        throw new AssertionError(n20);
                    }
                    if ((long)n18 > 0L) {
                        bl2 = n16 < n18;
                        bl = n16 + n18 > n19;
                    } else {
                        bl2 = true;
                        bl = true;
                    }
                    cArray[n13++] = (char)(48 + n20);
                }
                l2 = (n16 << 1) - n19;
            } else {
                long l4 = l * long5pow[n6] << n7;
                long l5 = long5pow[n8] << n9;
                long l6 = long5pow[n10] << n11;
                long l7 = l5 * 10L;
                n13 = 0;
                int n21 = (int)(l4 / l5);
                bl2 = (l4 = 10L * (l4 % l5)) < (l6 *= 10L);
                boolean bl4 = bl = l4 + l6 > l7;
                if (!$assertionsDisabled && n21 >= 10) {
                    throw new AssertionError(n21);
                }
                if (n21 == 0 && !bl) {
                    --n5;
                } else {
                    cArray[n13++] = (char)(48 + n21);
                }
                if (n5 <= -3 || n5 >= 8) {
                    bl2 = false;
                    bl = false;
                }
                while (!bl2 && !bl) {
                    n21 = (int)(l4 / l5);
                    l4 = 10L * (l4 % l5);
                    l6 *= 10L;
                    if (!$assertionsDisabled && n21 >= 10) {
                        throw new AssertionError(n21);
                    }
                    if (l6 > 0L) {
                        bl2 = l4 < l6;
                        bl = l4 + l6 > l7;
                    } else {
                        bl2 = true;
                        bl = true;
                    }
                    cArray[n13++] = (char)(48 + n21);
                }
                l2 = (l4 << 1) - l7;
            }
        } else {
            FDBigInt fDBigInt = FloatingDecimal.multPow52(new FDBigInt(l), n6, n7);
            FDBigInt fDBigInt2 = FloatingDecimal.constructPow52(n8, n9);
            FDBigInt fDBigInt3 = FloatingDecimal.constructPow52(n10, n11);
            int n22 = fDBigInt2.normalizeMe();
            fDBigInt.lshiftMe(n22);
            fDBigInt3.lshiftMe(n22);
            FDBigInt fDBigInt4 = fDBigInt2.mult(10);
            n13 = 0;
            int n23 = fDBigInt.quoRemIteration(fDBigInt2);
            fDBigInt3 = fDBigInt3.mult(10);
            bl2 = fDBigInt.cmp(fDBigInt3) < 0;
            boolean bl5 = bl = fDBigInt.add(fDBigInt3).cmp(fDBigInt4) > 0;
            if (!$assertionsDisabled && n23 >= 10) {
                throw new AssertionError(n23);
            }
            if (n23 == 0 && !bl) {
                --n5;
            } else {
                cArray[n13++] = (char)(48 + n23);
            }
            if (n5 <= -3 || n5 >= 8) {
                bl2 = false;
                bl = false;
            }
            while (!bl2 && !bl) {
                n23 = fDBigInt.quoRemIteration(fDBigInt2);
                fDBigInt3 = fDBigInt3.mult(10);
                if (!$assertionsDisabled && n23 >= 10) {
                    throw new AssertionError(n23);
                }
                bl2 = fDBigInt.cmp(fDBigInt3) < 0;
                bl = fDBigInt.add(fDBigInt3).cmp(fDBigInt4) > 0;
                cArray[n13++] = (char)(48 + n23);
            }
            if (bl && bl2) {
                fDBigInt.lshiftMe(1);
                l2 = fDBigInt.cmp(fDBigInt4);
            } else {
                l2 = 0L;
            }
        }
        this.decExponent = n5 + 1;
        this.digits = cArray;
        this.nDigits = n13;
        if (bl) {
            if (bl2) {
                if (l2 == 0L) {
                    if ((cArray[this.nDigits - 1] & '\u0001') != 0) {
                        this.roundup();
                    }
                } else if (l2 > 0L) {
                    this.roundup();
                }
            } else {
                this.roundup();
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.nDigits + 8);
        if (this.isNegative) {
            stringBuffer.append('-');
        }
        if (this.isExceptional) {
            stringBuffer.append(this.digits, 0, this.nDigits);
        } else {
            stringBuffer.append("0.");
            stringBuffer.append(this.digits, 0, this.nDigits);
            stringBuffer.append('e');
            stringBuffer.append(this.decExponent);
        }
        return new String(stringBuffer);
    }

    public String toJavaFormatString() {
        char[] cArray = (char[])perThreadBuffer.get();
        int n = this.getChars(cArray);
        return new String(cArray, 0, n);
    }

    private int getChars(char[] cArray) {
        if (!$assertionsDisabled && this.nDigits > 19) {
            throw new AssertionError(this.nDigits);
        }
        int n = 0;
        if (this.isNegative) {
            cArray[0] = 45;
            n = 1;
        }
        if (this.isExceptional) {
            System.arraycopy(this.digits, 0, cArray, n, this.nDigits);
            n += this.nDigits;
        } else if (this.decExponent > 0 && this.decExponent < 8) {
            int n2 = Math.min(this.nDigits, this.decExponent);
            System.arraycopy(this.digits, 0, cArray, n, n2);
            n += n2;
            if (n2 < this.decExponent) {
                n2 = this.decExponent - n2;
                System.arraycopy(zero, 0, cArray, n, n2);
                n += n2;
                cArray[n++] = 46;
                cArray[n++] = 48;
            } else {
                cArray[n++] = 46;
                if (n2 < this.nDigits) {
                    int n3 = this.nDigits - n2;
                    System.arraycopy(this.digits, n2, cArray, n, n3);
                    n += n3;
                } else {
                    cArray[n++] = 48;
                }
            }
        } else if (this.decExponent <= 0 && this.decExponent > -3) {
            cArray[n++] = 48;
            cArray[n++] = 46;
            if (this.decExponent != 0) {
                System.arraycopy(zero, 0, cArray, n, -this.decExponent);
                n -= this.decExponent;
            }
            System.arraycopy(this.digits, 0, cArray, n, this.nDigits);
            n += this.nDigits;
        } else {
            int n4;
            cArray[n++] = this.digits[0];
            cArray[n++] = 46;
            if (this.nDigits > 1) {
                System.arraycopy(this.digits, 1, cArray, n, this.nDigits - 1);
                n += this.nDigits - 1;
            } else {
                cArray[n++] = 48;
            }
            cArray[n++] = 69;
            if (this.decExponent <= 0) {
                cArray[n++] = 45;
                n4 = -this.decExponent + 1;
            } else {
                n4 = this.decExponent - 1;
            }
            if (n4 <= 9) {
                cArray[n++] = (char)(n4 + 48);
            } else if (n4 <= 99) {
                cArray[n++] = (char)(n4 / 10 + 48);
                cArray[n++] = (char)(n4 % 10 + 48);
            } else {
                cArray[n++] = (char)(n4 / 100 + 48);
                cArray[n++] = (char)((n4 %= 100) / 10 + 48);
                cArray[n++] = (char)(n4 % 10 + 48);
            }
        }
        return n;
    }

    void appendTo(StringBuffer stringBuffer) {
        char[] cArray = (char[])perThreadBuffer.get();
        int n = this.getChars(cArray);
        stringBuffer.append(cArray, 0, n);
    }

    public static FloatingDecimal readJavaFormatString(String string) throws NumberFormatException {
        block35: {
            boolean bl = false;
            boolean bl2 = false;
            try {
                string = string.trim();
                int n = string.length();
                if (n == 0) {
                    throw new NumberFormatException("empty String");
                }
                int n2 = 0;
                char c = string.charAt(n2);
                switch (c) {
                    case '-': {
                        bl = true;
                    }
                    case '+': {
                        ++n2;
                        bl2 = true;
                    }
                }
                c = string.charAt(n2);
                if (c == 'N' || c == 'I') {
                    boolean bl3 = false;
                    char[] cArray = null;
                    if (c == 'N') {
                        cArray = notANumber;
                        bl3 = true;
                    } else {
                        cArray = infinity;
                    }
                    int n3 = 0;
                    while (n2 < n && n3 < cArray.length) {
                        if (string.charAt(n2) == cArray[n3]) {
                            ++n2;
                            ++n3;
                            continue;
                        }
                        break block35;
                    }
                    if (n3 == cArray.length && n2 == n) {
                        return bl3 ? new FloatingDecimal(Double.NaN) : new FloatingDecimal(bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
                    }
                    break block35;
                }
                char[] cArray = new char[n];
                int n4 = 0;
                boolean bl4 = false;
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                block19: while (n2 < n) {
                    c = string.charAt(n2);
                    switch (c) {
                        case '0': {
                            if (n4 > 0) {
                                ++n7;
                                break;
                            }
                            ++n6;
                            break;
                        }
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            while (n7 > 0) {
                                cArray[n4++] = 48;
                                --n7;
                            }
                            cArray[n4++] = c;
                            break;
                        }
                        case '.': {
                            if (bl4) {
                                throw new NumberFormatException("multiple points");
                            }
                            n5 = n2;
                            if (bl2) {
                                --n5;
                            }
                            bl4 = true;
                            break;
                        }
                        default: {
                            break block19;
                        }
                    }
                    ++n2;
                }
                if (n4 == 0) {
                    cArray = zero;
                    n4 = 1;
                    if (n6 == 0) break block35;
                }
                int n8 = bl4 ? n5 - n6 : n4 + n7;
                if (n2 < n && (c = string.charAt(n2)) == 'e' || c == 'E') {
                    int n9 = 1;
                    int n10 = 0;
                    int n11 = 0xCCCCCCC;
                    boolean bl5 = false;
                    switch (string.charAt(++n2)) {
                        case '-': {
                            n9 = -1;
                        }
                        case '+': {
                            ++n2;
                        }
                    }
                    int n12 = n2;
                    block21: while (n2 < n) {
                        if (n10 >= n11) {
                            bl5 = true;
                        }
                        c = string.charAt(n2++);
                        switch (c) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                n10 = n10 * 10 + (c - 48);
                                break;
                            }
                            default: {
                                --n2;
                                break block21;
                            }
                        }
                    }
                    int n13 = 324 + n4 + n7;
                    n8 = bl5 || n10 > n13 ? n9 * n13 : (n8 += n9 * n10);
                    if (n2 == n12) break block35;
                }
                if (n2 >= n || n2 == n - 1 && (string.charAt(n2) == 'f' || string.charAt(n2) == 'F' || string.charAt(n2) == 'd' || string.charAt(n2) == 'D')) {
                    return new FloatingDecimal(bl, n8, cArray, n4, false);
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        }
        throw NumberFormatException.forInputString(string);
    }

    public double doubleValue() {
        boolean bl;
        double d;
        int n;
        int n2 = Math.min(this.nDigits, 16);
        if (this.digits == infinity || this.digits == notANumber) {
            if (this.digits == notANumber) {
                return Double.NaN;
            }
            return this.isNegative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        this.roundDir = 0;
        int n3 = this.digits[0] - 48;
        int n4 = Math.min(n2, 9);
        int n5 = 1;
        while (n5 < n4) {
            n3 = n3 * 10 + this.digits[n5] - 48;
            ++n5;
        }
        long l = n3;
        int n6 = n4;
        while (n6 < n2) {
            l = l * 10L + (long)(this.digits[n6] - 48);
            ++n6;
        }
        double d2 = l;
        int n7 = this.decExponent - n2;
        if (this.nDigits <= 15) {
            if (n7 == 0 || d2 == 0.0) {
                return this.isNegative ? -d2 : d2;
            }
            if (n7 >= 0) {
                if (n7 <= maxSmallTen) {
                    double d3 = d2 * small10pow[n7];
                    if (this.mustSetRoundDir) {
                        double d4 = d3 / small10pow[n7];
                        this.roundDir = d4 == d2 ? 0 : (d4 < d2 ? 1 : -1);
                    }
                    return this.isNegative ? -d3 : d3;
                }
                n = 15 - n2;
                if (n7 <= maxSmallTen + n) {
                    double d5 = (d2 *= small10pow[n]) * small10pow[n7 - n];
                    if (this.mustSetRoundDir) {
                        double d6 = d5 / small10pow[n7 - n];
                        this.roundDir = d6 == d2 ? 0 : (d6 < d2 ? 1 : -1);
                    }
                    return this.isNegative ? -d5 : d5;
                }
            } else if (n7 >= -maxSmallTen) {
                double d7 = d2 / small10pow[-n7];
                double d8 = d7 * small10pow[-n7];
                if (this.mustSetRoundDir) {
                    this.roundDir = d8 == d2 ? 0 : (d8 < d2 ? 1 : -1);
                }
                return this.isNegative ? -d7 : d7;
            }
        }
        if (n7 > 0) {
            if (this.decExponent > 309) {
                return this.isNegative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if ((n7 & 0xF) != 0) {
                d2 *= small10pow[n7 & 0xF];
            }
            if ((n7 >>= 4) != 0) {
                n = 0;
                while (n7 > 1) {
                    if ((n7 & 1) != 0) {
                        d2 *= big10pow[n];
                    }
                    ++n;
                    n7 >>= 1;
                }
                d = d2 * big10pow[n];
                if (Double.isInfinite(d)) {
                    d = d2 / 2.0;
                    if (Double.isInfinite(d *= big10pow[n])) {
                        return this.isNegative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                    }
                    d = Double.MAX_VALUE;
                }
                d2 = d;
            }
        } else if (n7 < 0) {
            n7 = -n7;
            if (this.decExponent < -325) {
                return this.isNegative ? -0.0 : 0.0;
            }
            if ((n7 & 0xF) != 0) {
                d2 /= small10pow[n7 & 0xF];
            }
            if ((n7 >>= 4) != 0) {
                n = 0;
                while (n7 > 1) {
                    if ((n7 & 1) != 0) {
                        d2 *= tiny10pow[n];
                    }
                    ++n;
                    n7 >>= 1;
                }
                d = d2 * tiny10pow[n];
                if (d == 0.0) {
                    d = d2 * 2.0;
                    if ((d *= tiny10pow[n]) == 0.0) {
                        return this.isNegative ? -0.0 : 0.0;
                    }
                    d = Double.MIN_VALUE;
                }
                d2 = d;
            }
        }
        FDBigInt fDBigInt = new FDBigInt(l, this.digits, n2, this.nDigits);
        n7 = this.decExponent - this.nDigits;
        do {
            FDBigInt fDBigInt2;
            FDBigInt fDBigInt3;
            int n8;
            int n9;
            int n10;
            int n11;
            FDBigInt fDBigInt4 = this.doubleToBigInt(d2);
            if (n7 >= 0) {
                n11 = 0;
                n10 = 0;
                n8 = n9 = n7;
            } else {
                n10 = n11 = -n7;
                n9 = 0;
                n8 = 0;
            }
            if (this.bigIntExp >= 0) {
                n10 += this.bigIntExp;
            } else {
                n8 -= this.bigIntExp;
            }
            int n12 = n10;
            int n13 = this.bigIntExp + this.bigIntNBits <= -1022 ? this.bigIntExp + 1023 + 52 : 54 - this.bigIntNBits;
            int n14 = Math.min(n10 += n13, Math.min(n8 += n13, n12));
            n12 -= n14;
            fDBigInt4 = FloatingDecimal.multPow52(fDBigInt4, n11, n10 -= n14);
            FDBigInt fDBigInt5 = FloatingDecimal.multPow52(new FDBigInt(fDBigInt), n9, n8 -= n14);
            int n15 = fDBigInt4.cmp(fDBigInt5);
            if (n15 > 0) {
                bl = true;
                fDBigInt3 = fDBigInt4.sub(fDBigInt5);
                if (this.bigIntNBits == 1 && this.bigIntExp > -1023 && --n12 < 0) {
                    n12 = 0;
                    fDBigInt3.lshiftMe(1);
                }
            } else {
                if (n15 >= 0) break;
                bl = false;
                fDBigInt3 = fDBigInt5.sub(fDBigInt4);
            }
            if ((n15 = fDBigInt3.cmp(fDBigInt2 = FloatingDecimal.constructPow52(n11, n12))) < 0) {
                this.roundDir = bl ? -1 : 1;
                break;
            }
            if (n15 != 0) continue;
            d2 += 0.5 * FloatingDecimal.ulp(d2, bl);
            this.roundDir = bl ? -1 : 1;
            break;
        } while ((d2 += FloatingDecimal.ulp(d2, bl)) != 0.0 && d2 != Double.POSITIVE_INFINITY);
        return this.isNegative ? -d2 : d2;
    }

    public float floatValue() {
        int n = Math.min(this.nDigits, 8);
        if (this.digits == infinity || this.digits == notANumber) {
            if (this.digits == notANumber) {
                return Float.NaN;
            }
            return this.isNegative ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
        }
        int n2 = this.digits[0] - 48;
        int n3 = 1;
        while (n3 < n) {
            n2 = n2 * 10 + this.digits[n3] - 48;
            ++n3;
        }
        float f = n2;
        int n4 = this.decExponent - n;
        if (this.nDigits <= 7) {
            if (n4 == 0 || f == 0.0f) {
                return this.isNegative ? -f : f;
            }
            if (n4 >= 0) {
                if (n4 <= singleMaxSmallTen) {
                    return this.isNegative ? -f : (f *= singleSmall10pow[n4]);
                }
                int n5 = 7 - n;
                if (n4 <= singleMaxSmallTen + n5) {
                    f *= singleSmall10pow[n5];
                    return this.isNegative ? -f : (f *= singleSmall10pow[n4 - n5]);
                }
            } else if (n4 >= -singleMaxSmallTen) {
                return this.isNegative ? -f : (f /= singleSmall10pow[-n4]);
            }
        } else if (this.decExponent >= this.nDigits && this.nDigits + this.decExponent <= 15) {
            long l = n2;
            int n6 = n;
            while (n6 < this.nDigits) {
                l = l * 10L + (long)(this.digits[n6] - 48);
                ++n6;
            }
            double d = l;
            n4 = this.decExponent - this.nDigits;
            f = (float)(d *= small10pow[n4]);
            return this.isNegative ? -f : f;
        }
        if (this.decExponent > 39) {
            return this.isNegative ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
        }
        if (this.decExponent < -46) {
            return this.isNegative ? -0.0f : 0.0f;
        }
        this.mustSetRoundDir = true;
        double d = this.doubleValue();
        return this.stickyRound(d);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$java$lang$FloatingDecimal == null ? (class$java$lang$FloatingDecimal = FloatingDecimal.class$("java.lang.FloatingDecimal")) : class$java$lang$FloatingDecimal).desiredAssertionStatus();
        perThreadBuffer = new ThreadLocal(){

            protected synchronized Object initialValue() {
                return new char[26];
            }
        };
        small10pow = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22};
        singleSmall10pow = new float[]{1.0f, 10.0f, 100.0f, 1000.0f, 10000.0f, 100000.0f, 1000000.0f, 1.0E7f, 1.0E8f, 1.0E9f, 1.0E10f};
        big10pow = new double[]{1.0E16, 1.0E32, 1.0E64, 1.0E128, 1.0E256};
        tiny10pow = new double[]{1.0E-16, 1.0E-32, 1.0E-64, 1.0E-128, 1.0E-256};
        maxSmallTen = small10pow.length - 1;
        singleMaxSmallTen = singleSmall10pow.length - 1;
        small5pow = new int[]{1, 5, 25, 125, 625, 3125, 15625, 78125, 390625, 1953125, 9765625, 48828125, 244140625, 1220703125};
        long5pow = new long[]{1L, 5L, 25L, 125L, 625L, 3125L, 15625L, 78125L, 390625L, 1953125L, 9765625L, 48828125L, 244140625L, 1220703125L, 6103515625L, 30517578125L, 152587890625L, 762939453125L, 3814697265625L, 19073486328125L, 95367431640625L, 476837158203125L, 2384185791015625L, 11920928955078125L, 59604644775390625L, 298023223876953125L, 1490116119384765625L};
        n5bits = new int[]{0, 3, 5, 7, 10, 12, 14, 17, 19, 21, 24, 26, 28, 31, 33, 35, 38, 40, 42, 45, 47, 49, 52, 54, 56, 59, 61};
        infinity = new char[]{'I', 'n', 'f', 'i', 'n', 'i', 't', 'y'};
        notANumber = new char[]{'N', 'a', 'N'};
        zero = new char[]{'0', '0', '0', '0', '0', '0', '0', '0'};
    }
}

