/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import com.ibm.jvm.ExtendedSystem;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandomSpi;
import java.security.Security;
import java.util.Enumeration;
import java.util.Random;

public class SecureRandom
extends Random {
    private Provider provider;
    private SecureRandomSpi secureRandomSpi;
    private static SecureRandom seedGenerator = null;
    static final long serialVersionUID = 4940670005562187L;
    private byte[] state;
    private MessageDigest digest;
    private byte[] randomBytes;
    private int randomBytesUsed;
    private long counter;

    public SecureRandom() {
        block2: {
            super(0L);
            this.provider = null;
            this.secureRandomSpi = null;
            this.digest = null;
            String string = SecureRandom.getPrngAlgorithm();
            if (string == null) break block2;
            try {
                SecureRandom secureRandom = SecureRandom.getInstance(string);
                this.secureRandomSpi = secureRandom.getSecureRandomSpi();
                this.provider = secureRandom.getProvider();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
    }

    public SecureRandom(byte[] byArray) {
        block2: {
            super(0L);
            this.provider = null;
            this.secureRandomSpi = null;
            this.digest = null;
            String string = SecureRandom.getPrngAlgorithm();
            if (string == null) break block2;
            try {
                SecureRandom secureRandom = SecureRandom.getInstance(string);
                this.secureRandomSpi = secureRandom.getSecureRandomSpi();
                this.provider = secureRandom.getProvider();
                this.secureRandomSpi.engineSetSeed(byArray);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
    }

    protected SecureRandom(SecureRandomSpi secureRandomSpi, Provider provider) {
        super(0L);
        this.provider = null;
        this.secureRandomSpi = null;
        this.digest = null;
        this.secureRandomSpi = secureRandomSpi;
        this.provider = provider;
    }

    public static SecureRandom getInstance(String string) throws NoSuchAlgorithmException {
        try {
            Object[] objectArray = Security.getImpl(string, "SecureRandom", (String)null);
            return new SecureRandom((SecureRandomSpi)objectArray[0], (Provider)objectArray[1]);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException(string + " not found");
        }
    }

    public static SecureRandom getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("missing provider");
        }
        Object[] objectArray = Security.getImpl(string, "SecureRandom", string2);
        return new SecureRandom((SecureRandomSpi)objectArray[0], (Provider)objectArray[1]);
    }

    public static SecureRandom getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("missing provider");
        }
        Object[] objectArray = Security.getImpl(string, "SecureRandom", provider);
        return new SecureRandom((SecureRandomSpi)objectArray[0], (Provider)objectArray[1]);
    }

    SecureRandomSpi getSecureRandomSpi() {
        return this.secureRandomSpi;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public synchronized void setSeed(byte[] byArray) {
        this.secureRandomSpi.engineSetSeed(byArray);
        ExtendedSystem.setJVMUnresettableConditionally(131075, new String("Modified security in SecureRandom.setSeed()"));
    }

    public void setSeed(long l) {
        if (l != 0L) {
            this.secureRandomSpi.engineSetSeed(SecureRandom.longToByteArray(l));
            ExtendedSystem.setJVMUnresettableConditionally(131075, new String("Modified security in SecureRandom.engineSetSeed()"));
        }
    }

    public synchronized void nextBytes(byte[] byArray) {
        this.secureRandomSpi.engineNextBytes(byArray);
    }

    protected final int next(int n) {
        int n2 = (n + 7) / 8;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        this.nextBytes(byArray);
        int n4 = 0;
        while (n4 < n2) {
            n3 = (n3 << 8) + (byArray[n4] & 0xFF);
            ++n4;
        }
        return n3 >>> n2 * 8 - n;
    }

    public static byte[] getSeed(int n) {
        if (seedGenerator == null) {
            seedGenerator = new SecureRandom();
        }
        return seedGenerator.generateSeed(n);
    }

    public byte[] generateSeed(int n) {
        return this.secureRandomSpi.engineGenerateSeed(n);
    }

    private static byte[] longToByteArray(long l) {
        byte[] byArray = new byte[8];
        int n = 0;
        while (n < 8) {
            byArray[n] = (byte)l;
            l >>= 8;
            ++n;
        }
        return byArray;
    }

    private static String getPrngAlgorithm() {
        Provider[] providerArray = Security.getProviders();
        int n = 0;
        while (n < providerArray.length) {
            Enumeration enumeration = providerArray[n].propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!string.startsWith("SecureRandom.") || string.indexOf(32) >= 0) continue;
                int n2 = string.indexOf(".", 0);
                return string.substring(n2 + 1);
            }
            ++n;
        }
        return null;
    }
}

