/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import com.ibm.jvm.ExtendedSystem;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.MissingResourceException;
import sun.text.CompactByteArray;

class BreakDictionary {
    private char[] reverseColumnMap = null;
    private static int supportedVersion = 0;
    private int version;
    private CompactByteArray columnMap = null;
    private int numCols;
    private int numColGroups;
    private short[] table = null;
    private short[] rowIndex = null;
    private int[] rowIndexFlags = null;
    private short[] rowIndexFlagsIndex = null;
    private byte[] rowIndexShifts = null;

    public static void main(String[] stringArray) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        String string = stringArray[0];
        BreakDictionary breakDictionary = new BreakDictionary(new FileInputStream(string));
        String string2 = "";
        if (stringArray.length >= 2) {
            string2 = stringArray[1];
        }
        PrintWriter printWriter = null;
        if (string2.length() != 0) {
            printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string2), "UnicodeLittle"));
        }
        breakDictionary.printWordList("", 0, printWriter);
    }

    public void printWordList(String string, int n, PrintWriter printWriter) throws IOException {
        if (n == -1) {
            System.out.println(string);
            if (printWriter != null) {
                printWriter.println(string);
            }
        } else {
            int n2 = 0;
            while (n2 < this.numCols) {
                if (this.at(n, n2) != 0) {
                    this.printWordList(string + this.reverseColumnMap[n2], this.at(n, n2), printWriter);
                }
                ++n2;
            }
        }
    }

    public BreakDictionary(InputStream inputStream) throws IOException {
        this.readDictionaryFile(new DataInputStream(inputStream));
    }

    public void readDictionaryFile(DataInputStream dataInputStream) throws IOException {
        this.version = dataInputStream.readInt();
        if (this.version != supportedVersion) {
            throw new MissingResourceException("Dictionary version(" + this.version + ") is unsupported", dataInputStream.toString(), "");
        }
        int n = dataInputStream.readInt();
        short[] sArray = new short[n];
        int n2 = 0;
        while (n2 < sArray.length) {
            sArray[n2] = dataInputStream.readShort();
            ++n2;
        }
        n = dataInputStream.readInt();
        byte[] byArray = new byte[n];
        int n3 = 0;
        while (n3 < byArray.length) {
            byArray[n3] = dataInputStream.readByte();
            ++n3;
        }
        this.columnMap = new CompactByteArray(sArray, byArray);
        this.numCols = dataInputStream.readInt();
        this.numColGroups = dataInputStream.readInt();
        n = dataInputStream.readInt();
        this.rowIndex = (short[])ExtendedSystem.newArray(Short.TYPE, n, this);
        int n4 = 0;
        while (n4 < this.rowIndex.length) {
            this.rowIndex[n4] = dataInputStream.readShort();
            ++n4;
        }
        n = dataInputStream.readInt();
        this.rowIndexFlagsIndex = (short[])ExtendedSystem.newArray(Short.TYPE, n, this);
        int n5 = 0;
        while (n5 < this.rowIndexFlagsIndex.length) {
            this.rowIndexFlagsIndex[n5] = dataInputStream.readShort();
            ++n5;
        }
        n = dataInputStream.readInt();
        this.rowIndexFlags = (int[])ExtendedSystem.newArray(Integer.TYPE, n, this);
        int n6 = 0;
        while (n6 < this.rowIndexFlags.length) {
            this.rowIndexFlags[n6] = dataInputStream.readInt();
            ++n6;
        }
        n = dataInputStream.readInt();
        this.rowIndexShifts = (byte[])ExtendedSystem.newArray(Byte.TYPE, n, this);
        int n7 = 0;
        while (n7 < this.rowIndexShifts.length) {
            this.rowIndexShifts[n7] = dataInputStream.readByte();
            ++n7;
        }
        n = dataInputStream.readInt();
        this.table = new short[n];
        int n8 = 0;
        while (n8 < this.table.length) {
            this.table[n8] = dataInputStream.readShort();
            ++n8;
        }
        this.reverseColumnMap = (char[])ExtendedSystem.newArray(Character.TYPE, this.numCols, this);
        char c = '\u0000';
        while (c < '\uffff') {
            byte by = this.columnMap.elementAt(c);
            if (by != 0) {
                this.reverseColumnMap[by] = c;
            }
            c = (char)(c + '\u0001');
        }
        dataInputStream.close();
    }

    public final short at(int n, char c) {
        byte by = this.columnMap.elementAt(c);
        return this.at(n, by);
    }

    public final short at(int n, int n2) {
        if (this.cellIsPopulated(n, n2)) {
            return this.internalAt(this.rowIndex[n], n2 + this.rowIndexShifts[n]);
        }
        return 0;
    }

    private final boolean cellIsPopulated(int n, int n2) {
        if (this.rowIndexFlagsIndex[n] < 0) {
            return n2 == -this.rowIndexFlagsIndex[n];
        }
        int n3 = this.rowIndexFlags[this.rowIndexFlagsIndex[n] + (n2 >> 5)];
        return (n3 & 1 << (n2 & 0x1F)) != 0;
    }

    private final short internalAt(int n, int n2) {
        return this.table[n * this.numCols + n2];
    }
}

