/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import com.ibm.jvm.ExtendedSystem;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import sun.text.Utility;

public class ChoiceFormat
extends NumberFormat {
    private double[] choiceLimits;
    private String[] choiceFormats;
    static final long SIGN = Long.MIN_VALUE;
    static final long EXPONENT = 0x7FF0000000000000L;
    static final long POSITIVEINFINITY = 0x7FF0000000000000L;
    private static final long serialVersionUID = 1795184449645032964L;
    static /* synthetic */ Class class$java$lang$String;

    public void applyPattern(String string) {
        StringBuffer[] stringBufferArray = new StringBuffer[2];
        int n = 0;
        while (n < stringBufferArray.length) {
            stringBufferArray[n] = new StringBuffer();
            ++n;
        }
        double[] dArray = new double[30];
        String[] stringArray = new String[30];
        int n2 = 0;
        int n3 = 0;
        double d = 0.0;
        double d2 = Double.NaN;
        boolean bl = false;
        int n4 = 0;
        while (n4 < string.length()) {
            char c = string.charAt(n4);
            if (c == '\'') {
                if (n4 + 1 < string.length() && string.charAt(n4 + 1) == c) {
                    stringBufferArray[n3].append(c);
                    ++n4;
                } else {
                    bl = !bl;
                }
            } else if (bl) {
                stringBufferArray[n3].append(c);
            } else if (c == '<' || c == '#' || c == '\u2264') {
                if (stringBufferArray[0].equals("")) {
                    throw new IllegalArgumentException();
                }
                try {
                    String string2 = stringBufferArray[0].toString();
                    d = string2.equals("\u221e") ? Double.POSITIVE_INFINITY : (string2.equals("-\u221e") ? Double.NEGATIVE_INFINITY : Double.valueOf(stringBufferArray[0].toString()));
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException();
                }
                if (c == '<' && d != Double.POSITIVE_INFINITY && d != Double.NEGATIVE_INFINITY) {
                    d = ChoiceFormat.nextDouble(d);
                }
                if (d <= d2) {
                    throw new IllegalArgumentException();
                }
                stringBufferArray[0].setLength(0);
                n3 = 1;
            } else if (c == '|') {
                if (n2 == dArray.length) {
                    dArray = ChoiceFormat.doubleArraySize(dArray);
                    stringArray = this.doubleArraySize(stringArray);
                }
                dArray[n2] = d;
                stringArray[n2] = stringBufferArray[1].toString();
                ++n2;
                d2 = d;
                stringBufferArray[1].setLength(0);
                n3 = 0;
            } else {
                stringBufferArray[n3].append(c);
            }
            ++n4;
        }
        if (n3 == 1) {
            if (n2 == dArray.length) {
                dArray = ChoiceFormat.doubleArraySize(dArray);
                stringArray = this.doubleArraySize(stringArray);
            }
            dArray[n2] = d;
            stringArray[n2] = stringBufferArray[1].toString();
            ++n2;
        }
        this.choiceLimits = (double[])ExtendedSystem.newArray(Double.TYPE, n2, this);
        System.arraycopy(dArray, 0, this.choiceLimits, 0, n2);
        this.choiceFormats = (String[])ExtendedSystem.newArray(class$java$lang$String == null ? (class$java$lang$String = ChoiceFormat.class$("java.lang.String")) : class$java$lang$String, n2, this);
        System.arraycopy(stringArray, 0, this.choiceFormats, 0, n2);
    }

    public String toPattern() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.choiceLimits.length) {
            boolean bl;
            double d;
            if (n != 0) {
                stringBuffer.append('|');
            }
            double d2 = ChoiceFormat.previousDouble(this.choiceLimits[n]);
            double d3 = Math.abs(Math.IEEEremainder(this.choiceLimits[n], 1.0));
            if (d3 < (d = Math.abs(Math.IEEEremainder(d2, 1.0)))) {
                stringBuffer.append("" + this.choiceLimits[n]);
                stringBuffer.append('#');
            } else {
                if (this.choiceLimits[n] == Double.POSITIVE_INFINITY) {
                    stringBuffer.append("\u221e");
                } else if (this.choiceLimits[n] == Double.NEGATIVE_INFINITY) {
                    stringBuffer.append("-\u221e");
                } else {
                    stringBuffer.append("" + d2);
                }
                stringBuffer.append('<');
            }
            String string = this.choiceFormats[n];
            boolean bl2 = bl = string.indexOf(60) >= 0 || string.indexOf(35) >= 0 || string.indexOf(8804) >= 0 || string.indexOf(124) >= 0;
            if (bl) {
                stringBuffer.append('\'');
            }
            if (string.indexOf(39) < 0) {
                stringBuffer.append(string);
            } else {
                int n2 = 0;
                while (n2 < string.length()) {
                    char c = string.charAt(n2);
                    stringBuffer.append(c);
                    if (c == '\'') {
                        stringBuffer.append(c);
                    }
                    ++n2;
                }
            }
            if (bl) {
                stringBuffer.append('\'');
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public ChoiceFormat(String string) {
        this.applyPattern(string);
    }

    public ChoiceFormat(double[] dArray, String[] stringArray) {
        this.setChoices(dArray, stringArray);
    }

    public void setChoices(double[] dArray, String[] stringArray) {
        if (dArray.length != stringArray.length) {
            throw new IllegalArgumentException("Array and limit arrays must be of the same length.");
        }
        this.choiceLimits = dArray;
        this.choiceFormats = stringArray;
    }

    public double[] getLimits() {
        return this.choiceLimits;
    }

    public Object[] getFormats() {
        return this.choiceFormats;
    }

    public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format((double)l, stringBuffer, fieldPosition);
    }

    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        int n = 0;
        while (n < this.choiceLimits.length) {
            if (!(d >= this.choiceLimits[n])) break;
            ++n;
        }
        if (--n < 0) {
            n = 0;
        }
        return stringBuffer.append(this.choiceFormats[n]);
    }

    public Number parse(String string, ParsePosition parsePosition) {
        int n;
        int n2 = n = parsePosition.index;
        double d = Double.NaN;
        double d2 = 0.0;
        int n3 = 0;
        while (n3 < this.choiceFormats.length) {
            String string2 = this.choiceFormats[n3];
            if (string.regionMatches(n, string2, 0, string2.length())) {
                parsePosition.index = n + string2.length();
                d2 = this.choiceLimits[n3];
                if (parsePosition.index > n2) {
                    n2 = parsePosition.index;
                    d = d2;
                    if (n2 == string.length()) break;
                }
            }
            ++n3;
        }
        parsePosition.index = n2;
        if (parsePosition.index == n) {
            parsePosition.errorIndex = n2;
        }
        return new Double(d);
    }

    public static final double nextDouble(double d) {
        return ChoiceFormat.nextDouble(d, true);
    }

    public static final double previousDouble(double d) {
        return ChoiceFormat.nextDouble(d, false);
    }

    public Object clone() {
        ChoiceFormat choiceFormat = (ChoiceFormat)super.clone();
        choiceFormat.choiceLimits = (double[])this.choiceLimits.clone();
        choiceFormat.choiceFormats = (String[])this.choiceFormats.clone();
        return choiceFormat;
    }

    public int hashCode() {
        int n = this.choiceLimits.length;
        if (this.choiceFormats.length > 0) {
            n ^= this.choiceFormats[this.choiceFormats.length - 1].hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ChoiceFormat choiceFormat = (ChoiceFormat)object;
        return Utility.arrayEquals(this.choiceLimits, (Object)choiceFormat.choiceLimits) && Utility.arrayEquals(this.choiceFormats, (Object)choiceFormat.choiceFormats);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.choiceLimits.length != this.choiceFormats.length) {
            throw new InvalidObjectException("limits and format arrays of different length.");
        }
    }

    public static double nextDouble(double d, boolean bl) {
        if (Double.isNaN(d)) {
            return d;
        }
        if (d == 0.0) {
            double d2 = Double.longBitsToDouble(1L);
            if (bl) {
                return d2;
            }
            return -d2;
        }
        long l = Double.doubleToLongBits(d);
        long l2 = l & Long.MAX_VALUE;
        if (l > 0L == bl) {
            if (l2 != 0x7FF0000000000000L) {
                ++l2;
            }
        } else {
            --l2;
        }
        long l3 = l & Long.MIN_VALUE;
        return Double.longBitsToDouble(l2 | l3);
    }

    private static double[] doubleArraySize(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n * 2];
        System.arraycopy(dArray, 0, dArray2, 0, n);
        return dArray2;
    }

    private String[] doubleArraySize(String[] stringArray) {
        int n = stringArray.length;
        String[] stringArray2 = new String[n * 2];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        return stringArray2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

