/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.ibm.jvm.ExtendedSystem;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import sun.text.resources.LocaleData;
import sun.util.BuddhistCalendar;
import sun.util.calendar.ZoneInfo;

public abstract class Calendar
implements Serializable,
Cloneable {
    public static final int ERA = 0;
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int WEEK_OF_YEAR = 3;
    public static final int WEEK_OF_MONTH = 4;
    public static final int DATE = 5;
    public static final int DAY_OF_MONTH = 5;
    public static final int DAY_OF_YEAR = 6;
    public static final int DAY_OF_WEEK = 7;
    public static final int DAY_OF_WEEK_IN_MONTH = 8;
    public static final int AM_PM = 9;
    public static final int HOUR = 10;
    public static final int HOUR_OF_DAY = 11;
    public static final int MINUTE = 12;
    public static final int SECOND = 13;
    public static final int MILLISECOND = 14;
    public static final int ZONE_OFFSET = 15;
    public static final int DST_OFFSET = 16;
    public static final int FIELD_COUNT = 17;
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 5;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;
    public static final int JANUARY = 0;
    public static final int FEBRUARY = 1;
    public static final int MARCH = 2;
    public static final int APRIL = 3;
    public static final int MAY = 4;
    public static final int JUNE = 5;
    public static final int JULY = 6;
    public static final int AUGUST = 7;
    public static final int SEPTEMBER = 8;
    public static final int OCTOBER = 9;
    public static final int NOVEMBER = 10;
    public static final int DECEMBER = 11;
    public static final int UNDECIMBER = 12;
    public static final int AM = 0;
    public static final int PM = 1;
    private static final int CACHE_COUNT = 4;
    protected int[] fields = new int[17];
    protected boolean[] isSet = new boolean[17];
    transient int[] stamp = new int[17];
    private transient long[] currentSecond;
    private transient boolean[] isCurrentSecondSet;
    private transient int[] recentMatch = new int[4];
    private transient int[][] localTimeToField;
    protected long time;
    protected boolean isTimeSet;
    protected boolean areFieldsSet;
    transient boolean areAllFieldsSet;
    private boolean lenient = true;
    private TimeZone zone;
    private int firstDayOfWeek;
    private int minimalDaysInFirstWeek;
    private static Hashtable cachedLocaleData = new Hashtable(3);
    static final int UNSET = 0;
    static final int INTERNALLY_SET = 1;
    static final int MINIMUM_USER_STAMP = 2;
    private int nextStamp = 2;
    static final int currentSerialVersion = 1;
    private int serialVersionOnStream = 1;
    static final long serialVersionUID = -1807547505821590642L;
    private static final String[] FIELD_NAME = new String[]{",ERA=", ",YEAR=", ",MONTH=", ",WEEK_OF_YEAR=", ",WEEK_OF_MONTH=", ",DAY_OF_MONTH=", ",DAY_OF_YEAR=", ",DAY_OF_WEEK=", ",DAY_OF_WEEK_IN_MONTH=", ",AM_PM=", ",HOUR=", ",HOUR_OF_DAY=", ",MINUTE=", ",SECOND=", ",MILLISECOND=", ",ZONE_OFFSET=", ",DST_OFFSET="};
    static /* synthetic */ Class array$I;

    protected Calendar() {
        this(TimeZone.getDefault(), Locale.getDefault());
    }

    protected Calendar(TimeZone timeZone, Locale locale) {
        this.isCurrentSecondSet = new boolean[4];
        this.localTimeToField = new int[4][17];
        this.currentSecond = new long[4];
        int n = 0;
        while (n < 4) {
            this.isCurrentSecondSet[n] = false;
            this.recentMatch[n] = n;
            this.currentSecond[n] = 0L;
            ++n;
        }
        this.zone = timeZone;
        this.setWeekCountData(locale);
    }

    public static Calendar getInstance() {
        return Calendar.createCalendar(TimeZone.getDefault(), Locale.getDefault());
    }

    public static Calendar getInstance(TimeZone timeZone) {
        return Calendar.createCalendar(timeZone, Locale.getDefault());
    }

    public static Calendar getInstance(Locale locale) {
        return Calendar.createCalendar(TimeZone.getDefault(), locale);
    }

    public static Calendar getInstance(TimeZone timeZone, Locale locale) {
        return Calendar.createCalendar(timeZone, locale);
    }

    private static Calendar createCalendar(TimeZone timeZone, Locale locale) {
        if (locale.getLanguage().compareTo("th") == 0 && locale.getCountry().compareTo("TH") == 0) {
            return new BuddhistCalendar(timeZone, locale);
        }
        return new GregorianCalendar(timeZone, locale);
    }

    public static synchronized Locale[] getAvailableLocales() {
        return DateFormat.getAvailableLocales();
    }

    protected abstract void computeTime();

    protected abstract void computeFields();

    public final Date getTime() {
        return new Date(this.getTimeInMillis());
    }

    private final void setCachedTime(int n) {
        this.localTimeToField[n][0] = this.fields[0];
        this.localTimeToField[n][1] = this.fields[1];
        this.localTimeToField[n][2] = this.fields[2];
        this.localTimeToField[n][3] = this.fields[3];
        this.localTimeToField[n][4] = this.fields[4];
        this.localTimeToField[n][5] = this.fields[5];
        this.localTimeToField[n][6] = this.fields[6];
        this.localTimeToField[n][7] = this.fields[7];
        this.localTimeToField[n][8] = this.fields[8];
        this.localTimeToField[n][9] = this.fields[9];
        this.localTimeToField[n][10] = this.fields[10];
        this.localTimeToField[n][11] = this.fields[11];
        this.localTimeToField[n][12] = this.fields[12];
        this.localTimeToField[n][13] = this.fields[13];
        this.localTimeToField[n][14] = this.fields[14];
        this.localTimeToField[n][15] = this.fields[15];
        this.localTimeToField[n][16] = this.fields[16];
    }

    private final void getCachedTime(int n) {
        this.fields[0] = this.localTimeToField[n][0];
        this.fields[1] = this.localTimeToField[n][1];
        this.fields[2] = this.localTimeToField[n][2];
        this.fields[3] = this.localTimeToField[n][3];
        this.fields[4] = this.localTimeToField[n][4];
        this.fields[5] = this.localTimeToField[n][5];
        this.fields[6] = this.localTimeToField[n][6];
        this.fields[7] = this.localTimeToField[n][7];
        this.fields[8] = this.localTimeToField[n][8];
        this.fields[9] = this.localTimeToField[n][9];
        this.fields[10] = this.localTimeToField[n][10];
        this.fields[11] = this.localTimeToField[n][11];
        this.fields[12] = this.localTimeToField[n][12];
        this.fields[13] = this.localTimeToField[n][13];
        this.fields[14] = this.localTimeToField[n][14];
        this.fields[15] = this.localTimeToField[n][15];
        this.fields[16] = this.localTimeToField[n][16];
    }

    public final void setTime(Date date) {
        long l = date.getTime();
        if (l < 0L) {
            this.setTimeInMillis(l);
            return;
        }
        long l2 = 0L;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        int n4 = (int)(l % 1000L);
        l2 = l - (long)n4;
        n3 = 0;
        while (n3 < 4) {
            if (!this.isCurrentSecondSet[n = this.recentMatch[n2 = n3++]]) break;
            if (l2 != this.currentSecond[n]) continue;
            this.localTimeToField[n][14] = n4;
            bl = true;
            break;
        }
        if (bl) {
            this.getCachedTime(n);
            this.isTimeSet = true;
            this.time = l;
            this.areFieldsSet = true;
            this.areAllFieldsSet = true;
            int n5 = 0;
            while (n5 < 17) {
                this.stamp[n5] = 1;
                this.isSet[n5] = true;
                ++n5;
            }
            if (n2 != 0) {
                int n6 = this.recentMatch[n2];
                int n7 = n2;
                while (n7 > 0) {
                    this.recentMatch[n7] = this.recentMatch[n7 - 1];
                    --n7;
                }
                this.recentMatch[0] = n6;
            }
        } else {
            this.setTimeInMillis(l);
            this.setCachedTime(n);
            this.isCurrentSecondSet[n] = true;
            this.currentSecond[n] = l2;
            if (n2 == 3) {
                int n8 = this.recentMatch[n2];
                int n9 = 3;
                while (n9 > 0) {
                    this.recentMatch[n9] = this.recentMatch[n9 - 1];
                    --n9;
                }
                this.recentMatch[0] = n8;
            }
        }
    }

    public long getTimeInMillis() {
        if (!this.isTimeSet) {
            this.updateTime();
        }
        return this.time;
    }

    public void setTimeInMillis(long l) {
        this.isTimeSet = true;
        this.time = l;
        this.areFieldsSet = false;
        if (!this.areFieldsSet) {
            this.computeFields();
            this.areFieldsSet = true;
            this.areAllFieldsSet = true;
        }
    }

    public int get(int n) {
        this.complete();
        return this.internalGet(n);
    }

    protected final int internalGet(int n) {
        return this.fields[n];
    }

    final void internalSet(int n, int n2) {
        this.fields[n] = n2;
    }

    final void internalClear(int n) {
        this.fields[n] = 0;
        this.stamp[n] = 0;
        this.areFieldsSet = false;
        this.areAllFieldsSet = false;
        this.isSet[n] = false;
    }

    public void set(int n, int n2) {
        this.isTimeSet = false;
        this.internalSet(n, n2);
        ++this.nextStamp;
        if (this.nextStamp == Integer.MAX_VALUE) {
            this.adjustStamp();
        }
        this.areFieldsSet = false;
        this.isSet[n] = true;
        if (n == 2 || n == 5) {
            this.stamp[6] = 0;
        }
    }

    public final void set(int n, int n2, int n3) {
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
    }

    public final void set(int n, int n2, int n3, int n4, int n5) {
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
        this.set(11, n4);
        this.set(12, n5);
    }

    public final void set(int n, int n2, int n3, int n4, int n5, int n6) {
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
        this.set(11, n4);
        this.set(12, n5);
        this.set(13, n6);
    }

    public final void clear() {
        int n = 0;
        while (n < 17) {
            this.fields[n] = 0;
            this.stamp[n] = 0;
            this.isSet[n] = false;
            ++n;
        }
        this.areFieldsSet = false;
        this.areAllFieldsSet = false;
        this.isTimeSet = false;
    }

    public final void clear(int n) {
        this.fields[n] = 0;
        this.stamp[n] = 0;
        this.areFieldsSet = false;
        this.areAllFieldsSet = false;
        this.isSet[n] = false;
        this.isTimeSet = false;
    }

    public final boolean isSet(int n) {
        return this.stamp[n] != 0;
    }

    protected void complete() {
        if (!this.isTimeSet) {
            this.updateTime();
        }
        if (!this.areFieldsSet) {
            this.computeFields();
            this.areFieldsSet = true;
            this.areAllFieldsSet = true;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Calendar)) {
            return false;
        }
        Calendar calendar = (Calendar)object;
        return this.getTimeInMillis() == calendar.getTimeInMillis() && this.lenient == calendar.lenient && this.firstDayOfWeek == calendar.firstDayOfWeek && this.minimalDaysInFirstWeek == calendar.minimalDaysInFirstWeek && this.zone.equals(calendar.zone);
    }

    public int hashCode() {
        return (this.lenient ? 1 : 0) | this.firstDayOfWeek << 1 | this.minimalDaysInFirstWeek << 4 | this.zone.hashCode() << 7;
    }

    public boolean before(Object object) {
        return object instanceof Calendar && this.getTimeInMillis() < ((Calendar)object).getTimeInMillis();
    }

    public boolean after(Object object) {
        return object instanceof Calendar && this.getTimeInMillis() > ((Calendar)object).getTimeInMillis();
    }

    public abstract void add(int var1, int var2);

    public abstract void roll(int var1, boolean var2);

    public void roll(int n, int n2) {
        while (n2 > 0) {
            this.roll(n, true);
            --n2;
        }
        while (n2 < 0) {
            this.roll(n, false);
            ++n2;
        }
    }

    public void setTimeZone(TimeZone timeZone) {
        this.zone = timeZone;
        this.areFieldsSet = false;
        int n = 0;
        while (n < 4) {
            this.isCurrentSecondSet[n] = false;
            this.recentMatch[n] = n;
            this.currentSecond[n] = 0L;
            ++n;
        }
    }

    public TimeZone getTimeZone() {
        return this.zone;
    }

    public void setLenient(boolean bl) {
        this.lenient = bl;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public void setFirstDayOfWeek(int n) {
        if (this.firstDayOfWeek == n) {
            return;
        }
        this.firstDayOfWeek = n;
        this.invalidateWeekFields();
    }

    public int getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public void setMinimalDaysInFirstWeek(int n) {
        if (this.minimalDaysInFirstWeek == n) {
            return;
        }
        this.minimalDaysInFirstWeek = n;
        this.invalidateWeekFields();
    }

    public int getMinimalDaysInFirstWeek() {
        return this.minimalDaysInFirstWeek;
    }

    public abstract int getMinimum(int var1);

    public abstract int getMaximum(int var1);

    public abstract int getGreatestMinimum(int var1);

    public abstract int getLeastMaximum(int var1);

    public int getActualMinimum(int n) {
        int n2;
        int n3 = this.getGreatestMinimum(n);
        if (n3 == (n2 = this.getMinimum(n))) {
            return n3;
        }
        Calendar calendar = (Calendar)this.clone();
        calendar.setLenient(true);
        int n4 = n3;
        do {
            calendar.set(n, n3);
            if (calendar.get(n) != n3) break;
            n4 = n3--;
        } while (n3 >= n2);
        return n4;
    }

    public int getActualMaximum(int n) {
        int n2;
        int n3 = this.getLeastMaximum(n);
        if (n3 == (n2 = this.getMaximum(n))) {
            return n3;
        }
        Calendar calendar = (Calendar)this.clone();
        calendar.setLenient(true);
        if (n == 3 || n == 4) {
            calendar.set(7, this.firstDayOfWeek);
        }
        int n4 = n3;
        do {
            calendar.set(n, n3);
            if (calendar.get(n) != n3) break;
            n4 = n3++;
        } while (n3 <= n2);
        return n4;
    }

    public Object clone() {
        try {
            Calendar calendar = (Calendar)super.clone();
            calendar.fields = new int[17];
            calendar.isSet = new boolean[17];
            calendar.stamp = new int[17];
            System.arraycopy(this.fields, 0, calendar.fields, 0, 17);
            System.arraycopy(this.isSet, 0, calendar.isSet, 0, 17);
            System.arraycopy(this.stamp, 0, calendar.stamp, 0, 17);
            calendar.zone = (TimeZone)this.zone.clone();
            calendar.setFirstDayOfWeek(this.firstDayOfWeek);
            return calendar;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("[time=");
        stringBuffer.append(this.isTimeSet ? String.valueOf(this.time) : "?");
        stringBuffer.append(",areFieldsSet=");
        stringBuffer.append(this.areFieldsSet);
        stringBuffer.append(",areAllFieldsSet=");
        stringBuffer.append(this.areAllFieldsSet);
        stringBuffer.append(",lenient=");
        stringBuffer.append(this.lenient);
        stringBuffer.append(",zone=");
        stringBuffer.append(this.zone);
        stringBuffer.append(",firstDayOfWeek=");
        stringBuffer.append(this.firstDayOfWeek);
        stringBuffer.append(",minimalDaysInFirstWeek=");
        stringBuffer.append(this.minimalDaysInFirstWeek);
        int n = 0;
        while (n < 17) {
            stringBuffer.append(FIELD_NAME[n]);
            stringBuffer.append(this.isSet(n) ? String.valueOf(this.fields[n]) : "?");
            ++n;
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    private void setWeekCountData(Locale locale) {
        int[] nArray = (int[])cachedLocaleData.get(locale);
        if (nArray == null) {
            ResourceBundle resourceBundle = LocaleData.getLocaleElements(locale);
            String[] stringArray = resourceBundle.getStringArray("DateTimeElements");
            nArray = new int[]{Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1])};
            cachedLocaleData.put(locale, nArray);
        }
        this.firstDayOfWeek = nArray[0];
        this.minimalDaysInFirstWeek = nArray[1];
    }

    private void updateTime() {
        this.computeTime();
        if (this.isLenient() || !this.areAllFieldsSet) {
            this.areFieldsSet = false;
        }
        this.isTimeSet = true;
    }

    private final void adjustStamp() {
        int n;
        int n2 = 2;
        int n3 = 2;
        do {
            int n4;
            n = Integer.MAX_VALUE;
            int n5 = 0;
            while (n5 < this.stamp.length) {
                n4 = this.stamp[n5];
                if (n4 >= n3 && n > n4) {
                    n = n4;
                }
                if (n2 < n4) {
                    n2 = n4;
                }
                ++n5;
            }
            if (n2 != n && n == Integer.MAX_VALUE) break;
            n4 = 0;
            while (n4 < this.stamp.length) {
                if (this.stamp[n4] == n) {
                    this.stamp[n4] = n3;
                }
                ++n4;
            }
            ++n3;
        } while (n != n2);
        this.nextStamp = n3;
    }

    private void invalidateWeekFields() {
        if (this.stamp[4] == 1) {
            this.stamp[4] = 0;
            this.isSet[4] = false;
            this.areFieldsSet = false;
        }
        if (this.stamp[3] == 1) {
            this.stamp[3] = 0;
            this.isSet[3] = false;
            this.areFieldsSet = false;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (!this.isTimeSet) {
            try {
                this.updateTime();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        TimeZone timeZone = null;
        if (this.zone instanceof ZoneInfo) {
            SimpleTimeZone simpleTimeZone = ((ZoneInfo)this.zone).getLastRuleInstance();
            if (simpleTimeZone == null) {
                simpleTimeZone = new SimpleTimeZone(this.zone.getRawOffset(), this.zone.getID());
            }
            timeZone = this.zone;
            this.zone = simpleTimeZone;
        }
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(timeZone);
        if (timeZone != null) {
            this.zone = timeZone;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        String string;
        TimeZone timeZone;
        objectInputStream.defaultReadObject();
        this.stamp = (int[])ExtendedSystem.newArray(Integer.TYPE, 17, this);
        if (this.serialVersionOnStream >= 2) {
            this.isTimeSet = true;
            if (this.fields == null) {
                this.fields = (int[])ExtendedSystem.newArray(Integer.TYPE, 17, this);
            }
            if (this.isSet == null) {
                this.isSet = (boolean[])ExtendedSystem.newArray(Boolean.TYPE, 17, this);
            }
        } else if (this.serialVersionOnStream >= 0) {
            int n = 0;
            while (n < 17) {
                this.stamp[n] = this.isSet[n] ? 1 : 0;
                ++n;
            }
        }
        this.serialVersionOnStream = 1;
        try {
            final ObjectInputStream objectInputStream2 = objectInputStream;
            ZoneInfo zoneInfo = (ZoneInfo)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return objectInputStream2.readObject();
                }
            });
            if (zoneInfo != null) {
                this.zone = zoneInfo;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.recentMatch = (int[])ExtendedSystem.newArray(Integer.TYPE, 17, this);
        this.isCurrentSecondSet = (boolean[])ExtendedSystem.newArray(Boolean.TYPE, 17, this);
        this.localTimeToField = (int[][])ExtendedSystem.newArray(array$I == null ? (array$I = Calendar.class$("[I")) : array$I, 4, this);
        int n = 0;
        while (n < 4) {
            this.localTimeToField[n] = (int[])ExtendedSystem.newArray(Integer.TYPE, 17, this);
            ++n;
        }
        this.currentSecond = (long[])ExtendedSystem.newArray(Long.TYPE, 4, this);
        int n2 = 0;
        while (n2 < 4) {
            this.isCurrentSecondSet[n2] = false;
            this.recentMatch[n2] = n2;
            this.currentSecond[n2] = 0L;
            ++n2;
        }
        TimeZone timeZone2 = this.getTimeZone();
        if (timeZone2 instanceof SimpleTimeZone && (timeZone = TimeZone.getTimeZone(string = timeZone2.getID())) != null && timeZone.hasSameRules(timeZone2) && timeZone.getID().equals(string)) {
            this.setTimeZone(timeZone);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

