/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Observer;
import java.util.Vector;

public class Observable {
    private boolean changed = false;
    private Vector obs = new Vector();

    public synchronized void addObserver(Observer observer) {
        if (observer == null) {
            throw new NullPointerException();
        }
        if (!this.obs.contains(observer)) {
            this.obs.addElement(observer);
        }
    }

    public synchronized void deleteObserver(Observer observer) {
        this.obs.removeElement(observer);
    }

    public void notifyObservers() {
        this.notifyObservers(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObservers(Object object) {
        Object[] objectArray;
        Observable observable = this;
        synchronized (observable) {
            if (!this.changed) {
                return;
            }
            objectArray = this.obs.toArray();
            this.clearChanged();
        }
        int n = objectArray.length - 1;
        while (n >= 0) {
            ((Observer)objectArray[n]).update(this, object);
            --n;
        }
    }

    public synchronized void deleteObservers() {
        this.obs.removeAllElements();
    }

    protected synchronized void setChanged() {
        this.changed = true;
    }

    protected synchronized void clearChanged() {
        this.changed = false;
    }

    public synchronized boolean hasChanged() {
        return this.changed;
    }

    public synchronized int countObservers() {
        return this.obs.size();
    }
}

