/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.PropertyPermission;

final class PropertyPermissionCollection
extends PermissionCollection
implements Serializable {
    private transient Map perms = new HashMap(32);
    private boolean all_allowed = false;
    private static final long serialVersionUID = 7015263904581634791L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("permissions", class$java$util$Hashtable == null ? (class$java$util$Hashtable = PropertyPermissionCollection.class$("java.util.Hashtable")) : class$java$util$Hashtable), new ObjectStreamField("all_allowed", Boolean.TYPE)};
    static /* synthetic */ Class class$java$util$Hashtable;

    public void add(Permission permission) {
        if (!(permission instanceof PropertyPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        PropertyPermission propertyPermission = (PropertyPermission)permission;
        PropertyPermission propertyPermission2 = (PropertyPermission)this.perms.get(propertyPermission.getName());
        if (propertyPermission2 != null) {
            int n;
            int n2 = propertyPermission2.getMask();
            if (n2 != (n = propertyPermission.getMask())) {
                int n3 = n2 | n;
                String string = PropertyPermission.getActions(n3);
                this.perms.put(propertyPermission.getName(), new PropertyPermission(propertyPermission.getName(), string));
            }
        } else {
            this.perms.put(propertyPermission.getName(), permission);
        }
        if (!this.all_allowed && propertyPermission.getName().equals("*")) {
            this.all_allowed = true;
        }
    }

    public boolean implies(Permission permission) {
        int n;
        PropertyPermission propertyPermission;
        if (!(permission instanceof PropertyPermission)) {
            return false;
        }
        PropertyPermission propertyPermission2 = (PropertyPermission)permission;
        int n2 = propertyPermission2.getMask();
        int n3 = 0;
        if (this.all_allowed && (propertyPermission = (PropertyPermission)this.perms.get("*")) != null && ((n3 |= propertyPermission.getMask()) & n2) == n2) {
            return true;
        }
        String string = propertyPermission2.getName();
        propertyPermission = (PropertyPermission)this.perms.get(string);
        if (propertyPermission != null && ((n3 |= propertyPermission.getMask()) & n2) == n2) {
            return true;
        }
        int n4 = string.length() - 1;
        while ((n = string.lastIndexOf(".", n4)) != -1) {
            propertyPermission = (PropertyPermission)this.perms.get(string = string.substring(0, n + 1) + "*");
            if (propertyPermission != null && ((n3 |= propertyPermission.getMask()) & n2) == n2) {
                return true;
            }
            n4 = n - 1;
        }
        return false;
    }

    public Enumeration elements() {
        return Collections.enumeration(this.perms.values());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Hashtable hashtable = new Hashtable(this.perms.size() * 2);
        hashtable.putAll(this.perms);
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("all_allowed", this.all_allowed);
        putField.put("permissions", hashtable);
        objectOutputStream.writeFields();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.all_allowed = getField.get("all_allowed", false);
        Hashtable hashtable = (Hashtable)getField.get("permissions", null);
        this.perms = new HashMap(hashtable.size() * 2);
        this.perms.putAll(hashtable);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

