/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import com.ibm.jvm.Constants;
import com.ibm.jvm.io.LocalizedInputStream;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.Vector;
import sun.misc.SoftCache;

public abstract class ResourceBundle {
    private static final ResourceCacheKey cacheKey = new ResourceCacheKey();
    private static final int INITIAL_CACHE_SIZE = 25;
    private static final float CACHE_LOAD_FACTOR = 1.0f;
    private static final int MAX_BUNDLES_SEARCHED = 3;
    private static final Hashtable underConstruction = new Hashtable(3, 1.0f);
    private static final Integer DEFAULT_NOT_FOUND = new Integer(-1);
    private static SoftCache cacheList = new SoftCache(25, 1.0f);
    protected ResourceBundle parent = null;
    private Locale locale = null;
    static /* synthetic */ Class class$java$util$ResourceBundle;

    public final String getString(String string) {
        return (String)this.getObject(string);
    }

    public final String[] getStringArray(String string) {
        return (String[])this.getObject(string);
    }

    public final Object getObject(String string) {
        Object object = this.handleGetObject(string);
        if (object == null) {
            if (this.parent != null) {
                object = this.parent.getObject(string);
            }
            if (object == null) {
                throw new MissingResourceException("Can't find resource for bundle " + this.getClass().getName() + ", key " + string, this.getClass().getName(), string);
            }
        }
        return object;
    }

    public Locale getLocale() {
        return this.locale;
    }

    private void setLocale(String string, String string2) {
        if (string.length() == string2.length()) {
            this.locale = new Locale("", "");
        } else if (string.length() < string2.length()) {
            int n = string.length();
            String string3 = string2.substring(n + 1);
            if ((n = string3.indexOf(95)) == -1) {
                this.locale = new Locale(string3, "", "");
                return;
            }
            String string4 = string3.substring(0, n);
            if ((n = (string3 = string3.substring(n + 1)).indexOf(95)) == -1) {
                this.locale = new Locale(string4, string3, "");
                return;
            }
            String string5 = string3.substring(0, n);
            string3 = string3.substring(n + 1);
            this.locale = new Locale(string4, string5, string3);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private static ClassLoader getLoader() {
        ClassLoader classLoader;
        Class[] classArray = ResourceBundle.getClassContext();
        Class clazz = classArray[2];
        ClassLoader classLoader2 = classLoader = clazz == null ? null : clazz.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        int n = 0;
        while (n < classArray.length) {
            classArray[n] = null;
            ++n;
        }
        return classLoader;
    }

    private static native Class[] getClassContext();

    protected void setParent(ResourceBundle resourceBundle) {
        this.parent = resourceBundle;
    }

    public static final ResourceBundle getBundle(String string) {
        return ResourceBundle.getBundleImpl(string, Locale.getDefault(), ResourceBundle.getLoader());
    }

    public static final ResourceBundle getBundle(String string, Locale locale) {
        return ResourceBundle.getBundleImpl(string, locale, ResourceBundle.getLoader());
    }

    public static ResourceBundle getBundle(String string, Locale locale, ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException();
        }
        return ResourceBundle.getBundleImpl(string, locale, classLoader);
    }

    private static ResourceBundle getBundleImpl(String string, Locale locale, ClassLoader classLoader) {
        if (string == null) {
            throw new NullPointerException();
        }
        Object object = classLoader != null ? classLoader : DEFAULT_NOT_FOUND;
        String string2 = string;
        String string3 = locale.toString();
        if (string3.length() > 0) {
            string2 = string2 + "_" + string3;
        } else if (locale.getVariant().length() > 0) {
            string2 = string2 + "___" + locale.getVariant();
        }
        Locale locale2 = Locale.getDefault();
        Object object2 = ResourceBundle.findBundleInCache(classLoader, string2, locale2);
        if (object2 == object) {
            ResourceBundle.throwMissingResourceException(string, locale);
        } else if (object2 != null) {
            return (ResourceBundle)object2;
        }
        Object object3 = object;
        try {
            boolean bl;
            Object object4 = ResourceBundle.findBundle(classLoader, string, locale2, string, null, object);
            if (object4 == null) {
                ResourceBundle.putBundleInCache(classLoader, string, locale2, object);
                object4 = object;
            }
            Vector vector = ResourceBundle.calculateBundleNames(string, locale);
            Vector vector2 = new Vector(3);
            boolean bl2 = bl = object4 != object && vector.size() == 0;
            if (!bl) {
                object3 = object4;
                int n = 0;
                while (n < vector.size()) {
                    string2 = (String)vector.elementAt(n);
                    object2 = ResourceBundle.findBundle(classLoader, string2, locale2, string, object3, object);
                    vector2.addElement(object2);
                    if (object2 != null) {
                        object3 = object2;
                        bl = true;
                    }
                    ++n;
                }
            }
            object3 = object4;
            if (!bl) {
                Vector vector3 = ResourceBundle.calculateBundleNames(string, locale2);
                int n = 0;
                while (n < vector3.size()) {
                    string2 = (String)vector3.elementAt(n);
                    if (vector.contains(string2)) break;
                    object2 = ResourceBundle.findBundle(classLoader, string2, locale2, string, object3, object);
                    if (object2 != null) {
                        object3 = object2;
                    } else {
                        ResourceBundle.putBundleInCache(classLoader, string2, locale2, object3);
                    }
                    ++n;
                }
            }
            object3 = ResourceBundle.propagate(classLoader, vector, vector2, locale2, object3);
        }
        catch (Exception exception) {
            ResourceBundle.cleanUpConstructionList();
            ResourceBundle.throwMissingResourceException(string, locale);
        }
        catch (Error error) {
            ResourceBundle.cleanUpConstructionList();
            throw error;
        }
        if (object3 == object) {
            ResourceBundle.throwMissingResourceException(string, locale);
        }
        return (ResourceBundle)object3;
    }

    private static Object propagate(ClassLoader classLoader, Vector vector, Vector vector2, Locale locale, Object object) {
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            Object object2 = vector2.elementAt(n);
            if (object2 == null) {
                ResourceBundle.putBundleInCache(classLoader, string, locale, object);
            } else {
                object = object2;
            }
            ++n;
        }
        return object;
    }

    private static void throwMissingResourceException(String string, Locale locale) throws MissingResourceException {
        throw new MissingResourceException("Can't find bundle for base name " + string + ", locale " + locale, string + "_" + locale, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanUpConstructionList() {
        SoftCache softCache = cacheList;
        synchronized (softCache) {
            Collection collection = underConstruction.values();
            Thread thread = Thread.currentThread();
            while (collection.remove(thread)) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object findBundle(ClassLoader classLoader, String string, Locale locale, String string2, Object object, Object object2) {
        Object object3;
        Object object4;
        SoftCache softCache = cacheList;
        synchronized (softCache) {
            boolean bl;
            cacheKey.setKeyValues(classLoader, string, locale);
            object4 = cacheList.get(cacheKey);
            if (object4 != null) {
                cacheKey.clear();
                return object4;
            }
            object3 = (Thread)underConstruction.get(cacheKey);
            boolean bl2 = bl = object3 != null && object3 != Thread.currentThread();
            if (bl) {
                while (bl) {
                    cacheKey.clear();
                    try {
                        cacheList.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    cacheKey.setKeyValues(classLoader, string, locale);
                    bl = underConstruction.containsKey(cacheKey);
                }
                object4 = cacheList.get(cacheKey);
                if (object4 != null) {
                    cacheKey.clear();
                    return object4;
                }
            }
            Object object5 = cacheKey.clone();
            underConstruction.put(object5, Thread.currentThread());
            cacheKey.clear();
        }
        object4 = ResourceBundle.loadBundle(classLoader, string, locale);
        if (object4 != null) {
            object3 = (ResourceBundle)object4;
            if (object != object2 && ((ResourceBundle)object3).parent == null) {
                ((ResourceBundle)object3).setParent((ResourceBundle)object);
            }
            super.setLocale(string2, string);
            ResourceBundle.putBundleInCache(classLoader, string, locale, object4);
        }
        return object4;
    }

    private static Vector calculateBundleNames(String string, Locale locale) {
        String string2;
        int n;
        String string3;
        int n2;
        Vector vector = new Vector(3);
        String string4 = locale.getLanguage();
        int n3 = string4.length();
        if (n3 + (n2 = (string3 = locale.getCountry()).length()) + (n = (string2 = locale.getVariant()).length()) == 0) {
            return vector;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append('_');
        stringBuffer.append(string4);
        if (n3 > 0) {
            vector.addElement(stringBuffer.toString());
        }
        if (n2 + n == 0) {
            return vector;
        }
        if ("zh".equals(string4) && ("HK".equals(string3) || "MO".equals(string3))) {
            vector.addElement(string + "zh_TW");
        }
        stringBuffer.append('_');
        stringBuffer.append(string3);
        if (n2 > 0) {
            vector.addElement(stringBuffer.toString());
        }
        if (n == 0) {
            return vector;
        }
        stringBuffer.append('_');
        stringBuffer.append(string2);
        vector.addElement(stringBuffer.toString());
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object findBundleInCache(ClassLoader classLoader, String string, Locale locale) {
        SoftCache softCache = cacheList;
        synchronized (softCache) {
            cacheKey.setKeyValues(classLoader, string, locale);
            Object object = cacheList.get(cacheKey);
            cacheKey.clear();
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putBundleInCache(ClassLoader classLoader, String string, Locale locale, Object object) {
        SoftCache softCache = cacheList;
        synchronized (softCache) {
            cacheKey.setKeyValues(classLoader, string, locale);
            cacheList.put(cacheKey.clone(), object);
            underConstruction.remove(cacheKey);
            cacheKey.clear();
            cacheList.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Object loadBundle(final ClassLoader classLoader, String string, Locale locale) {
        Object object;
        Object object2;
        try {
            object2 = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
            if ((class$java$util$ResourceBundle == null ? (class$java$util$ResourceBundle = ResourceBundle.class$("java.util.ResourceBundle")) : class$java$util$ResourceBundle).isAssignableFrom((Class)object2)) {
                return ((Class)object2).newInstance();
            }
        }
        catch (Exception exception) {
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        object2 = string.replace('.', '/') + ".properties";
        InputStream inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedAction((String)object2){
            private final /* synthetic */ String val$resName;
            {
                this.val$resName = string;
            }

            public Object run() {
                if (classLoader != null) {
                    return classLoader.getResourceAsStream(this.val$resName);
                }
                return ClassLoader.getSystemResourceAsStream(this.val$resName);
            }
        });
        if (inputStream == null && Constants.fat_filesystem_support) {
            object = string.replace('.', '/') + Constants.dot_properties;
            inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedAction((String)object){
                private final /* synthetic */ String val$resName2;
                {
                    this.val$resName2 = string;
                }

                public Object run() {
                    if (classLoader != null) {
                        return classLoader.getResourceAsStream(this.val$resName2);
                    }
                    return ClassLoader.getSystemResourceAsStream(this.val$resName2);
                }
            });
        }
        if (inputStream != null) {
            inputStream = new BufferedInputStream(LocalizedInputStream.localize(inputStream));
            object = new PropertyResourceBundle(inputStream);
            Object var7_9 = null;
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return object;
            catch (Exception exception) {
                try {
                    Object var7_10 = null;
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    inputStream.close();
                }
                catch (Exception exception3) {}
            }
        }
        return null;
    }

    protected abstract Object handleGetObject(String var1);

    public abstract Enumeration getKeys();

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class ResourceCacheKey
    implements Cloneable {
        private SoftReference loaderRef;
        private String searchName;
        private Locale defaultLocale;
        private int hashCodeCache;

        private ResourceCacheKey() {
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            try {
                ResourceCacheKey resourceCacheKey = (ResourceCacheKey)object;
                if (this.hashCodeCache != resourceCacheKey.hashCodeCache) {
                    return false;
                }
                if (!this.searchName.equals(resourceCacheKey.searchName)) {
                    return false;
                }
                if (this.defaultLocale == null ? resourceCacheKey.defaultLocale != null : !this.defaultLocale.equals(resourceCacheKey.defaultLocale)) {
                    return false;
                }
                if (this.loaderRef == null) {
                    return resourceCacheKey.loaderRef == null;
                }
                return resourceCacheKey.loaderRef != null && this.loaderRef.get() == resourceCacheKey.loaderRef.get();
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        public int hashCode() {
            return this.hashCodeCache;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }

        public void setKeyValues(ClassLoader classLoader, String string, Locale locale) {
            this.searchName = string;
            this.hashCodeCache = string.hashCode();
            this.defaultLocale = locale;
            if (locale != null) {
                this.hashCodeCache ^= locale.hashCode();
            }
            if (classLoader == null) {
                this.loaderRef = null;
            } else {
                this.loaderRef = new SoftReference(classLoader);
                this.hashCodeCache ^= classLoader.hashCode();
            }
        }

        public void clear() {
            this.setKeyValues(null, "", null);
        }
    }
}

