/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;
import sun.security.pkcs.ParsingException;
import sun.security.util.Debug;
import sun.security.util.ManifestDigester;
import sun.security.util.ManifestEntryVerifier;
import sun.security.util.SignatureFileVerifier;

class JarVerifier {
    static final Debug debug = Debug.getInstance("jar");
    private Hashtable verifiedCerts;
    private Hashtable sigFileCerts;
    private Hashtable sigFileData;
    private ArrayList pendingBlocks;
    private ArrayList certCache;
    private boolean parsingBlockOrSF = false;
    private boolean parsingMeta = true;
    private boolean anyToVerify = true;
    private Manifest manifest;
    private ByteArrayOutputStream baos;
    private ManifestDigester manDig;
    byte[] manifestRawBytes = null;

    public JarVerifier(Manifest manifest, byte[] byArray) {
        this.manifestRawBytes = byArray;
        this.sigFileCerts = new Hashtable();
        this.verifiedCerts = new Hashtable();
        this.sigFileData = new Hashtable(11);
        this.pendingBlocks = new ArrayList();
        this.baos = new ByteArrayOutputStream();
        this.manifest = manifest;
    }

    public void beginEntry(JarEntry jarEntry, ManifestEntryVerifier manifestEntryVerifier) throws IOException {
        String string;
        if (jarEntry == null) {
            return;
        }
        if (debug != null) {
            debug.println("beginEntry " + jarEntry.getName());
        }
        String string2 = jarEntry.getName();
        if (this.parsingMeta && ((string = string2.toUpperCase(Locale.ENGLISH)).startsWith("META-INF/") || string.startsWith("/META-INF/"))) {
            if (jarEntry.isDirectory()) {
                manifestEntryVerifier.setEntry(null, jarEntry);
                return;
            }
            if (string.endsWith(".DSA") || string.endsWith(".RSA") || string.endsWith(".SF")) {
                this.parsingBlockOrSF = true;
                this.baos.reset();
                manifestEntryVerifier.setEntry(null, jarEntry);
            }
            return;
        }
        if (this.parsingMeta) {
            this.doneWithMeta();
        }
        if (jarEntry.isDirectory()) {
            manifestEntryVerifier.setEntry(null, jarEntry);
            return;
        }
        if (string2.startsWith("./")) {
            string2 = string2.substring(2);
        }
        if (string2.startsWith("/")) {
            string2 = string2.substring(1);
        }
        if (this.sigFileCerts.get(string2) != null) {
            manifestEntryVerifier.setEntry(string2, jarEntry);
            return;
        }
        manifestEntryVerifier.setEntry(null, jarEntry);
    }

    public void update(int n, ManifestEntryVerifier manifestEntryVerifier) throws IOException {
        if (n != -1) {
            if (this.parsingBlockOrSF) {
                this.baos.write(n);
            } else {
                manifestEntryVerifier.update((byte)n);
            }
        } else {
            this.processEntry(manifestEntryVerifier);
        }
    }

    public void update(int n, byte[] byArray, int n2, int n3, ManifestEntryVerifier manifestEntryVerifier) throws IOException {
        if (n != -1) {
            if (this.parsingBlockOrSF) {
                this.baos.write(byArray, n2, n);
            } else {
                manifestEntryVerifier.update(byArray, n2, n);
            }
        } else {
            this.processEntry(manifestEntryVerifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void processEntry(ManifestEntryVerifier var1_1) throws IOException {
        if (!this.parsingBlockOrSF) {
            var2_2 = var1_1.getEntry();
            if (var2_2 == null) return;
            if (var2_2.certs != null) return;
            var2_2.certs = var1_1.verify(this.verifiedCerts, this.sigFileCerts);
            return;
        }
        try {
            this.parsingBlockOrSF = false;
            if (JarVerifier.debug != null) {
                JarVerifier.debug.println("processEntry: processing block");
            }
            if (!(var2_3 = var1_1.getEntry().getName().toUpperCase(Locale.ENGLISH)).endsWith(".SF")) {
                var3_6 = var2_3.substring(0, var2_3.lastIndexOf("."));
                if (this.certCache == null) {
                    this.certCache = new ArrayList();
                }
                if (this.manDig == null) {
                    var4_9 = this.manifestRawBytes;
                    // MONITORENTER : this.manifestRawBytes
                    if (this.manDig == null) {
                        this.manDig = new ManifestDigester(this.manifestRawBytes);
                        this.manifestRawBytes = null;
                    }
                    // MONITOREXIT : var4_9
                }
                if ((var4_9 = (Object)new SignatureFileVerifier(this.certCache, this.manDig, var2_3, this.baos.toByteArray())).needSignatureFileBytes()) {
                    var5_12 = (byte[])this.sigFileData.get(var3_6);
                    if (var5_12 == null) {
                        if (JarVerifier.debug != null) {
                            JarVerifier.debug.println("adding pending block");
                        }
                        this.pendingBlocks.add(var4_9);
                        return;
                    }
                    var4_9.setSignatureFile(var5_12);
                }
                var4_9.process(this.sigFileCerts);
                return;
            }
            var3_5 = var2_3.substring(0, var2_3.length() - 3);
            var4_8 = this.baos.toByteArray();
            this.sigFileData.put(var3_5, var4_8);
            var5_11 = this.pendingBlocks.iterator();
            if (true) ** GOTO lbl65
        }
        catch (ParsingException var2_4) {
            if (JarVerifier.debug == null) return;
            JarVerifier.debug.println("processEntry caught: " + var2_4);
            JarVerifier.debug.printStackTrace(var2_4);
            return;
        }
        catch (IOException var3_7) {
            if (JarVerifier.debug == null) return;
            JarVerifier.debug.println("processEntry caught: " + var3_7);
            JarVerifier.debug.printStackTrace(var3_7);
            return;
        }
        catch (SignatureException var4_10) {
            if (JarVerifier.debug == null) return;
            JarVerifier.debug.println("processEntry caught: " + var4_10);
            JarVerifier.debug.printStackTrace(var4_10);
            return;
        }
        catch (NoSuchAlgorithmException var5_13) {
            if (JarVerifier.debug == null) return;
            JarVerifier.debug.println("processEntry caught: " + var5_13);
            JarVerifier.debug.printStackTrace(var5_13);
            return;
        }
        do {
            if (!(var6_14 = (SignatureFileVerifier)var5_11.next()).needSignatureFile(var3_5)) continue;
            if (JarVerifier.debug != null) {
                JarVerifier.debug.println("processEntry: processing pending block");
            }
            var6_14.setSignatureFile(var4_8);
            var6_14.process(this.sigFileCerts);
lbl65:
            // 3 sources

        } while (var5_11.hasNext());
    }

    public Certificate[] getCerts(String string) {
        return (Certificate[])this.verifiedCerts.get(string);
    }

    boolean nothingToVerify() {
        return !this.anyToVerify;
    }

    void doneWithMeta() {
        this.parsingMeta = false;
        this.anyToVerify = !this.sigFileCerts.isEmpty();
        this.baos = null;
        this.sigFileData = null;
        this.pendingBlocks = null;
        this.certCache = null;
        this.manDig = null;
    }

    static class VerifierStream
    extends InputStream {
        private InputStream is;
        private JarVerifier jv;
        private ManifestEntryVerifier mev;
        private long numLeft;

        VerifierStream(Manifest manifest, JarEntry jarEntry, InputStream inputStream, JarVerifier jarVerifier) throws IOException {
            this.is = inputStream;
            this.jv = jarVerifier;
            this.mev = new ManifestEntryVerifier(manifest);
            this.jv.beginEntry(jarEntry, this.mev);
            this.numLeft = jarEntry.getSize();
            if (this.numLeft == 0L) {
                this.jv.update(-1, this.mev);
            }
        }

        public int read() throws IOException {
            if (this.numLeft > 0L) {
                int n = this.is.read();
                this.jv.update(n, this.mev);
                --this.numLeft;
                if (this.numLeft == 0L) {
                    this.jv.update(-1, this.mev);
                }
                return n;
            }
            return -1;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.numLeft > 0L && this.numLeft < (long)n2) {
                n2 = (int)this.numLeft;
            }
            if (this.numLeft > 0L) {
                int n3 = this.is.read(byArray, n, n2);
                this.jv.update(n3, byArray, n, n2, this.mev);
                this.numLeft -= (long)n3;
                if (this.numLeft == 0L) {
                    this.jv.update(-1, byArray, n, n2, this.mev);
                }
                return n3;
            }
            return -1;
        }

        public void close() throws IOException {
            if (this.is != null) {
                this.is.close();
            }
            this.is = null;
            this.mev = null;
            this.jv = null;
        }

        public int available() throws IOException {
            return this.is.available();
        }
    }
}

