/*
 * Decompiled with CFR 0.152.
 */
package sun.net.ftp;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.misc.REException;
import sun.misc.RegexpPool;
import sun.net.NetworkClient;
import sun.net.TelnetInputStream;
import sun.net.TelnetOutputStream;
import sun.net.TransferProtocolClient;
import sun.net.ftp.FtpLoginException;
import sun.net.ftp.FtpProtocolException;
import sun.security.action.GetPropertyAction;

public class FtpClient
extends TransferProtocolClient {
    public static final int FTP_PORT = 21;
    static int FTP_SUCCESS = 1;
    static int FTP_TRY_AGAIN = 2;
    static int FTP_ERROR = 3;
    private boolean replyPending = false;
    private boolean binaryMode = false;
    private boolean loggedIn = false;
    private static RegexpPool nonProxyHostsPool = null;
    private static String nonProxyHostsSource = null;
    String command;
    int lastReplyCode;
    public String welcomeMsg;
    static /* synthetic */ Class class$sun$net$ftp$FtpClient;

    public static boolean getUseFtpProxy() {
        return FtpClient.getFtpProxyHost() != null;
    }

    public static String getFtpProxyHost() {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty("ftp.proxyHost");
                if (string == null) {
                    string = System.getProperty("ftpProxyHost");
                }
                if (string == null && Boolean.getBoolean("ftp.useProxy")) {
                    string = System.getProperty("proxyHost");
                }
                return string;
            }
        });
    }

    public static int getFtpProxyPort() {
        final int[] nArray = new int[]{80};
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty("ftp.proxyPort");
                if (string == null) {
                    string = System.getProperty("ftpProxyPort");
                }
                if (string == null && Boolean.getBoolean("ftp.useProxy")) {
                    string = System.getProperty("proxyPort");
                }
                if (string != null) {
                    nArray[0] = Integer.parseInt(string);
                }
                return null;
            }
        });
        return nArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean matchNonProxyHosts(String string) {
        Class clazz = class$sun$net$ftp$FtpClient == null ? (class$sun$net$ftp$FtpClient = FtpClient.class$("sun.net.ftp.FtpClient")) : class$sun$net$ftp$FtpClient;
        synchronized (clazz) {
            String string2 = (String)AccessController.doPrivileged(new GetPropertyAction("ftp.nonProxyHosts"));
            if (string2 == null) {
                nonProxyHostsPool = null;
            } else if (!string2.equals(nonProxyHostsSource)) {
                RegexpPool regexpPool = new RegexpPool();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "|", false);
                try {
                    while (stringTokenizer.hasMoreTokens()) {
                        regexpPool.add(stringTokenizer.nextToken().toLowerCase(), Boolean.TRUE);
                    }
                }
                catch (REException rEException) {
                    System.err.println("Error in http.nonProxyHosts system property: " + rEException);
                }
                nonProxyHostsPool = regexpPool;
            }
            nonProxyHostsSource = string2;
        }
        if (nonProxyHostsPool == null) {
            return false;
        }
        return nonProxyHostsPool.match(string) != null;
    }

    public void closeServer() throws IOException {
        if (this.serverIsOpen()) {
            this.issueCommand("QUIT");
            super.closeServer();
        }
    }

    protected int issueCommand(String string) throws IOException {
        int n;
        this.command = string;
        while (this.replyPending) {
            this.replyPending = false;
            if (this.readReply() != FTP_ERROR) continue;
            throw new FtpProtocolException("Error reading FTP pending reply\n");
        }
        do {
            this.sendServer(string + "\r\n");
        } while ((n = this.readReply()) == FTP_TRY_AGAIN);
        return n;
    }

    protected void issueCommandCheck(String string) throws IOException {
        if (this.issueCommand(string) != FTP_SUCCESS) {
            throw new FtpProtocolException(string + ":" + this.getResponseString());
        }
    }

    protected int readReply() throws IOException {
        this.lastReplyCode = this.readServerResponse();
        switch (this.lastReplyCode / 100) {
            case 1: {
                this.replyPending = true;
            }
            case 2: 
            case 3: {
                return FTP_SUCCESS;
            }
            case 5: {
                if (this.lastReplyCode == 530) {
                    if (!this.loggedIn) {
                        throw new FtpLoginException("Not logged in");
                    }
                    return FTP_ERROR;
                }
                if (this.lastReplyCode != 550) break;
                throw new FileNotFoundException(this.command + ": " + this.getResponseString());
            }
        }
        return FTP_ERROR;
    }

    protected Socket openPassiveDataConnection() throws IOException {
        Object object;
        InetSocketAddress inetSocketAddress = null;
        if (this.issueCommand("EPSV ALL") == FTP_SUCCESS) {
            if (this.issueCommand("EPSV") == FTP_ERROR) {
                throw new FtpProtocolException("EPSV Failed: " + this.getResponseString());
            }
            String string = this.getResponseString();
            object = Pattern.compile("^229 .* \\(\\|\\|\\|(\\d+)\\|\\)");
            Matcher matcher = ((Pattern)object).matcher(string);
            if (!matcher.find()) {
                throw new FtpProtocolException("EPSV failed : " + string);
            }
            String string2 = matcher.group(1);
            int n = Integer.parseInt(string2);
            InetAddress inetAddress = this.serverSocket.getInetAddress();
            inetSocketAddress = new InetSocketAddress(inetAddress, n);
        } else {
            if (this.issueCommand("PASV") == FTP_ERROR) {
                throw new FtpProtocolException("PASV failed: " + this.getResponseString());
            }
            String string = this.getResponseString();
            object = Pattern.compile("227 .* \\(?(\\d{1,3},\\d{1,3},\\d{1,3},\\d{1,3}),(\\d{1,3}),(\\d{1,3})\\)?");
            Matcher matcher = ((Pattern)object).matcher(string);
            if (!matcher.find()) {
                throw new FtpProtocolException("PASV failed : " + string);
            }
            int n = Integer.parseInt(matcher.group(3)) + (Integer.parseInt(matcher.group(2)) << 8);
            String string3 = matcher.group(1).replace(',', '.');
            inetSocketAddress = new InetSocketAddress(string3, n);
        }
        object = new Socket();
        if (NetworkClient.defaultConnectTimeout > 0) {
            ((Socket)object).connect(inetSocketAddress, NetworkClient.defaultConnectTimeout);
        } else {
            ((Socket)object).connect(inetSocketAddress);
        }
        if (NetworkClient.defaultSoTimeout > 0) {
            ((Socket)object).setSoTimeout(NetworkClient.defaultSoTimeout);
        }
        return object;
    }

    protected Socket openDataConnection(String string) throws IOException {
        String string2;
        Socket socket;
        InetAddress inetAddress;
        block9: {
            inetAddress = this.serverSocket.getLocalAddress();
            try {
                socket = this.openPassiveDataConnection();
                if (this.issueCommand(string) == FTP_ERROR) {
                    socket.close();
                    break block9;
                }
                return socket;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        ServerSocket serverSocket = new ServerSocket(0, 1, inetAddress);
        if (inetAddress.isAnyLocalAddress()) {
            inetAddress = this.getLocalAddress();
        }
        if (this.issueCommand(string2 = "EPRT |" + (inetAddress instanceof Inet6Address ? "2" : "1") + "|" + inetAddress.getHostAddress() + "|" + serverSocket.getLocalPort() + "|") == FTP_ERROR || this.issueCommand(string) == FTP_ERROR) {
            string2 = "PORT ";
            byte[] byArray = inetAddress.getAddress();
            int n = 0;
            while (n < byArray.length) {
                string2 = string2 + (byArray[n] & 0xFF) + ",";
                ++n;
            }
            if (this.issueCommand(string2 = string2 + (serverSocket.getLocalPort() >>> 8 & 0xFF) + "," + (serverSocket.getLocalPort() & 0xFF)) == FTP_ERROR) {
                FtpProtocolException ftpProtocolException = new FtpProtocolException("PORT :" + this.getResponseString());
                serverSocket.close();
                throw ftpProtocolException;
            }
            if (this.issueCommand(string) == FTP_ERROR) {
                FtpProtocolException ftpProtocolException = new FtpProtocolException(string + ":" + this.getResponseString());
                serverSocket.close();
                throw ftpProtocolException;
            }
        }
        socket = serverSocket.accept();
        if (NetworkClient.defaultSoTimeout != -1) {
            socket.setSoTimeout(NetworkClient.defaultSoTimeout);
        }
        serverSocket.close();
        return socket;
    }

    public void openServer(String string) throws IOException {
        this.openServer(string, 21);
    }

    public void openServer(String string, int n) throws IOException {
        super.openServer(string, n);
        if (this.readReply() == FTP_ERROR) {
            throw new FtpProtocolException("Welcome message: " + this.getResponseString());
        }
    }

    public void login(String string, String string2) throws IOException {
        if (!this.serverIsOpen()) {
            throw new FtpLoginException("not connected to host");
        }
        if (string == null || string.length() == 0) {
            return;
        }
        if (this.issueCommand("USER " + string) == FTP_ERROR) {
            throw new FtpLoginException("user " + string + " : " + this.getResponseString());
        }
        if (this.lastReplyCode == 331 && (string2 == null || string2.length() == 0 || this.issueCommand("PASS " + string2) == FTP_ERROR)) {
            throw new FtpLoginException("password: " + this.getResponseString());
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.serverResponse.size()) {
            String string3 = (String)this.serverResponse.elementAt(n);
            if (string3 != null) {
                if (string3.length() >= 4 && string3.startsWith("230")) {
                    string3 = string3.substring(4);
                }
                stringBuffer.append(string3);
            }
            ++n;
        }
        this.welcomeMsg = stringBuffer.toString();
        this.loggedIn = true;
    }

    /*
     * Unable to fully structure code
     */
    public TelnetInputStream get(String var1_1) throws IOException {
        block7: {
            try {
                var2_2 = this.openDataConnection("RETR " + var1_1);
                break block7;
            }
            catch (FileNotFoundException var3_3) {
                var4_4 = new StringTokenizer(var1_1, "/");
                var5_5 = null;
                ** while (var4_4.hasMoreElements())
            }
lbl-1000:
            // 1 sources

            {
                var5_5 = var4_4.nextToken();
                if (!var4_4.hasMoreElements()) break;
                try {
                    this.cd(var5_5);
                    continue;
                }
                catch (FtpProtocolException var6_6) {
                    throw var3_3;
                }
            }
lbl15:
            // 2 sources

            if (var5_5 != null) {
                var2_2 = this.openDataConnection("RETR " + var5_5);
            } else {
                throw var3_3;
            }
        }
        return new TelnetInputStream(var2_2.getInputStream(), this.binaryMode);
    }

    public TelnetOutputStream put(String string) throws IOException {
        Socket socket = this.openDataConnection("STOR " + string);
        TelnetOutputStream telnetOutputStream = new TelnetOutputStream(socket.getOutputStream(), this.binaryMode);
        if (!this.binaryMode) {
            telnetOutputStream.setStickyCRLF(true);
        }
        return telnetOutputStream;
    }

    public TelnetOutputStream append(String string) throws IOException {
        Socket socket = this.openDataConnection("APPE " + string);
        TelnetOutputStream telnetOutputStream = new TelnetOutputStream(socket.getOutputStream(), this.binaryMode);
        if (!this.binaryMode) {
            telnetOutputStream.setStickyCRLF(true);
        }
        return telnetOutputStream;
    }

    public TelnetInputStream list() throws IOException {
        Socket socket = this.openDataConnection("LIST");
        return new TelnetInputStream(socket.getInputStream(), this.binaryMode);
    }

    public TelnetInputStream nameList(String string) throws IOException {
        Socket socket = string != null ? this.openDataConnection("NLST " + string) : this.openDataConnection("NLST");
        return new TelnetInputStream(socket.getInputStream(), this.binaryMode);
    }

    public void cd(String string) throws IOException {
        if (string == null || "".equals(string)) {
            return;
        }
        this.issueCommandCheck("CWD " + string);
    }

    public void cdUp() throws IOException {
        this.issueCommandCheck("CDUP");
    }

    public String pwd() throws IOException {
        this.issueCommandCheck("PWD");
        String string = this.getResponseString();
        if (!string.startsWith("257")) {
            throw new FtpProtocolException("PWD failed. " + string);
        }
        return string.substring(5, string.lastIndexOf(34));
    }

    public void binary() throws IOException {
        this.issueCommandCheck("TYPE I");
        this.binaryMode = true;
    }

    public void ascii() throws IOException {
        this.issueCommandCheck("TYPE A");
        this.binaryMode = false;
    }

    public void rename(String string, String string2) throws IOException {
        this.issueCommandCheck("RNFR " + string);
        this.issueCommandCheck("RNTO " + string2);
    }

    public String system() throws IOException {
        this.issueCommandCheck("SYST");
        String string = this.getResponseString();
        if (!string.startsWith("215")) {
            throw new FtpProtocolException("SYST failed." + string);
        }
        return string.substring(4);
    }

    public void noop() throws IOException {
        this.issueCommandCheck("NOOP");
    }

    public void reInit() throws IOException {
        this.issueCommandCheck("REIN");
        this.loggedIn = false;
    }

    public FtpClient(String string) throws IOException {
        this.openServer(string, 21);
    }

    public FtpClient(String string, int n) throws IOException {
        this.openServer(string, n);
    }

    public FtpClient() {
    }

    protected void finalize() throws IOException {
        if (this.serverIsOpen()) {
            this.closeServer();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

