/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.jar;

import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.util.HashMap;
import java.util.jar.JarFile;
import sun.net.www.protocol.jar.URLJarFile;

class JarFileFactory {
    private static HashMap fileCache = new HashMap();
    private static HashMap urlCache = new HashMap();

    JarFileFactory() {
    }

    URLConnection getConnection(JarFile jarFile) throws IOException {
        URL uRL = (URL)urlCache.get(jarFile);
        if (uRL != null) {
            return uRL.openConnection();
        }
        return null;
    }

    public JarFile get(URL uRL) throws IOException {
        return this.get(uRL, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JarFile get(URL uRL, boolean bl) throws IOException {
        Object object;
        if (uRL.getProtocol().equalsIgnoreCase("file") && (object = uRL.getHost()) != null && !((String)object).equals("") && !((String)object).equals("localhost")) {
            uRL = new URL("file", "", "//" + (String)object + uRL.getPath());
        }
        object = null;
        JarFile jarFile = null;
        if (bl) {
            JarFileFactory jarFileFactory = this;
            synchronized (jarFileFactory) {
                object = this.getCachedJarFile(uRL);
            }
            if (object == null) {
                jarFile = URLJarFile.getJarFile(uRL);
                JarFileFactory jarFileFactory2 = this;
                synchronized (jarFileFactory2) {
                    object = this.getCachedJarFile(uRL);
                    if (object == null) {
                        fileCache.put(uRL, jarFile);
                        urlCache.put(jarFile, uRL);
                        object = jarFile;
                    } else if (jarFile != null) {
                        jarFile.close();
                    }
                }
            }
        } else {
            object = URLJarFile.getJarFile(uRL);
        }
        if (object == null) {
            throw new FileNotFoundException(uRL.toString());
        }
        return object;
    }

    private JarFile getCachedJarFile(URL uRL) {
        SecurityManager securityManager;
        Permission permission;
        JarFile jarFile = (JarFile)fileCache.get(uRL);
        if (jarFile != null && (permission = this.getPermission(jarFile)) != null && (securityManager = System.getSecurityManager()) != null) {
            try {
                securityManager.checkPermission(permission);
            }
            catch (SecurityException securityException) {
                if (permission instanceof FilePermission && permission.getActions().indexOf("read") != -1) {
                    securityManager.checkRead(permission.getName());
                }
                if (permission instanceof SocketPermission && permission.getActions().indexOf("connect") != -1) {
                    securityManager.checkConnect(uRL.getHost(), uRL.getPort());
                }
                throw securityException;
            }
        }
        return jarFile;
    }

    private Permission getPermission(JarFile jarFile) {
        try {
            URLConnection uRLConnection = this.getConnection(jarFile);
            if (uRLConnection != null) {
                return uRLConnection.getPermission();
            }
        }
        catch (IOException iOException) {}
        return null;
    }
}

