/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.SelectorProvider;
import sun.nio.ch.PollArrayWrapper;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SelectorImpl;
import sun.nio.ch.Util;

abstract class AbstractPollSelectorImpl
extends SelectorImpl {
    PollArrayWrapper pollWrapper;
    protected final int INIT_CAP = 10;
    protected SelectionKeyImpl[] channelArray;
    protected int channelOffset = 0;
    protected int totalChannels;
    protected int interestingChannels;
    private boolean closed = false;

    AbstractPollSelectorImpl(SelectorProvider selectorProvider, int n, int n2) {
        super(selectorProvider);
        this.totalChannels = n;
        this.interestingChannels = n;
        this.channelOffset = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putEventOps(SelectionKeyImpl selectionKeyImpl, int n) {
        SelectionKeyImpl selectionKeyImpl2 = selectionKeyImpl;
        synchronized (selectionKeyImpl2) {
            this.pollWrapper.putEventOps(selectionKeyImpl.getIndex(), n);
            this.adjustInteresting(selectionKeyImpl, n);
        }
    }

    public Selector wakeup() {
        this.pollWrapper.interrupt();
        return this;
    }

    protected abstract int doSelect(long var1) throws IOException;

    protected void implClose() throws IOException {
        if (!this.closed) {
            this.closed = true;
            int n = this.channelOffset;
            while (n < this.totalChannels) {
                this.channelArray[n].setIndex(-1);
                this.deregister(this.channelArray[n]);
                SelectableChannel selectableChannel = this.channelArray[n].channel();
                if (!selectableChannel.isOpen() && !selectableChannel.isRegistered()) {
                    ((SelChImpl)((Object)selectableChannel)).kill();
                }
                ++n;
            }
            this.implCloseInterrupt();
            this.pollWrapper.free();
            this.pollWrapper = null;
            this.selectedKeys = null;
            this.channelArray = null;
            this.totalChannels = 0;
            this.interestingChannels = 0;
        }
    }

    protected abstract void implCloseInterrupt() throws IOException;

    protected int updateSelectedKeys() {
        int n = 0;
        int n2 = this.channelOffset;
        while (n2 < this.interestingChannels) {
            try {
                int n3 = this.pollWrapper.getReventOps(n2);
                if (n3 != 0) {
                    SelectionKeyImpl selectionKeyImpl = this.channelArray[n2];
                    this.pollWrapper.putReventOps(n2, 0);
                    if (this.selectedKeys.contains(selectionKeyImpl)) {
                        int n4 = selectionKeyImpl.readyOps();
                        selectionKeyImpl.channel.translateAndSetReadyOps(n3, selectionKeyImpl);
                        if (selectionKeyImpl.readyOps() != n4) {
                            ++n;
                        }
                    } else {
                        selectionKeyImpl.channel.translateAndSetReadyOps(n3, selectionKeyImpl);
                        if ((selectionKeyImpl.readyOps() & selectionKeyImpl.interestOps()) != 0) {
                            this.selectedKeys.add(selectionKeyImpl);
                            ++n;
                        }
                    }
                }
            }
            catch (CancelledKeyException cancelledKeyException) {
                // empty catch block
            }
            ++n2;
        }
        return n;
    }

    private void checkChannelArrayAndPollWrapper() {
        if (this.channelArray[0] != null) {
            System.err.println("channelArray[0] should be null.");
            System.exit(1);
        }
        int n = 1;
        while (n < this.totalChannels) {
            if (this.channelArray[n].getIndex() != n) {
                System.err.println("selector error: i=" + n + ", channelArray[i].getIndex()=" + this.channelArray[n].getIndex());
                System.exit(1);
            }
            if (this.pollWrapper.getDescriptor(n) != ((SelChImpl)((Object)this.channelArray[n].channel())).getFDVal()) {
                System.exit(1);
            }
            ++n;
        }
    }

    private void outputChannelArray() {
        int n;
        int n2 = 1;
        while (n2 < this.totalChannels) {
            n = (char)(this.channelArray[n2].channel.getFDVal() % 94 + 33);
            System.err.print((char)n);
            ++n2;
        }
        System.err.println();
        n = 1;
        while (n < this.totalChannels) {
            char c = this.channelArray[n].interestOps() == 0 ? (char)'0' : '1';
            System.err.print(c);
            ++n;
        }
        System.err.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swapChannels(int n, int n2) {
        if (0 > n || n >= this.totalChannels || 0 > n2 || n2 >= this.totalChannels) {
            throw new RuntimeException("Internal Selector problem, cannot swap channels " + n + " and " + n2);
        }
        if (n == n2) {
            return;
        }
        SelectionKeyImpl selectionKeyImpl = this.channelArray[n];
        SelectionKeyImpl selectionKeyImpl2 = this.channelArray[n2];
        SelectionKeyImpl selectionKeyImpl3 = selectionKeyImpl;
        synchronized (selectionKeyImpl3) {
            SelectionKeyImpl selectionKeyImpl4 = selectionKeyImpl2;
            synchronized (selectionKeyImpl4) {
                this.channelArray[n] = selectionKeyImpl2;
                this.channelArray[n2] = selectionKeyImpl;
                selectionKeyImpl.setIndex(n2);
                selectionKeyImpl2.setIndex(n);
                PollArrayWrapper.swapEntry(this.pollWrapper, n, this.pollWrapper, n2);
            }
        }
    }

    private void adjustInteresting(SelectionKeyImpl selectionKeyImpl, int n) {
        if (this.totalChannels <= 1 || this.interestingChannels < 1) {
            throw new RuntimeException("Internal Selector problem, cannot adjust. totalChannels=" + this.totalChannels + ", interestingChannels=" + this.interestingChannels);
        }
        if (selectionKeyImpl.getIndex() < this.interestingChannels) {
            if (n == 0) {
                int n2 = this.interestingChannels - 1;
                this.swapChannels(selectionKeyImpl.getIndex(), n2);
                --this.interestingChannels;
            }
        } else if (n != 0) {
            int n3 = this.interestingChannels++;
            this.swapChannels(selectionKeyImpl.getIndex(), n3);
        }
    }

    protected void implRegister(SelectionKeyImpl selectionKeyImpl) {
        if (this.channelArray.length == this.totalChannels) {
            int n = this.pollWrapper.totalChannels * 2;
            SelectionKeyImpl[] selectionKeyImplArray = new SelectionKeyImpl[n];
            int n2 = this.channelOffset;
            while (n2 < this.totalChannels) {
                selectionKeyImplArray[n2] = this.channelArray[n2];
                ++n2;
            }
            this.channelArray = selectionKeyImplArray;
            this.pollWrapper.grow(n);
        }
        this.channelArray[this.totalChannels] = selectionKeyImpl;
        selectionKeyImpl.setIndex(this.totalChannels);
        this.pollWrapper.addEntry(selectionKeyImpl.channel);
        ++this.totalChannels;
        this.keys.add(selectionKeyImpl);
        try {
            this.adjustInteresting(selectionKeyImpl, selectionKeyImpl.interestOps());
        }
        catch (CancelledKeyException cancelledKeyException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void implDereg(SelectionKeyImpl selectionKeyImpl) throws IOException {
        SelectionKeyImpl selectionKeyImpl2 = selectionKeyImpl;
        synchronized (selectionKeyImpl2) {
            Object object;
            int n = selectionKeyImpl.getIndex();
            if (n >= this.totalChannels || n < 0) {
                throw new IOException("Internal Selector problem, trying to deregister key not in selector(totalChannels=" + this.totalChannels + ").");
            }
            if (this.channelArray[n] == selectionKeyImpl) {
                object = this.channelArray[this.totalChannels - 1];
                if (n != this.totalChannels - 1) {
                    Object object2 = object;
                    synchronized (object2) {
                        this.channelArray[n] = object;
                        ((SelectionKeyImpl)object).setIndex(n);
                        this.pollWrapper.release(n);
                        PollArrayWrapper.replaceEntry(this.pollWrapper, this.totalChannels - 1, this.pollWrapper, n);
                    }
                } else {
                    this.pollWrapper.release(n);
                }
                this.channelArray[this.totalChannels - 1] = null;
                --this.totalChannels;
                --this.pollWrapper.totalChannels;
                if (this.interestingChannels > this.totalChannels) {
                    this.interestingChannels = this.totalChannels;
                }
                try {
                    this.adjustInteresting((SelectionKeyImpl)object, ((SelectionKeyImpl)object).interestOps());
                }
                catch (CancelledKeyException cancelledKeyException) {
                    // empty catch block
                }
                selectionKeyImpl.setIndex(-1);
                this.keys.remove(selectionKeyImpl);
                this.selectedKeys.remove(selectionKeyImpl);
                this.deregister(selectionKeyImpl);
            }
            if (!((AbstractInterruptibleChannel)(object = selectionKeyImpl.channel())).isOpen() && !((SelectableChannel)object).isRegistered()) {
                ((SelChImpl)object).kill();
            }
        }
    }

    static {
        Util.load();
    }
}

