/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import sun.nio.ch.Net;
import sun.nio.ch.OptionAdaptor;
import sun.nio.ch.ServerSocketChannelImpl;
import sun.nio.ch.Util;

public class ServerSocketAdaptor
extends ServerSocket {
    private final ServerSocketChannelImpl ssc;
    private volatile OptionAdaptor opts = null;
    private volatile int timeout = 0;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$sun$nio$ch$ServerSocketAdaptor;

    public static ServerSocket create(ServerSocketChannelImpl serverSocketChannelImpl) {
        try {
            return new ServerSocketAdaptor(serverSocketChannelImpl);
        }
        catch (IOException iOException) {
            throw new Error(iOException);
        }
    }

    private ServerSocketAdaptor(ServerSocketChannelImpl serverSocketChannelImpl) throws IOException {
        this.ssc = serverSocketChannelImpl;
    }

    public void bind(SocketAddress socketAddress) throws IOException {
        this.bind(socketAddress, 50);
    }

    public void bind(SocketAddress socketAddress, int n) throws IOException {
        if (socketAddress == null) {
            socketAddress = new InetSocketAddress(0);
        }
        try {
            this.ssc.bind(socketAddress, n);
        }
        catch (Exception exception) {
            Net.translateException(exception);
        }
    }

    public InetAddress getInetAddress() {
        if (!this.ssc.isBound()) {
            return null;
        }
        return Net.asInetSocketAddress(this.ssc.localAddress()).getAddress();
    }

    public int getLocalPort() {
        if (!this.ssc.isBound()) {
            return -1;
        }
        return Net.asInetSocketAddress(this.ssc.localAddress()).getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Socket accept() throws IOException {
        Object object = this.ssc.blockingLock();
        synchronized (object) {
            if (!this.ssc.isBound()) {
                throw new IllegalBlockingModeException();
            }
            try {
                if (this.timeout == 0) {
                    SocketChannel socketChannel = this.ssc.accept();
                    return socketChannel.socket();
                }
                SelectionKey selectionKey = null;
                this.ssc.configureBlocking(false);
                try {
                    long l;
                    SocketChannel socketChannel = this.ssc.accept();
                    if (socketChannel != null) {
                        Socket socket = socketChannel.socket();
                        return socket;
                    }
                    Selector selector = Util.getTemporarySelector(this.ssc);
                    selectionKey = this.ssc.register(selector, 16);
                    long l2 = this.timeout;
                    do {
                        l = System.currentTimeMillis();
                        selector.select(l2);
                        if (selectionKey.isAcceptable() && (socketChannel = this.ssc.accept()) != null) {
                            Socket socket = socketChannel.socket();
                            return socket;
                        }
                        selector.selectedKeys().remove(selectionKey);
                    } while ((l2 -= System.currentTimeMillis() - l) > 0L);
                    throw new SocketTimeoutException();
                }
                finally {
                    if (selectionKey != null) {
                        selectionKey.cancel();
                    }
                    if (this.ssc.isOpen()) {
                        this.ssc.configureBlocking(true);
                    }
                }
            }
            catch (Exception exception) {
                Net.translateException(exception);
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return null;
            }
        }
    }

    public void close() throws IOException {
        try {
            this.ssc.close();
        }
        catch (Exception exception) {
            Net.translateException(exception);
        }
    }

    public ServerSocketChannel getChannel() {
        return this.ssc;
    }

    public boolean isBound() {
        return this.ssc.isBound();
    }

    public boolean isClosed() {
        return !this.ssc.isOpen();
    }

    public void setSoTimeout(int n) throws SocketException {
        this.timeout = n;
    }

    public int getSoTimeout() throws SocketException {
        return this.timeout;
    }

    private OptionAdaptor opts() {
        if (this.opts == null) {
            this.opts = new OptionAdaptor(this.ssc);
        }
        return this.opts;
    }

    public void setReuseAddress(boolean bl) throws SocketException {
        this.opts().setReuseAddress(bl);
    }

    public boolean getReuseAddress() throws SocketException {
        return this.opts().getReuseAddress();
    }

    public String toString() {
        if (!this.isBound()) {
            return "ServerSocket[unbound]";
        }
        return "ServerSocket[addr=" + this.getInetAddress() + ",localport=" + this.getLocalPort() + "]";
    }

    public void setReceiveBufferSize(int n) throws SocketException {
        this.opts().setReceiveBufferSize(n);
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.opts().getReceiveBufferSize();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$sun$nio$ch$ServerSocketAdaptor == null ? (class$sun$nio$ch$ServerSocketAdaptor = ServerSocketAdaptor.class$("sun.nio.ch.ServerSocketAdaptor")) : class$sun$nio$ch$ServerSocketAdaptor).desiredAssertionStatus();
    }
}

