/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.IOUtil;
import sun.security.action.LoadLibraryAction;

class Util {
    private static final int TEMP_BUF_POOL_SIZE = 3;
    private static ThreadLocal[] bufferPool;
    private static ThreadLocal localSelector;
    private static Unsafe unsafe;
    private static int pageSize;
    private static Constructor directByteBufferConstructor;
    private static Constructor directByteBufferRConstructor;
    private static boolean loaded;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$sun$nio$ch$Util;
    static /* synthetic */ Class class$java$lang$Runnable;

    Util() {
    }

    static ByteBuffer getTemporaryDirectBuffer(int n) {
        ByteBuffer byteBuffer = null;
        int n2 = 0;
        while (n2 < 3) {
            SoftReference softReference = (SoftReference)bufferPool[n2].get();
            if (softReference != null && (byteBuffer = (ByteBuffer)softReference.get()) != null && byteBuffer.capacity() >= n) {
                byteBuffer.rewind();
                byteBuffer.limit(n);
                bufferPool[n2].set(null);
                return byteBuffer;
            }
            ++n2;
        }
        return ByteBuffer.allocateDirect(n);
    }

    static void releaseTemporaryDirectBuffer(ByteBuffer byteBuffer) {
        int n = 0;
        while (n < 3) {
            SoftReference softReference = (SoftReference)bufferPool[n].get();
            if (softReference == null || softReference.get() == null) {
                bufferPool[n].set(new SoftReference(byteBuffer));
                return;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < 3) {
            SoftReference softReference = (SoftReference)bufferPool[n2].get();
            ByteBuffer byteBuffer2 = (ByteBuffer)softReference.get();
            if (byteBuffer2 != null && byteBuffer.capacity() > byteBuffer2.capacity()) {
                bufferPool[n2].set(new SoftReference(byteBuffer));
                return;
            }
            ++n2;
        }
    }

    static Selector getTemporarySelector(SelectableChannel selectableChannel) throws IOException {
        SoftReference softReference = (SoftReference)localSelector.get();
        Selector selector = null;
        if (softReference == null || (selector = (Selector)softReference.get()) == null || selector.provider() != selectableChannel.provider()) {
            selector = selectableChannel.provider().openSelector();
            localSelector.set(new SoftReference(selector));
        } else {
            selector.selectNow();
            if (!$assertionsDisabled && !selector.keys().isEmpty()) {
                throw new AssertionError((Object)"Temporary selector not empty");
            }
        }
        return selector;
    }

    static ByteBuffer[] subsequence(ByteBuffer[] byteBufferArray, int n, int n2) {
        if (n == 0 && n2 == byteBufferArray.length) {
            return byteBufferArray;
        }
        int n3 = n2;
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[n3];
        int n4 = 0;
        while (n4 < n3) {
            byteBufferArray2[n4] = byteBufferArray[n + n4];
            ++n4;
        }
        return byteBufferArray2;
    }

    private static byte _get(long l) {
        return unsafe.getByte(l);
    }

    private static void _put(long l, byte by) {
        unsafe.putByte(l, by);
    }

    static void erase(ByteBuffer byteBuffer) {
        unsafe.setMemory(((DirectBuffer)((Object)byteBuffer)).address(), byteBuffer.capacity(), (byte)0);
    }

    static Unsafe unsafe() {
        return unsafe;
    }

    static int pageSize() {
        if (pageSize == -1) {
            pageSize = Util.unsafe().pageSize();
        }
        return pageSize;
    }

    private static void initDBBConstructor() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Class clazz = Class.forName("java.nio.DirectByteBuffer");
                    directByteBufferConstructor = clazz.getDeclaredConstructor(new Class[]{Integer.TYPE, Long.TYPE, class$java$lang$Runnable == null ? (class$java$lang$Runnable = Util.class$("java.lang.Runnable")) : class$java$lang$Runnable});
                    directByteBufferConstructor.setAccessible(true);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new InternalError();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new InternalError();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new InternalError();
                }
                catch (ClassCastException classCastException) {
                    throw new InternalError();
                }
                return null;
            }
        });
    }

    static MappedByteBuffer newMappedByteBuffer(int n, long l, Runnable runnable) {
        MappedByteBuffer mappedByteBuffer;
        if (directByteBufferConstructor == null) {
            Util.initDBBConstructor();
        }
        try {
            mappedByteBuffer = (MappedByteBuffer)directByteBufferConstructor.newInstance(new Object[]{new Integer(n), new Long(l), runnable});
        }
        catch (InstantiationException instantiationException) {
            throw new InternalError();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InternalError();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new InternalError();
        }
        return mappedByteBuffer;
    }

    private static void initDBBRConstructor() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Class clazz = Class.forName("java.nio.DirectByteBufferR");
                    directByteBufferRConstructor = clazz.getDeclaredConstructor(new Class[]{Integer.TYPE, Long.TYPE, class$java$lang$Runnable == null ? (class$java$lang$Runnable = Util.class$("java.lang.Runnable")) : class$java$lang$Runnable});
                    directByteBufferRConstructor.setAccessible(true);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new InternalError();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new InternalError();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new InternalError();
                }
                catch (ClassCastException classCastException) {
                    throw new InternalError();
                }
                return null;
            }
        });
    }

    static MappedByteBuffer newMappedByteBufferR(int n, long l, Runnable runnable) {
        MappedByteBuffer mappedByteBuffer;
        if (directByteBufferRConstructor == null) {
            Util.initDBBRConstructor();
        }
        try {
            mappedByteBuffer = (MappedByteBuffer)directByteBufferRConstructor.newInstance(new Object[]{new Integer(n), new Long(l), runnable});
        }
        catch (InstantiationException instantiationException) {
            throw new InternalError();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InternalError();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new InternalError();
        }
        return mappedByteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void load() {
        Class clazz = class$sun$nio$ch$Util == null ? (class$sun$nio$ch$Util = Util.class$("sun.nio.ch.Util")) : class$sun$nio$ch$Util;
        synchronized (clazz) {
            if (loaded) {
                return;
            }
            loaded = true;
            AccessController.doPrivileged(new LoadLibraryAction("net"));
            AccessController.doPrivileged(new LoadLibraryAction("nio"));
            IOUtil.initIDs();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$sun$nio$ch$Util == null ? (class$sun$nio$ch$Util = Util.class$("sun.nio.ch.Util")) : class$sun$nio$ch$Util).desiredAssertionStatus();
        bufferPool = new ThreadLocal[3];
        int n = 0;
        while (n < 3) {
            Util.bufferPool[n] = new ThreadLocal();
            ++n;
        }
        localSelector = new ThreadLocal();
        unsafe = Unsafe.getUnsafe();
        pageSize = -1;
        directByteBufferConstructor = null;
        directByteBufferRConstructor = null;
        loaded = false;
    }
}

