/*
 * Decompiled with CFR 0.152.
 */
package sun.text;

import com.ibm.jvm.ExtendedSystem;
import sun.text.Utility;

public final class CompactCharArray
implements Cloneable {
    public static final int UNICODECOUNT = 65536;
    private static final int BLOCKSHIFT = 5;
    private static final int BLOCKCOUNT = 32;
    private static final int INDEXSHIFT = 11;
    private static final int INDEXCOUNT = 2048;
    private static final int BLOCKMASK = 31;
    private char[] values;
    private char[] indices;
    private int[] hashes;
    private boolean isCompact;
    private char defaultValue;

    public CompactCharArray() {
        this('\u0000');
    }

    public CompactCharArray(char c) {
        this.values = new char[65536];
        this.indices = new char[2048];
        this.hashes = new int[2048];
        int n = 0;
        while (n < 65536) {
            this.values[n] = c;
            ++n;
        }
        n = 0;
        while (n < 2048) {
            this.indices[n] = (char)(n << 5);
            this.hashes[n] = 0;
            ++n;
        }
        this.isCompact = false;
        this.defaultValue = c;
    }

    public CompactCharArray(String string, String string2) {
        this(Utility.RLEStringToCharArray(string), Utility.RLEStringToCharArray(string2));
    }

    public CompactCharArray(char[] cArray, char[] cArray2) {
        if (cArray.length != 2048) {
            throw new IllegalArgumentException("Index out of bounds.");
        }
        int n = 0;
        while (n < 2048) {
            char c = cArray[n];
            if (c < '\u0000' || c >= cArray2.length + 32) {
                throw new IllegalArgumentException("Index out of bounds.");
            }
            ++n;
        }
        this.indices = cArray;
        this.values = cArray2;
        this.isCompact = true;
    }

    public char elementAt(char c) {
        return this.values[(this.indices[c >> 5] & 0xFFFF) + (c & 0x1F)];
    }

    public void setElementAt(char c, char c2) {
        if (this.isCompact) {
            this.expand();
        }
        this.values[c] = c2;
        this.touchBlock(c >> 5, c2);
    }

    public void setElementAt(char n, char c, char c2) {
        if (this.isCompact) {
            this.expand();
        }
        int n2 = n;
        while (n2 <= c) {
            this.values[n2] = c2;
            this.touchBlock(n2 >> 5, c2);
            ++n2;
        }
    }

    public void compact() {
        if (!this.isCompact) {
            int n;
            int n2 = 0;
            int n3 = 0;
            int n4 = 65535;
            int n5 = 0;
            while (n5 < this.indices.length) {
                this.indices[n5] = 65535;
                n = this.blockTouched(n5) ? 1 : 0;
                if (n == 0 && n4 != 65535) {
                    this.indices[n5] = n4;
                } else {
                    int n6 = 0;
                    int n7 = 0;
                    n7 = 0;
                    while (n7 < n2) {
                        if (this.hashes[n5] == this.hashes[n7] && CompactCharArray.arrayRegionMatches(this.values, n3, this.values, n6, 32)) {
                            this.indices[n5] = (char)n6;
                        }
                        ++n7;
                        n6 += 32;
                    }
                    if (this.indices[n5] == '\uffff') {
                        System.arraycopy(this.values, n3, this.values, n6, 32);
                        this.indices[n5] = (char)n6;
                        this.hashes[n7] = this.hashes[n5];
                        ++n2;
                        if (n == 0) {
                            n4 = (char)n6;
                        }
                    }
                }
                ++n5;
                n3 += 32;
            }
            n = n2 * 32;
            this.values = (char[])ExtendedSystem.resizeArray(n, this.values, 0, n);
            this.isCompact = true;
            this.hashes = null;
        }
    }

    static final boolean arrayRegionMatches(char[] cArray, int n, char[] cArray2, int n2, int n3) {
        int n4 = n + n3;
        int n5 = n2 - n;
        int n6 = n;
        while (n6 < n4) {
            if (cArray[n6] != cArray2[n6 + n5]) {
                return false;
            }
            ++n6;
        }
        return true;
    }

    private final void touchBlock(int n, int n2) {
        this.hashes[n] = this.hashes[n] + (n2 << 1) | 1;
    }

    private final boolean blockTouched(int n) {
        return this.hashes[n] != 0;
    }

    public char[] getIndexArray() {
        return this.indices;
    }

    public char[] getStringArray() {
        return this.values;
    }

    public Object clone() {
        try {
            CompactCharArray compactCharArray = (CompactCharArray)super.clone();
            compactCharArray.values = (char[])this.values.clone();
            compactCharArray.indices = (char[])this.indices.clone();
            if (this.hashes != null) {
                compactCharArray.hashes = (int[])this.hashes.clone();
            }
            return compactCharArray;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CompactCharArray compactCharArray = (CompactCharArray)object;
        int n = 0;
        while (n < 65536) {
            if (this.elementAt((char)n) != compactCharArray.elementAt((char)n)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        int n2 = Math.min(3, this.values.length / 16);
        int n3 = 0;
        while (n3 < this.values.length) {
            n = n * 37 + this.values[n3];
            n3 += n2;
        }
        return n;
    }

    private void expand() {
        if (this.isCompact) {
            char[] cArray = (char[])ExtendedSystem.newArray(Character.TYPE, 65536, this);
            this.hashes = (int[])ExtendedSystem.newArray(Integer.TYPE, 2048, this);
            int n = 0;
            while (n < 65536) {
                char c;
                cArray[n] = c = this.elementAt((char)n);
                this.touchBlock(n >> 5, c);
                ++n;
            }
            n = 0;
            while (n < 2048) {
                this.indices[n] = (char)(n << 5);
                ++n;
            }
            this.values = null;
            this.values = cArray;
            this.isCompact = false;
        }
    }

    private char getArrayValue(int n) {
        return this.values[n];
    }

    private char getIndexArrayValue(int n) {
        return this.indices[n];
    }
}

