/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jar;

import com.ibm.security.x509.X509Cert;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.KeyManagementException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import sun.security.provider.SystemIdentity;
import sun.tools.jar.Manifest;

public class JarVerifierStream
extends ZipInputStream {
    private JarEntry current;
    private Hashtable verified = new Hashtable();
    private JarInputStream jis;
    private Manifest man = null;
    private ArrayList certCache = null;

    public JarVerifierStream(InputStream inputStream) throws IOException {
        super(inputStream);
        this.jis = new JarInputStream(inputStream);
    }

    public void close() throws IOException {
        this.jis.close();
    }

    public void closeEntry() throws IOException {
        this.jis.closeEntry();
    }

    public synchronized ZipEntry getNextEntry() throws IOException {
        this.current = (JarEntry)this.jis.getNextEntry();
        return this.current;
    }

    public int read() throws IOException {
        int n = this.jis.read();
        if (n == -1) {
            this.addIds();
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.jis.read(byArray, n, n2);
        if (n3 == -1) {
            this.addIds();
        }
        return n3;
    }

    private void addIds() {
        Vector vector;
        Certificate[] certificateArray;
        if (this.current != null && (certificateArray = this.current.getCertificates()) != null && (vector = this.getIds(certificateArray)) != null) {
            this.verified.put(this.current.getName(), vector);
        }
    }

    public Hashtable getVerifiedSignatures() {
        if (this.verified.isEmpty()) {
            return null;
        }
        return this.verified;
    }

    public Enumeration getBlocks() {
        if (this.verified.isEmpty()) {
            return null;
        }
        return new Enumeration(){

            public boolean hasMoreElements() {
                return false;
            }

            public Object nextElement() {
                return null;
            }
        };
    }

    public Hashtable getNameToHash() {
        return null;
    }

    public Manifest getManifest() {
        block3: {
            if (this.man != null) break block3;
            try {
                java.util.jar.Manifest manifest = this.jis.getManifest();
                if (manifest == null) {
                    return null;
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                manifest.write(byteArrayOutputStream);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                this.man = new Manifest(byArray);
            }
            catch (IOException iOException) {}
        }
        return this.man;
    }

    protected Vector getIds(Certificate[] certificateArray) {
        CertCache certCache;
        if (certificateArray == null) {
            return null;
        }
        if (this.certCache == null) {
            this.certCache = new ArrayList();
        }
        int n = 0;
        while (n < this.certCache.size()) {
            certCache = (CertCache)this.certCache.get(n);
            if (certCache.equals(certificateArray)) {
                return certCache.ids;
            }
            ++n;
        }
        certCache = new CertCache();
        certCache.certs = certificateArray;
        if (certificateArray.length > 0) {
            int n2 = 0;
            while (n2 < certificateArray.length) {
                try {
                    X509Certificate x509Certificate = (X509Certificate)certificateArray[n2];
                    Principal principal = x509Certificate.getSubjectDN();
                    final SystemIdentity systemIdentity = new SystemIdentity(principal.getName(), null);
                    byte[] byArray = x509Certificate.getEncoded();
                    X509Cert x509Cert = new X509Cert(byArray);
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction((java.security.Certificate)x509Cert){
                            private final /* synthetic */ java.security.Certificate val$oldC;
                            {
                                this.val$oldC = certificate;
                            }

                            public Object run() throws KeyManagementException {
                                systemIdentity.addCertificate(this.val$oldC);
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw (KeyManagementException)privilegedActionException.getException();
                    }
                    if (certCache.ids == null) {
                        certCache.ids = new Vector();
                    }
                    certCache.ids.addElement(systemIdentity);
                }
                catch (KeyManagementException keyManagementException) {
                }
                catch (IOException iOException) {
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    // empty catch block
                }
                ++n2;
            }
        }
        this.certCache.add(certCache);
        return certCache.ids;
    }

    static class CertCache {
        Certificate[] certs;
        Vector ids;

        CertCache() {
        }

        boolean equals(Certificate[] certificateArray) {
            int n;
            boolean bl;
            if (this.certs == null) {
                return certificateArray == null;
            }
            if (certificateArray == null) {
                return false;
            }
            int n2 = 0;
            while (n2 < certificateArray.length) {
                bl = false;
                n = 0;
                while (n < this.certs.length) {
                    if (certificateArray[n2].equals(this.certs[n])) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
                if (!bl) {
                    return false;
                }
                ++n2;
            }
            n = 0;
            while (n < this.certs.length) {
                bl = false;
                int n3 = 0;
                while (n3 < certificateArray.length) {
                    if (this.certs[n].equals(certificateArray[n3])) {
                        bl = true;
                        break;
                    }
                    ++n3;
                }
                if (!bl) {
                    return false;
                }
                ++n;
            }
            return true;
        }
    }
}

