/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.DESedeKey;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11KeySpec;
import com.ibm.crypto.pkcs11impl.provider.PKCS11SecretKey;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.DESedeKeySpec;

public final class DESedePKCS11KeyFactory
extends SecretKeyFactorySpi {
    private PKCS11Session session = null;
    static /* synthetic */ Class class$javax$crypto$spec$DESedeKeySpec;

    public DESedePKCS11KeyFactory() {
        IBMPKCS11Impl.verifyJceJar();
        this.session = IBMPKCS11Impl.session;
    }

    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        DESedeKey dESedeKey = null;
        if (keySpec == null || !(keySpec instanceof DESedeKeySpec) && !(keySpec instanceof PKCS11KeySpec)) {
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        if (!(keySpec instanceof PKCS11KeySpec)) {
            try {
                PKCS11Object pKCS11Object = null;
                byte[] byArray = null;
                Boolean bl = Boolean.FALSE;
                Boolean bl2 = Boolean.FALSE;
                Boolean bl3 = Boolean.TRUE;
                Boolean bl4 = Boolean.TRUE;
                Boolean bl5 = Boolean.TRUE;
                byte[] byArray2 = null;
                DESedeKeySpec dESedeKeySpec = (DESedeKeySpec)keySpec;
                byArray2 = dESedeKeySpec.getKey();
                byArray = this.genID();
                int[] nArray = new int[]{0, 256, 258, 2, 1, 259, 260, 261, 262, 263, 17};
                Object[] objectArray = new Object[]{PKCS11Object.SECRET_KEY, PKCS11Object.DES3, byArray, Boolean.TRUE, bl, bl2, bl3, new Boolean(bl3), bl4, new Boolean(bl4), byArray2};
                pKCS11Object = this.session.createObject(nArray, objectArray);
                dESedeKey = new DESedeKey(pKCS11Object, byArray, null, bl, bl2, bl3, bl4, bl5, byArray2);
            }
            catch (InvalidKeyException invalidKeyException) {}
        } else {
            PKCS11Object pKCS11Object = ((PKCS11KeySpec)keySpec).getObject();
            try {
                dESedeKey = new DESedeKey(pKCS11Object, (byte[])this.getAttrValue(pKCS11Object, 258), (String)this.getAttrValue(pKCS11Object, 3), (Boolean)this.getAttrValue(pKCS11Object, 1), (Boolean)this.getAttrValue(pKCS11Object, 259), (Boolean)this.getAttrValue(pKCS11Object, 260), (Boolean)this.getAttrValue(pKCS11Object, 262), (Boolean)this.getAttrValue(pKCS11Object, 354), (byte[])this.getAttrValue(pKCS11Object, 17));
            }
            catch (InvalidKeyException invalidKeyException) {}
        }
        return dESedeKey;
    }

    protected KeySpec engineGetKeySpec(SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
        try {
            if (secretKey != null && secretKey instanceof PKCS11SecretKey && secretKey.getAlgorithm().equalsIgnoreCase("DESede") && secretKey.getFormat().equalsIgnoreCase("PKCS#11")) {
                Class<?> clazz2 = Class.forName("javax.crypto.spec.DESedeKeySpec");
                if (clazz != null && clazz2.isAssignableFrom(clazz)) {
                    if (((DESedeKey)secretKey).getSensitive().booleanValue()) {
                        throw new PKCS11Exception("Secret key value is not exportable");
                    }
                    return new DESedeKeySpec(((DESedeKey)secretKey).getValue());
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (secretKey != null && secretKey instanceof SecretKey && secretKey.getAlgorithm().equalsIgnoreCase("DESede") && secretKey.getFormat().equalsIgnoreCase("RAW")) {
                Class<?> clazz3 = Class.forName("javax.crypto.spec.DESedeKeySpec");
                if (clazz != null && clazz3.isAssignableFrom(clazz)) {
                    return new DESedeKeySpec(secretKey.getEncoded());
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            throw new InvalidKeySpecException("Inappropriate key format/algorithm");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException("Secret key has wrong size");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidKeySpecException("Unsupported key specification: " + classNotFoundException.getMessage());
        }
    }

    protected SecretKey engineTranslateKey(SecretKey secretKey) throws InvalidKeyException {
        try {
            if (secretKey != null && secretKey.getAlgorithm().equalsIgnoreCase("DESede") && secretKey.getFormat().equalsIgnoreCase("RAW")) {
                if (secretKey instanceof DESedeKey) {
                    return secretKey;
                }
                DESedeKeySpec dESedeKeySpec = (DESedeKeySpec)this.engineGetKeySpec(secretKey, class$javax$crypto$spec$DESedeKeySpec == null ? (class$javax$crypto$spec$DESedeKeySpec = DESedePKCS11KeyFactory.class$("javax.crypto.spec.DESedeKeySpec")) : class$javax$crypto$spec$DESedeKeySpec);
                return this.engineGenerateSecret(dESedeKeySpec);
            }
            throw new InvalidKeyException("Inappropriate key format/algorithm");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("Cannot translate key");
        }
    }

    private byte[] genID() {
        Serializable serializable;
        byte[] byArray = new byte[33];
        byte[] byArray2 = new byte[24];
        byte[] byArray3 = null;
        int n = 0;
        try {
            serializable = SecureRandom.getInstance("IBMSecureRandom", "IBMPKCS11Impl");
            ((SecureRandom)serializable).nextBytes(byArray2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        serializable = new BigInteger(1, byArray2);
        try {
            byArray3 = ((BigInteger)serializable).toString().getBytes("8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError("Can not convert string");
        }
        n = ((BigInteger)serializable).toString().length();
        if (n > 24) {
            n = 24;
        }
        System.arraycopy(byArray3, 0, byArray, 9, n);
        byArray[0] = 73;
        byArray[1] = 66;
        byArray[2] = 77;
        byArray[3] = 80;
        byArray[4] = 75;
        byArray[5] = 67;
        byArray[6] = 83;
        byArray[7] = 49;
        byArray[8] = 49;
        return byArray;
    }

    private Object getAttrValue(PKCS11Object pKCS11Object, int n) {
        Object object;
        try {
            object = pKCS11Object.getAttributeValue(n);
        }
        catch (Exception exception) {
            object = null;
        }
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

