/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Hash;
import com.ibm.crypto.pkcs11impl.provider.Signature;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;

public final class PKCS11MD2withRSASingle
extends SignatureSpi {
    private Signature sig = new Signature(1);
    private Hash md2 = new Hash(512);
    private String oid = "1.2.840.113549.2.2";
    private PrivateKey privateKey;
    private PublicKey publicKey;
    private boolean reset = false;

    protected void engineSetParameter(String string, Object object) {
    }

    protected Object engineGetParameter(String string) {
        return null;
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.privateKey = privateKey;
        if (this.reset) {
            this.md2.engineReset();
        }
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.publicKey = publicKey;
        if (this.reset) {
            this.md2.engineReset();
        }
    }

    protected void engineUpdate(byte by) {
        byte[] byArray = new byte[]{by};
        this.md2.engineUpdate(byArray, 0, 1);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        this.md2.engineUpdate(byArray, n, n2);
    }

    protected byte[] engineSign() throws SignatureException {
        Object object;
        byte[] byArray = this.md2.engineDigest();
        DerOutputStream derOutputStream = null;
        try {
            derOutputStream = new DerOutputStream();
            object = new DerOutputStream();
            AlgorithmId algorithmId = AlgorithmId.getAlgorithmId((String)this.oid);
            algorithmId.encode(object);
            DerValue[] derValueArray = new DerValue[]{new DerValue(object.toByteArray()), new DerValue(4, byArray)};
            derOutputStream.putSequence(derValueArray);
        }
        catch (IOException iOException) {
            throw new SignatureException("error encoding signature");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SignatureException("error encoding signature");
        }
        object = derOutputStream.toByteArray();
        try {
            this.sig.engineInitSign(this.privateKey);
        }
        catch (Exception exception) {
            throw new PKCS11Exception(exception.getMessage());
        }
        this.reset = true;
        return this.sig.engineSign((byte[])object, ((DerOutputStream)object).length);
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        Object object;
        byte[] byArray2 = this.md2.engineDigest();
        DerOutputStream derOutputStream = null;
        try {
            derOutputStream = new DerOutputStream();
            object = new DerOutputStream();
            AlgorithmId algorithmId = AlgorithmId.getAlgorithmId((String)this.oid);
            algorithmId.encode(object);
            DerValue[] derValueArray = new DerValue[]{new DerValue(object.toByteArray()), new DerValue(4, byArray2)};
            derOutputStream.putSequence(derValueArray);
        }
        catch (IOException iOException) {
            throw new SignatureException("error encoding signature");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SignatureException("error encoding signature");
        }
        object = derOutputStream.toByteArray();
        try {
            this.sig.engineInitVerify(this.publicKey);
        }
        catch (Exception exception) {
            throw new PKCS11Exception(exception.getMessage());
        }
        this.reset = true;
        return this.sig.engineVerify(byArray, (byte[])object, ((DerOutputStream)object).length);
    }
}

